# Change the 0 on the following line to 1 for beta release versions
%if 0
%define beta rc1
%endif

# Use "rpmbuild --define 'suse_version 1'" to build for SuSE system

%define rpmrel 3
%{!?__id_u: %define __id_u /bin/id -u}

Summary:	Point-to-Point Tunneling Protocol (PPTP) Client
Name:		pptp
Version:	1.7.2
Distribution:	PPTP Client Project
Release:	%{?beta:0.%{beta}.}%{rpmrel}%{?suse_version:suse}%{?dist}
URL:		http://pptpclient.sourceforge.net/
Source:		http://downloads.sf.net/pptpclient/pptp-%{version}.tar.gz
Patch0:		pptp-1.7.2-compat.patch
Patch1:		pptp-1.7.2-declaration.patch
Patch2:		pptp-1.7.2-ip-path.patch
License:	GPLv2+
%if %{?suse_version:0}%{!?suse_version:1}
Group:		Applications/Internet
%else
Group:		Productivity/Networking/Security
%endif
Obsoletes:	pptp-scripts <= 1.6.0 pptp-linux <= 1.6.0
Provides:	pptp-linux = %{version}-%{release}, pptp-scripts = %{version}-%{release}
Requires:	ppp >= 2.4.2, /sbin/ip
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
Client for the proprietary Microsoft Point-to-Point Tunneling
Protocol, PPTP.  Allows connection to a PPTP based VPN as used
by employers and some cable and ADSL service providers.
Requires MPPE support in kernel.%{?suse_version: Use the ppp-mppe package.}

%prep
%setup -q
%patch0 -p1 -b .compat
%patch1 -p1 -b .declaration
%patch2 -p1 -b .ip-path
/usr/bin/find . -depth -type d -name CVS -exec %{__rm} -rf {} \;
%{__perl} -pi -e 's/install -o root -m 555 pptp/install -m 755 pptp/;' Makefile

%build
# Parallel make disabled because .o files don't have dependency on config.h
%{__make} CFLAGS="-Wall %{optflags}"

%install
%{__rm} -rf %{buildroot}
%{__make} DESTDIR=%{buildroot} install
%{__install} -d -m 750 %{buildroot}%{_localstatedir}/run/pptp

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING DEVELOPERS INSTALL NEWS README TODO USING
%doc ChangeLog Documentation/DESIGN.PPTP PROTOCOL-SECURITY
%{_sbindir}/pptp
%{_sbindir}/pptpsetup
%{_mandir}/man8/pptp.8*
%{_mandir}/man8/pptpsetup.8.*
%dir %attr(750,root,root) %{_localstatedir}/run/pptp/
%config(noreplace) /etc/ppp/options.pptp

%changelog
* Mon May 19 2008 Paul Howarth <paul@city-fan.org> 1.7.2-3
- Add dependency on /sbin/ip
- Disable parallel make - object files are missing dependency on config.h

* Mon May 19 2008 Paul Howarth <paul@city-fan.org> 1.7.2-2
- Use /sbin/ip, not /bin/ip for routing

* Wed May 14 2008 Paul Howarth <paul@city-fan.org> 1.7.2-1
- Update to 1.7.2
- Include new script and manpage: pptpsetup
- Update declaration patch (original problem fixed, similar issues introduced
  in different files)
- Add patch to remove reference to stropts.h, not shipped in F9 onwards and
  only needed for Solaris

* Tue Jan  8 2008 Paul Howarth <paul@city-fan.org> 1.7.1-5
- Old distributions like RHL7/8 don't have a sed that supports the "-i"
  option, so use perl to do inline edits instead
- Apply patch to declare local variables at the start of functions, needed
  to build on old distributions like RHL7/8

* Mon Nov 12 2007 Paul Howarth <paul@city-fan.org> 1.7.1-4
- Change download URL from df.sf.net to downloads.sf.net
- Clarify license as GPL version 2 or later
- Add optional dist tag
- Add blank lines between spec changelog entries
- Use versioned obsoletes

* Mon Feb 13 2006 Paul Howarth <paul@city-fan.org> 1.7.1-3
- remove buildroot unconditionally in %%clean and %%install
- don't use macros in build-time command paths, hardcode them instead
- add PROTOCOL-SECURITY as %%doc

* Mon Feb 13 2006 James Cameron <james.cameron@hp.com> 1.7.1-2
- update to 1.7.1

* Wed Aug 10 2005 Paul Howarth <paul@city-fan.org> 1.7.0-2
- own directory %%{_localstatedir}/run/pptp

* Thu Jul 28 2005 Paul Howarth <paul@city-fan.org> 1.7.0-1
- define %%{__id_u} if it's not already done (e.g. on Mandriva)
- explictly provide version/release for Provides:
- use full URL for source
- add URL tag
- move changelog to end of spec file
- do parallel makes if possible
- make sure directories have correct permissions
- don't overwrite user-edited options.pptp
- add DEVELOPERS, ChangeLog & DESIGN.PPTP as %%doc
- install pptp mode 755 to keep rpmlint happy
- no longer need other mode fixes
- use system-default optflags
- edit Makefile to prevent attempted chown in %%install

* Wed Jul 27 2005 James Cameron <james.cameron@hp.com> 1.7.0-0
- new upstream version 1.7.0.

* Fri Feb 18 2005 Paul Howarth <paul@city-fan.org> 1.6.0-1
- changed deprecated Copyright: tag to License:
- more macros for portability
- group is Productivity/Networking/Security if built for SuSE system
- use upstream Makefile for %%install after clearing out buildroot
- add macro support for 'beta' releases, with 0.beta.rpmrel release ID,
  with removal of `CVS' directories if required
- add "Provides: pptp-linux" and "Obsoletes: pptp-linux" to handle name
  change nicely
- remove redundant %%attr tags from file list

* Fri Feb 18 2005 James Cameron <james.cameron@hp.com> 1.6.0-0
- move options.pptp to main Makefile
- rename package to pptp as planned
- remove pptp-command (has been deprecated since 1.2.0; no active maintainer
  and has caused much mailing list traffic; replacement is pptpconfig)
- new upstream version 1.6.0.

* Tue Jun 22 2004 James Cameron <james.cameron@hp.com>
- remove /etc/pptp.d as unused
- remove RFC and development documentation
- new upstream version 1.5.0.

* Mon Nov 10 2003 James Cameron <james.cameron@hp.com>
- new upstream version 1.4.0.

* Wed Jun 11 2003 James Cameron <james.cameron@hp.com>
- new upstream version 1.3.1.

* Tue Jun 10 2003 James Cameron <james.cameron@hp.com>
- new upstream version 1.3.0.

* Wed Jan 15 2003 James Cameron <james.cameron@hp.com>
- rewrite INSTALL.
- add man page to install target.
- fix response to dropped packets.
- fix man page, address must be before options.

* Mon Dec 30 2002 James Cameron <james.cameron@hp.com>
- adopt man page contributed by Thomas Quinot.
- close stderr to prevent holding open ssh sessions.
- minor hint added in case of EIO on read() of pty.
- support synchronous HDLC ppp encoding. Synchronous mode results in an
  important improvement of the CPU efficiency.
- handle out-of-order packets arriving on the GRE socket by buffering.
- bind GRE socket early to prevent ICMP Unreachable response by client.

* Fri Mar 22 2002 James Cameron <james.cameron@compaq.com>
- new release engineer.
- avoid requiring ppp-mppe.
- allow activation as a psuedo-tty child process from pppd.
- ADSL modem quirks handler by mulix@actcom.co.il.
- Orckit ADSL modem compatibility.
- Cisco PIX compatibility.
- enhance bad FCS error message.
- ported to FreeBSD and NetBSD.
