%{!?__id_u: %define __id_u /bin/id -u}

Summary		: Linux kernel PPP MPPE module
Name		: kernel_ppp_mppe
Version		: 1.0.2
Release		: 3dkms
Group		: System Environment/Kernel
BuildArch	: noarch
Source0		: kernel_ppp_mppe-%{version}-src.tgz
Patch0		: kernel_ppp_mppe-0.0.5-pre_build.patch
License		: Dual BSD/GPL
URL		: http://pptpclient.sourceforge.net/
BuildRoot	: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Requires	: dkms >= 2.0.6, gcc, make

%description
This driver provides MPPE capability, necessary for implementing encryption for
the PPTP protocol. This driver supports 2.4.x and 2.6.x kernels.

For issues with this device driver, please see the PPTP Client project
on http://pptpclient.sourceforge.net/, and use the PPTP Client developers'
mailing list (subscribe and read archives at
https://lists.sourceforge.net/lists/listinfo/pptpclient-devel).

%prep
%setup -q
%patch0 -p0
%{__rm} -f kernel_ppp_mppe.spec
%{__cp} %{_specdir}/kernel_ppp_mppe.spec .
%{__sed} -i -e 's#^\(DEST_MODULE_LOCATION.*\)/"$#\1"#' dkms.conf

%install
[ "$RPM_BUILD_ROOT" != "/" -a -n "$RPM_BUILD_ROOT" ] && %{__rm} -rf $RPM_BUILD_ROOT
DESTDIR=$RPM_BUILD_ROOT%{_usrsrc}/kernel_ppp_mppe-%{version}
%{__install} -m 755 -d $DESTDIR $DESTDIR/patches $DESTDIR/ppp_generic
%{__install} -m 444 arcfour.[ch] $DESTDIR
%{__install} -m 444 ppp-comp*.h $DESTDIR
%{__install} -m 444 ppp_mppe_compress.c $DESTDIR
%{__install} -m 444 sha1.[ch] $DESTDIR
%{__install} -m 444 dkms.conf $DESTDIR
%{__install} -m 444 Makefile $DESTDIR
%{__install} -m 444 kernel_ppp_mppe.spec $DESTDIR
%{__install} -m 444 patches/* $DESTDIR/patches
%{__install} -m 755 pre_build.sh $DESTDIR
%{__install} -m 755 post_build.sh $DESTDIR
%{__install} -m 444 README $DESTDIR
%{__install} -m 444 ppp_generic/README $DESTDIR/ppp_generic
# for all other kernels
for kernel in ppp_generic/*
do
	if [ -d $kernel ]; then
		%{__install} -m 755 -d $DESTDIR/$kernel
		%{__install} -m 644 $kernel/ppp_generic.c $DESTDIR/$kernel
	fi
done
# for 2.6.13 only
%{__install} -m 755 -d $DESTDIR/ppp_generic/2.6.13/include
%{__install} -m 755 -d $DESTDIR/ppp_generic/2.6.13/include/linux
%{__install} -m 644 ppp_generic/2.6.13/Makefile $DESTDIR/ppp_generic/2.6.13
%{__install} -m 644 ppp_generic/2.6.13/ppp_mppe.[ch] $DESTDIR/ppp_generic/2.6.13
%{__install} -m 644 ppp_generic/2.6.13/include/linux/* $DESTDIR/ppp_generic/2.6.13/include/linux

%clean
[ "$RPM_BUILD_ROOT" != "/" -a -n "$RPM_BUILD_ROOT" ] && %{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_usrsrc}/kernel_ppp_mppe-%{version}

%post
# Add it (build and install it for currently running kernel if not a BOOT kernel)
dkms add -m kernel_ppp_mppe -v %{version} --rpm_safe_upgrade

if [ `uname -r | grep -c "BOOT"` -eq 0 ] && [ -e /lib/modules/`uname -r`/build/include ] ; then
	dkms build -m kernel_ppp_mppe -v %{version}
	dkms install -m kernel_ppp_mppe -v %{version}
elif [ `uname -r | grep -c "BOOT"` -gt 0 ]; then
	echo -e "Module build for the currently running kernel was skipped"
	echo -e "since you are running a BOOT variant of the kernel."
else
	echo -e "Module build for the currently running kernel was skipped"
	echo -e "since the kernel source for this kernel does not seem to be"
        echo -e "installed."
fi
exit 0

%preun
echo -e "Uninstall of kernel_ppp_mppe (version %{version}) beginning:"
dkms remove -m kernel_ppp_mppe -v %{version} --all --rpm_safe_upgrade
exit 0

%changelog
* Wed Oct  5 2005 Paul Howarth <paul@city-fan.org> 1.0.2-3dkms
- get rid of redundant macro definitions module, version, rpm_release
- use "Requires:" instead of "PreReq:" - rpm will get it right
- drop sed BR - everyone should have sed
- unpack tatball quietly
- tidy up %%description
- use mode 755 instead of 555 for pre/post build scripts (rpmlint)
- use braces consistently in macro expansions

* Sat Oct 1 2005 Matt Domsch <Matt_Domsch@dell.com> 1.0.2-2dkms
- fix pre_build.sh for < 2.6.13 kernels

* Sat Oct 1 2005 Matt Domsch <Matt_Domsch@dell.com>
- add 2.6.13 capability based on 2.6.14-rc-mm code.
- require dkms 2.0.6 or higher, it has several important bug fixes.

* Fri Apr  8 2005 Paul Howarth <paul@city-fan.org> 0.0.5-5dkms
- patch for pre_build.sh for 2.4 kernels to find ppp_generic.c in
  the right place; this is only a cosmetic change because 2.4 kernels
  need the kernel-source to be installed, and with the kernel-source
  installed, the included ppp_generic.c isn't needed anyway

* Wed Mar 16 2005 Paul Howarth <paul@city-fan.org> 0.0.5-4dkms
- another cosmetic change - get rid of redundant trailing "/" in
  dkms.conf DEST_MODULE_LOCATIONs
- define __id_u for BuildRoot if necessary

* Fri Feb 18 2005 Paul Howarth <paul@city-fan.org> 0.0.5-3dkms
- get rid of "file included twice" warning at RPM build time for
  "kernel_ppp_mppe.spec"

* Tue Jan 25 2005 Matt Domsch <Matt_Domsch@dell.com>
- make package depend on DKMS 2.0.4.3 or higher; this lets me remove
  explicit MAKE and CLEAN lines from dkms.conf

* Mon Jan 17 2005 Matt Domsch <Matt_Domsch@dell.com>
- patch from Richard Dawe fixes sha1 calculations on 64-bit CPUs

* Mon Nov 8 2004 Paul Howarth <paul@city-fan.org>
- add dependencies on gcc and make, making them and the dkms dependency
  prerequisites rather than just plain dependencies as they are all needed
  for the post-install script

* Thu Jul 1 2004 Paul Howarth <paul@city-fan.org>
- patch for compatbility with dkms >= 1.90

* Mon Jun 7 2004 <Matt_Domsch@dell.com>
- strip kernel modules in POST_BUILD script

* Fri Jun 4 2004 <Matt_Domsch@dell.com>
- Initial packaging in RPM format
