#!/bin/bash

function show_usage ()
{
    echo $"Usage: $0 /path/to/kernel/source /path/to/module/source /path/to/build/dir kernel-version"
}



[ $# -lt 4 ] && show_usage;

kernel_source_dir=$1
module_source_dir=$2
build_dir=$3
kernel_version=$4

VERSION_WO_SUFFIX=`echo ${kernel_version} | sed -e 's/smp\|BOOT\|bigmem\|hugemem\|enterprise\|debug//'`

kernel_version_no_release=`echo ${kernel_version} | awk -F- '{print $1}'`
kernel_version_major=`echo ${kernel_version_no_release} | awk -F. '{print $1}'`
kernel_version_minor=`echo ${kernel_version_no_release} | awk -F. '{print $2}'`
kernel_version_patch=`echo ${kernel_version_no_release} | awk -F. '{print $3}'`

if [ `echo $kernel_version | egrep -c "^2\.6\."` -gt 0 ]; then
    if [ $kernel_version_patch -gt 12 ]; then
	    # for 2.6.13 and higher, use our own copies of everything
	    rm ${build_dir}/*.[ch] ${build_dir}/Makefile
	    cp -r $module_source_dir/ppp_generic/2.6.13/* $build_dir
	    exit 0
    fi
fi


if [ -f ${kernel_source_dir}/drivers/net/ppp_generic.c ]; then
   cp ${kernel_source_dir}/drivers/net/ppp_generic.c $build_dir
   echo $"Using ${kernel_source_dir}/drivers/net/ppp_generic.c"
elif [ -f /usr/src/linux-$VERSION_WO_SUFFIX/drivers/net/ppp_generic.c ]; then
   cp /usr/src/linux-${VERSION_WO_SUFFIX}/drivers/net/ppp_generic.c $build_dir
   echo $"Using /usr/src/linux-${VERSION_WO_SUFFIX}/drivers/net/ppp_generic.c"
else
    # Use the closest copy for RHL{7.x-9, FC1, FC2, FC3, FC4} at least
    # All the 2.4s are the same, yea!
    if [ `echo $kernel_version | egrep -c "^2\.4\."` -gt 0 ]; then
	cp $module_source_dir/ppp_generic/2.4.22-1.2115.nptl/ppp_generic.c $build_dir
	echo $"Using $module_source_dir/ppp_generic/2.4.22-1.2115.nptl/ppp_generic.c"
    elif [ `echo $kernel_version | egrep -c "^2\.6\."` -gt 0 ]; then
	if [ $kernel_version_patch -lt 13 ]; then
	    cp $module_source_dir/ppp_generic/2.6.5-1.358/ppp_generic.c $build_dir
	    echo $"Using $module_source_dir/ppp_generic/2.6.5-1.358/ppp_generic.c"
	fi
    fi
fi
