/*******************************************************************************
* Copyright 2004 Engenio Information Technologies, Inc.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            genuniqueid.c
SUMMARY         %description%
VERSION         %version: 3 %
UPDATE DATE     %date_modified: Fri Jun 11 11:55:10 2004 %
PROGRAMMER      %created_by:    sdachepa %

        Copyright 2004 Engenio Information Technologies, Inc.

DESCRIPTION:
   This utility program generates an 8-byte unique byte -sequences. It uses the
   time since 1/1/1970 as the seed of a random number generator. It runs a random
   number of times to mix bits orders and generates two random integer numbers. 
   The two integer numbers are the 8-byte unique byte -sequences.
INCLUDE FILES:

NOTES:

RESTRICTIONS:

SEE ALSO:

REFERENCE:

IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/

#define __SRCgenuniqueid_c

/***  INCLUDES  ***/  
#include<stdio.h>
#include <stdlib.h>
#include <sys/time.h>

/***  CONSTANT DEFINITIONS  ***/
/***  MACRO DEFINITIONS  ***/
/***  TYPE DEFINITIONS  ***/
/***  LOCALS  ***/
/***  PROCEDURES  ***/
int main(int argc, char argv[])
{
   int seed;
   time_t   now;
   int first4b;
   int second4b;
   int tmp1, tmp2;
   int numberOfRun;
   int i;

   /*
   * use the time since the Epoch (00:00:00 UTC, January 1, 1970)
   * as the seed of the random number generator
   * the time_t is a type of unsigned long, convert it to the int in case a long is 
   * 64 bits
   */
   now = time(NULL);
   seed = now &0xffffffff;
   srand(seed);
   
   numberOfRun = (int)(10.0*rand()/(RAND_MAX +1.0));

   first4b = rand();
   second4b = rand();
   /*
   * Run a random number of times between 1-10
   */
   for(i = 0; i < numberOfRun; i++)
   {
      tmp1 = rand();
      tmp2 = rand();
      first4b = ((tmp1&0xffff0000)|(tmp2&0x0000ffff))^first4b;

      tmp1 = rand();
      tmp2 = rand();
      second4b = ((tmp1&0xffff0000)|(tmp2&0x0000ffff))^second4b;
   }

   printf("%08x%08x\n",first4b,second4b);
}   
