/*******************************************************************************
* Copyright 2008 LSI Corporation.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            MPP_RdacInfo.h
SUMMARY         %description%
VERSION         %version: 41 %
UPDATE DATE     %date_modified: Wed Jul 23 14:14:31 2008 %
PROGRAMMER      %created_by:    harshi %

DESCRIPTION:

INCLUDE FILES:

NOTES: 

RESTRICTIONS:

SEE ALSO:

REFERENCE:

IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/


#ifndef __INCMPP_RdacInfo
#define __INCMPP_RdacInfo


/***  INCLUDES  ***/  
#include "MPP_Sysdep.h"
#include "MPP_Common.h"
#include "scsiio.h"

/***  CONSTANT DEFINITIONS  ***/
#define	MPP_STARTED			1
#define	MPP_STOPPED			0
#define	MPP_STOP_QUERY_ACCEPTED	2

#define	MPP_PRESENT			1
#define	MPP_REMOVED			0
#define	MPP_REMOVE_QUERY_ACCEPTED	2

#define	NO_REMOVE			0
#define	REMOVE_PENDING			1
#define	REMOVE_COMPLETE			2



/***  MACRO DEFINITIONS  ***/
#define	INITIALIZE_PSEUDO_STATE(_Device_) \
	(_Device_)->PseudoDevState = NotStarted; \
	(_Device_)->PseudoPreviousDevState = NotStarted; \
	MPP_DEBUGPRINT((MPP_PNP_DEBUG+MPP_DEBUG_LEVEL_3, "InitPseudoState(0x%x)\n", _Device_));

#define	SET_NEW_PSEUDO_STATE(_Device_, _State_) \
	(_Device_)->PseudoPreviousDevState = (_Device_)->PseudoDevState; \
	(_Device_)->PseudoDevState = (_State_); \
	MPP_DEBUGPRINT((MPP_PNP_DEBUG+MPP_DEBUG_LEVEL_3, "NewPseudoState(0x%x;0x%x)\n", _Device_, _State_));

#define	RESTORE_PREVIOUS_PSEUDO_STATE(_Device_) \
	(_Device_)->PseudoDevState = (_Device_)->PseudoPreviousDevState; \
	MPP_DEBUGPRINT((MPP_PNP_DEBUG+MPP_DEBUG_LEVEL_3, "RestorePseudoState(0x%x;0x%x)\n", _Device_, (_Device_)->PseudoDevState));


/*** Note: When you add a field into one of the data structures, please add it in
       the beginning of data structure instead of the end. Otherwise it will cause 
       memory problems in mpp_RemoveLun().  ***/

/***  TYPE DEFINITIONS  ***/
typedef struct LPWLinkedListNode
{
  LWORD PathId;
  LWORD pathWeight;
	LWORD  controllerIndex;
	BYTE  pathIndex;
	LWORD Lun;
	PVOID prvLLNode;
	PVOID nxtLLNode;
} LPWLinkedListNode_t;

typedef struct LPWLinkedListHeader
{
	unsigned int controllerIndex;
	LWORD               leastPathWeight;
	LPWLinkedListNode_t *firstLLNode;
	LPWLinkedListNode_t *firstLLNodeToCheck;
} LPWLinkedListHeader_t;

typedef struct LunPathInfo
{
	LWORD		UtmLinkCreated : 1,
			refCount : 4, /* used as Linux device reference counter */
			holdKref : 4, /* whether or not the mpp driver holds a kernel object ref for the LunPathDevice*/
			Reserved : 23; /* Compiler directive for starting the next storage class on new storage boundary. 
			                  This field should be the last field in the list of bits defined above. */
	LWORD		IoCount;
	BYTE		PathStartState;
	BYTE		PathRemoveState;
	BYTE		PathPowerState;
	LWORD		UtmNumber;
	MPPCMN_PATH_STATE	DeviceState[MPPCMN_MAX_STATE_HISTORY];
	LWORD		DeviceStateIndex;
	MPP_HANDLE	UtmLunDevice;  /* The system's way to the UTM Lun */
	MPP_HANDLE	LunPathDevice;  /* The MPP's path to the data for this LUN */
  MPP_HANDLE	SavedLunPathDevice; /*Save the LunPathDevice at the device time of device removing */	
  LWORD PathWeight;
  LPWLinkedListNode_t *lLNode; /* Address of LPW linked list node for this path */
   VOID        *PlatformPrivateData; /* a void pointer that points to 
                                      *platform MPP driver's private data struct 
                                      */
} LunPathInfo_t;

typedef struct LunPathObjects
{
	BYTE   		RoundRobinPathIndex;
	BYTE   		NumberOfLunObjects;
	LINT		PreferredControllerPath;
	LPWLinkedListHeader_t lLHeader;
	LunPathInfo_t	LunPaths[1];
} LunPathObjects_t;

typedef struct RdacLunInformation
{
	LWORD		CurrentOwningPath:	1,	/*  0 - A, 1 - B  */
			BootOwningPath:		1,	/*  0 - A, 1 - B  */
			PreferredPath:		1,	/*  0 - A, 1 - B  */
			Present:		1,
			NotConfigured:		1,
			PseudoRemoveEligible:	1,	/* the PseudoLunObject has no real paths left - it is removable */
			Quiescent:	1,  /* the array did not come out of quiescience within the allotted time interval */
		    NotReady:	1,  	/* the controller did not come ready within the allotted time interval */
		    Busy:	1,  	/* the controller did not come out of busy within the allotted time interval */
			UTMLun:			1,
			NeedsReservationCheck:	1,
			TASBitSet: 1,
			LBPFromStore: 1,
			PseudoLunEventCreated:	1, /* Used while adding Dynamic Luns */
			Reserved:		18; /* Compiler directive for starting the next storage class on new storage boundary. 
						This field should be the last field in the list of bits defined above. */
	MPP_HANDLE	PseudoLunObject;  	/* The RDAC's pseudo disk object for the LUN */
	LWORD		PseudoInstance;
	BYTE		PseudoPowerState;
	MPPCMN_PATH_STATE	PseudoDevState[MPPCMN_MAX_STATE_HISTORY];
	LWORD			PseudoDevStateIndex;
	BOOL		ReportedMissing;
	BOOL		ReportedPresent;
	MPP_TIME	QuiescienceStart;
	MPP_TIME	NotReadyStart;
	MPP_TIME	BusyStart;
	LunPathObjects_t *LunControllers[2];  /* The RDAC's paths to the data for this LUN */
	BYTE		WWN[16];		/* The Volume WWN */
   VOID        *PlatformPrivateData; /* a void pointer that points to 
                                      *platform MPP driver's private data struct 
                                      */
	MPPCMN_LOAD_BALANCE_POLICY LoadBalancePolicy; /* Lun level Load Balance Policy */
	BYTE 		reserved[4]; 		/* added for structure alignment*/
} RdacLunInformation_t;


/** This structure is used to maintain information about which luns should be failed-over to a given controller **/
typedef struct RdacLunFailoverInfo
{
	LWORD    	LunFailoverTimerSet: 1,	/* Has a timer been set for lun failover - 0 = no, 1 = yes */
			Reserved:	31;

	LWORD		LunFailoverDuration;  /* Number of seconds elapsed for a given lun failover */
	BYTE		LunFailoverTable[MPPCMN_LUN_FAILOVER_TABLE_LENGTH]; /* Bitmask used to specify luns to failover */
	MPP_LOCK_T	LunFailoverLock;      /* Used to control access to the LunFailoverTable. */
} RdacLunFailoverInfo_t;

typedef struct RdacControllerPath
{
    	ControllerAddress_t Address;
    	LWORD		DirectoryCreated: 1,	/* Path's Object directory has been created */
			Present:	1,	/* path is present */
			Reserved:	30; 	/* Compiler directive for starting the next storage class on new storage boundary. 
						This field should be the last field in the list of bits defined above. */
	MPP_DIR_HANDLE 	DirectoryVertex;	
	MPPCMN_PATH_STATE	PathState[MPPCMN_MAX_STATE_HISTORY];
	LWORD			PathId;
	LWORD		PathStateIndex;
	LWORD 		PathIdleTime;
	LWORD		PathFailedTime;
	MPPSYS_ATOMIC_T	RequestsInProgress;  // Number of outstanding requests.
	unsigned long PathStamp;
   VOID        *PlatformPrivateData; /* a void pointer that points to 
                                      *platform MPP driver's private data struct 
                                      */
} RdacControllerPath_t;

typedef struct RdacControllerInformation
{
    	LWORD	Failed:	1,	      /* this controller is failed */
	    UTMLunExists: 1,     	/* there is an UTM LUN on this controller */
	    ControllerPresent: 1,  /* controller is in the array module */
	    DirectoryCreated: 1,  /* controller's Object directory has been created */
	    FailoverInProgress: 1,  /* This controller is the process of being failed */
	    BootMode:		1,	/* controller mode at boot - 0 = passive, 1 = active */
	    ServiceMode:	1,	/* controller is in Service Mode - 0 = no, 1 = yes */
	    Reserved:		25;	/* Compiler directive for starting the next storage class on new storage boundary. 
					This field should be the last field in the list of bits defined above. */
	MPP_DIR_HANDLE	ControllerSlotHandle;  /* handle to the Array Module controller (A/B) object directory */
	LWORD		UTMLunNumber;
	BYTE		NumberOfPaths;
	LWORD			ReservationPathIndex; 
	VOID			*PlatformPrivateData; /* a void pointer that points to platform MPP driver's private data struct */
	RdacLunFailoverInfo_t	LunFailoverInfo; /* records information on which luns to fail to THIS controller. */
	RdacControllerPath_t	ControllerPath[1];	/* the controller paths */
} RdacControllerInformation_t;

typedef struct RdacDeviceInformation
{
    	LWORD 		ObjectCount;	    /* count of objects associated with this module */
        MPP_DIR_HANDLE  ModuleHandle;     /* Array Module Object directory handle */
        MPP_HANDLE      ModuleLinkHandle;     /* Array Module Object directory handle */
	LWORD		SingleController: 	1,  /* This module has only one path */
			RestoreCfg:	1,  /* The array needs its configuration restored */
			DirectoryCreated:	1,  /* This module's Object directory has been created */
			ScanTriggered:	1,  /* This module is SingleController & !Independent - we received 5 94/01 statuses
						and triggered a scan for the 2nd controller */
			AVTEnabled:	1,  /* AVT is enabled on this module */
			Page2CSubPage1:	1,  /* This module supports SubPage 1 for 256 volume support */
			FWSonoran4OrLater: 1, /* Firmware Version of array is Sonoran 4 or Later */ 
		PRResetSupported:  1, /* This module supports the PR SCSI_ENGENIO_BUS_RESET command */
		LBPRetrieved:  1, /* Array specific LBP retrieved */
		Reserved:23; 		/* Compiler directive for starting the next storage class on new storage boundary.
						This field should be the last field in the list of bits defined above. */
	LWORD		ScanTaskState;
	MPP_LOCK_T	Lock;
	MPP_RW_LOCK_T	RWLock;
	BYTE		WWN[16];
	BYTE		VirtualTargetId;
	DevName_t	*ModuleName;
	RdacControllerInformation_t	*ControllerInfo[ 2 ];	/* the two controller 0 - A & 1 - B      */
	BYTE		FirmwareVersion[4];
	MPP_TIME	ArrayFailoverStartTime;   /* Time that the first failover attempt started */
	MPPCMN_FAILOVER_METHOD FailoverMethod;
	MPPCMN_LOAD_BALANCE_POLICY LoadBalancePolicy;	/* Array Load Balance Policy */
	MPPCMN_ARRAY_TYPE      ArrayType; /* iscsi, ib, fc or sas */
   RdacLunInformation_t	RdacLuns[1]; /* This field must be the last field in this data struct.
                                      * This is because the mpp_AllocRdacinfo() implicitly 
                                      *relies on this field to be the last field.
                                      */
} RdacDeviceInformation_t;

typedef struct ArrayModuleEntry {
	LWORD		ModuleNameInConfig: 	1,  /* This module has been assigned an ID via the system configuration file */
        		ControllerRestored:     1,  /* A controller was restored by FailbackScan */
			Reserved:30;		 /* Compiler directive for starting the next storage class on new storage boundary. 
						This field should be the last field in the list of bits defined above. */
	RdacDeviceInformation_t *RdacInfo;
	DevName_t		ModuleName;
} ArrayModuleEntry_t;


/** This structure is used "standalone" for passing information to the failover worker thread routine.
 ** It is also embedded into the mppCmn_FailoverCompletionContext_t structure since the same information
 ** may be needed if the failover request is issued again, however there is one important difference.
 ** As a standalone structure the 'ControllerIndex' field is the controller you are failing FROM.
 ** As part of the failover completion context it is the controller you are failing TO.  The reason
 ** for this distinction is the way some of the existing functions use the ControllerIndex.
 **/
typedef struct _MppCmn_FailoverContext {
	RdacDeviceInformation_t		*RdacInfo;
	BYTE				ControllerIndex;	// See note above.
	BYTE				PathIndex;
	LWORD				Lun;
	LWORD				IoErrorCondition;
	MPPCMN_FAILOVER_METHOD		FailoverMethod;
} MppCmn_FailoverContext_t;

/** This structure is used to pass information to the mppCmn_DoFailoverCompletion() routine. **/
typedef struct _MppCmn_FailoverCompletionContext {
	MppCmn_FailoverContext_t	FailoverContext;
	SenseData_t			*SenseData;
	SINT				SenseLength;
	LWORD				DataLengthTransferred;
	MPP_TIME			FailoverStartTime;
	BOOL				ForcedQuiescenceAttempted;
	BOOL				noHoldInReset;
	LWORD				OSStatus;
} MppCmn_FailoverCompletionContext_t;

#define CHECK_RDACINFO_EXIST(x)   \
{ \
    x = ModPtr->x; \
    if( !x )	break; \
}

/***  GLOBALS  ***/ 
extern ArrayModuleEntry_t *mpp_ModuleArray;


#endif        /* End of __INCMPP_RdacInfo.h */
