/*******************************************************************************
* Copyright 2004 Engenio Information Technologies, Inc.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            mppCmn_SysInterface.h
SUMMARY         %description%
VERSION         %version: 13 %
UPDATE DATE     %date_modified: Mon Jan 28 08:09:53 2008 %
PROGRAMMER      %created_by:    rstankey %

DESCRIPTION:

INCLUDE FILES:

NOTES:

RESTRICTIONS:

SEE ALSO:

REFERENCE:

IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/

#ifndef __INCmppCmn_SysInterface
#define __INCmppCmn_SysInterface

/***  CONSTANT DEFINITIONS  ***/

/* CONSOLIDATION OF SYSTEM DEPENDENT FUNCTIONS */
typedef struct mppCmn_SysInterface
{	
	/* 
	 * REQUIRED Functions 
	 */

	/*
	 * Status : required
	 * SUMMARY:  This is the system dependent part of the Synchronous IO function.
	 */
	REQUIRED LWORD (*mpp_SysdepSynchronousIo)	(IN MPP_HANDLE DeviceVertex, IN BYTE *cdb, IN BYTE cdblen, 
							IN void *BufferAddress, IN LWORD BufferLength,
                                			OUT void *SenseBuffer, IN LWORD SenseLength, 
							IN TINY DataDirection, OUT LWORD *SenseLengthReturned,
			                                OUT LWORD *DataLengthXfered);

	/*
	 * Status : required
	 * SUMMARY: MPP System Dependent routine to issue a failover command to controller
	 */
	REQUIRED void (*mpp_IssueFailover) (IN RdacDeviceInformation_t *RdacInfo, IN BYTE Controller, IN BYTE Path,
 				       IN MPP_HANDLE FailoverHandle, IN BYTE *Page2C, IN BYTE *cdb,
				       IN MPPCMN_FAILOVER_METHOD FailoverMethod, IN BOOL ForcedQuiescence,
				       IN BOOL noHoldInReset);

	/*
	 * Status : required
	 * SUMMARY: perform necessary steps to make virtual lun.
	 */
	REQUIRED MPP_HANDLE (*mpp_makeVirtualLun)(MPP_HANDLE DeviceVertex, 
						 RdacDeviceInformation_t *RdacInfo, LWORD Lun, LWORD *PBusStatus);

        /*
         * Status : required
         * SUMMARY:  This system dependent function fills in the Sysdep information into the UtilStatusInfo_t data
         * structure needed for an MPP_IOCTL_UTIL_STATUS_INFO ioctl call.
         */
	REQUIRED  void (*mppSys_GetUtilSysdepData)(RdacDeviceInformation_t *RdacInfo, mpp_utilStatusInfo_t *utilStatusInfo );

        /*
         * Status : required
         * SUMMARY: MPP System Dependent routine to issue a Path Validation (inquiry) command. 
         */
	REQUIRED  LWORD (*mppSys_ValidatePath) (IN RdacDeviceInformation_t *RdacInfo, IN LWORD Controller, IN LWORD Path);

		/* 
         * Status : required
         * SUMMARY: MPP System Dependent routine to copy Rdac info structures from kernel memory to user memory
         *          when ioctl command to get the rdacinfo is sent to the driver from mppUtil.
         */
	REQUIRED  SINT (*mppSys_CopyRdacInfoToUser) ( OUT void *RdacInfoAdrs, IN RdacDeviceInformation_t *RdacInfo);

        /*
         * Status : required
         * SUMMARY: MPP System Dependent routine to issue a Path Validation (inquiry) command. 
         */
	REQUIRED  LWORD (*mppSys_QueueRequest) (IN MPPCMN_QUEUE_REQUEST_CALLBACK RequestCallback, IN void *Context, IN LWORD DelaySecs);

	/* 
	 * OPTIONAL Functions 
	 */
	
	/*
	 * Status : optional
	 * SUMMARY:  Remove the identified controller's directory ( ex: proc directory )
	 *           Dummy function in MPRAS
	 */
	OPTIONAL void (*mpp_RemoveControllerDirectory) (IN MPP_HANDLE DeviceVertex, IN RdacDeviceInformation_t *RdacInfo, IN BYTE Controller);

	/*
	 * Status : optional
	 * SUMMARY: MPP function that introduces delay. (dummy in MPRAS)
	 */
	OPTIONAL void (*mpp_ThreadDelay) (IN ULONG DelayTime, IN ULONG DelayResolution);
	
	/*
	 * Status : optional
	 * SUMMARY: Determine whether the RdacLun structure can be initialized to zero 
	 */
	OPTIONAL LWORD (*mpp_IsOkayToClearRdacLuns)	(IN RdacDeviceInformation_t *RdacInfo, IN LWORD Lun);

	/*
	 * Status : optional
	 * SUMMARY: Checks if all paths to the controller are failed.
	 *          Dummy Function in LINUX.
	 */
	OPTIONAL LWORD (*mppSys_AreControllerPathsFailed) (IN RdacDeviceInformation_t *RdacInfo, 
							IN BYTE ControllerIndex, IN LWORD Lun);

	/*
	 * Status : optional
	 * SUMMARY: this function returns the DeviceHandle for UTM Device after creation.
	 */
	OPTIONAL MPP_HANDLE (*mpp_CreateUtmDevice) 	(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, 
							BYTE ControllerIndex, BYTE Path, LWORD Lun);

	/*
	 * Status : optional
	 * SUMMARY:  mpp_RemoveUtmDevice is called to remove node(s) that are associated with the argument
         * 	     UTM LUN from the system.
	 */
	OPTIONAL void (*mpp_RemoveUTM)	(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun);

	/*
	 * Status : optional
	 * SUMMARY:  mpp_RemoveLunLink removes the OS device directories and object graphs, if applicable,
	 	     to indicate the existence of the path to the logical unit.
	 */
	OPTIONAL void (*mpp_RemoveLunLink) (RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun);
		
	/*
	 * Status : optional
 	 * SUMMARY:  mpp_RemoveVirtualLun is called to remove node(s) that are associated with the argument
	 * 	     virtual LUN from the system.
	 */
	OPTIONAL void (*mpp_RemoveVirtualLun) (RdacDeviceInformation_t *RdacInfo, LWORD Lun);
	
	/*
	 * Status : optional
	 * SUMMARY: Determine if a given path is available for I/O routing.
	 */
	OPTIONAL LWORD (*mpp_CheckPathGood) (RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun);

	/*
	 * Status : optional
	 * SUMMARY: perform necessary steps make virtual target.
	 * 	    Defined in Linux and Win but dummy in MPRas.
	 */
	OPTIONAL MPP_DIR_HANDLE (*mpp_makeVirtualTarget)(targ_t targ);
	

	/*
	 * Status : optional
	 * SUMMARY:  Create controller vertex for the given controller path
         * Example:  in LINUX,  /proc/mpp/array_name/controller/path is created.
	 * 	    Defined in Linux and Win but dummy in MPRas.
	 */
	OPTIONAL MPP_DIR_HANDLE (*mpp_CreateControllerVertex)(RdacDeviceInformation_t *RdacInfo, 
								BYTE ControllerIndex, BYTE Path, 
								ControllerAddress_t *DeviceAddress);

	/*
	 * Status : optional
  	 * SUMMARY:  mpp_CreateLunLink updates the OS device directories and object graphs, if applicable,
	 * to indicate the existence of the path to the logical unit.
	 * 	    Defined in Linux and Win but dummy in MPRas.
	 */
	OPTIONAL void (*mpp_CreateLunLink)(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, 
					BYTE ControllerIndex, BYTE PathIndex, LWORD Lun);
	
	/*
	 * Status : optional
  	 * SUMMARY:  Removes a controller path directory from the host (Ex: Linux path for controller path in /proc file system )
	 * 	    Defined in Linux and Win but dummy in MPRas.
	 */
	OPTIONAL void (*mpp_RemovePathDirectory)(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path);
	
	/*
	 * Status : optional
	 * SUMMARY:  Remove system resources for the storage array module
	 * 	    Defined in Linux and Win but dummy in MPRas.
	 */
	OPTIONAL void 	(*mpp_RemoveModule) (MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo);

	/*
	 * Status : optional
	 * SUMMARY:  MPP function that goes through RdacInfo data structure to 
	 *	     find if a device has already been discovered.
	 * 	    Defined in Linux and MPRas but dummy in Windows.
	 */
	OPTIONAL LWORD	(*mppSys_DeviceAlreadyDiscovered) (MPP_HANDLE Devicepnt, LWORD Lun);
	
	/*
	 * Status : optional
	 * SUMMARY: MPP function that prints sense data buffer. (dummy in MPRAS , WINDOWS)
	 */
	OPTIONAL void (*mppSys_PrintSenseBuffer) ( IN RdacDeviceInformation_t *RdacInfo, IN LWORD Controller, 
				                       IN LWORD Path, IN void *SenseBuffer,IN ULONG SerialNumber);
	/*
	 * Status : optional
	 * SUMMARY: MPP function that acquires a reference count for a DeviceVertex.
	 * 	    Defined in Windows but dummy in Linux and MPRas.
	 */
	OPTIONAL LWORD (*mppSys_AcquireReferenceCount) (IN MPP_HANDLE DeviceVertex);

	/*
	 * Status : optional
	 * SUMMARY: MPP function that releases a reference count for a DeviceVertex.
	 * 	    Defined in Windows but dummy in Linux and MPRas.
	 */
	OPTIONAL void (*mppSys_ReleaseReferenceCount) (IN MPP_HANDLE DeviceVertex);

	/*
	 * Status : optional
	 * SUMMARY: MPP function that determines if a Lun is truly configured from the storage array.
	 * 	    Defined in Linux but dummy in Windows.
	 */
	OPTIONAL BOOL (*mppSys_IsConfiguredDevice) (IN MPP_HANDLE DeviceVertex, IN ControllerAddress_t *DeviceAddress, IN LWORD Lun);
			
	/*
	 * Status : optional
	 * SUMMARY: MPP function that performs any actions before issuing a failover request.
	 */
	OPTIONAL void (*mppSys_PreFailoverProcessing) (IN RdacDeviceInformation_t *RdacInfo, IN BYTE ControllerIndex, IN MPPCMN_FAILOVER_METHOD FailoverMethod);

	/*
	 * Status : optional
	 * SUMMARY: MPP function that performs any actions after a failover request has been completed.
	 */
	OPTIONAL void (*mppSys_PostFailoverProcessing) (IN RdacDeviceInformation_t *RdacInfo, IN BYTE ControllerIndex, IN MPPCMN_FAILOVER_METHOD FailoverMethod);
			
	
} mppCmn_SysInterface_t;

/***  GLOBAL DEFINITIONS    ***/
extern mppCmn_SysInterface_t *mpp_SysInterface;

/*** prototypes ***/
LWORD 
mppCmn_RegisterSysInterface( IN mppCmn_SysInterface_t *platformInterface  );

OPTIONAL LWORD  
mppCmn_default_IsOkayToClearRdacLuns(IN RdacDeviceInformation_t *RdacInfo, IN LWORD Lun);

OPTIONAL void
mppCmn_default_RemoveControllerDirectory(IN MPP_HANDLE DeviceVertex, IN RdacDeviceInformation_t *RdacInfo, IN BYTE Controller);

OPTIONAL void
mppCmn_default_ThreadDelay(IN ULONG DelayTime, IN ULONG DelayResolution);

OPTIONAL LWORD
mppCmn_default_AreControllerPathsFailed(RdacDeviceInformation_t *RdacInfo, BYTE ControllerIndex, LWORD lun);

OPTIONAL MPP_HANDLE
mppCmn_default_CreateUtmDevice(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t    *RdacInfo, BYTE ControllerIndex,
                                                                BYTE Path, LWORD        Lun);

OPTIONAL void
mppCmn_default_RemoveUTM(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun);

OPTIONAL void
mppCmn_default_RemoveLunLink(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun);

OPTIONAL void
mppCmn_default_RemoveVirtualLun(RdacDeviceInformation_t *RdacInfo, LWORD Lun);

OPTIONAL LWORD
mppCmn_default_CheckPathGood(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun);

OPTIONAL MPP_DIR_HANDLE
mppCmn_default_makeVirtualTarget(targ_t targ);

OPTIONAL MPP_DIR_HANDLE
mppCmn_default_CreateControllerVertex ( RdacDeviceInformation_t *RdacInfo, BYTE ControllerIndex, BYTE Path, ControllerAddress_t *DeviceAddress);

OPTIONAL void
mppCmn_default_CreateLunLink(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE ControllerIndex, BYTE PathIndex, LWORD Lun);

void
mppCmn_default_RemovePathDirectory(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path);

void
mppCmn_default_RemoveModule(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo);

LWORD
mppCmn_default_DeviceAlreadyDiscovered(MPP_HANDLE Devicepnt, LWORD Lun);

OPTIONAL void 
mppCmn_default_PrintSenseBuffer ( IN RdacDeviceInformation_t *RdacInfo, IN LWORD Controller, 
				  IN LWORD Path, IN void *SenseBuffer,IN ULONG SerialNumber);

OPTIONAL LWORD
mppCmn_default_AcquireReferenceCount(IN MPP_HANDLE DeviceVertex);

OPTIONAL void
mppCmn_default_ReleaseReferenceCount(IN MPP_HANDLE DeviceVertex);

OPTIONAL BOOL 
mppCmn_default_IsConfiguredDevice(IN MPP_HANDLE DeviceVertex, IN ControllerAddress_t *DeviceAddress, IN LWORD Lun);

OPTIONAL void 
mppCmn_default_PreFailoverProcessing(IN RdacDeviceInformation_t *RdacInfo, IN BYTE ControllerIndex, IN MPPCMN_FAILOVER_METHOD FailoverMethod);

OPTIONAL void 
mppCmn_default_PostFailoverProcessing(IN RdacDeviceInformation_t *RdacInfo, IN BYTE ControllerIndex, IN MPPCMN_FAILOVER_METHOD FailoverMethod);

#endif /* End of __INCmppCmn_SysInterface */
