/*******************************************************************************
* Copyright 2004-2008 LSI Corporation.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            mppLnx26p_vhba.h
SUMMARY         %description%
VERSION         %version: 11 %
UPDATE DATE     %date_modified: Mon Jun 30 11:46:10 2008 %
PROGRAMMER      %created_by:    bmoger %

DESCRIPTION: This header file defines data structs and definitions for the Linux
               MPP Virtual HBA driver.

INCLUDE FILES:

NOTES:
   This header file must be included after all Linux kernel include files.

RESTRICTIONS:

SEE ALSO:

REFERENCE:

  349-1033500 Linux MPP Driver Feature Architecture Specification
  349-1034610 Linux MPP Virtual HBA Driver Feature Design Document
  349-1034750 Linux MPP Upper Level Driver Feature Design Document
  349-1034730 Linux MPP Utility Feature Design Document
  349-1034620 Linux MPP Installation Feature Design Document

IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/


#ifndef __INCmppLnx26p_vhba
#define __INCmppLnx26p_vhba


/***  INCLUDES  ***/  
#include <scsi/scsi_cmnd.h>

/***  CONSTANT DEFINITIONS  ***/
#define MPPVHBASTRING "mpp virtual bus adapter "
#define TIME_STAMP    "timestamp"
#define         MPPLNX_PROC_NAME "mpp"

/** the size of a proc leaf node name **/
#define NODENAMESIZE    512
#define PROCDIRNAMESIZE 1024
/** proc leaf node mode_t */
#define PROC_LEAF_NODE_MODE S_IFREG|S_IRUGO|S_IWUSR

/** proc leaf node type */
#define MPPLNX_VDEVICE_NODE 0
#define MPPLNX_PDEVICE_NODE 1



/* IO completion status */
#define MPPLNX_IO_SUCCESS              0
#define MPPLNX_IO_PATHFAILOVER         1
#define MPPLNX_IO_CTRLFAILOVER         2
#define MPPLNX_IO_FAILED               3

#define MPPLNX_LUN0_REPLACED_MAGIC     0x1698
/*
*We need assign a scsi command op code for the bus device reset message. This is no 
* such command in the scsi spec. We need to make-up an op code. The op code 0xEE 
* is in the vendor specific command group and it will not conflict with other command.
*/
#define  MPPLNX_BDR_CMND_OPCODE       0xEE
/***  MACRO DEFINITIONS  ***/
/*
* panic the kernel
* Used for reporting a program error.
*/
#define MPPLNX_VHBA_BUG() do { \
   printk("mpp vhba BUG at %s:%d!\n", __FILE__, __LINE__); \
	* ((char *) 0) = 0; \
} while (0)

/***  MACRO DEFINITIONS  ***/
#define MPPLNX_GET_LWORD_FROM_4BYTES(a) \
   (((a)[0] << 24) | \
   ((a)[1] << 16) | \
   ((a)[2] << 8 ) | \
   ((a)[3]      ))


#define MPPLNX_GET_LWORD_FROM_2BYTES(a) \
   ((((a)[0] <<8) & 0x0000ff00)| \
   (((a)[1]    ) & 0x000000ff))
/*
* physical device proc read buffer size
*/
#define MPPLNX_PROC_READ_BUFFSIZE 8192
/* define the /proc/scsi/mpp/host_no proc info buffer size
* as 8*1024
*/
#define MPPLNX_PROC_INFO_BUFFSIZE 4095*5
#define WWN_LENGTH                  16

/*
* A virtual IO which is first time dispatched to the
* virtual HBA driver. Its previous controller is not-defined
*/
#define UNKNOWN_PREVIOUS_CONTROLLER    200

#define UNKNOWN_PREVIOUS_PATH          200

//#ifdef MPP_DEBUG FIX ME
extern char * mppStatusStrings[];

extern char * mppActionStrings[];


#ifdef MPP_DEBUG
#define MPPLNX_DUMP_SCSI_HOST_TEMPLATE(x)  \
                mppLnx_dump_Scsi_Host_Template(x)
#define MPPLNX_DUMP_SCSI_HOST(x)  \
                mppLnx_dump_Scsi_Host(x)
#define MPPLNX_DUMPCMND(x)   \
                mppLnx_dumpCmnd(x)
#define MPPLNX_DUMP_PROXYREQUESTLIST(x) \
                mppLnx_dump_proxyRequestList(x)
#define MPPLNX_DUMP_PDEVICEENTRY(x) \
                mppLnx_dump_PDeviceEntry(x)
#define MPPLNX_DUMPREADWRITECDB(x) \
               mppLnx_dumpReadWriteCdb(x)
#else
#define MPPLNX_DUMP_SCSI_HOST_TEMPLATE(x)
#define MPPLNX_DUMP_SCSI_HOST(x) 
#define MPPLNX_DUMPCMND(x)  
#define MPPLNX_DUMP_PROXYREQUESTLIST(x)
#define MPPLNX_DUMP_PDEVICEENTRY(x)
#define MPPLNX_DUMPREADWRITECDB(x)
#endif

/* sense buffer length  */
#define PRINT_SENSE_BUFFER_LENGTH 	1024

/***  TYPE DEFINITIONS  ***/


/***  LOCALS  ***/


/***  PROCEDURES  ***/



typedef struct mppLnx_ProcLeafNode
{
   int                        nodeType;
   char                       nodeName[NODENAMESIZE];
   struct proc_dir_entry      *parent;
   struct proc_dir_entry      *thisNode;
   int                        isCreated;
   int                        needsClean;
   mode_t                     procMode;
}  mppLnx_ProcLeafNode_t;
/*
* this definition should be removed
*after the common code is ready
*/
typedef enum _mppLnx_proxyRequestState {
   MPPLNX_REQUEST_NOTUSED = 0,
   MPPLNX_REQUEST_DPQUEUED,
   MPPLNX_REQUEST_DISPATCHED,
   MPPLNX_REQUEST_COMPLETING,
   MPPLNX_REQUEST_DEFERRED
} mppLnx_proxyRequestState_t;

typedef enum _mppLnx_proxyRequestType {
   MPPLNX_DELAY_RESPONSE_TYPE = 0,
   MPPLNX_QUEUED_CMND_TYPE,
   MPPLNX_COMPLETED_CMND_TYPE,
   MPPLNX_REQUEUED_CMND_TYPE,
   MPPLNX_SCSI2TOSCSI3_TRAN_TYPE,
   MPPLNX_VALIDATE_PATH_TYPE,  
   MPPLNX_FAILOVER_CMND_TYPE  
} mppLnx_proxyRequestType_t;

typedef struct mppLnx_ProxyRequestEntry
{
   struct list_head           dispatch_list;
   struct list_head           avail_list;
   struct list_head           pending_list;
   struct list_head           queued_list;
   struct list_head           s2tos3_list;
   struct list_head           pathvalidation_list;
   struct scsi_cmnd           *vcmnd;
   unsigned char              sense_buffer[SCSI_SENSE_BUFFERSIZE]; 
   struct scsi_device         *pdev;
   struct Scsi_Host           *phost;
   unsigned long              startTime;
   unsigned long              vcmndStartTime;
   BYTE                       SelectionTimeoutRetryCount;
   BYTE                       CommandTimeoutRetryCount;
   BYTE                       UaRetryCount;
   BYTE                       RetryCount;
   MPP_TIME                   ControllerIoWaitTime;
   MPP_TIME                   ArrayIoWaitTime;
   void(*vcmd_timeoutfunc)(struct scsi_cmnd *);
   unsigned int               expire_time;
   unsigned int               lun;
   unsigned int               vtid;
   unsigned short 	      host_no; /* Physical host number */
   unsigned int  	      channel; /* Physical channel number */
   unsigned int               id;      /* Physical lun id         */
   RdacDeviceInformation_t    *rdacInfo;
   void (*done)(struct scsi_cmnd *);
   mppLnx_proxyRequestState_t state;
   mppLnx_proxyRequestType_t  dispatchType;
   BYTE                       controller;
   BYTE                       path;
   int                        errorRecovery;
   int                        result;
   int                        resid;
   BYTE                       writeWithVerify;
   BOOL                       isVcmdCompleted;
   MPPCMN_FAILOVER_METHOD     FailoverMethod;
   BOOL                       ForcedQuiescence;
   BOOL                       noHoldInReset;
   struct request             *req;
   void (*mppLnx_done)(void *data, char *sense, int result, int resid);
   }  mppLnx_ProxyRequestEntry_t;


typedef struct mppLnx_AsyncRequestEntry
{
   struct list_head        free_list;
   struct scsi_cmnd        *cmnd;   /*the mpp driver manufactured struct scsi_cmnd*/
   void                    *buffer; /*the data buffer of the command */
   
}mppLnx_AsyncRequestEntry_t;

typedef struct mppLnx_PDeviceEntry
{
   mppLnx_ProcLeafNode_t			procNode;
   struct scsi_device               *pdevice;
   RdacDeviceInformation_t          *rdacInfo;
   int                              controllerSlot;
   int                              pathId;
   int                              ioCount;
   int                              longestTrip;
   int                              shortestTrip;
   int                              ioFails;
   int                              numPathFailures;
   BOOL                             PRKeyRegistered; /* Plun flag to be set when the LUNs gets Registered */
   BOOL                             IsReserved;
}  mppLnx_PDeviceEntry_t;




typedef struct mppLnx_PtargetEntry
{
   struct list_head              list;
   int                           targetId;
   int                           channelId;
   mppLnx_PDeviceEntry_t         ** pdevices;
} 	mppLnx_PtargetEntry_t;



typedef struct mppLnx_VDeviceEntry
{
   struct   list_head         list;
   mppLnx_ProcLeafNode_t      procNode;
   struct scsi_device         *vdevice;
   RdacDeviceInformation_t    *rdacInfo;
   int                        lun;
   int                        ioCount;
   int                        ioFails;
   int                        longestTrip;
   int                        shortestTrip;
   int                        numPathFailures;
   int                        numCntlFailures;
   unsigned long              cntlFailoverStartTime;
   unsigned long              pathFailoverStartTime;
   unsigned long              longestCntlFailoverTime;
   unsigned long              shortestCntlFailoverTime;
   unsigned long              longestPathFailoverTime;
   unsigned long              shortestPathFailoverTime;
   BOOL                       PRKeyValid; /* Virtual LUN flag set when the LUN gets registered */
   TEXT                       PRKey[8];   /* To store the PRKey */
   BOOL                       IsReserved;
   BYTE                       srvActCode; /* To store Service Action Key from the original PROUT cmnd */
}  mppLnx_VDeviceEntry_t;


typedef struct mppLnx_PhostEntry
{
   struct list_head           list;
   int                        hostNo;
   struct Scsi_Host           *host;
   mppLnx_PtargetEntry_t      *targetList;
} 	mppLnx_PhostEntry_t;



typedef struct mppLnx_VHBAContext
{
   spinlock_t                 *vhbaContextLock;
   mppLnx_PhostEntry_t        *phostList;
   mppLnx_VDeviceEntry_t      *virtualDeviceList;
   struct scsi_host_template  *vhbaSHTP;
} 	mppLnx_VHBAContext_t;


typedef enum _mppLnx_queue_type {
   MPPLNX_QUEUE_FREE_LIST=0,
   MPPLNX_QUEUE_DEFERRED_LIST,
   MPPLNX_QUEUE_QUEUED_LIST,
   MPPLNX_QUEUE_DISPATCHED_LIST,
   MPPLNX_QUEUE_S2TOS3_LIST,
   MPPLNX_QUEUE_PATHVALIDATION_LIST
} mppLnx_queue_type_t;
/*
*proxy request queue list
*/
typedef struct mppLnx_queueContext
{
   spinlock_t                 queueLock;
   struct list_head           list;
   mppLnx_queue_type_t        queueType;
}  mppLnx_queueContext_t;

/*
* Use a kernel thread to dispatch proxy commands
*/
typedef struct mppLnx_dpcThreadQueue
{
   struct semaphore           *dpc_sem;
   struct semaphore           *detect_sem;
   pid_t                      dpcQueue_pid;
   //mppLnx_CmndEntry_t         *cmndEntry;
   //spinlock_t                 *cmndQueueLock;
   LWORD                      isStopped;
   atomic_t                   needSchedule; /* 1 yes 0 not*/
} mppLnx_dpcQueueContext_t;


/**
* data struct for failback rescan thread
*/
typedef struct mppLnx_failbackScanContext
{
   struct semaphore       *failback_sem;
   struct semaphore       *detect_sem;     			/*for the thread start and termination*/
   pid_t                  failback_pid;
   atomic_t               scan_active;               		 /* Set this if scan already in progress */
   LWORD                  isStopped;
   struct timer_list      fbs_timer;
} mppLnx_failbackScanContext_t;

/**
* data struct for pathvalidation  thread for completinf "PRRegistration check"
*/
typedef struct mppLnx_pathvalidateContext
{
   struct semaphore       *pathvalidate_sem;
   struct semaphore       *detect_sem;     			/*for the thread start and termination*/
   pid_t                  pathvalidate_pid;
   atomic_t               scan_active;               		 /* Set this if scan already in progress */
   LWORD                  isStopped;
} mppLnx_pathvalidateContext_t;
/*
* data struct for sync IO queue
*/
typedef struct mppLnx_workerQueueContext
{
   struct semaphore       *workerQueue_sem;
   struct semaphore       *detect_sem;      /*for the thread start
                                             *and termination*/
   pid_t                  workerQueue_pid;
   atomic_t               worker_active;
   //spinlock_t             *cmndQueueLock;
   LWORD                  isStopped;
   //mppLnx_CmndEntry_t     *cmndEntry;
} mppLnx_workerQueueContext_t;

typedef struct mppLnx_vhbaMemPool
{
   struct kmem_cache   *memCache;
   int            size;       /* number of the objects */
} mppLnx_vhbaMemPool_t;

typedef enum {
   SCAN_VHOST,
   ADD_VDEV
} mppLnx_workqType_t;

typedef struct mppLnx_workQueueWrapper
{
   struct work_struct work;
   void   (* callback_fcn)(void *context);
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,20))
   struct delayed_work dwork;
#endif
   void   * work_context;
} mppLnx_workQueueWrapper_t;
   
typedef struct mppLnx_vdAddEvent
{
   RdacDeviceInformation_t    * rdacInfo;
   struct scsi_device         * sdp;
   int                        lun;
   int                        tid;
   unsigned long              startTime;
   mppLnx_workqType_t         eventType;
} mppLnx_vdAddEvent_t;
/*
*fit to the new device model
*/
void mppLnx_primary_device_release(struct device * dev);
void mppLnx_mppvadapter0_release(struct device *dev);
int  mppLnx_mppvbus_match(struct device * dev, struct device_driver * drv);
int  mppLnx_mppvbus_driver_probe(struct device * dev);
int  mppLnx_mppvbus_driver_remove(struct device * dev);
int  mppLnx_slave_alloc(struct scsi_device *);
int  mppLnx_slave_configure(struct scsi_device *);
void mppLnx_slave_destroy(struct scsi_device *);
int  mppLnx_init_virtual_hba(int fromVscan);
int  mppLnx_release_virtual_host(void);
void mppLnx_vhba_init_queues(void);
int  mppLnx_vhba_mem_alloc(int size);
int  mppLnx_vhba_mem_free(int size);
int  mppLnx_vhba_arMem_alloc(int size);
int  mppLnx_vhba_arMem_free(int size);
mppLnx_ProxyRequestEntry_t * 	mppLnx_get_free_proxyRequest( void );
void	mppLnx_put_free_proxyRequest( mppLnx_ProxyRequestEntry_t *pre);
void  mppLnx_remove_proxyRequest_from_list(
      mppLnx_ProxyRequestEntry_t *pre,
      mppLnx_queue_type_t type);
void  mppLnx_insert_proxyRequest_to_list( 
       mppLnx_ProxyRequestEntry_t *pre,
       mppLnx_queue_type_t type);

mppLnx_AsyncRequestEntry_t * mppLnx_get_free_asyncRequest(void);
void  mppLnx_put_free_asyncRequest(mppLnx_AsyncRequestEntry_t *are);



int mppLnx_proc_info(struct Scsi_Host *, char *, char **, off_t, int, int);

const char * mppLnx_info(struct Scsi_Host * shp);
int mppLnx_queuecommand(struct scsi_cmnd * scp, void (*done)(struct scsi_cmnd *));
int mppLnx_eh_device_reset_handler(struct scsi_cmnd * scp);
int mppLnx_eh_bus_reset_handler(struct scsi_cmnd * scp);
int mppLnx_eh_host_reset_handler(struct scsi_cmnd * scp);
int mppLnx_bios_param(struct scsi_device *, struct block_device *,
			sector_t, int []);
int mppLnx_createVDeviceProcNode(mppLnx_VDeviceEntry_t * vde);
int mppLnx_initVHBAContext(void);
int mppLnx_createPDeviceProcNode(mppLnx_PDeviceEntry_t * pde);
void mppLnx_removeVDeviceProcNode(mppLnx_VDeviceEntry_t * vde);
void mppLnx_removePDeviceProcNode(mppLnx_PDeviceEntry_t * pde);
int mppLnx_PDevice_read_proc(char *, char ** , off_t , int , int *, void *);
int  mppLnx_change_queue_depth(struct scsi_device * sdev, int queue_depth);
void mppLnx_cleanProcFiles(mppLnx_VHBAContext_t * hbaContext);
void mppLnx_newDeviceAdded(struct scsi_device * sdp);
void mppLnx_vhbaScanHost(int);

int mppLnx_do_queuecommand(mppLnx_ProxyRequestEntry_t * preq);

void mppLnx_IssueFailover(RdacDeviceInformation_t *rdacInfo, BYTE controller, 
		BYTE Path, MPP_HANDLE FailoverHandle, BYTE *Page2C, BYTE *cdb,
		MPPCMN_FAILOVER_METHOD FailoverMethod,
		BOOL ForceQuiescence, BOOL noHoldInReset);
void mppLnx_failoverCmd_done(void *data, char *sense, int result, int resid);
void mppLnx_printsensebuffer (RdacDeviceInformation_t *RdacInfo, LWORD Controller, 
	                        LWORD Path, void *SenseBuffer, ULONG SerialNumber);
LWORD mppLnx_validatepath (RdacDeviceInformation_t *RdacInfo, LWORD Controller, LWORD Path);
void mppLnx_validatepath_done(void *data, char *sense, int result, int resid); 
void __mppLnx_validatepath_done( mppLnx_ProxyRequestEntry_t    *prequest); 
void __mppLnx_scsi_done( mppLnx_ProxyRequestEntry_t    *prequest); 
void __mppLnx_failoverCmd_done ( mppLnx_ProxyRequestEntry_t    *proxyRequest);
void mppLnx_flushdeferredqueue( WORD Host , BYTE Target );
void mppLnx_scsi_done(void *data, char *sense, int result, int resid); 
int mppLnx_failback_handler(void * data);
int mppLnx_pathvalidate_handler(void * data);
void mppLnx_rescan_timer_handler(unsigned long data);
void mppLnx_failbackRescan(void);
mppLnx_VDeviceEntry_t * mppLnx_get_VdeviceEntry(struct scsi_device *vdevice);
mppLnx_VDeviceEntry_t * mppLnx_insert_VdeviceEntry(int, RdacDeviceInformation_t *);
mppLnx_VDeviceEntry_t * mppLnx_createVDeviceEntry(int, RdacDeviceInformation_t *);
mppLnx_PDeviceEntry_t * mppLnx_get_PdeviceEntry(struct scsi_device *pdevice);
void mppLnx_insert_PdeviceEntry(struct scsi_device * pdevice, 
		RdacDeviceInformation_t *rdacInfo, int , int );
mppLnx_PhostEntry_t * mppLnx_createPhostEntry(struct scsi_device * pdevice);
mppLnx_PtargetEntry_t * mppLnx_createPtargetEntry(struct scsi_device *);
void mppLnx_checkPdevEntry(RdacDeviceInformation_t * rdacInfo);
void mppLnx_wakeup_pathvalidate_thread(void );
void mppLnx_cleanup_requests_per_scsi_device( struct scsi_device *sdev);
LWORD mppLnx_PersistentReserveOut(RdacDeviceInformation_t *rdacInfo, struct scsi_cmnd *vcmd,
                                  BYTE serviceAction, unsigned char *proutParamDataBuffer);
LWORD mppLnx_PersistentReserveIn(RdacDeviceInformation_t *rdacInfo, struct scsi_cmnd *vcmd,
                                 BYTE serviceAction, unsigned char *KeyParamDataBuffer);


int mppLnx_dpc_handler(void * data);

void mppLnx_Scsi2toScsi3_handler( struct scsi_cmnd * scp);
int mppLnx_worker_handler(void * data);
void mppLnx_schedule_resp( struct scsi_cmnd * scp);
int  mppLnx_delete_VdeviceEntry(mppLnx_VDeviceEntry_t *);
int  mppLnx_delete_PdeviceEntry(struct scsi_device *);
int  mppLnx_cleanVHBAContext(void);
void mppLnx_TestAndGetDevice(struct scsi_device * sdev, LunPathInfo_t * lunPathInfo);
void mppLnx_TestAndPutDevice(struct scsi_device * sdev, LunPathInfo_t * lunPathInfo);


mppLnx_ProxyRequestEntry_t * mppLnx_createProxyRequest(
	  struct scsi_cmnd * vscp,
	  struct scsi_cmnd *proxyCmnd);
void mppLnx_update_VdeviceStat(
       mppLnx_VDeviceEntry_t * vde, 
       int ioStatus, 
       unsigned long roundTrip);
void mppLnx_update_PdeviceStat(
        mppLnx_PDeviceEntry_t *pde,
        int ioStatus, 
        unsigned long startTime);

struct scsi_device * mppLnx_getAnyPathByVDev(struct scsi_device *);

int mppLnx_VDevice_read_proc
(
      char *page, 
      char ** start, 
      off_t offset, 
      int count, 
      int *eof, 
      void *data);


void mppLnx_BytestoAscii(char *ascii, char *buff, int bufflen);

void mppLnx_schedule_queuecmd( struct scsi_cmnd * scp);
void mppLnx_setCheckCondition(struct scsi_cmnd * vcmd, SenseData_t *sensedata);

extern void mpp_ConvertWWNtoAscii(BYTE *AsciiWWN, BYTE *ArrayWWN);
extern BYTE mpp_FailController(RdacDeviceInformation_t * rdacInfo,
                               BYTE controller,
                               LWORD lun);
extern int mppLnx_addWorkQueue(void *context, mppLnx_workqType_t type );
extern LWORD mppLnx_QueueRequest(MPPCMN_QUEUE_REQUEST_CALLBACK RequestCallback, void *Context, LWORD DelaySecs);

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,20))
extern void mppLnx_delayHostScanWorkHandler(struct work_struct *ws);
extern void mppLnx_vdAddWorkHandler(struct work_struct *ws);
extern void mppLnx_genericCallback(struct work_struct *ws);
#else
extern void mppLnx_delayHostScanWorkHandler(void * arg);
extern void mppLnx_vdAddWorkHandler(void * arg);
extern void mppLnx_genericCallback(void *arg);
#endif

#ifdef MPP_DEBUG
void mppLnx_dump_Scsi_Host_Template(struct scsi_host_template *sht);
void mppLnx_dump_Scsi_Host(struct Scsi_Host *shp);
void mppLnx_dumpCmnd(struct scsi_cmnd * SCnp);
void mppLnx_dump_proxyRequestList(mppLnx_ProxyRequestEntry_t * requestList);
void mppLnx_dump_PDeviceEntry(mppLnx_PDeviceEntry_t * pde);
void mppLnx_dumpReadWriteCdb(struct scsi_cmnd *vSCp);
#endif


extern mppLnx_queueContext_t mppLnx_freeProxyRequestQ;
extern mppLnx_queueContext_t mppLnx_DPProxyRequestQ;
extern mppLnx_queueContext_t mppLnx_deferredProxyRequestQ;
extern mppLnx_queueContext_t mppLnx_queuedProxyRequestQ;
extern mppLnx_queueContext_t mppLnx_s2tos3ProxyRequestQ;
extern mppLnx_queueContext_t mppLnx_pathvalidationProxyRequestQ;

extern mppLnx_queueContext_t mppLnx_freeAsyncRequestQ;

extern mppLnx_vhbaMemPool_t          mppLnx_vhba_pqPool;

extern mppLnx_vhbaMemPool_t          mppLnx_vhba_arPool;

extern int mppLnx_workTaskRefCnt;
extern int mppLnx_startVhbaModRemove;
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,16))
int mppLnx_scsi_delete_timer(struct scsi_cmnd *scmd);
void mppLnx_scsi_add_timer(struct scsi_cmnd *scmd, int timeout,
		    void (*complete)(struct scsi_cmnd *));
#endif

#endif        /* End of __INCmppLnx26p_vhba */
