/*******************************************************************************
*  Copyright 2004-2008 LSI Corporation.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            MPP_hba.c
SUMMARY         %description%
VERSION         %version: 155 %
UPDATE DATE     %date_modified: Wed Jul 23 14:16:51 2008 %
PROGRAMMER      %created_by:    harshi %

DESCRIPTION:

INCLUDE FILES:

NOTES:

RESTRICTIONS:

SEE ALSO:

REFERENCE:

IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/
/*
*	For Error Log purposes this module has been assigned numbers 1-249.
*	the last number currently used is 163.
*/
#define __SRCMPP_hba

/***  INCLUDES  ***/

#include "MPP_Sysdep.h"
#include "MPP_Common.h"
#include "MPP_RdacInfo.h"
#include "MPP_ProtoTypes.h"
#include "mppCmn_s2tos3.h"
#include "mppCmn_SysInterface.h"
#include "copyright.h"

/***  CONSTANT DEFINITIONS  ***/
TEXT mpp_VendorId[9] = "        \0";
TEXT mpp_ProductId[17] = "                \0";
TEXT mpp_Version[16] = RAID_MANAGER_VERSION;

LWORD mpp_Debug = MPPCMN_DEFAULT_DEBUG_LEVEL;
LWORD mpp_NotReadyWaitTime = MPPCMN_DEFAULT_NOTREADYWAITTIME;
LWORD mpp_BusyWaitTime = MPPCMN_DEFAULT_BUSYWAITTIME;
LWORD mpp_QuiescenceWaitTime = MPPCMN_DEFAULT_QUIESCENCEWAITTIME;
LWORD mpp_InquiryWaitTime = MPPCMN_DEFAULT_INQUIRYWAITTIME;
LWORD mpp_MaxLunsPerArray = MPPCMN_DEFAULT_MAXLUNSPERARRAY;
LWORD mpp_MaxPathsPerController = MPPCMN_DEFAULT_MAXPATHSPERCONTROLLER;
LWORD mpp_ScanInterval = MPPCMN_DEFAULT_SCANINTERVAL;
LWORD mpp_InquiryInterval = MPPCMN_DEFAULT_INQUIRYINTERVAL;
LWORD mpp_MaxArrayModules = MPPCMN_DEFAULT_MAXARRAYMODULES;
LWORD mpp_ErrorLevel = MPPCMN_DEFAULT_ERRORLEVEL;
LWORD mpp_SelectionTimeoutRetryCount = MPPCMN_DEFAULT_SELECTIONTIMEOUTRETRYCOUNT;
LWORD mpp_CommandTimeoutRetryCount = MPPCMN_DEFAULT_COMMANDTIMEOUTRETRYCOUNT;
LWORD mpp_UaRetryCount = MPPCMN_DEFAULT_UARETRYCOUNT;
LWORD mpp_SyncRetryCount = MPPCMN_DEFAULT_RETRYCOUNT;
LWORD mpp_SynchTimeout= MPPCMN_DEFAULT_SYNCHTIMEOUT;  /* synchronous I/O timeout in seconds */
LWORD mpp_FailOverQuiescenceTime = MPPCMN_DEFAULT_FAILOVERQUIESCETIME;
LWORD mpp_FailoverTimeout = MPPCMN_DEFAULT_FAILOVERTIMEOUT;
LWORD mpp_FailBackToCurrentAllowed = MPPCMN_DEFAULT_FAILBACKTOCURRENTALLOWED;
LWORD mpp_HoldAltInReset = MPPCMN_DEFAULT_HOLDALTINRESET;
LWORD mpp_DoUARetry = MPPCMN_DEFAULT_DOUARETRY;
int   mpp_FailBackInProgress = 0;
LWORD mpp_ControllerIoWaitTime = MPPCMN_DEFAULT_CONTROLLERIOWAITTIME;
LWORD mpp_ArrayIoWaitTime = MPPCMN_DEFAULT_ARRAYIOWAITTIME;
LWORD mpp_DisableLUNRebalance = MPPCMN_DEFAULT_DISABLELUNREBALANCE;
BYTE  mpp_S2ToS3Key[8];
LWORD mpp_MaxArrayFailoverLength = MPPCMN_DEFAULT_MAXARRAYFAILOVERLENGTH;  /* max seconds to allow a controller to failover */
LWORD mppCmn_RecheckFailedPathWaitTime = MPPCMN_DEFAULT_RECHECKFAILEDPATHWAITTIME;
LWORD mppCmn_FailedPathCheckingInterval = MPPCMN_DEFAULT_FAILEDPATHCHECKINGINTERVAL;
LWORD mppCmn_IdlePathCheckingInterval = MPPCMN_DEFAULT_IDLEPATHCHECKINGINTERVAL;
LWORD mppCmn_PrintSenseBuffer = MPPCMN_DEFAULT_PRINTSENSEBUFFER;
LWORD mppCmn_AncientWaitTimeThreshold = MPPCMN_DEFAULT_ANCIENTWAITTIMETHRESHOLD;
LWORD mppCmn_NumFeatureOptions;
LWORD mppCmn_ClassicModeFailover = MPPCMN_FAILOVER_METHOD_CONTROLLER;
LWORD mppCmn_AVTModeFailover = MPPCMN_FAILOVER_METHOD_CONTROLLER;
LWORD mppCmn_LunFailoverDelay = MPPCMN_DEFAULT_LUNFAILOVERDELAY;
LWORD mppCmn_RetryFailoverDelay = MPPCMN_DEFAULT_RETRYFAILOVERDELAY;
LWORD mppCmn_PRWaitTime = MPPCMN_DEFAULT_PRWAITTIME;
MppCmn_FeatureOptionControl_t *mppCmn_FeatureOptionControl; // Global driver pointer to available Feature Options

// Global Default Load Balance Policy
MPPCMN_LOAD_BALANCE_POLICY  mppCmn_LoadBalancePolicy = MPPCMN_LB_LEAST_QUEUE_DEPTH;

ArrayModuleEntry_t *mpp_ModuleArray;

/* Global Pointer to System Dependent Functions */
mppCmn_SysInterface_t *mpp_SysInterface;


BYTE mpp_HardwareStamp[4]={0x68, 0x77, 0x72, 0x34};
BYTE mpp_FirmwareStamp[4]={0x66, 0x77, 0x72, 0x34};
BYTE mpp_SoftwareStamp[4]={0x73, 0x77, 0x72, 0x34};

MPP_FEATURE_SUPPORT	mpp_FeatureSupport[] =
{
	{ FeatMinimumFirmwareRelease, MINIMUM_MAJOR_REL, MINIMUM_MINOR_REL, 0 }
};

#define	MAX_FEATURE_SUPPORT	sizeof(mpp_FeatureSupport)/sizeof(MPP_FEATURE_SUPPORT)


/**
 ** 09/20/04 - Feature Option Control enhancement
 **/
MppCmn_FeatureOptionControl_t mppCmn_FeatureOptions[] =
{
	{ MPPCMN_FEATURE_TYPE_VARIABLE, "DebugLevel", &mpp_Debug, 0, 0, 0xFFFFFFFF, NULL },
	{ MPPCMN_FEATURE_TYPE_VARIABLE, "ErrorLevel", &mpp_ErrorLevel, 3, 0, 0x5, NULL },
	{ MPPCMN_FEATURE_TYPE_VARIABLE, MPP_DISABLELUNREBALANCE, &mpp_DisableLUNRebalance, 0, 0, 0x3, NULL },
	{ MPPCMN_FEATURE_TYPE_VARIABLE, "LoadBalancePolicy", &mppCmn_LoadBalancePolicy, 1, 0, 0x2,
				(MPPCMN_FEATURE_CALLBACK_FUNC)mppCmn_LoadBalanceFeatureCallback}
};

/***  MACRO DEFINITIONS  ***/


/***  TYPE DEFINITIONS  ***/


/***  LOCALS  ***/
LWORD mpp_GetAVTData(MPP_HANDLE DeviceVertex, BYTE *AVTPriority, BOOL *CurrentOwner, BOOL *AVTEnabled);
LWORD mpp_CheckSwVersion(MPP_HANDLE DeviceVertex, BYTE *);
BYTE mpp_FailController(RdacDeviceInformation_t *RdacInfo, BYTE Controller, LWORD Lun, LWORD mppIoErrorCondition);
LWORD mpp_SynchronousIo(MPP_HANDLE DeviceVertex, BYTE *cdb, BYTE cdblen, void *BufferAddress, LWORD BufferLength, TINY Direction);
LWORD mpp_IsNull(BYTE *BufferAddress, LWORD BufferLength);
LWORD mpp_IsBlank(BYTE *BufferAddress, LWORD BufferLength);
VOID mpp_ConvertWWNtoAscii(BYTE *AsciiWWN, BYTE *ArrayWWN);
void mpp_CreatePage2CSubPageFailoverCommand(ModePage2CSubPage_t *page2C, BYTE *cdb, BOOL noHold);
void mpp_CreatePage2CFailoverCommand(ModePage2C_t *page2C, BYTE *cdb, BOOL noHold);
BOOL	mpp_CreatePage2CSubPageRebalance(ModePage2CSubPage_t *page2C, BYTE *cdb, unsigned char *lunTable, BOOL forcedQuiescence);
BOOL	mpp_CreatePage2CRebalance(ModePage2C_t *page2C, BYTE *cdb, unsigned char *lunTable, BOOL forcedQuiescence);
void    mppCmn_InitUtilStatus(RdacDeviceInformation_t *RdacInfo,mpp_utilStatusInfo_t *utilStatusInfo);
void    mppCmn_GetPathState(RdacDeviceInformation_t *RdacInfo,mpp_utilStatusInfo_t *utilStatusInfo);
void    mppCmn_GetControllerState(RdacDeviceInformation_t *RdacInfo,mpp_utilStatusInfo_t *utilStatusInfo);
LWORD 	mppCmn_QueryPathStatus( MPP_HANDLE deviceVertex, mpp_utilPathInfo_t *utilPathInfo );
void    mppCmn_CreateModeSense2C(ModePage2C_t *Page2C, BYTE *cdb);
void	mppCmn_CreateInquiry(InqSupportedPages_t *suppPages, BYTE *cdb);
BYTE    mppCmn_ConvertToControllerState(BYTE mode);

/***  PROCEDURES  ***/

/*******************************************************************************
* PROCEDURE
*
* NAME:     mpp_FailBackScan
* SUMMARY:  go thru  the RDAC array looking for failed controllers and
*       	check to see if their back online
*/
void
mpp_FailBackScan(void)
{
	RdacDeviceInformation_t *RdacInfo;
	MPP_HANDLE 			DeviceObject;
	BYTE 				Controller;
	BYTE				path;
	LWORD				Lun;
	BYTE				i;
	ArrayModuleEntry_t		*ModPtr;
	BYTE 				PathAvail = 0;
	LWORD				*AlreadyIssuedInquiry;
	LWORD				StateIndex;

	/* need to initialize to false value */
	AlreadyIssuedInquiry = (LWORD *) MPP_INT_KMEM_ALLOC(sizeof(LWORD) * mpp_MaxArrayModules);
	if(!AlreadyIssuedInquiry)
	{
		MPP_DEBUGPRINT((MPP_FAILOVERSCAN_DEBUG+MPP_DEBUG_LEVEL_1,
			"Mpp_FailBackScan: Could not alloc inquiry memory\n"));
		return;
	}

	bzero(AlreadyIssuedInquiry, sizeof(LWORD) * mpp_MaxArrayModules);
	MPP_DEBUGPRINT((MPP_FAILOVERSCAN_DEBUG+MPP_DEBUG_LEVEL_4,
		"Mpp_FailBackScan: Called\n"));

	mpp_FailBackInProgress = TRUE;

	ModPtr = mpp_ModuleArray;
	for(i=0; i<mpp_MaxArrayModules; ++i, ++ModPtr)
	{
		RdacInfo = ModPtr->RdacInfo;
		if( !RdacInfo )
			continue;
		for( Controller=0; Controller<2; ++Controller )
		{
			CHECK_RDACINFO_EXIST(RdacInfo);
			if( !RdacInfo->ControllerInfo[Controller]->ControllerPresent )
					continue;

			mppCmn_CheckControllerForServiceMode(RdacInfo, Controller);

			for( path=0; path<mpp_MaxPathsPerController; ++path )
			{
				DeviceObject = NULL;
				CHECK_RDACINFO_EXIST(RdacInfo);
				if( ! RdacInfo->ControllerInfo[Controller]->ControllerPath[path].Present )
				{
					continue;
				}
				StateIndex = RdacInfo->ControllerInfo[Controller]->ControllerPath[path].PathStateIndex;
				CHECK_RDACINFO_EXIST(RdacInfo);
				if (RdacInfo->ControllerInfo[Controller]->ControllerPath[path].PathState[StateIndex] != MPPCMN_FAILED )
				{
					for( Lun=0; Lun<mpp_MaxLunsPerArray; ++Lun ) {
						CHECK_RDACINFO_EXIST(RdacInfo);
						if( !RdacInfo->RdacLuns[Lun].Present ||
						!RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[path].LunPathDevice ||
						RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[path].PathRemoveState )
						{
							continue;
						}
						CHECK_RDACINFO_EXIST(RdacInfo);
						DeviceObject = RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[path].LunPathDevice;
						/* If we have already not issued a successful INQUIRY to this array */
						if ( ! AlreadyIssuedInquiry[i] )
							if( mpp_CheckSwVersion(DeviceObject, &RdacInfo->FirmwareVersion[0] ) )
							{
								MPP_DEBUGPRINT((MPP_FAILOVERSCAN_DEBUG+MPP_DEBUG_LEVEL_1,
								"Mpp_FailBackScan: Getting Array Firmware Version %s:%d:%d\n",
								RdacInfo->ModuleName, Controller, path));
								if(((RdacInfo->FirmwareVersion[0] & 0x0f) == 0x05) && ((RdacInfo->FirmwareVersion[1] & 0x0f0 ) >= 0x40))
									RdacInfo->FWSonoran4OrLater = TRUE;
								if((RdacInfo->FirmwareVersion[0] & 0x0f) > 0x05)
									RdacInfo->FWSonoran4OrLater = TRUE;
								AlreadyIssuedInquiry[i] = TRUE;
							}
					}
				}

				CHECK_RDACINFO_EXIST(RdacInfo);
				if ( RdacInfo->ControllerInfo[Controller]->ControllerPath[path].PathState[StateIndex] == MPPCMN_FAILED ) {
					for( Lun=0; Lun<mpp_MaxLunsPerArray; ++Lun )
					{
						CHECK_RDACINFO_EXIST(RdacInfo);
						if( !RdacInfo->RdacLuns[Lun].Present ||
						!RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[path].LunPathDevice ||
						RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[path].PathRemoveState )
						{
							continue;
						}
						DeviceObject = RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[path].LunPathDevice;
						MPP_DEBUGPRINT((MPP_FAILOVERSCAN_DEBUG+MPP_DEBUG_LEVEL_1,
						"Mpp_FailBackScan: Checking Failed Device %s:%d:%d\n",
						RdacInfo->ModuleName, Controller, path));

						// 06/09/04 - Only check for a path if one hasn't been found.
						if(!PathAvail)
						{
							// We haven't successfully found a path yet so try this one.
							CHECK_RDACINFO_EXIST(RdacInfo);
							if( mpp_CheckSwVersion(DeviceObject, &RdacInfo->FirmwareVersion[0] ) )
							{
								MPP_DEBUGPRINT((MPP_FAILOVERSCAN_DEBUG+MPP_DEBUG_LEVEL_3, "FailBack: Found path\n"));
								++PathAvail;
							}
						}
					}

               /*
               * The message with the error number of 1 will be informational. The failback scan
               * will not change the path state because this may interfere with the on-the-fly
               * path validation. Leave the log message here because developers and test engineers
               * used to check this message for path state
               */
					if(PathAvail)
					{
						MPP_DEBUGPRINT((MPP_FAILOVERSCAN_DEBUG+MPP_DEBUG_LEVEL_3, "FailBack: %s:%d:%d Unfailed\n", RdacInfo->ModuleName,
							Controller, path));
						MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 1,
						"%s:%d:%d - Unfailed\n",
						RdacInfo->ModuleName, Controller, path));
						if(!RdacInfo->ControllerInfo[Controller]->Failed)
						{
							MPP_DEBUGPRINT((MPP_FAILOVERSCAN_DEBUG+MPP_DEBUG_LEVEL_3, "FailBack: %s:%d Unfailed\n",
								RdacInfo->ModuleName, Controller));
							MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 2,
							"%s:%d - Unfailed\n",
							RdacInfo->ModuleName, Controller));
						}
					}
					else
					{
						MPP_DEBUGPRINT((MPP_FAILOVERSCAN_DEBUG+MPP_DEBUG_LEVEL_1,
						"Mpp_FailBackScan: Device %s:%d:%d - Still Failed failed\n",
						RdacInfo->ModuleName, Controller, path));

						MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 114,
						"Mpp_FailBackScan: Device %s:%d:%d - Still Failed\n",
						RdacInfo->ModuleName, Controller, path));
					}

					PathAvail = 0;
				}
			}
		}

		RdacInfo = ModPtr->RdacInfo;
		// 01/15/04 - AutoLun Rebalance refactor
		if( RdacInfo )
			mppCmn_RebalanceLuns(RdacInfo, FALSE);
   	}

	MPP_FREE(AlreadyIssuedInquiry, sizeof(LWORD) * mpp_MaxArrayModules);
	mpp_FailBackInProgress = FALSE;

	// 09/26/02 - Added function to print an error message if only one path to a given Lun exists.
	mpp_CheckForMultiplePaths();

}

/*******************************************************************************
* PROCEDURE
*
* NAME:     mpp_CheckAVTState
* SUMMARY:  go thru  the RDAC array looking for a physical path to the array
*       	check its AVT state; enabled/disabled
*/
void
mpp_CheckAVTState(void)
{
    	RdacDeviceInformation_t *RdacInfo;
    	MPP_HANDLE DeviceObject;
    	BYTE Controller, path, i, AVTPriority, ModuleDone;
	LWORD Lun;
	LWORD StateIndex;
	BOOL CurrentOwner, AVTEnabled;
	ArrayModuleEntry_t *ModPtr;

	MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG+MPP_DEBUG_LEVEL_4,
		"Mpp_CheckAVTState: Called\n"));

	ModPtr = mpp_ModuleArray;
	for(i=0; i<mpp_MaxArrayModules; ++i, ++ModPtr) {
		RdacInfo = ModPtr->RdacInfo;
		if( !RdacInfo )
			continue;
		ModuleDone = 0;
    		for( Controller=0; Controller<2; ++Controller ) {
			CHECK_RDACINFO_EXIST(RdacInfo);
		        if( !RdacInfo->ControllerInfo[Controller]->ControllerPresent ||
		    	    RdacInfo->ControllerInfo[Controller]->Failed )
			    	continue;
			for( path=0; path<mpp_MaxPathsPerController; ++path ) {
				CHECK_RDACINFO_EXIST(RdacInfo);
				DeviceObject = NULL;
			    	StateIndex = RdacInfo->ControllerInfo[Controller]->ControllerPath[path].PathStateIndex;
				if( !RdacInfo->ControllerInfo[Controller]->ControllerPath[path].Present ||
			    	    RdacInfo->ControllerInfo[Controller]->ControllerPath[path].PathState[StateIndex] == MPPCMN_FAILED )
				    	continue;
				for( Lun=0; Lun<mpp_MaxLunsPerArray; ++Lun ) {
					CHECK_RDACINFO_EXIST(RdacInfo);
					if( !RdacInfo->RdacLuns[Lun].Present ||
					    !RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[path].LunPathDevice ||
					    RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[path].PathRemoveState )
						continue;
					DeviceObject = RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[path].LunPathDevice;
					MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG+MPP_DEBUG_LEVEL_3,
						"mpp_CheckAVTState: Checking Device %s:%d:%d:%d - 0x%lx\n",
						RdacInfo->ModuleName, Controller, path, Lun, DeviceObject));
					if( mpp_GetAVTData(DeviceObject, &AVTPriority,&CurrentOwner, &AVTEnabled) ) {
						MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG+MPP_DEBUG_LEVEL_3,
							"mpp_CheckAVTState: AVTPriority 0x%x, CurrentOwner %d, AVTEnabled %d\n",
							AVTPriority, CurrentOwner, AVTEnabled));
						if( RdacInfo->AVTEnabled != (LWORD) AVTEnabled  )
							MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 3,
							"%s - AVT Toggled - %d\n",
							RdacInfo->ModuleName, AVTEnabled));
							RdacInfo->AVTEnabled = AVTEnabled;

							// 07/20/06 - Lun failover enhancement
							if(RdacInfo->AVTEnabled)
							{
								RdacInfo->FailoverMethod = mppCmn_AVTModeFailover;
							}
							else
							{
								RdacInfo->FailoverMethod = mppCmn_ClassicModeFailover;
							}

							ModuleDone = 1;
							break;
					} else {
						MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 4,
							"Error accessing %s:%d:%d:%d for AVT state check\n",
							RdacInfo->ModuleName, Controller, path, Lun));
					}
				}
				if( ModuleDone )
					break;
			}
			if( ModuleDone )
				break;
		}
	}
}


/*******************************************************************************
* PROCEDURE
*
* NAME:     mpp_CheckForMultiplePaths
* SUMMARY:  Verify whether each Lun has more than one path and print an
*           error message if only one path is found.
*
*/
VOID mpp_CheckForMultiplePaths(void)
{
	RdacDeviceInformation_t	*rdacInfo;
	LWORD			count, lun, controller, path, lunPathCnt = 0;
	ArrayModuleEntry_t 	*moduleArray;

	for(count=0; count<mpp_MaxArrayModules; ++count)
	{
		moduleArray = mpp_ModuleArray + count;
		if((rdacInfo = moduleArray->RdacInfo))
		{
			for(lun=0; lun<mpp_MaxLunsPerArray; ++lun)
			{
				if(!(rdacInfo->RdacLuns[lun].PseudoLunObject &&
				   !rdacInfo->RdacLuns[lun].NotConfigured &&
				   rdacInfo->RdacLuns[lun].ReportedPresent))
					continue;

				for(controller = 0; controller < 2; ++controller)
				{
					for(path = 0; path < mpp_MaxPathsPerController; ++path)
					{
						if(rdacInfo->ControllerInfo[controller]->ControllerPresent &&
						   rdacInfo->ControllerInfo[controller]->ControllerPath[path].Present &&
						   rdacInfo->RdacLuns[lun].LunControllers[controller]->LunPaths[path].LunPathDevice)
						{
							lunPathCnt++;
						}

					}
				}

				if(lunPathCnt <= 1)
				{
					MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 107, "Lun %s:%d has a single path\n",
						rdacInfo->ModuleName, lun));
				}

				lunPathCnt = 0;
			}
		}
	}
}


/*******************************************************************************
* PROCEDURE
*
* NAME:     mpp_VirtualdiskInquiryData
* SUMMARY:  Insert the MPP driver inquiry data
*
*/
void
mpp_VirtualdiskInquiryData(TEXT *inqData)
{
    bcopy((caddr_t) mpp_VendorId, (caddr_t) (inqData + 8), 8);
    bcopy((caddr_t) mpp_ProductId, (caddr_t) (inqData + 16), 16);
}

/*******************************************************************************
* PROCEDURE
*
* NAME:     mpp_FailPath
* SUMMARY:  Fail the given Controller/Path and Determine if there is another path to this controller
*/
BYTE
mpp_FailPath(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path)
{
	LINT LockLevel;
	BYTE i, FailedPath=0, AnotherPathAvailable=0;
	LWORD j;
	LWORD stateIndex;

	MPP_LOCK(RdacInfo->Lock, LockLevel);

	stateIndex = RdacInfo->ControllerInfo[Controller]->ControllerPath[Path].PathStateIndex;
	if( RdacInfo->ControllerInfo[Controller]->ControllerPath[Path].PathState[stateIndex] != MPPCMN_FAILED )
	{

		MPPCMN_SET_PATH_STATE(RdacInfo, Controller, Path, MPPCMN_FAILED);
      RdacInfo->ControllerInfo[Controller]->ControllerPath[Path].PathFailedTime = 0;

		for(j=0; j<mpp_MaxLunsPerArray; ++j)
		{
			/* CR 142789 - Added checks to avoid NULL pointer references */
			if( !RdacInfo->RdacLuns[j].Present ||
                    !RdacInfo->RdacLuns[j].LunControllers[Controller]->LunPaths[Path].LunPathDevice ) {
                    continue;
			}
			MPPCMN_SET_DEVICE_PATH_STATE(RdacInfo, Controller, Path, j, MPPCMN_FAILED);
		}
		FailedPath = 1;
	}
	for(i=0; i<mpp_MaxPathsPerController; ++i) {
		stateIndex = RdacInfo->ControllerInfo[Controller]->ControllerPath[i].PathStateIndex;
		if( RdacInfo->ControllerInfo[Controller]->ControllerPath[i].PathState[stateIndex] != MPPCMN_FAILED ) {
			for(j=0; j<mpp_MaxLunsPerArray; ++j) {
				/* CR 142789 - Added checks to avoid NULL pointer references */
				if( !RdacInfo->RdacLuns[j].Present ||
						!RdacInfo->RdacLuns[j].LunControllers[Controller]->LunPaths[i].LunPathDevice ) {
                                    continue;
				}
                if( mpp_SysInterface->mpp_CheckPathGood(RdacInfo, Controller, i, j) ) {
                    MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_4,
                    "mpp_FailPath: %s:%d:%d still good\n", RdacInfo->ModuleName, Controller, i));
                    AnotherPathAvailable = 1;
                    break;
                }
			}
			if( AnotherPathAvailable )
				break;
		}
	}

	MPP_UNLOCK(RdacInfo->Lock, LockLevel);
	if( FailedPath )
		MPP_ERRORLOGPRINT((MPP_ERR_PATH_FAILOVER, 7, "%s:%d:%d Path Failed\n",
		RdacInfo->ModuleName, Controller, Path));

	return(AnotherPathAvailable);

}
/*******************************************************************************
* PROCEDURE
*
* NAME:     mpp_IsFailoverPossible
* SUMMARY:  Check for alternate paths to this controller and/or to the alternate controller
*		level indicates if it is controller (1) or path (0) failover
*
*	Returns: 1 = Failover is possible
*			 0 = Failover not possible
*/
BYTE
mpp_IsFailoverPossible(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun, BYTE level)
{
	LINT LockLevel;
	LWORD StateIndex;
	BYTE i;

	MPP_LOCK(RdacInfo->Lock, LockLevel);

	if( !level ) {
		/* 1st check for more paths to this controller */
		for(i=0; i<mpp_MaxPathsPerController; ++i) {
			StateIndex = RdacInfo->ControllerInfo[Controller]->ControllerPath[i].PathStateIndex;
			if( RdacInfo->ControllerInfo[Controller]->ControllerPath[i].PathState[StateIndex] != MPPCMN_FAILED &&
		    	(i != Path) &&
		    	RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[i].LunPathDevice &&
		    	mpp_SysInterface->mpp_CheckPathGood(RdacInfo, Controller, i, Lun) ) {
				MPP_UNLOCK(RdacInfo->Lock, LockLevel);
				return(1);
			}
		}
	}
	/* No paths to this controller available - check the alternate */
	if( !RdacInfo->ControllerInfo[Controller^1]->ControllerPresent ||
	    RdacInfo->ControllerInfo[Controller^1]->Failed ||
       RdacInfo->ControllerInfo[Controller^1]->ServiceMode )
   {
	    	/* no alternate controller */
		MPP_UNLOCK(RdacInfo->Lock, LockLevel);
		return(0);
	}

	/* 2nd check for more paths to this alternate controller */
	for(i=0; i<mpp_MaxPathsPerController; ++i) {
		StateIndex = RdacInfo->ControllerInfo[Controller^1]->ControllerPath[i].PathStateIndex;
		if( RdacInfo->ControllerInfo[Controller^1]->ControllerPath[i].PathState[StateIndex] != MPPCMN_FAILED &&
		    RdacInfo->RdacLuns[Lun].LunControllers[Controller^1]->LunPaths[i].LunPathDevice &&
		    mpp_SysInterface->mpp_CheckPathGood(RdacInfo, (BYTE) (Controller^1), i, Lun) ) {
			MPP_UNLOCK(RdacInfo->Lock, LockLevel);
			return(1);
		}
	}

	MPP_UNLOCK(RdacInfo->Lock, LockLevel);

	return(0);

}


BOOL
mpp_CreatePage2CSubPageRebalance(ModePage2CSubPage_t *page2C, BYTE *cdb, unsigned char *lunTable, BOOL forcedQuiescence)
{
	unsigned int i;
	BOOL MovedLuns = FALSE;

	page2C->PageLength[0] = 0x01;
	page2C->PageLength[1] = 0x28;
	page2C->SubPageCode = 0x01;
	page2C->PageCode = 0x2c + 0x40; /* Page 0x2C with the SPF bit set to 1 */
	page2C->RDAC_Mode[1] = 0x02; /* dual active mode */

	page2C->QuiescenceTimeout = (BYTE) mpp_FailOverQuiescenceTime;

	// 07/20/06 - CR 109208.  Check for Forced Quiescence mode on lun-based failovers.
	if(forcedQuiescence)
	{
		page2C->RDACOptions = RDAC_FORCED_QUIESENCE;
	}

	/* package the controller LUN table to transfer ownership back to preferred path */
	for(i = 0; (i < 256) && (i < mpp_MaxLunsPerArray); i++)
	{
		if(lunTable[i] == 1)
		{
			/* found a LUN that needs to be on this controller */
			page2C->ControllerLunTable[i] = 0x81;
			MovedLuns = TRUE;
		}
	}

	*cdb = SCSI_MODE_SELECT;
	*(cdb+1) = 1;
   	*(cdb+7) = (sizeof(ModePage2CSubPage_t) >> 8);
	*(cdb+8) = sizeof(ModePage2CSubPage_t) & 0x00ff;

	return MovedLuns;
}


BOOL
mpp_CreatePage2CRebalance(ModePage2C_t *page2C, BYTE *cdb, unsigned char *lunTable, BOOL forcedQuiescence)
{
	unsigned int i;
	BOOL MovedLuns = FALSE;

	page2C->PageLength = 0x68;
	page2C->PageCode = PAGE_CODE_REDUNDANT_CONTROLLER;
	page2C->RDAC_Mode[1] = 0x02; /* dual active mode */

	page2C->QuiescenceTimeout = (BYTE) mpp_FailOverQuiescenceTime;

	// 07/20/06 - CR 109208.  Check for Forced Quiescence mode on lun-based failovers.
	if(forcedQuiescence)
	{
		page2C->RDACOptions = RDAC_FORCED_QUIESENCE;
	}

	/* package the controller LUN table to transfer ownership back to preferred path */
	for(i = 0; (i < 64) && (i < mpp_MaxLunsPerArray); i++)
	{
		if(lunTable[i] == 1)
		{
			/* found a LUN that needs to be on this controller */
			page2C->ControllerLunTable[i] = 0x81;
			MovedLuns = TRUE;
		}
	}

	*cdb = SCSI_MODE_SELECT;

	*(cdb+1) = 1;
	*(cdb+8) = sizeof(ModePage2C_t);

	return MovedLuns;
}


void
mpp_CreatePage2CFailoverCommand(ModePage2C_t *page2C, BYTE *cdb, BOOL noHold)
{
	page2C->PageLength = 0x68;
	page2C->PageCode = PAGE_CODE_REDUNDANT_CONTROLLER;
	page2C->RDAC_Mode[1] = ACTIVE_MODE; /* switch to active/passive - this one active */

	/* 06/05/02 - Added option to hold the Alternate controller in reset.  This is necessary
	 * for w2k systems running MSCS where a system is configured in such a way that one node
	 * only sees the 'A' controller and the other node only sees the 'B' controller.  MSCS
	 * must be able to issue reservation/release commands to both controllers.  By holding the
	 * alternate in reset it has the side-effect of preventing one of the nodes from successfully
	 * taking over luns.
	 *
	 * 09/07/06 - CR 107498.  If noHold is set, the alternate controller will not be held
	 * in reset.  The value of noHold is initially determined in the function that called
	 * mpp_AnalyseIoError.
	 */
	if(mpp_HoldAltInReset && !noHold)
		page2C->AltRDACMode[1] = RDAC_RESET_ALTERNATE;

	page2C->QuiescenceTimeout = (BYTE) mpp_FailOverQuiescenceTime;
	page2C->RDACOptions = RDAC_FORCED_QUIESENCE;

    	*cdb = SCSI_MODE_SELECT;

    	*(cdb+1) = 1;
    	*(cdb+8) = sizeof(ModePage2C_t);
}


void
mpp_CreatePage2CSubPageFailoverCommand(ModePage2CSubPage_t *page2C, BYTE *cdb, BOOL noHold)
{
	page2C->PageLength[0] = 0x01;
	page2C->PageLength[1] = 0x28;
	page2C->SubPageCode = 0x01;
	//page2C->PageCode = PAGE_CODE_REDUNDANT_CONTROLLER;
	page2C->PageCode = 0x2c + 0x40; /* Page 0x2C with the SPF bit set to 1 */
	page2C->RDAC_Mode[1] = ACTIVE_MODE; /* switch to active/passive - this one active */

	/* 06/05/02 - Added option to hold the Alternate controller in reset.  This is necessary
	 * for w2k systems running MSCS where a system is configured in such a way that one node
	 * only sees the 'A' controller and the other node only sees the 'B' controller.  MSCS
	 * must be able to issue reservation/release commands to both controllers.  By holding the
	 * alternate in reset it has the side-effect of preventing one of the nodes from successfully
	 * taking over luns.
	 *
	 * 09/07/06 - CR 107498.  If noHold is set, the alternate controller will not be held
	 * in reset.  The value of noHold is initially determined in the function that called
	 * mpp_AnalyseIoError.
	 */
	if(mpp_HoldAltInReset && !noHold)
		page2C->AltRDACMode[1] = RDAC_RESET_ALTERNATE;

	page2C->QuiescenceTimeout = (BYTE) mpp_FailOverQuiescenceTime;
	page2C->RDACOptions = RDAC_FORCED_QUIESENCE;

    	*cdb = SCSI_MODE_SELECT;
    	*(cdb+1) = 1;
   	*(cdb+7) = (sizeof(ModePage2CSubPage_t) >> 8);
    	*(cdb+8) = sizeof(ModePage2CSubPage_t) & 0x00ff;
}


/*******************************************************************************
* PROCEDURE
*
* NAME:     mpp_FailController
* SUMMARY:  Fail the given Controller
*
* 09/07/2006 CR 107498 - the mppIoErrorCondition parameter was added to support
*                        additional error information that may be used to determine
*                        special recovery actions. See comment in mpp_AnalyseIoError
*/
BYTE
mpp_FailController(RdacDeviceInformation_t *RdacInfo, BYTE Controller, LWORD Lun, LWORD mppIoErrorCondition)
{
	LINT LockLevel;
	BYTE i, path, FailController=0, markFailed = 0;
	VOID	*Page2C;
	BYTE *cdb;
	LWORD	lun;
	LWORD	stateIndex;
	MPP_HANDLE FailoverHandle=NULL;
  BOOL noHold = FALSE;

	MPP_LOCK(RdacInfo->Lock, LockLevel);

	/*
	 * 05/13/03 - This function can be called as the result of a FAILBACK_TO_CURRENT request.
	 * In a PnP environment (aka Windows) its possible that I/O's may be sent to the virtual
	 * disk before all paths have been found, resulting in a condition where the only path
	 * available is the unowned path.  The controller will return a LUN_NOT_OWNED status when
	 * this happens.  If the FailbackToCurrent option is enabled this will result in a failover
	 * request being issued against the controller which received the original I/O request.
	 * Because of the way in which this function was written the alternate controller index
	 * is passed in.  For example, Lun 0 is owned by the 'B' controller but the only path we
	 * have is to the 'A' controller.  The controller index passed into this function would
	 * represent the 'B' controller.  The problem with the logic below is that it always marks
	 * the controller as failed even if no paths currently exist to that controller.  This will
	 * result in the controller state being Failed while any future paths are marked as
	 * Unfailed.  The failback scan process does not Unfail controllers unless one of the paths
	 * to that controller is Failed.  One could argue whether the logic should be added in the
	 * FailBack process to account for this, but at the very least this function should not
	 * mark a controller as failed if none of the paths exist.
	 */
	if( !RdacInfo->ControllerInfo[Controller]->Failed ) {
		for( path=0; path<mpp_MaxPathsPerController; ++path ) {
			if( !RdacInfo->ControllerInfo[Controller]->ControllerPath[path].Present )
				continue;

			MPPCMN_SET_PATH_STATE(RdacInfo, Controller, path, MPPCMN_FAILED);
         RdacInfo->ControllerInfo[Controller]->ControllerPath[path].PathFailedTime = 0;
			markFailed = 1;
			for( lun=0; lun<mpp_MaxLunsPerArray; ++lun)
			{
            if(RdacInfo->RdacLuns[lun].LunControllers[Controller]->LunPaths[path].LunPathDevice)
            {
               MPPCMN_SET_DEVICE_PATH_STATE(RdacInfo, Controller, path, lun, MPPCMN_FAILED);
            }
         }
		}

		if(markFailed)
		{
			RdacInfo->ControllerInfo[Controller]->Failed = TRUE;
		}
		else
		{
			RdacInfo->ControllerInfo[Controller]->Failed = FALSE;
		}

		FailController = 1;
	}

	MPP_UNLOCK(RdacInfo->Lock, LockLevel);

	/*FailController = 1;*/
	if(RdacInfo->ControllerInfo[Controller^1]->ServiceMode)
	{
	       /*
	        * alternative controller is in Service Mode. The FailController is always equal to 1
	        * because the caller of mpp_FailController set this controller's failed state to true
	        * FailController returns 0 will cause the native io completion function returns IO error
		*/
		return(0);
	}

	if(FailController) {
		if( !RdacInfo->AVTEnabled &&
		    !RdacInfo->ControllerInfo[Controller^1]->FailoverInProgress)
		{
			if(RdacInfo->Page2CSubPage1)
				Page2C = (ModePage2CSubPage_t *) MPP_INT_KMEM_ALLOC(sizeof(ModePage2CSubPage_t)+10);
			else
			        Page2C = (ModePage2C_t *) MPP_INT_KMEM_ALLOC(sizeof(ModePage2C_t)+10);

			if(!Page2C) {
				MPP_LOCK(RdacInfo->Lock, LockLevel);
	      			RdacInfo->ControllerInfo[Controller]->Failed = FALSE;
				MPP_UNLOCK(RdacInfo->Lock, LockLevel);

				MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 8,
				"%s:%d Failover Failed could not alloc memory\n",
				RdacInfo->ModuleName, Controller));
				return(0);
			}

			// 11/02/02 - mpp_CreateFailoverCommand has been replaced by new functions which build
			// the appropriate Page2C failover command depending on whether it supports 32 or 256
			// luns per partition.
      MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_FailController: mppIoErrorCondition %d\n", mppIoErrorCondition));
      if (mppIoErrorCondition & MPPCMN_EVALUATE_IO_ERROR)
      {
        if (mppIoErrorCondition & MPPCMN_LUN_CAN_BE_OWNED)
          noHold = TRUE;
      }

      if(RdacInfo->Page2CSubPage1)
			{
				cdb = ((BYTE *) Page2C) + sizeof(ModePage2CSubPage_t);
        mpp_CreatePage2CSubPageFailoverCommand(Page2C, cdb, noHold);
			}
			else
			{
			        cdb = ((BYTE *) Page2C) + sizeof(ModePage2C_t);
        mpp_CreatePage2CFailoverCommand(Page2C, cdb, noHold);
			}

			for( i=0; i<mpp_MaxPathsPerController; ++i) {
				stateIndex = RdacInfo->ControllerInfo[Controller^1]->ControllerPath[i].PathStateIndex;
				if(  RdacInfo->ControllerInfo[Controller^1]->ControllerPath[i].PathState[stateIndex] != MPPCMN_FAILED &&
				     RdacInfo->RdacLuns[Lun].LunControllers[Controller^1]->LunPaths[i].LunPathDevice &&
				     mpp_SysInterface->mpp_CheckPathGood(RdacInfo, (BYTE) (Controller^1), i, Lun) ) {
					FailoverHandle =
					RdacInfo->RdacLuns[Lun].LunControllers[Controller^1]->LunPaths[i].LunPathDevice;
					break;
				}
			}
			if( FailoverHandle && (i != mpp_MaxPathsPerController) ) {
				MPP_LOCK(RdacInfo->Lock, LockLevel);
				RdacInfo->ControllerInfo[Controller^1]->FailoverInProgress = TRUE;
				MPP_GETTIME(RdacInfo->ArrayFailoverStartTime);  /* start failover timer */
				MPP_UNLOCK(RdacInfo->Lock, LockLevel);
				mpp_SysInterface->mpp_IssueFailover(RdacInfo, (BYTE) (Controller^1), i, FailoverHandle, (BYTE *) Page2C, cdb,
					MPPCMN_FAILOVER_METHOD_CONTROLLER, FALSE, noHold);
				MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 10, "%s:%d Failover command issued\n",
				RdacInfo->ModuleName, Controller));
			} else {
				MPP_LOCK(RdacInfo->Lock, LockLevel);
	      			RdacInfo->ControllerInfo[Controller]->Failed = FALSE;
				MPP_UNLOCK(RdacInfo->Lock, LockLevel);
				MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 9,
				"%s:%d Failover Failed no path to Lun %d via controller %d\n",
				RdacInfo->ModuleName, Controller, Lun, Controller^1));
				return(0);
			}
		} else {
			if( RdacInfo->AVTEnabled ) {
				MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 106, "%s:%d:%d AVT Failover\n",
				RdacInfo->ModuleName, Controller, Lun));
			} else {
				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3,
				"mpp_FailController:s:%d Failover In Progress - skip failover command\n",
				RdacInfo->ModuleName, Controller));
			}
		}
   }
	return(1);

}

/*******************************************************************************
* PROCEDURE
*
* NAME:     mpp_IsAnotherPathAvailableForFailover
* SUMMARY:  Check for another path to the "good" controller
*/
BYTE
mpp_IsAnotherPathAvailableForFailover(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun)
{
	BYTE i;
	LWORD stateIndex;

	for(i=0; i<mpp_MaxPathsPerController; ++i) {
		stateIndex = RdacInfo->ControllerInfo[Controller]->ControllerPath[i].PathStateIndex;
		if( (i != Path) &&
		    RdacInfo->ControllerInfo[Controller]->ControllerPath[i].Present &&
		    RdacInfo->ControllerInfo[Controller]->ControllerPath[i].PathState[stateIndex] != MPPCMN_FAILED &&
		    RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[i].LunPathDevice )
		    	return(1);
	}
	return(0);
}


/*******************************************************************************
* PROCEDURE
*
* NAME:     mpp_AnalyseFailoverError
* SUMMARY:  Analyse a failover command error
*/
LWORD
mpp_AnalyseFailoverError(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun, LWORD mppStatus,
			SenseData_t *SenseData, SINT SenseLength, LWORD DataLengthXfered, MPP_TIME StartTime)
{
	MPP_TIME CurrentTime;
	BYTE path;
	LINT LockLevel;

	MPP_GETTIME(CurrentTime);
	if( !((CurrentTime - StartTime) % 60)  && (CurrentTime != StartTime) ) {
		MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_4,
		"mpp_AnalyseFailoverError: CurrentTime 0x%x, StartTime 0x%x\n", CurrentTime, StartTime));
	}

	/* Check if a failover attempt is currently in progress.
	   If so, look to see if the timer for failover in progress has expired.
	*/
	if (mpp_MaxArrayFailoverLength && RdacInfo->ArrayFailoverStartTime > 0)
	{
		if ((CurrentTime - RdacInfo->ArrayFailoverStartTime) > mpp_MaxArrayFailoverLength)
		{
			/* Timer has expired, must set the controller we are sending the command to to a failed status */
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 133, "Failover: controller failover timer has expired, setting controller: %s:%d to failed status\n", RdacInfo->ModuleName, Controller));
			MPP_LOCK(RdacInfo->Lock, LockLevel);
			for( path=0; path<mpp_MaxPathsPerController; ++path )
			{
				if( !RdacInfo->ControllerInfo[Controller]->ControllerPath[path].Present)
					continue;
				MPPCMN_SET_PATH_STATE(RdacInfo, Controller, path, MPPCMN_FAILED);
            RdacInfo->ControllerInfo[Controller]->ControllerPath[path].PathFailedTime = 0;
			}
			RdacInfo->ControllerInfo[Controller]->Failed = TRUE;
			RdacInfo->ArrayFailoverStartTime = 0;   /* reset timer */
			MPP_UNLOCK(RdacInfo->Lock, LockLevel);
		}
	}

	switch(mppStatus) {
		case MPP_GOOD_STATUS:
			if( DataLengthXfered )
			{
				RdacInfo->ArrayFailoverStartTime = 0;   /* reset failover timer */
				return(MPP_NO_FAILOVER_ERROR);
			}
			MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 11, "Failover: Good Status but no data\n"));
			return(MPP_RETRY_FAILOVER);

		case MPP_CHECK_CONDITION:
    			MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_2,
			"mpp_AnalyseFailoverError: Check Condition, sense data length %d\n",
			SenseLength));
			if( SenseLength < 3 ) {
				MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 12, "Failover: Check Condition but no Sense data\n"));
				return(MPP_RETRY_FAILOVER);
			}

    			MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_1, "mpp_AnalyseFailoverError: Sense Key %d\n", SenseData->Sense_Key));
			switch( SenseData->Sense_Key ) {
				case SENSE_KEY_ABORTED_COMMAND:
				case SENSE_KEY_NO_SENSE:
					MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 13, "Failover: retryable Error SK 0x%x, ASC/ASCQ 0x%x/0x%x\n",
					SenseData->Sense_Key,SenseData->ASC, SenseData->ASCQ));
					return(MPP_RETRY_FAILOVER);

				case SENSE_KEY_RECOVERED_ERROR:
					MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 14,
					"Failover: Recovered Error SK, ASC/ASCQ 0x%x/0x%x\n",
					SenseData->ASC, SenseData->ASCQ));
					RdacInfo->ArrayFailoverStartTime = 0;
					return(MPP_NO_FAILOVER_ERROR);

				case SENSE_KEY_NOT_READY:
					if( SenseLength < 12 ) {
						MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 15,
						"Failover: Not ready but no ASC/ASCQ\n"));
						return(MPP_RETRY_FAILOVER);
					}
					MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_1,
					"mpp_AnalyseFailoverError: Not Ready ASC/ASCQ 0x%x/0x%x\n",
					SenseData->ASC, SenseData->ASCQ));
					if( (SenseData->ASC == ASC_NOT_READY) && (SenseData->ASCQ == ASCQ_BECOMING_READY) ) {
						if( (CurrentTime - StartTime) > mpp_NotReadyWaitTime ) {
							MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 16, "Not Ready Wait Time exceeded\n"));
							RdacInfo->ArrayFailoverStartTime = 0;
							return(MPP_RETURN_FAILOVER_ERROR);
						}
						return(MPP_RETRY_FAILOVER);
					}
					MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 17,
					"Failover: Not ready & Not becoming ready\n"));
					RdacInfo->ArrayFailoverStartTime = 0;
					return(MPP_RETURN_FAILOVER_ERROR);

				case SENSE_KEY_ILLEGAL_REQUEST:
					if( (SenseData->ASC == ASC_MODE_ERROR) && (SenseData->ASCQ == ASCQ_CMD_LOCK_VIOLATION) ) {
						MPP_ERRORLOGPRINT((MPP_ERR_ALL, 18,
						"Failover: Command Lock Violation\n"));
						return(MPP_RETRY_FAILOVER);
					}
					MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 19,
					"Failover: Illegal Request ASC/ASCQ 0x%x/0x%x, SKSBs 0x%x/0x%x/0x%x\n",
					SenseData->ASC, SenseData->ASCQ, SenseData->Sense_Key_Specific_Info[0],
					SenseData->Sense_Key_Specific_Info[1], SenseData->Sense_Key_Specific_Info[2]));

					RdacInfo->ArrayFailoverStartTime = 0;
					return(MPP_RETURN_FAILOVER_ERROR);

				case SENSE_KEY_UNIT_ATTENTION:
					MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_1,
					"mpp_AnalyseFailoverError: UA ASC/ASCQ 0x%x/0x%x\n",
					SenseData->ASC, SenseData->ASCQ));
					if( (SenseLength > 12) &&
					    (SenseData->ASC == ASC_QUIESCENCE) && (SenseData->ASCQ == ASCQ_QUIESCENCE_IN_PRGS) ) {
						if( (CurrentTime - StartTime) > mpp_QuiescenceWaitTime ) {
							MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 20,
							"Failover: Quiescence Wait Time exceeded\n"));
							RdacInfo->ArrayFailoverStartTime = 0;
							return(MPP_RETURN_FAILOVER_ERROR);
						}
						return(MPP_RETRY_FAILOVER);
					}
					if( SenseLength > 12) {
						MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 21,
						"Failover: Ua, ASC/ASCQ 0x%x/0x%x, fru 0x%x\n",
						SenseData->ASC, SenseData->ASCQ, SenseData->Field_Replaceable_Unit));
					}


					return(MPP_RETRY_FAILOVER);

				case SENSE_KEY_HARDWARE_ERROR:
					if( SenseLength > 12) {
						MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 22,
						"Failover: Hardware Error ASC/ASCQ 0x%x/0x%x, fru 0x%x\n",
						SenseData->ASC, SenseData->ASCQ, SenseData->Field_Replaceable_Unit));
					}

					// 07/20/06 - CR 109208.  Lun-based Failover enhancement
					if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_CONTROLLER)
					{
						if(mpp_FailPath(RdacInfo, Controller, Path))
						{
							return(MPP_RETRY_FAILOVER);
						}
					}
					else if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
					{
						if(mppCmn_FailLun(RdacInfo, Controller, Path, Lun, MPPCMN_FAIL_LUN_ONE_PATH))
						{
							return(MPP_RETRY_FAILOVER);
						}
					}

					RdacInfo->ArrayFailoverStartTime = 0;
					return(MPP_RETURN_FAILOVER_ERROR);

				default:
					MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 23, "Failover: Unrecognized SK - %d\n",
					SenseData->Sense_Key));
					RdacInfo->ArrayFailoverStartTime = 0;
					return(MPP_RETURN_FAILOVER_ERROR);
			}

		case MPP_SCSI_BUSY:
			if( (CurrentTime - StartTime) > mpp_BusyWaitTime ) {
				MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 24, "Failover: Busy Wait Time exceeded\n"));
				return(MPP_RETURN_FAILOVER_ERROR);
			}
			return(MPP_RETRY_FAILOVER);

		case MPP_SELECTION_TIMEOUT:
			MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 25, "Failover: Retrying Selection Timeout\n"));
			if(mpp_FailPath(RdacInfo, Controller, Path))
				return(MPP_RETRY_FAILOVER);
			RdacInfo->ArrayFailoverStartTime = 0;
			return(MPP_RETURN_FAILOVER_ERROR);

		case MPP_SCSI_RESERVATION:
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL,26, "Failover: Reservation Conflict\n"));
			RdacInfo->ArrayFailoverStartTime = 0;
			return(MPP_RETURN_FAILOVER_ERROR);

		case MPP_INVALID_REQUEST:
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 27, "Failover: Illegal Command\n"));
			RdacInfo->ArrayFailoverStartTime = 0;
			return(MPP_RETURN_FAILOVER_ERROR);

		case MPP_COMMAND_TIMEOUT:
			 MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 28, "Failover: command Timeout\n"));
			RdacInfo->ArrayFailoverStartTime = 0;
			 return(MPP_RETURN_FAILOVER_ERROR);

		// 01/21/08 - CR135691.  Added new MPP common driver statuses
		case MPP_BUS_RESET:
		case MPP_IO_TIMEOUT:
			MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 29, "Failover: Retrying mpp status %d\n", mppStatus));
			RdacInfo->ArrayFailoverStartTime = 0;
			return(MPP_RETRY_FAILOVER);

		case MPP_UNSUPPORTED_SCSI_STATUS:
		case MPP_HARDWARE_ERROR:
		case MPP_COMMAND_ABORTED:
		case MPP_UNRECOGNIZED_OS_STATUS:
		case MPP_REQUEST_SENSE_FAILED:
		default:
			MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 29, "Failover: Retrying mpp status %d\n", mppStatus));
			RdacInfo->ArrayFailoverStartTime = 0;
			return(MPP_RETURN_FAILOVER_ERROR);
	}
}

/*******************************************************************************
* PROCEDURE
*
* NAME:     mpp_AnalyseIoError
* SUMMARY:
* SCOPE:    private
*
*
* DESCRIPTION: This routine determines the appropriate action to take when a SCSI I/O, via scsi_command is returned.
*
* 03/03/03 - Reworked the ErrorLog printing due to the Windows platform truncating the errorlog text.
* 09/07/06 - CR 107498 mppIoErrorCondition was added to provide additional failure information to the
*            calling function. For 107498, the focus was on not holding the alt controller in reset
*            when a 05/94/01 sense is returned.
*/
LWORD
mpp_AnalyseIoError(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun, LWORD mpp_status,
			SenseData_t *SenseData, SINT SenseLength, LWORD DataLengthXfered, MPP_TIME StartTime,
			BYTE *SelectionTimeoutRetryCount, BYTE *CommandTimeoutRetryCount, BYTE *UaRetryCount, BYTE *RetryCount,
			MPP_TIME ControllerIoWaitTime, MPP_TIME ArrayIoWaitTime, LWORD *mppIoErrorCondition)
{
	MPP_TIME CurrentTime;
	LWORD ReturnStatus;
	LWORD ErrorLevel= MPP_ERR_ALL;
	LINT LockLevel;
	TINY AdditionalErrorString[100];
	LWORD ErrorNumber = 0;
	BYTE ResetWaitTimes = FALSE;	/** 03/22/05 CR87136 - Reset the NotReady, Quiescence, and Busy Wait Times for unrecoverable errors **/
  LWORD ioErrorCondition = *mppIoErrorCondition;

	MPP_GETTIME(CurrentTime);
	bzero(&AdditionalErrorString[0], 100);
	if( !((CurrentTime - StartTime) % 60)  && (CurrentTime != StartTime) ) {
		MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_4,
		"mpp_AnalyseIoError: CurrentTime 0x%x, StartTime 0x%x\n", CurrentTime, StartTime));
	}

	switch(mpp_status) {
		case MPP_GOOD_STATUS:
			if( DataLengthXfered ) {
				sprintf(&AdditionalErrorString[0], "Good Status & %d data bytes xferred\n", DataLengthXfered);
				ErrorLevel = MPP_ERR_ALL;
				ErrorNumber = 104;
				ReturnStatus = MPP_NO_ERROR;
				break;
			}
			ErrorLevel = MPP_ERR_RETRYABLE;
			ErrorNumber = 76;
			sprintf(&AdditionalErrorString[0], "Good Status but no data\n");
			ReturnStatus = MPP_RETRY_DEC_COUNT;
			break;

		case MPP_CHECK_CONDITION:
    			MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_2, "mpp_AnalyseIoError: Check Condition, sense data length %d\n",
			SenseLength));
			if( SenseLength < 3 ) {
				ErrorLevel = MPP_ERR_RETRYABLE;
				ErrorNumber = 77;
				sprintf(&AdditionalErrorString[0], "Check Condition but no Sense data\n");
				ReturnStatus = MPP_RETRY_DEC_COUNT;
				break;
			}

    			MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_1, "mpp_AnalyseIoError: Sense Key %d\n", SenseData->Sense_Key));
			switch( SenseData->Sense_Key ) {
				case SENSE_KEY_ABORTED_COMMAND:
				case SENSE_KEY_NO_SENSE:
					ErrorLevel = MPP_ERR_RETRYABLE;
					ErrorNumber = 78;
					sprintf(&AdditionalErrorString[0],  "retryable Error SK 0x%x\n",
					SenseData->Sense_Key);
					ReturnStatus = MPP_RETRY_DEC_COUNT;
					break;
				case SENSE_KEY_RECOVERED_ERROR:
					ErrorLevel = MPP_ERR_RECOVERED;
					ErrorNumber =  79;
					sprintf(&AdditionalErrorString[0], "Recovered Error SK, ASC/ASCQ 0x%x/0x%x\n",
						SenseData->ASC, SenseData->ASCQ);

					ReturnStatus = MPP_NO_ERROR;
					break;
				case SENSE_KEY_NOT_READY:
					if( SenseLength < 12 ) {
						ErrorLevel = MPP_ERR_RETRYABLE;
						ErrorNumber = 80;
						sprintf(&AdditionalErrorString[0], "Not ready but no ASC/ASCQ\n");
						ReturnStatus = MPP_RETRY_DEC_COUNT;
						break;
					}
					MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_1, "mpp_AnalyseIoError: Not Ready ASC/ASCQ 0x%x/0x%x\n",
					SenseData->ASC, SenseData->ASCQ));
					if( (SenseData->ASC == ASC_NOT_READY) && (SenseData->ASCQ == ASCQ_BECOMING_READY) ) {

						/*
						 * 03/22/05 - CR87136.  Certain timing conditions in a Cluster environment can result in
						 * the NotReady, Busy, or Quiescence wait times being set yet they are never legitimately
						 * cleared.  For example, a host that doesn't currently own a volume may make a request
						 * which returns one of the above statuses which is retried.  On the retry we make get
						 * another error condition that is NOT retried.  As a result, depending on when the next
						 * IO request is sent from the same host one we could exceed the wait time although the
						 * timestamp reflects the _previous_ error condition.  A new configurable parameter is
						 * being introduced that will reset the timestamp to zero, then the logic below will
						 * reset the timestamp to the current time.
						 */
						if(RdacInfo->RdacLuns[Lun].NotReadyStart &&
						    ((CurrentTime - RdacInfo->RdacLuns[Lun].NotReadyStart) > mppCmn_AncientWaitTimeThreshold))
						{
							ErrorLevel = MPP_ERR_RETRYABLE;
							ErrorNumber = 147;
							sprintf(&AdditionalErrorString[0], "WaitTimeThreshold exceeded for Not Ready.  Will reset.\n");
							RdacInfo->RdacLuns[Lun].NotReadyStart = 0;
						}

						if( RdacInfo->RdacLuns[Lun].NotReady ||
						    (RdacInfo->RdacLuns[Lun].NotReadyStart &&
						    ((CurrentTime - RdacInfo->RdacLuns[Lun].NotReadyStart) > mpp_NotReadyWaitTime)) )
						{
							RdacInfo->RdacLuns[Lun].NotReady = TRUE;
							ErrorLevel = MPP_ERR_FATAL;
							ErrorNumber = 81;
							sprintf(&AdditionalErrorString[0], "Not Ready Wait Time exceeded\n");
							if( mpp_IsFailoverPossible(RdacInfo, Controller, Path, Lun, 1) )
							{
								// 07/20/06 - CR 109208.  Return status based on FailoverMethod.
								if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
								{
									ReturnStatus = MPP_FAILOVER_LUN;
								}
								else
								{
									ReturnStatus = MPP_FAILOVER_CONTROLLER;
								}
							}
					 		else
					 		{
								// 07/20/06 - CR 109208.  Lun-based Failover enhancement
								if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_CONTROLLER)
								{
									/* mark this controller as failed */
									mpp_FailPath(RdacInfo, Controller, Path);
									RdacInfo->ControllerInfo[Controller]->Failed = TRUE;
								}
								else if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
								{
									/* mark this lun as failed */
									mppCmn_FailLun(RdacInfo, Controller, Path, Lun,
										MPPCMN_FAIL_LUN_ALL_PATHS);
								}
								ReturnStatus = MPP_RETURN_ERROR;
							}
							break;
						}
						else
						{
							if( !RdacInfo->RdacLuns[Lun].NotReadyStart )
								RdacInfo->RdacLuns[Lun].NotReadyStart = CurrentTime;
						}
						ReturnStatus = MPP_RETRY_NO_DEC;
						break;
					}
					/*
					 * This case is for a pass through command to a drive.
					 * The controller never returns an 04/02 status, just pass this IO back.
					 */
					if ((SenseData->ASC == ASC_NOT_READY) && (SenseData->ASCQ == 0x02))
					{
						ReturnStatus = MPP_NO_ERROR;
						break;
					}

					/*
					 * Check if the LUN is being formatted
					 */
					if ((SenseData->ASC == ASC_NOT_READY) && (SenseData->ASCQ == ASCQ_FORMAT_IN_PROGRESS))
					{
						ReturnStatus = MPP_RETURN_ERROR;
						ErrorLevel = MPP_ERR_FATAL;
						ErrorNumber = 127;
						sprintf(AdditionalErrorString, "Lun format in progress\n");
						break;
					}

					ErrorLevel = MPP_ERR_FATAL;
					ErrorNumber = 82;
					sprintf(&AdditionalErrorString[0], "Not ready & Not becoming ready ASC/ASCQ 0x%x/0x%x\n",
					SenseData->ASC, SenseData->ASCQ);
					if( mpp_IsFailoverPossible(RdacInfo, Controller, Path, Lun, 1) )
					{
						// 07/20/06 - CR 109208.  Return status based on FailoverMethod.
						if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
						{
							ReturnStatus = MPP_FAILOVER_LUN;
						}
						else
						{
							ReturnStatus = MPP_FAILOVER_CONTROLLER;
						}
					}
			 		else
						ReturnStatus = MPP_RETURN_ERROR;
					break;

				case SENSE_KEY_ILLEGAL_REQUEST:
					if( SenseData->ASC == LUN_NOT_OWNED )
					{
						BYTE i;
						if((mpp_SysInterface->mppSys_AreControllerPathsFailed(RdacInfo, Controller^1, Lun) ||
						    ! RdacInfo->ControllerInfo[Controller^1]->ControllerPresent ||
						    RdacInfo->ControllerInfo[Controller^1]->Failed) &&
						    ! RdacInfo->ControllerInfo[Controller]->FailoverInProgress &&
						    mpp_FailBackToCurrentAllowed )
						{
							if(SenseData->ASCQ == ASCQ_LUN_CAN_BE_OWNED)
							{
								ErrorLevel = MPP_ERR_RETRYABLE;
								ErrorNumber = 83;
								sprintf(&AdditionalErrorString[0],"Lun Not owned - No Alternate\n");
								if ( RdacInfo->ControllerInfo[Controller]->ServiceMode )
								{

									/* Return error if one controller is failed and other is in service mode */
									ResetWaitTimes = TRUE;
							   		ReturnStatus = MPP_RETURN_ERROR;
								}
								else
								{
									ReturnStatus = MPP_FAILOVER_TO_CURRENT;
									// CR 109958 09/27/2006 - changed bit OR to local variable instead
									// of through the passed in pointer
									ioErrorCondition |= MPPCMN_LUN_CAN_BE_OWNED;
									*mppIoErrorCondition = ioErrorCondition;
								}
							}
							else if(SenseData->ASCQ == ASCQ_LUN_CANNOT_BE_OWNED)
							{
								/* The LUN is a secondary volume and cannot be transferred */
								ErrorLevel = MPP_ERR_FATAL;
								ErrorNumber = 131;
								sprintf(&AdditionalErrorString[0],
								       "Lun Not owned - No Alternate and not-allowed to failover to current \n");
								ResetWaitTimes = TRUE;
								ReturnStatus = MPP_RETURN_ERROR;
							}
							else
							{
								/*
								* We get a unknown ASCQ under ASC 0x94.
								* Return io error and generate an log event.
								*/
								sprintf(&AdditionalErrorString[0],
								        "Illegal Request ASC/ASCQ 0x%x/0x%x, SKSBs 0x%x/0x%x/0x%x\n",
								        SenseData->ASC, SenseData->ASCQ, SenseData->Sense_Key_Specific_Info[0],
								        SenseData->Sense_Key_Specific_Info[1], SenseData->Sense_Key_Specific_Info[2]);
								ErrorLevel = MPP_ERR_FATAL;
								ErrorNumber = 132;
								ResetWaitTimes = TRUE;
								ReturnStatus = MPP_RETURN_ERROR;
							}
							break;
						}


						if((mpp_SysInterface->mppSys_AreControllerPathsFailed(RdacInfo, Controller^1, Lun) ||
							! RdacInfo->ControllerInfo[Controller^1]->ControllerPresent ||
							RdacInfo->ControllerInfo[Controller^1]->Failed) &&
							! RdacInfo->ControllerInfo[Controller]->FailoverInProgress &&
							! mpp_FailBackToCurrentAllowed)
						{
							/* failover to current not allowed..because of thrashing*/
							ErrorLevel = MPP_ERR_FATAL;
							ErrorNumber = 112;  /*FIX THIS NUMBER FOR SOLARIS*/
							sprintf(&AdditionalErrorString[0],"Lun Not owned - Failover to alternate not allowed\n");
					                ResetWaitTimes = TRUE;
							ReturnStatus = MPP_RETURN_ERROR;
							break;
						}

						if (RdacInfo->ControllerInfo[Controller]->FailoverInProgress)
						{
							/* retry to same controller while failover in progress*/
							ReturnStatus = MPP_RETRY_NO_DEC;
							break;
						}
						MPP_LOCK(RdacInfo->Lock, LockLevel);
						if( RdacInfo->ControllerInfo[Controller^1]->Failed )
						{
							for(i=0; i<mpp_MaxPathsPerController; ++i)
							{
								MPPCMN_SET_PATH_STATE(RdacInfo, Controller^1, i, MPPCMN_FAILED_NEED_CHECK);
							}

							RdacInfo->ControllerInfo[Controller^1]->Failed = FALSE;
						}
						MPP_UNLOCK(RdacInfo->Lock, LockLevel);
						ErrorLevel = MPP_ERR_ALL;
						ErrorNumber = 84;
						sprintf(&AdditionalErrorString[0],"Lun Not owned\n");
						ReturnStatus = MPP_RETRY_ALTERNATE_CONTROLLER;


						break;
					}
					sprintf(&AdditionalErrorString[0],
					"Illegal Request ASC/ASCQ 0x%x/0x%x, SKSBs 0x%x/0x%x/0x%x\n",
					SenseData->ASC, SenseData->ASCQ, SenseData->Sense_Key_Specific_Info[0],
					SenseData->Sense_Key_Specific_Info[1], SenseData->Sense_Key_Specific_Info[2]);
					ErrorLevel = MPP_ERR_FATAL;
					ErrorNumber = 85;
					ResetWaitTimes = TRUE;
					ReturnStatus = MPP_RETURN_ERROR;
					break;

				case SENSE_KEY_UNIT_ATTENTION:
					MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_1,
					"mpp_AnalyseIoError: UA ASC/ASCQ 0x%x/0x%x\n",
					SenseData->ASC, SenseData->ASCQ));
					if( (SenseLength > 12) &&
					    (SenseData->ASC == ASC_QUIESCENCE) && (SenseData->ASCQ == ASCQ_QUIESCENCE_IN_PRGS) ) {

						/*
						 * 03/22/05 - CR87136.  Certain timing conditions in a Cluster environment can result in
						 * the NotReady, Busy, or Quiescence wait times being set yet they are never legitimately
						 * cleared.  For example, a host that doesn't currently own a volume may make a request
						 * which returns one of the above statuses which is retried.  On the retry we make get
						 * another error condition that is NOT retried.  As a result, depending on when the next
						 * IO request is sent from the same host one we could exceed the wait time although the
						 * timestamp reflects the _previous_ error condition.  A new configurable parameter is
						 * being introduced that will reset the timestamp to zero, then the logic below will
						 * reset the timestamp to the current time.
						 */
						if(RdacInfo->RdacLuns[Lun].QuiescienceStart &&
						    ((CurrentTime - RdacInfo->RdacLuns[Lun].QuiescienceStart) > mppCmn_AncientWaitTimeThreshold))
						{
							ErrorLevel = MPP_ERR_RETRYABLE;
							ErrorNumber = 148;
							sprintf(&AdditionalErrorString[0], "WaitTimeThreshold exceeded for Quiescence.  Will reset.\n");
							RdacInfo->RdacLuns[Lun].QuiescienceStart = 0;
						}

						if( RdacInfo->RdacLuns[Lun].Quiescent ||
						    (RdacInfo->RdacLuns[Lun].QuiescienceStart &&
						     ((CurrentTime - RdacInfo->RdacLuns[Lun].QuiescienceStart) > mpp_QuiescenceWaitTime)) ) {
						    	RdacInfo->RdacLuns[Lun].Quiescent = TRUE;
							ErrorLevel = MPP_ERR_FATAL;
							ErrorNumber = 86;
							sprintf(&AdditionalErrorString[0], "Quiescence Wait Time exceeded\n");
							if( mpp_IsFailoverPossible(RdacInfo, Controller, Path, Lun, 1) )
							{
								// 07/20/06 - CR 109208.  Return status based on FailoverMethod.
								if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
								{
									ReturnStatus = MPP_FAILOVER_LUN;
								}
								else
								{
									ReturnStatus = MPP_FAILOVER_CONTROLLER;
								}
							}
					 		else
					 		{
								// 07/20/06 - CR 109208.  Lun-based Failover enhancement
								if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_CONTROLLER)
								{
									/* mark this controller as failed */
									mpp_FailPath(RdacInfo, Controller, Path);
									RdacInfo->ControllerInfo[Controller]->Failed = TRUE;
								}
								else if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
								{
									/* mark this lun as failed */
									mppCmn_FailLun(RdacInfo, Controller, Path, Lun,
										MPPCMN_FAIL_LUN_ALL_PATHS);
								}
								ReturnStatus = MPP_RETURN_ERROR;
							}
							break;
						}
						else
						{
							if( !RdacInfo->RdacLuns[Lun].QuiescienceStart )
								RdacInfo->RdacLuns[Lun].QuiescienceStart = CurrentTime;
						}
						ErrorLevel = MPP_ERR_ALL;
						ErrorNumber = 105;
						sprintf(&AdditionalErrorString[0], "Quiescence In Progress\n");
						ReturnStatus = MPP_RETRY_NO_DEC;
						break;
					}
					if( SenseLength > 12) {
						ErrorLevel = MPP_ERR_RECOVERED;
						ErrorNumber = 87;
						sprintf(&AdditionalErrorString[0], "Ua, ASC/ASCQ 0x%x/0x%x, fru 0x%x\n",
						SenseData->ASC, SenseData->ASCQ, SenseData->Field_Replaceable_Unit);
					}

					*UaRetryCount += 1;

					if( *UaRetryCount <= mpp_UaRetryCount ) {
						if ( mpp_DoUARetry )
						{
							ReturnStatus = MPP_RETRY_NO_DEC;
						}
						else
						{
							ReturnStatus = MPP_NO_ERROR;
						}
						break;
					}

					ErrorLevel = MPP_ERR_FATAL;
					ErrorNumber =  88;
					sprintf(&AdditionalErrorString[0], "UA Retry count exhausted, ASC/ASCQ 0x%x/0x%x, fru 0x%x\n",
					SenseData->ASC, SenseData->ASCQ, SenseData->Field_Replaceable_Unit);
					if( mpp_IsFailoverPossible(RdacInfo, Controller, Path, Lun, 1) )
					{
						// 07/20/06 - CR 109208.  Return status based on FailoverMethod.
						if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
						{
							ReturnStatus = MPP_FAILOVER_LUN;
						}
						else
						{
							ReturnStatus = MPP_FAILOVER_CONTROLLER;
						}
					}
			 		else
			 		{
						// 07/20/06 - CR 109208.  Lun-based Failover enhancement
						if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_CONTROLLER)
						{
							/* mark this controller as failed */
							mpp_FailPath(RdacInfo, Controller, Path);
							RdacInfo->ControllerInfo[Controller]->Failed = TRUE;
						}
						else if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
						{
							/* mark this lun as failed */
							mppCmn_FailLun(RdacInfo, Controller, Path, Lun,
								MPPCMN_FAIL_LUN_ALL_PATHS);
						}
						ReturnStatus = MPP_RETURN_ERROR;
					}
					break;
				case SENSE_KEY_HARDWARE_ERROR:
					ErrorLevel = MPP_ERR_FATAL;
					sprintf(&AdditionalErrorString[0], "Hardware error, ASC/ASCQ 0x%x/0x%x, fru 0x%x\n",
							SenseData->ASC, SenseData->ASCQ, SenseData->Field_Replaceable_Unit);
					switch(SenseData->ASC) {
	    					case  FORMAT_FAILED:
						case  OUT_OF_ALTERNATES:
						case  CONTROLLER_MSG_ERROR:
						case  DRIVE_SELECTION_TIMEOUT:
						case  OPERATION_NOT_ALLOWED:
						case  DRIVE_IO_ABORTED:
						case  DRIVE_ERROR:
						case  MICROCODE_DL_FAILED:
							ErrorNumber =  89;
							ResetWaitTimes = TRUE;
							ReturnStatus = MPP_RETURN_ERROR;
							break;
						default:
							ErrorNumber =  90;
							ReturnStatus = MPP_RETRY_DEC_COUNT;
							break;
					}
					break;

				// 03/12/07 - CR118449.  Added check for medium error even though the default case
				// would cover it to add clarification for the pre-read redundancy check
				// FFD (349-1063070).
				case SENSE_KEY_MEDIUM_ERROR:
					ErrorLevel = MPP_ERR_FATAL;
					sprintf(&AdditionalErrorString[0], "Medium error, ASC/ASCQ 0x%x/0x%x\n",
							SenseData->ASC, SenseData->ASCQ);
					ErrorNumber = 138;
					ResetWaitTimes = TRUE;
					ReturnStatus = MPP_RETURN_ERROR;
					break;

				default:
					ErrorLevel = MPP_ERR_FATAL;
					ErrorNumber = 91;
					sprintf(&AdditionalErrorString[0], "Unrecognized SK - %d\n",
					SenseData->Sense_Key);
					ReturnStatus = MPP_RETURN_ERROR;
					break;
			}
			break;

		case MPP_SCSI_BUSY:

			/*
			 * 03/22/05 - CR87136.  Certain timing conditions in a Cluster environment can result in
			 * the NotReady, Busy, or Quiescence wait times being set yet they are never legitimately
			 * cleared.  For example, a host that doesn't currently own a volume may make a request
			 * which returns one of the above statuses which is retried.  On the retry we make get
			 * another error condition that is NOT retried.  As a result, depending on when the next
			 * IO request is sent from the same host one we could exceed the wait time although the
			 * timestamp reflects the _previous_ error condition.  A new configurable parameter is
			 * being introduced that will reset the timestamp to zero, then the logic below will
			 * reset the timestamp to the current time.
			 */
			if(RdacInfo->RdacLuns[Lun].BusyStart &&
			    ((CurrentTime - RdacInfo->RdacLuns[Lun].BusyStart) > mppCmn_AncientWaitTimeThreshold))
			{
				ErrorLevel = MPP_ERR_RETRYABLE;
				ErrorNumber = 149;
				sprintf(&AdditionalErrorString[0], "WaitTimeThreshold exceeded for Busy.  Will reset.\n");
				RdacInfo->RdacLuns[Lun].BusyStart = 0;
			}

			if( RdacInfo->RdacLuns[Lun].Busy ||
			    (RdacInfo->RdacLuns[Lun].BusyStart &&
			    ((CurrentTime - RdacInfo->RdacLuns[Lun].BusyStart) > mpp_BusyWaitTime)) )
			{
			    RdacInfo->RdacLuns[Lun].Busy = TRUE;
				ErrorLevel = MPP_ERR_FATAL;
				ErrorNumber = 92;
				sprintf(&AdditionalErrorString[0], "Busy Wait Time exceeded\n");
				if( mpp_IsFailoverPossible(RdacInfo, Controller, Path, Lun, 1) )
				{
					// 07/20/06 - CR 109208.  Return status based on FailoverMethod.
					if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
					{
						ReturnStatus = MPP_FAILOVER_LUN;
					}
					else
					{
						ReturnStatus = MPP_FAILOVER_CONTROLLER;
					}
				}
			 	else
		 		{
					// 07/20/06 - CR 109208.  Lun-based Failover enhancement
					if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_CONTROLLER)
					{
						/* mark this controller as failed */
						mpp_FailPath(RdacInfo, Controller, Path);
						RdacInfo->ControllerInfo[Controller]->Failed = TRUE;
					}
					else if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
					{
						/* mark this lun as failed */
						mppCmn_FailLun(RdacInfo, Controller, Path, Lun,
							MPPCMN_FAIL_LUN_ALL_PATHS);
					}
					ReturnStatus = MPP_RETURN_ERROR;
				}
				break;
			}
			else
			{
				if( !RdacInfo->RdacLuns[Lun].BusyStart )
					RdacInfo->RdacLuns[Lun].BusyStart = CurrentTime;
			}
			ReturnStatus = MPP_RETRY_NO_DEC;
			break;

		case MPP_SELECTION_TIMEOUT:
			*SelectionTimeoutRetryCount += 1;
			if( *SelectionTimeoutRetryCount <= mpp_SelectionTimeoutRetryCount ) {
				ErrorLevel = MPP_ERR_RETRYABLE;
				ErrorNumber = 93;
				sprintf(&AdditionalErrorString[0], "Retrying Selection Timeout %d\n",
					*SelectionTimeoutRetryCount);
				ReturnStatus = MPP_RETRY_NO_DEC;
				break;
			}
			ErrorLevel = MPP_ERR_FATAL;
			ErrorNumber = 94;
			sprintf(&AdditionalErrorString[0], "Selection Retry count exhausted\n");
			if( mpp_IsFailoverPossible(RdacInfo, Controller, Path, Lun, 0) )
				ReturnStatus = MPP_FAILOVER;
			else
	 		{
				// 07/20/06 - CR 109208.  Lun-based Failover enhancement
				if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_CONTROLLER)
				{
					/* mark this controller as failed */
					mpp_FailPath(RdacInfo, Controller, Path);
					RdacInfo->ControllerInfo[Controller]->Failed = TRUE;
				}
				else if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
				{
					/* mark this lun as failed */
					mppCmn_FailLun(RdacInfo, Controller, Path, Lun,
						MPPCMN_FAIL_LUN_ALL_PATHS);
				}
				ReturnStatus = MPP_RETURN_ERROR;
			}
			break;
		case MPP_SCSI_RESERVATION:
			// 02/20/03 - Changed error level from FATAL to RECOVERED to reduce the
			// number of error messages produced when MSCS is used.
			ErrorLevel = MPP_ERR_RECOVERED;
			ErrorNumber = 95;
			sprintf(&AdditionalErrorString[0], "Reservation Conflict\n");
			ResetWaitTimes = TRUE;
			ReturnStatus = MPP_RETURN_ERROR;
			break;
		case MPP_INVALID_REQUEST:
			ErrorLevel = MPP_ERR_FATAL;
			ErrorNumber = 96;
			sprintf(&AdditionalErrorString[0], "Illegal Command\n");
			ResetWaitTimes = TRUE;
			ReturnStatus = MPP_RETURN_ERROR;
			break;

		case MPP_COMMAND_TIMEOUT:
			*CommandTimeoutRetryCount += 1;
			 if( *CommandTimeoutRetryCount <= mpp_CommandTimeoutRetryCount ) {
				ErrorLevel = MPP_ERR_RETRYABLE;
				ErrorNumber = 97;
				sprintf(&AdditionalErrorString[0], "Retrying command Timeout\n");
				ReturnStatus = MPP_RETRY_NO_DEC;
				break;
			 }

			 ErrorLevel = MPP_ERR_FATAL;
			 ErrorNumber = 98;
			 sprintf(&AdditionalErrorString[0], "Command Timeout Retry count exhausted\n");
			 if( mpp_IsFailoverPossible(RdacInfo, Controller, Path, Lun, 1) )
			 {
				// 07/20/06 - CR 109208.  Return status based on FailoverMethod.
				if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
				{
					ReturnStatus = MPP_FAILOVER_LUN;
				}
				else
				{
					ReturnStatus = MPP_FAILOVER_CONTROLLER;
				}
			 }
			 else
	 		 {
				// 07/20/06 - CR 109208.  Lun-based Failover enhancement
				if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_CONTROLLER)
				{
					/* mark this controller as failed */
					mpp_FailPath(RdacInfo, Controller, Path);
					RdacInfo->ControllerInfo[Controller]->Failed = TRUE;
				}
				else if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
				{
					/* mark this lun as failed */
					mppCmn_FailLun(RdacInfo, Controller, Path, Lun,
						MPPCMN_FAIL_LUN_ALL_PATHS);
				}
				ReturnStatus = MPP_RETURN_ERROR;
			}
			 break;

		// 01/21/08 - CR135691.  Added new MPP common driver statuses
		case MPP_BUS_RESET:
			ErrorLevel = MPP_ERR_RETRYABLE;
			ErrorNumber = 99;
			sprintf(&AdditionalErrorString[0], "mpp status %d\n", mpp_status);
			ReturnStatus = MPP_RETRY_NO_DEC;
			break;

		case MPP_UNSUPPORTED_SCSI_STATUS:
		case MPP_HARDWARE_ERROR:
		case MPP_COMMAND_ABORTED:
		case MPP_UNRECOGNIZED_OS_STATUS:
		case MPP_REQUEST_SENSE_FAILED:
		case MPP_IO_TIMEOUT:
		default:
			ErrorLevel = MPP_ERR_RETRYABLE;
			ErrorNumber = 99;
			sprintf(&AdditionalErrorString[0], "mpp status %d\n", mpp_status);
			ReturnStatus = MPP_RETRY_DEC_COUNT;
			break;
	}

	/*
	 * Check if this IO has expired.
	 * 06/29/04 - Modified when this condition is checked.  The reason is as follows:  During testing it
	 * was discovered there may be cases where some error condition above will cause an error to be returned,
	 * or some other status that indicates "try another controller".  In those cases we want the message from
	 * that condition to print rather than a controller or array IO wait time expiration.
	 * 07/20/06 - CR109208.  Check for new lun failover status.
	 */
	if( ReturnStatus == MPP_RETURN_ERROR || ReturnStatus == MPP_FAILOVER_CONTROLLER ||
	    ReturnStatus == MPP_RETRY_ALTERNATE_CONTROLLER || ReturnStatus == MPP_FAILOVER ||
	    ReturnStatus == MPP_FAILOVER_LUN)
	{
		; /* Do nothing here.  Allow the original error message to print. */
	}
	else if ( (CurrentTime - ControllerIoWaitTime) > mpp_ControllerIoWaitTime)
	{
		if( mpp_IsFailoverPossible(RdacInfo, Controller, Path, Lun, 1) )
		{
			// 07/20/06 - CR 109208.  Return status based on FailoverMethod.
			if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
			{
				ReturnStatus = MPP_FAILOVER_LUN;
			}
			else
			{
				ReturnStatus = MPP_FAILOVER_CONTROLLER;
			}
		}
		else
		{
			// 07/20/06 - CR 109208.  Lun-based Failover enhancement
			if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_CONTROLLER)
			{
				/* mark this controller as failed */
				mpp_FailPath(RdacInfo, Controller, Path);
				RdacInfo->ControllerInfo[Controller]->Failed = TRUE;
			}
			else if(RdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
			{
				/* mark this lun as failed */
				mppCmn_FailLun(RdacInfo, Controller, Path, Lun,
					MPPCMN_FAIL_LUN_ALL_PATHS);
			}
			ReturnStatus = MPP_RETURN_ERROR;
		}
		ErrorLevel = MPP_ERR_FATAL;
		ErrorNumber = 122;
		sprintf(AdditionalErrorString, "Controller IO time expired. Delta %ld secs\n",CurrentTime-ControllerIoWaitTime);
	}
	else if ((CurrentTime - ArrayIoWaitTime) > mpp_ArrayIoWaitTime)
	{
		ReturnStatus = MPP_RETURN_ERROR;
		ErrorLevel = MPP_ERR_FATAL;
		ErrorNumber = 128;
		sprintf(AdditionalErrorString, "Array IO time expired. Delta %ld secs\n",CurrentTime-ArrayIoWaitTime);
	}
	else if( ReturnStatus == MPP_RETRY_DEC_COUNT )
	{
		*RetryCount -= 1;
	 	if( !(*RetryCount) ) {
			if( mpp_IsFailoverPossible(RdacInfo, Controller, Path, Lun, 0) )
				ReturnStatus = MPP_FAILOVER;
			else
				ReturnStatus = MPP_RETURN_ERROR;
			ErrorLevel = MPP_ERR_FATAL;
		}
	}

	if(ResetWaitTimes == TRUE)
	{
		RdacInfo->RdacLuns[Lun].QuiescienceStart = 0;
		RdacInfo->RdacLuns[Lun].NotReadyStart = 0;
		RdacInfo->RdacLuns[Lun].BusyStart = 0;
	}

	MPP_ERRORLOGPRINT((ErrorLevel, ErrorNumber, "%s:%d:%d:%d %s", RdacInfo->ModuleName, Controller,
		Path, Lun, AdditionalErrorString));

	return(ReturnStatus);

}
/*******************************************************************************
* PROCEDURE
*
* NAME:
* SUMMARY:  mpp_AnalyseSyncError
* SCOPE:    private
*
*
* DESCRIPTION: This routine determines the appropriate action to take when a synchronous I/O is returned.
*
* RESTRICTIONS:
*
* RETURNS: retry action
*
* ERRNO:
*
* NOTES:
*
* EXAMPLES:
*
* SEE ALSO:
*
*/
LWORD
mpp_AnalyseSyncError(LWORD mppStatus, SenseData_t *SenseData, LWORD SenseLengthReturned,
			LWORD DataLengthXfered, MPP_TIME StartTime, BYTE *SelectionTimeoutRetryCount,
			BYTE *CommandTimeoutRetryCount, BYTE *UaRetryCount)
{
	MPP_TIME CurrentTime;

	MPP_GETTIME(CurrentTime);
	if( !((CurrentTime - StartTime) % 60)  && (CurrentTime != StartTime) ) {
		MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AnalyseSyncError: CurrentTime 0x%x, StartTime 0x%x\n", CurrentTime, StartTime));
	}
	switch(mppStatus) {
		case MPP_GOOD_STATUS:
			if( DataLengthXfered )
				return(MPP_NO_ERROR);
			MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 30, "Synch IO: Good Status but no data\n"));
			return(MPP_RETRY_DEC_COUNT);

		case MPP_CHECK_CONDITION:
    			MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_2, "mpp_AnalyseSyncError: Check Condition, sense data length %d\n",
			SenseLengthReturned));
			if( SenseLengthReturned < 3 ) {
				MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 31, "Synch IO: Check Condition but no Sense data\n"));
				return(MPP_RETRY_DEC_COUNT);
			}

			MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_1, "mpp_AnalyseSyncError: Sense Key 0x%x ASC 0x%x ASCQ 0x%x \n", SenseData->Sense_Key, SenseData->ASC, SenseData->ASCQ));
			switch( SenseData->Sense_Key ) {
				case SENSE_KEY_ABORTED_COMMAND:
				case SENSE_KEY_NO_SENSE:
					MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 32, "Synch IO: retryable Error SK 0x%x\n",
					SenseData->Sense_Key));
					return(MPP_RETRY_DEC_COUNT);

				case SENSE_KEY_RECOVERED_ERROR:
					MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 33, "Synch IO: Recovered Error SK, ASC/ASCQ 0x%x/0x%x\n",
					SenseData->ASC, SenseData->ASCQ));

					return(MPP_NO_ERROR);

				case SENSE_KEY_NOT_READY:
					if( SenseLengthReturned < 12 ) {
						MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 34, "Synch IO: Not ready but no ASC/ASCQ\n"));
						return(MPP_RETRY_DEC_COUNT);
					}
					MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_1, "mpp_AnalyseSyncError: Not Ready ASC/ASCQ 0x%x/0x%x\n",
					SenseData->ASC, SenseData->ASCQ));
					if( (SenseData->ASC == ASC_NOT_READY) && (SenseData->ASCQ == ASCQ_BECOMING_READY) ) {
						if( (CurrentTime - StartTime) > mpp_NotReadyWaitTime ) {
							MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 35, "Synch IO: Not Ready Wait Time exceeded\n"));
							return(MPP_RETURN_ERROR);
						}
						return(MPP_RETRY_NO_DEC);
					}

					/** 08/22/05 - Added a check for Operation in Progress. **/
					if(SenseData->ASCQ == ASCQ_OPERATION_IN_PROGRESS)
					{
						return(MPP_RETRY_NO_DEC);
					}

					MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 36, "Synch IO: Not ready & Not becoming ready\n"));
					return(MPP_RETURN_ERROR);

				case SENSE_KEY_ILLEGAL_REQUEST:
					MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_1, "mpp_AnalyseSyncError: Illegal Request ASC/ASCQ 0x%x/0x%x\n",
					SenseData->ASC, SenseData->ASCQ));

					// 02/09/07 - CR117260.  Added check for 05/91/36 condition.
					if( (SenseLengthReturned > 12) &&
					    (SenseData->ASC == ASC_MODE_ERROR) && (SenseData->ASCQ == ASCQ_CMD_LOCK_VIOLATION) ) {
						return(MPP_RETRY_NO_DEC);
					}

					MPP_ERRORLOGPRINT((MPP_ERR_ALL, 37, "Synch IO: Illegal Request\n"));
					return(MPP_RETURN_ERROR);

				case SENSE_KEY_UNIT_ATTENTION:
					MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_1,
					"mpp_AnalyseSyncError: UA ASC/ASCQ 0x%x/0x%x\n",
					SenseData->ASC, SenseData->ASCQ));
					if( (SenseLengthReturned > 12) &&
					    (SenseData->ASC == ASC_QUIESCENCE) && (SenseData->ASCQ == ASCQ_QUIESCENCE_IN_PRGS) ) {
					    	if( (CurrentTime - StartTime) > mpp_QuiescenceWaitTime ) {
							MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 38, "Synch IO: Quiescence Wait Time exceeded\n"));
							return(MPP_RETURN_ERROR);
						}
						return(MPP_RETRY_NO_DEC);
					}
					if( SenseLengthReturned > 12) {
						MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 39,
						"Synch IO: Ua, ASC/ASCQ 0x%x/0x%x, fru 0x%x\n",
						SenseData->ASC, SenseData->ASCQ, SenseData->Field_Replaceable_Unit));
					}

					*UaRetryCount += 1;

					if( *UaRetryCount <= mpp_UaRetryCount ) {
						return(MPP_RETRY_NO_DEC);
					}

					MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 40, "Synch IO: UA Retry count exhausted\n"));
					return(MPP_RETURN_ERROR);

				case SENSE_KEY_HARDWARE_ERROR:
					if( SenseLengthReturned > 12) {
						MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 41,
						"Synch IO: Hardware Error ASC/ASCQ 0x%x/0x%x, fru 0x%x\n",
						SenseData->ASC, SenseData->ASCQ, SenseData->Field_Replaceable_Unit));
					}
					return(MPP_RETURN_ERROR);

				// 03/12/07 - CR118449.  Added check for medium error even though the default case
				// would cover it to add clarification for the pre-read redundancy check
				// FFD (349-1063070).
				case SENSE_KEY_MEDIUM_ERROR:
					MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 163,
						"Synch IO: Medium Error SK - ASC/ASCQ 0x%x/0x%x\n",
						SenseData->ASC, SenseData->ASCQ));
					return(MPP_RETURN_ERROR);

				default:
					MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 42, "Synch IO: Unrecognized SK - %d\n",
					SenseData->Sense_Key));
					return(MPP_RETURN_ERROR);
			}

		case MPP_SCSI_BUSY:
			if( (CurrentTime - StartTime) > mpp_BusyWaitTime ) {
				MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 43, "Synch IO: Busy Wait Time exceeded\n"));
				return(MPP_RETURN_ERROR);
			}

			return(MPP_RETRY_NO_DEC);

		case MPP_SELECTION_TIMEOUT:
			*SelectionTimeoutRetryCount += 1;
			if( *SelectionTimeoutRetryCount <= mpp_SelectionTimeoutRetryCount ) {
				MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 44, "Synch IO: Retrying Selection Timeout\n"));
				return(MPP_RETRY_NO_DEC);
			}
			// 07/30/03 - Changed error level from FATAL to RECOVERED to reduce the
			// number of error messages produced when the scan task process tries to
			// talk with devices currently marked as failed.
			MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 45, "Synch IO: Selection Retry count exhausted\n"));
			return(MPP_RETURN_ERROR);

		case MPP_SCSI_RESERVATION:
			// 02/20/03 - Changed error level from FATAL to RECOVERED to reduce the
			// number of error messages produced when MSCS is used.
			MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 46, "Synch IO: Reservation Conflict\n"));
			return(MPP_RETURN_ERROR);
		case MPP_INVALID_REQUEST:
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 47, "Synch IO: Illegal Command\n"));
			return(MPP_RETURN_ERROR);

		case MPP_COMMAND_TIMEOUT:
			*CommandTimeoutRetryCount += 1;
			 if( *CommandTimeoutRetryCount <= mpp_CommandTimeoutRetryCount ) {
				MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 109, "Synch IO: Retrying command Timeout\n"));
				return(MPP_RETRY_NO_DEC);
			 }

			 MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 48, "Synch IO: Command Timeout Retry count exhausted\n"));
			 return(MPP_RETURN_ERROR);

		// 01/21/08 - CR135691.  Added new MPP common driver statuses
		case MPP_BUS_RESET:
			MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 49, "Synch IO: Retrying mpp status %d\n", mppStatus));
			return(MPP_RETRY_NO_DEC);

		case MPP_UNSUPPORTED_SCSI_STATUS:
		case MPP_HARDWARE_ERROR:
		case MPP_COMMAND_ABORTED:
		case MPP_UNRECOGNIZED_OS_STATUS:
		case MPP_REQUEST_SENSE_FAILED:
		case MPP_IO_TIMEOUT:
		default:
			MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 49, "Synch IO: Retrying mpp status %d\n", mppStatus));
			return(MPP_RETRY_DEC_COUNT);
	}
}

/*******************************************************************************
* PROCEDURE
*
* NAME:     mpp_SynchronousIo
* SUMMARY:
* SCOPE:    private
*
*
* DESCRIPTION: This routine is used by the MPP driver to initiate synchronous I/O.
*
* RESTRICTIONS:
*
* RETURNS:
*
* ERRNO:
*
* NOTES:
*
* EXAMPLES:
*
* SEE ALSO:
*
*/
LWORD
mpp_SynchronousIo(MPP_HANDLE DeviceVertex, BYTE *cdb, BYTE cdblen, void *BufferAddress, LWORD BufferLength, TINY Direction)
{
	SenseData_t *SenseData;
	LWORD SenseLengthReturned, DataLengthXfered, mppStatus, retry;
	LWORD retryCount;
	MPP_TIME StartTime;
	BYTE SelectionTimeoutRetryCount = 0;
	BYTE CommandTimeoutRetryCount = 0;
	BYTE UaRetryCount = 0;

	MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG, "mpp_SynchronousIo:  called with vertex 0x%x, cdb 0x%lx, cdblen %d, BufferAddress 0x%lx, BufferLength 0x%x\n",
	DeviceVertex, cdb, cdblen, BufferAddress, BufferLength));
	SenseData = (SenseData_t *) MPP_INT_KMEM_ALLOC(sizeof(SenseData_t));
	if( !SenseData ) {
		MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 103, "Unable to allocate memory\n"));
		return(FALSE);
	}
	MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_SynchronousIo: SenseData 0x%lx\n", SenseData));
	MPP_GETTIME(StartTime);
	MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_4, "mpp_SynchronousIo: StartTime 0x%lx\n", StartTime));

	for( retryCount = mpp_SyncRetryCount; retryCount > 0;  ) {
    		MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_SynchronousIo: calling mpp_SysdepSynchronousIo, vertex 0x%lx, retryCount %d\n",
		DeviceVertex, retryCount));
		mppStatus = mpp_SysInterface->mpp_SysdepSynchronousIo(DeviceVertex, cdb, cdblen, BufferAddress, BufferLength, SenseData,
					sizeof(SenseData_t), Direction, &SenseLengthReturned, &DataLengthXfered);

    		MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_SynchronousIo: mpp_SysdepSynchronousIo returned status %d\n", mppStatus));
		if(mppStatus != MPP_GOOD_STATUS)
		{
		        retry = mpp_AnalyseSyncError(mppStatus, SenseData, SenseLengthReturned, DataLengthXfered,
			        StartTime, &SelectionTimeoutRetryCount, &CommandTimeoutRetryCount, &UaRetryCount );
		}
		else
		{
			retry = MPP_NO_ERROR;
		}

		if( (retry == MPP_NO_ERROR) || (retry == MPP_RETURN_ERROR) ) {
			MPP_FREE(SenseData, sizeof(SenseData_t));
			return(retry);
		}
		if( retry == MPP_RETRY_DEC_COUNT )
			--retryCount;
	}
	MPP_FREE(SenseData, sizeof(SenseData_t));
	return(MPP_RETURN_ERROR);

}


/*******************************************************************************
* PROCEDURE
*
* NAME:     mpp_SynchInquiry
* SUMMARY:
* SCOPE:    private
*
*
* DESCRIPTION: This routine is used by the MPP driver to initiate synchronous Inquiry commands.
*
* RESTRICTIONS:
*
* RETURNS:
*
* ERRNO:
*
* NOTES:
*
* EXAMPLES:
*
* SEE ALSO:
*
*/
LWORD
mpp_SynchInquiry(MPP_HANDLE DeviceVertex, BOOL Evpd, BYTE PgCode, void *BufferAddress, LWORD BufferLength)
{
	LWORD	status;
	BYTE	*cdb, cdblen=6, i, j, *buffer;
	CHAR	output[38];

	MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG, "mpp_SynchInquiry:  called with vertex 0x%x, Evpd %d, PgCode 0x%x, BufferAddress 0x%lx, BufferLength 0x%x\n",
	DeviceVertex, Evpd, PgCode, BufferAddress, BufferLength));
	cdb = (BYTE *) MPP_INT_KMEM_ALLOC(6);
	if( !cdb ) {
		MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 102, "Unable to allocate memory\n"));
		return(FALSE);
	}
	*cdb = 0x12;
	*(cdb+1) = (BYTE) Evpd;
	*(cdb+2) = PgCode;
	*(cdb+3) = *(cdb+5) = 0;
	*(cdb+4) = (BYTE) BufferLength;
	bzero(BufferAddress, BufferLength);
	bzero(output, 38);

	status = mpp_SynchronousIo(DeviceVertex, cdb, cdblen, BufferAddress, BufferLength, MPPCMN_XFER_DEV_HOST);
	MPP_FREE(cdb, 6);
	if( !status ) {
		buffer = (BYTE *) BufferAddress;
    		MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_4, "mpp_SynchInquiry: data returned\n"));

		// 09/01/02 - Replaced output algorithm with this one, which causes the Driver Verifier utility under
		// Windows W2K/.NET to crash the system due to invalid regions of memory being printed.
		for(i=0, j=0; i<BufferLength; ++i)
		{
			if((i != 0) && !(i % 12))
			{
    				MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_4, "%s\n", output));
				bzero(output, 38);
				j = 0;
			}

			sprintf(&output[j*3], "%02x ", *(buffer+i));
			j++;
		}

    		MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_4, "%s\n", output));
	}
	return(status);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_GetAVTData
* SUMMARY:
* SCOPE:    local
*
*
* DESCRIPTION:
*   This function sends an VPD page inquiry for page 0xC9 and returns the AVT data.
*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE means AVT Data was returned.
*************************************************************************/

LWORD
mpp_GetAVTData(MPP_HANDLE DeviceVertex, BYTE *AVTPriority, BOOL *CurrentOwner, BOOL *AVTEnabled)
{
	InqVolumeAccessControl_t *VolumeAccessControlPage;


	VolumeAccessControlPage = (InqVolumeAccessControl_t *) MPP_INT_KMEM_ALLOC(sizeof(InqVolumeAccessControl_t));
	if( !VolumeAccessControlPage ) {
		MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 100, "Unable to allocate memory\n"));
		return(FALSE);
	}
	if( !mpp_SynchInquiry(DeviceVertex, TRUE, INQ_VOLACESSCTRL_PAGE, VolumeAccessControlPage, sizeof(InqVolumeAccessControl_t)) ) {
		if(( VolumeAccessControlPage->Periph_Device_Type == 0 ) && ( VolumeAccessControlPage->Periph_Qualifier == 0 ) ){
			*AVTEnabled = VolumeAccessControlPage->AVTCVP>>7;
			*CurrentOwner = VolumeAccessControlPage->AVTCVP & 0x1;
			*AVTPriority = VolumeAccessControlPage->PathPriotity&0xf;
			MPP_FREE(VolumeAccessControlPage, sizeof(InqVolumeAccessControl_t));
			return(TRUE);
		}
		else
		{       /* Lun Unmapped, we dont need to rebalance this lun - CR 120302 */
			MPP_FREE(VolumeAccessControlPage, sizeof(InqVolumeAccessControl_t));
			return(FALSE);
		}
	}

	MPP_FREE(VolumeAccessControlPage, sizeof(InqVolumeAccessControl_t));
	return(FALSE);
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_GetUTMData
* SUMMARY:
* SCOPE:    local
*
*
* DESCRIPTION:
*   This function sends an VPD page inquiry for page 0xC3 and returns the UTM data.
*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE means UTM Data was returned.
*************************************************************************/

LWORD
mpp_GetUTMData(MPP_HANDLE DeviceVertex, LWORD *UTMLun, BOOL *UTMEnabled)
{
	InqFeaParData_t *FeatureParametersPage;


	FeatureParametersPage = (InqFeaParData_t *) MPP_KMEM_ALLOC(sizeof(InqFeaParData_t));
	if( !mpp_SynchInquiry(DeviceVertex, TRUE, INQ_FEAPAR_PAGE, FeatureParametersPage, sizeof(InqFeaParData_t)) ) {
		*UTMEnabled = FeatureParametersPage->UTMData>>7;
		*UTMLun = FeatureParametersPage->UTMData & 0x7f;
		MPP_FREE(FeatureParametersPage, sizeof(InqFeaParData_t));
		return(TRUE);
	}

	MPP_FREE(FeatureParametersPage, sizeof(InqFeaParData_t));
	return(FALSE);
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_GetArrayName
* SUMMARY:
* SCOPE:    local
*
*
* DESCRIPTION:
*   This function sends an VPD page inquiry for page 0xC8 and returns the Array WWN & ASCII name.
*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE means the Array names were returned.
*************************************************************************/

LWORD
mpp_GetArrayName(MPP_HANDLE DeviceVertex, BYTE *ArrayWWN, BYTE *ArrayAsciiName, LWORD *Lun)
{
	InqExtDeviceId_t	*ExtDeviceIdPage;
	MPP_TIME		CurrentTime, StartTime;
	LWORD			i;

	ExtDeviceIdPage = (InqExtDeviceId_t *) MPP_KMEM_ALLOC(sizeof(InqExtDeviceId_t));


	/** 10/03/02 - During W2K/.NET testing it was discovered that the Extended Device Id inquiry
	    request was issued to a volume before the controller has a chance to populate the Storage
	    Array WWN.  This can result in MPP thinking a different array exists.  Although the
	    controller firmware could be changed to populate the field earlier in SOD the timing
	    window may still exist.  As a result, code is added here to retry the inquiry request
	    at periodic intervals until some limit is reached. **/
	MPP_GETTIME(StartTime);
	MPP_GETTIME(CurrentTime);

	while(TRUE)
	{
		if((CurrentTime - StartTime) > mpp_InquiryWaitTime)
		{
			MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
				"mpp_GetArrayName: Exceeded Inquiry Wait Time\n"));
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 110, "GetArrayName Inquiry Wait Time exceeded\n"));
			break;
		}

		bzero(ExtDeviceIdPage, sizeof(InqExtDeviceId_t));
		if(!mpp_SynchInquiry(DeviceVertex, TRUE, INQ_EXTDEVID_PAGE, ExtDeviceIdPage, sizeof(InqExtDeviceId_t)))
		{
			if(!(mpp_IsNull(ExtDeviceIdPage->ArrayUniqueId, 16) || mpp_IsBlank(ExtDeviceIdPage->ArrayUniqueId, 16)))
			{
				bcopy(&ExtDeviceIdPage->ArrayUniqueId, ArrayWWN, 16);
				for(i=0; i<30; ++i)
            {
					*(ArrayAsciiName+i) = ExtDeviceIdPage->ArrayUserLabel[(2*i)+1];
               /*
               * replace characters that are not legal as Unix file name
               * # 0x23
               * - 0x2d
               * . 0x2E
               * 0-9 0x30 - 0x39
               * A-Z 0x41 - 0x5A
               * _  0x5F
               * a-z 0x61 - 0x7A
               *
               */
               if(*(ArrayAsciiName+i) == 0||
                  *(ArrayAsciiName+i) == 0x23 ||
                  *(ArrayAsciiName+i) == 0x2d ||
                  *(ArrayAsciiName+i) == 0x2e ||
                  ((*(ArrayAsciiName+i) >= 0x30) && (*(ArrayAsciiName+i) <=0x39)) ||
                  ((*(ArrayAsciiName+i) >= 0x41) && (*(ArrayAsciiName+i) <=0x5a)) ||
                  *(ArrayAsciiName+i) == 0x5f ||
                  ((*(ArrayAsciiName+i) >= 0x61) && (*(ArrayAsciiName+i) <= 0x7a)) )
               {
                  /*
                  * no op
                  */
                  ;
               }
               else
               {
                  *(ArrayAsciiName+i)=0x5f;/* replace it with "_"*/
               }
            }

				*Lun = ExtDeviceIdPage->LogicalUnitNumber[7];
				MPP_FREE(ExtDeviceIdPage, sizeof(InqExtDeviceId_t));
				return(TRUE);
			}
		}
		else
		{
			MPP_FREE(ExtDeviceIdPage, sizeof(InqExtDeviceId_t));
			return(FALSE);
		}

		mpp_SysInterface->mpp_ThreadDelay(mpp_InquiryInterval, MPPCMN_DELAY_SECONDS);
		MPP_GETTIME(CurrentTime);
	}

	MPP_FREE(ExtDeviceIdPage, sizeof(InqExtDeviceId_t));
	return(FALSE);
}


LWORD
mpp_GetMaxLunsSupported(MPP_HANDLE DeviceVertex, BYTE *MaxLuns)
{
	InqSwPageData_t *SwPage;

	SwPage = (InqSwPageData_t *) MPP_INT_KMEM_ALLOC(sizeof(InqSwPageData_t));
	if( !SwPage ) {
		MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 172, "Unable to allocate memory\n"));
		return(FALSE);
	}

	if( mpp_SynchInquiry(DeviceVertex, TRUE, INQ_SFWVER_PAGE, SwPage, sizeof(InqSwPageData_t)) ) {
		MPP_FREE(SwPage, sizeof(InqSwPageData_t));
		return(FALSE);
	}

	*MaxLuns = SwPage->Max_LUN_Supported[0];
	MPP_FREE(SwPage, sizeof(InqSwPageData_t));
	return(TRUE);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_IsNull
* SUMMARY:
* SCOPE:    local
*
*
* DESCRIPTION:
*   This function determines whether a given buffer is entirely null.
*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE means the buffer is entirely null.
*************************************************************************/
LWORD
mpp_IsNull(BYTE *BufferAddress, LWORD BufferLength)
{
	LWORD		cnt;

	for(cnt = 0; cnt < BufferLength; cnt++)
	{
		if(BufferAddress[cnt] != '\0')
			return(FALSE);
	}

	return(TRUE);

}


/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_IsBlank
* SUMMARY:
* SCOPE:    local
*
*
* DESCRIPTION:
*   This function determines whether a given buffer is entirely filled with
*   space characters.
*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE means the buffer is filled with blanks.
*************************************************************************/
LWORD
mpp_IsBlank(BYTE *BufferAddress, LWORD BufferLength)
{
	LWORD		cnt;

	for(cnt = 0; cnt < BufferLength; cnt++)
	{
		if(BufferAddress[cnt] != ' ')
			return(FALSE);
	}

	return(TRUE);

}


/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_GetVolumeWWN
* SUMMARY:
* SCOPE:    local
*
*
* DESCRIPTION:
*   This function sends an VPD page inquiry for page 0x83 and returns the Volume WWN.
*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE means Volume WWN was returned.
*************************************************************************/

LWORD
mpp_GetVolumeWWN(MPP_HANDLE DeviceVertex, BYTE *VolumeWWN)
{
	InqDeviceIdData_t 	*DeviceIdPage;
	MPP_TIME		CurrentTime, StartTime;

	DeviceIdPage = (InqDeviceIdData_t *) MPP_KMEM_ALLOC(sizeof(InqDeviceIdData_t));

	MPP_GETTIME(StartTime);
	MPP_GETTIME(CurrentTime);

	while(TRUE)
	{
		if((CurrentTime - StartTime) > mpp_InquiryWaitTime)
		{
			MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
				"mpp_GetVolumeWWN: Exceeded Inquiry Wait Time\n"));
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 108, "GetVolumeWWN Inquiry Wait Time exceeded\n"));
			break;
		}

		bzero(DeviceIdPage, sizeof(InqDeviceIdData_t));
		if(!mpp_SynchInquiry(DeviceVertex, TRUE, INQ_DEVCID_PAGE, DeviceIdPage, sizeof(InqDeviceIdData_t)))
		{
			if(!(mpp_IsNull(DeviceIdPage->ExtendedIdentifier, 16) || mpp_IsBlank(DeviceIdPage->ExtendedIdentifier, 16)))
			{
				bcopy(&DeviceIdPage->ExtendedIdentifier, VolumeWWN, 16);
				MPP_FREE(DeviceIdPage, sizeof(InqDeviceIdData_t));
				return(TRUE);
			}
		}
		else
		{
			MPP_FREE(DeviceIdPage, sizeof(InqDeviceIdData_t));
			return(FALSE);
		}

		mpp_SysInterface->mpp_ThreadDelay(mpp_InquiryInterval, MPPCMN_DELAY_SECONDS);
		MPP_GETTIME(CurrentTime);
	}

	MPP_FREE(DeviceIdPage, sizeof(InqDeviceIdData_t));
	return(FALSE);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_GetArrayType
* SUMMARY:
* SCOPE:    local
*
*
* DESCRIPTION:
*   This function sends an VPD page inquiry for page 0x83 and returns the 
*   array type from Target Protocol Identifier field
*
*   Array Type -     
*
*      FC    - 0 
*      IB    - 4 
*      iSCSI - 5
*      SAS   - 6
*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE means Array Type was returned.
*************************************************************************/

LWORD
mpp_GetArrayType(MPP_HANDLE DeviceVertex, BYTE *ArrayType)
{
	InqDeviceIdData_t 	*DeviceIdPage;
	MPP_TIME		CurrentTime, StartTime;

	DeviceIdPage = (InqDeviceIdData_t *) MPP_KMEM_ALLOC(sizeof(InqDeviceIdData_t));

	MPP_GETTIME(StartTime);
	MPP_GETTIME(CurrentTime);

	while(TRUE)
	{
		if((CurrentTime - StartTime) > mpp_InquiryWaitTime)
		{
			MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
				"mpp_GetVolumeWWN: Exceeded Inquiry Wait Time\n"));
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 888, "GetArrayType Inquiry Wait Time exceeded\n"));
			break;
		}

		bzero(DeviceIdPage, sizeof(InqDeviceIdData_t));
		if(!mpp_SynchInquiry(DeviceVertex, TRUE, INQ_DEVCID_PAGE, DeviceIdPage, sizeof(InqDeviceIdData_t)))
		{
			if(!(mpp_IsNull(DeviceIdPage->ExtendedIdentifier, 16) || mpp_IsBlank(DeviceIdPage->ExtendedIdentifier, 16)))
			{
                *ArrayType = (BYTE)DeviceIdPage->Target_Protocol_Identifier;
				MPP_FREE(DeviceIdPage, sizeof(InqDeviceIdData_t));
				return(TRUE);
			}
		}
		else
		{
			MPP_FREE(DeviceIdPage, sizeof(InqDeviceIdData_t));
			return(FALSE);
		}

		mpp_SysInterface->mpp_ThreadDelay(mpp_InquiryInterval, MPPCMN_DELAY_SECONDS);
		MPP_GETTIME(CurrentTime);
	}

	MPP_FREE(DeviceIdPage, sizeof(InqDeviceIdData_t));
	return(FALSE);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_ControllerSlot
* SUMMARY:
* SCOPE:    local
*
*
* DESCRIPTION:
*   This function sends an VPD page inquiry for page 0xC4 and returns the Controller slot A/B
*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE means Controller Slot was returned.
*************************************************************************/

LWORD
mpp_ControllerSlot(MPP_HANDLE DeviceVertex, BYTE *Slot)
{
	InqSubSystem_t *SubSystemPage;

	SubSystemPage = (InqSubSystem_t *) MPP_KMEM_ALLOC(sizeof(InqSubSystem_t));
	if( !mpp_SynchInquiry(DeviceVertex, TRUE, INQ_SUBSYS_PAGE, SubSystemPage, sizeof(InqSubSystem_t)) ) {
		if( SubSystemPage->ControllerSlotId[1] == 0x31 )
			*Slot = 0;
		else {
			if( SubSystemPage->ControllerSlotId[1] == 0x32 )
				*Slot = 1;
			else {
				MPP_FREE(SubSystemPage, sizeof(InqSubSystem_t));
				return(FALSE);
			}
		}
		MPP_FREE(SubSystemPage, sizeof(InqSubSystem_t));
		return(TRUE);
	}

	MPP_FREE(SubSystemPage, sizeof(InqSubSystem_t));
	return(FALSE);
}
/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_CheckHwVersion
* SUMMARY:  Check the Hardware Version VPD page, 0xC0
* SCOPE:    local
*
*
* DESCRIPTION:
*   This function sends an VPD page inquiry for page 0xC0 and checks the Page Identifier.
*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE means the page identifier matches an Engenio array.
*************************************************************************/

LWORD
mpp_CheckHwVersion(MPP_HANDLE DeviceVertex)
{
	InqHwPageData_t *HwPage;


	HwPage = (InqHwPageData_t *) MPP_KMEM_ALLOC(sizeof(InqHwPageData_t));
	if( mpp_SynchInquiry(DeviceVertex, TRUE, INQ_HDWVER_PAGE, HwPage, sizeof(InqHwPageData_t)) ) {
		MPP_FREE(HwPage, sizeof(InqHwPageData_t));
		return(FALSE);
	}

	if( (HwPage->Page_Identifier[0] == mpp_HardwareStamp[0]) &&
	    (HwPage->Page_Identifier[1] == mpp_HardwareStamp[1]) &&
	    (HwPage->Page_Identifier[2] == mpp_HardwareStamp[2]) &&
	    (HwPage->Page_Identifier[3] == mpp_HardwareStamp[3]) ) {
		MPP_FREE(HwPage, sizeof(InqHwPageData_t));
		return(TRUE);
	}

	MPP_FREE(HwPage, sizeof(InqHwPageData_t));
	return(FALSE);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_CheckFwVersion
* SUMMARY:  Check the Firmware Version VPD page, 0xC1
* SCOPE:    local
*
*
* DESCRIPTION:
*   This function sends an VPD page inquiry for page 0xC1 and checks the Page Identifier.
*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE means the page identifier matches an Engenio array.
*************************************************************************/

LWORD
mpp_CheckFwVersion(MPP_HANDLE DeviceVertex)
{
	InqFwPageData_t *FwPage;


	FwPage = (InqFwPageData_t *) MPP_KMEM_ALLOC(sizeof(InqFwPageData_t));
	if( mpp_SynchInquiry(DeviceVertex, TRUE, INQ_FRMVER_PAGE, FwPage, sizeof(InqFwPageData_t)) ) {
		MPP_FREE(FwPage, sizeof(InqFwPageData_t));
		return(FALSE);
	}

	if( (FwPage->Page_Identifier[0] == mpp_FirmwareStamp[0]) &&
	    (FwPage->Page_Identifier[1] == mpp_FirmwareStamp[1]) &&
	    (FwPage->Page_Identifier[2] == mpp_FirmwareStamp[2]) &&
	    (FwPage->Page_Identifier[3] == mpp_FirmwareStamp[3]) ) {
		MPP_FREE(FwPage, sizeof(InqFwPageData_t));
		return(TRUE);
	}
	MPP_FREE(FwPage, sizeof(InqFwPageData_t));
	return(FALSE);
}
/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_CheckSwVersion
* SUMMARY:  Check the Software Version VPD page, 0xC2
* SCOPE:    local
*
*
* DESCRIPTION:
*   This function sends an VPD page inquiry for page 0xC2 and checks the Page Identifier.
*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE means the page identifier matches an Engenio array.
*************************************************************************/

LWORD
mpp_CheckSwVersion(MPP_HANDLE DeviceVertex, BYTE *FirmwareVersion)
{
	InqSwPageData_t *SwPage;


	SwPage = (InqSwPageData_t *) MPP_INT_KMEM_ALLOC(sizeof(InqSwPageData_t));
	if( !SwPage ) {
		MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 101, "Unable to allocate memory\n"));
		return(FALSE);
	}
	if( mpp_SynchInquiry(DeviceVertex, TRUE, INQ_SFWVER_PAGE, SwPage, sizeof(InqSwPageData_t)) ) {
		MPP_FREE(SwPage, sizeof(InqSwPageData_t));
		return(FALSE);
	}

	if( (SwPage->Page_Identifier[0] == mpp_SoftwareStamp[0]) &&
	    (SwPage->Page_Identifier[1] == mpp_SoftwareStamp[1]) &&
	    (SwPage->Page_Identifier[2] == mpp_SoftwareStamp[2]) &&
	    (SwPage->Page_Identifier[3] == mpp_SoftwareStamp[3]) &&
	    mpp_IsSupported(FeatMinimumFirmwareRelease, SwPage->SW_Version))
	{
		bcopy(&SwPage->SW_Version, FirmwareVersion, 3);

		MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_3,
			"mpp_CheckSwVersion:  SoftWare Version %x.%x.%x\n",
			FirmwareVersion[0], FirmwareVersion[1], FirmwareVersion[2]));
		MPP_FREE(SwPage, sizeof(InqSwPageData_t));
		return(TRUE);
	}

	MPP_FREE(SwPage, sizeof(InqSwPageData_t));
	return(FALSE);
}


LWORD
mpp_IsSupported(MPP_FEATURE_ID Feature, BYTE *SwVersion)
{
	BYTE		count;

	for(count = 0; count < MAX_FEATURE_SUPPORT; count++)
	{
		if(mpp_FeatureSupport[count].FeatureId != Feature)
			continue;

		if(SwVersion[0] >= mpp_FeatureSupport[count].MajorRelease ||
		  (SwVersion[0] == mpp_FeatureSupport[count].MajorRelease &&
		   SwVersion[1] >= mpp_FeatureSupport[count].MinorRelease))
			return(TRUE);
	}

	return(FALSE);
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_IsArray
* SUMMARY:  Determine if candidate is a disk array LUN
* SCOPE:    local
*
*
* DESCRIPTION:
*   This function sends VPD page inquiries to determine if the device belongs to a
*   disk array.  It looks for signatures in the hardware, firmware and
*   software version pages.
*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE means this is an array.
*   If lunAvailable is TRUE, then this particular LUN does exist.
*************************************************************************/

LWORD
mpp_IsArray(MPP_HANDLE DeviceVertex, BYTE *FirmwareVersion)
{
	LWORD pageCount;
	LWORD i, found;
      	InqSupportedPages_t	*supPages;

	MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG, "mpp_IsArray:  called with vertex 0x%x\n", DeviceVertex));
	supPages = (InqSupportedPages_t *) MPP_KMEM_ALLOC(sizeof(InqSupportedPages_t));
	if( mpp_SynchInquiry(DeviceVertex, TRUE, 0, supPages, sizeof(InqSupportedPages_t)) ) {
		MPP_FREE(supPages, sizeof(InqSupportedPages_t));
		return(FALSE);
	}

	pageCount = supPages->PageLength;
	if( pageCount > sizeof(supPages->Pages) )
      		pageCount = sizeof(supPages->Pages);

	found = 0;
	for ( i = 0; i < pageCount ; i++)
	{
		if (supPages->Pages[i] == INQ_HDWVER_PAGE)
		{
	    		if ( ( ((WORD) (i + 2)) < pageCount-2) &&
				  (supPages->Pages[i+1] == INQ_FRMVER_PAGE) &&
				  (supPages->Pages[i+2] == INQ_SFWVER_PAGE) )
			{
				found = 1;
				break;
			} else {
				MPP_FREE(supPages, sizeof(InqSupportedPages_t));
				return(FALSE);
			}
		}

	}

	MPP_FREE(supPages, sizeof(InqSupportedPages_t));
	if(!found)
	{
		MPP_DEBUGPRINT((MPP_SYNC_IO_DEBUG+MPP_DEBUG_LEVEL_1, "mpp_IsArray:  VPD pages not found\n"));
		return(FALSE);
	}


	if( mpp_CheckHwVersion(DeviceVertex) &&
	    mpp_CheckFwVersion(DeviceVertex) &&
	    mpp_CheckSwVersion(DeviceVertex, &FirmwareVersion[0]) ) {
		return (TRUE);
	}

	return (FALSE);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_GetPRResetSupport
* SUMMARY:
* SCOPE:    local
*
*
* DESCRIPTION:
*   This function sends a VPD page inquiry for page 0xC3 to determine if
*   the controller unique SCSI_ENGENIO_BUS_RESET command is supported.
*   If so, the rdacinfo PRResetSupported flag is set.
*
* RESTRICTIONS:
*
* RETURNS:
*   N/A
*************************************************************************/
VOID
mpp_GetPRResetSupport(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo)
{
	InqFeaParData_t *FeatureParametersPage;

	FeatureParametersPage = (InqFeaParData_t *) MPP_KMEM_ALLOC(sizeof(InqFeaParData_t));
	if(!mpp_SynchInquiry(DeviceVertex, TRUE, INQ_FEAPAR_PAGE, FeatureParametersPage, sizeof(InqFeaParData_t)))
	{

   	RdacInfo->PRResetSupported = FeatureParametersPage->PRReset;
		MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_GetPRResetSupport: PRResetSupported = %x\n", RdacInfo->PRResetSupported));
	}
  else
 	{
    RdacInfo->PRResetSupported = 0;
    MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_GetPRResetSupport: mpp_SynchInquiry error getting PRResetSupported\n"));
  }

	MPP_FREE(FeatureParametersPage, sizeof(InqFeaParData_t));
	return;
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_MatchExistingController
* SUMMARY:  Search the array of modules for an entry with a matching controller
*	    but this is a new path
* SCOPE:    local
*
*
* DESCRIPTION:

*
* RESTRICTIONS:
*
* RETURNS:
*   RdacInfo or NULL
*************************************************************************/
RdacDeviceInformation_t *
mpp_MatchExistingController(BYTE *ArrayWWN, BYTE ControllerIndex,
			BYTE *PathIndex)
{
	BYTE i, Path;
	RdacDeviceInformation_t *RdacInfo;
	ArrayModuleEntry_t *ModPtr;

	ModPtr = mpp_ModuleArray;
	for(i=0; i<mpp_MaxArrayModules; ++i){
		if( (RdacInfo = ModPtr->RdacInfo) ) {
			if( !bcmp( (BYTE *) &RdacInfo->WWN, ArrayWWN, 16) ) {
				if( RdacInfo->ControllerInfo[ControllerIndex]->ControllerPresent ) {
					for(Path=0; Path<mpp_MaxPathsPerController; ++Path) {
						if( !RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[Path].Present ) {
							*PathIndex = Path;
							MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
							"mpp_MatchExistingController: %s:%d:%d\n",
							RdacInfo->ModuleName, ControllerIndex, Path));
							return(RdacInfo);
						}
					}
					MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 50, "MaxPathsPerController (%d) exceeded for %s:%d\n",
					mpp_MaxPathsPerController, ModPtr->ModuleName, ControllerIndex));
					*PathIndex = 0xff;
					return(RdacInfo);
				}
				*PathIndex = 0;
				return(RdacInfo);
			}
		}
		++ModPtr;
	}
	return(NULL);
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_NewSelectPath
* SUMMARY:  Select the correct path for an I/O to a Lun
*
*
* DESCRIPTION:
*   This function selects a path and returns to the caller for sending I/O
*   to Lun. A pointer to LunPathInfo_t is returned.
*
*		IN  	RdacInfo
*		IN 	Lun
*		OUT	Controller
*		OUT	Path
*
*
* RESTRICTIONS:
*
*
* RETURNS:
*   LunPathInfo_t or NULL.
*************************************************************************/
LunPathInfo_t *
mppCmn_NewSelectPath(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BYTE *Controller, BYTE *Path)
{
	BYTE			curController, pathIndex;
	LunPathInfo_t		*lunPath = NULL;
	LWORD			index, stateIndex;
	LINT			lockLevel;

	if (!RdacInfo)
		return NULL;

    	MPP_LOCK(RdacInfo->Lock, lockLevel);

	curController = (BYTE)RdacInfo->RdacLuns[Lun].CurrentOwningPath;

	/**
	 ** 05/21/01 - Preferred controller path changes for SCSI reservation/release commands.
	 ** Since only one path from each controller is available, we can assume that if the PreferredControllerPath for the
	 ** curController is Failed that we should check the PreferredControllerPath for the alternate
	 ** rather than going through the elaborate criteria rules.
	 **/
	if(RdacInfo->RdacLuns[Lun].LunControllers[curController]->PreferredControllerPath > -1)
	{
		for(index = 0; index < 2; index++)
		{
			if(index == 1)
			{
				curController = curController^1;
			}

			pathIndex = (BYTE)RdacInfo->RdacLuns[Lun].LunControllers[curController]->PreferredControllerPath;
			MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_4,
				"mpp_SelectPath: %s:%d PreferredControllerPath = %d\n",
				RdacInfo->ModuleName, curController, pathIndex));

			stateIndex = RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].PathStateIndex;
			if( RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].Present
			&&  RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].PathState[stateIndex] != MPPCMN_FAILED
			&&  RdacInfo->RdacLuns[Lun].LunControllers[curController]->LunPaths[pathIndex].LunPathDevice
			&&  RdacInfo->RdacLuns[Lun].LunControllers[curController]->LunPaths[pathIndex].PathRemoveState != 1)
			{
				lunPath = &RdacInfo->RdacLuns[Lun].LunControllers[curController]->LunPaths[pathIndex];
				*Controller = curController;
				*Path = pathIndex;

				if(curController != (BYTE)RdacInfo->RdacLuns[Lun].CurrentOwningPath)
				{
					RdacInfo->RdacLuns[Lun].CurrentOwningPath = curController;
				}
				MPP_UNLOCK(RdacInfo->Lock, lockLevel);
				return(lunPath);
			}
		}

		/**
		 ** We've lost the preferred controller path.  Return a NULL PathDeviceObject to indicate a failure.
		 **/
		MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_4,
			"mpp_SelectPath: %s:%d:%d PreferredControllerPath %d not available\n",
			RdacInfo->ModuleName, curController, Lun, pathIndex));
		// 12/02/2004 removed duplicate MPP_UNLOCK (CR 84154)
		MPP_UNLOCK(RdacInfo->Lock, lockLevel);
		return(NULL);
	}

	// Determine which Load Balance Policy algorithm to use based on lun Load Balance Policy
	switch(RdacInfo->RdacLuns[Lun].LoadBalancePolicy) {
		case MPPCMN_LB_ROUND_ROBIN_SUBSET:
			lunPath = mppCmn_RoundRobinPolicy(RdacInfo, Lun, Controller, Path);
			break;

		case MPPCMN_LB_LEAST_QUEUE_DEPTH:
		default:
			lunPath = mppCmn_LeastQueueDepthPolicy(RdacInfo, Lun, Controller, Path);
			break;
	}

	MPP_UNLOCK(RdacInfo->Lock, lockLevel);
	return(lunPath);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_SelectPath
* SUMMARY:  Select the correct path for an I/O to a Lun
* RETURNS:
*   MPP_HANDLE or NULL.
*************************************************************************/
MPP_HANDLE
mpp_SelectPath(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BYTE *Controller, BYTE *Path)
{
	LWORD ControllerIndex, PathIndex, StateIndex;
	BYTE paths_checked;
	MPP_HANDLE PathVertex=NULL;
	LINT LockLevel;
	MPP_HANDLE PathDeviceObject;


    	MPP_LOCK(RdacInfo->Lock, LockLevel);

	ControllerIndex = RdacInfo->RdacLuns[Lun].CurrentOwningPath;

	if( mpp_SysInterface->mppSys_AreControllerPathsFailed(RdacInfo, (BYTE)ControllerIndex, Lun) ||
		RdacInfo->ControllerInfo[ControllerIndex]->Failed ||
		!RdacInfo->ControllerInfo[ControllerIndex]->ControllerPresent)
	{
		ControllerIndex ^= 1;
		RdacInfo->RdacLuns[Lun].CurrentOwningPath = ControllerIndex;
	}

	/**
	 ** 05/21/01 - Preferred controller path changes for SCSI reservation/release commands.
	 **/
	if(RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->PreferredControllerPath > -1)
	{
		PathIndex = RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->PreferredControllerPath;
		MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_4,
			"mpp_SelectPath: %s:%d PreferredControllerPath = %d\n",
			RdacInfo->ModuleName, ControllerIndex, PathIndex));

		PathDeviceObject=NULL;

		StateIndex = RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[PathIndex].PathStateIndex;
		if( RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[PathIndex].Present &&
			RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[PathIndex].PathState[StateIndex] != MPPCMN_FAILED &&
			!RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].PathRemoveState)
		{
			MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_4,
				"mpp_SelectPath: %s:%d:%d PreferredControllerPath %d\n",
				RdacInfo->ModuleName, ControllerIndex, Lun, PathIndex));
			PathDeviceObject = RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].LunPathDevice;

			if(!RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].PathRemoveState)
			{
				MPP_UNLOCK(RdacInfo->Lock, LockLevel);
				return(PathDeviceObject);
			}
		}

		/**
		 ** We've lost the preferred controller path.  Return a NULL PathDeviceObject to indicate a controller
		 ** failover.
		 **/
		MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_4,
			"mpp_SelectPath: %s:%d:%d PreferredControllerPath %d not available\n",
			RdacInfo->ModuleName, ControllerIndex, Lun, PathIndex));
			MPP_UNLOCK(RdacInfo->Lock, LockLevel);
		return(PathDeviceObject);
	}

	for( paths_checked = 0;  paths_checked <mpp_MaxPathsPerController; ++paths_checked ) {
		PathIndex = RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->RoundRobinPathIndex;
		MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_4, "mpp_SelectPath: testing %s:%d:%d\n",
			RdacInfo->ModuleName, ControllerIndex, PathIndex));
		StateIndex = RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[PathIndex].PathStateIndex;
		if( RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[PathIndex].Present &&
			RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[PathIndex].PathState[StateIndex] != MPPCMN_FAILED &&
			RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].LunPathDevice &&
			!RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].PathRemoveState)
		{
			PathVertex = RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].LunPathDevice;
			*Controller = (BYTE) ControllerIndex;
			*Path = (BYTE) PathIndex;
			break;
		}

		++RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->RoundRobinPathIndex;
		RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->RoundRobinPathIndex %= mpp_MaxPathsPerController;
	}

	++RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->RoundRobinPathIndex;
	RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->RoundRobinPathIndex %=  mpp_MaxPathsPerController;
	MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_4,
		"mpp_SelectPath: %s:%d RoundRobinPathIndex %d DevObj 0x%x\n",
		RdacInfo->ModuleName, Lun,
		RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->RoundRobinPathIndex,
		PathVertex));
	MPP_UNLOCK(RdacInfo->Lock, LockLevel);
	return(PathVertex);

}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_SelectFailoverPath
* SUMMARY:  Select the correct path for an I/O to a Lun
* RETURNS:
*   MPP_HANDLE or NULL.
*************************************************************************/
MPP_HANDLE
mpp_SelectFailoverPath(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BYTE *Controller, BYTE *Path)
{
	BYTE ControllerIndex, PathIndex=*Path;
	BYTE paths_checked;
	MPP_HANDLE PathVertex=NULL;
	LINT LockLevel;
	LWORD StateIndex;


    	MPP_LOCK(RdacInfo->Lock, LockLevel);

	ControllerIndex = *Controller;


	for( paths_checked = 0;  paths_checked <mpp_MaxPathsPerController; ++paths_checked ) {
		++PathIndex;
		PathIndex %= mpp_MaxPathsPerController;
		StateIndex = RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[PathIndex].PathStateIndex;
		if( RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[PathIndex].Present &&
		    RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[PathIndex].PathState[StateIndex] != MPPCMN_FAILED &&
		    RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].LunPathDevice &&
		    !RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].PathRemoveState ) {

		        PathVertex = RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].LunPathDevice;
			break;
		}
	}

	*Path = PathIndex;

	MPP_UNLOCK(RdacInfo->Lock, LockLevel);
	return(PathVertex);

}
/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_MatchExistingControllerPath
* SUMMARY:  Search the array of modules for an entry with a matching controller address
* SCOPE:    local
*
*
* DESCRIPTION:

*
* RESTRICTIONS:
*
* RETURNS:
*   RdacInfo or NULL.
*************************************************************************/
RdacDeviceInformation_t *
mpp_MatchExistingControllerPath(ControllerAddress_t *DeviceAddress, BYTE *ControllerIndex, BYTE *PathIndex)
{
	BYTE i, Controller, Path;
	RdacDeviceInformation_t *RdacInfo;
	ArrayModuleEntry_t *ModPtr;

	ModPtr = mpp_ModuleArray;
	/*MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
	"mpp_MatchExistingControllerPath: Attempting to match ControllerTrans 0x%lx, TargetId %d\n",
	DeviceAddress->ControllerTrans,
	DeviceAddress->TargetId));*/
	for(i=0; i<mpp_MaxArrayModules; ++i){
		if( (RdacInfo = ModPtr->RdacInfo) ) {
			for(Controller=0; Controller<2; ++Controller) {
				if( RdacInfo->ControllerInfo[Controller]->ControllerPresent ) {
					for(Path=0; Path<mpp_MaxPathsPerController; ++Path) {
						/*if( RdacInfo->ControllerInfo[Controller]->ControllerPath[Path].Present ) {
							MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
							"mpp_MatchExistingControllerPath: Path %s:%d:%d present, ControllerTrans 0x%lx, TargetId %d\n",
							RdacInfo->ModuleName, Controller, Path,
							RdacInfo->ControllerInfo[Controller]->ControllerPath[Path].Address.ControllerTrans,
							RdacInfo->ControllerInfo[Controller]->ControllerPath[Path].Address.TargetId));
						}*/
						if( (RdacInfo->ControllerInfo[Controller]->ControllerPath[Path].Present) &&
						    (!bcmp( (BYTE *) &RdacInfo->ControllerInfo[Controller]->ControllerPath[Path].Address,
						            (BYTE *) DeviceAddress, sizeof(ControllerAddress_t)) ) ) {
							     *ControllerIndex = Controller;
							     *PathIndex	= Path;
							     MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
							     "mpp_MatchExistingControllerPath: %s:%d:%d\n",
							     RdacInfo->ModuleName, Controller, Path));
							     return(RdacInfo);
						}
					}
				}
			}
		}
		++ModPtr;
	}
	return(NULL);
}

/**************************************************************************************
* PROCEDURE
*
* NAME:     mpp_MaxArrayModuleOverflow
* SUMMARY:  Check to see if we find new ArrayModules greater than the configured MAXIMUM
* SCOPE:    local
*
*
* DESCRIPTION:
*	Check all the slots in the ArrayModule datastructure for free slots.
*       If there is no free slot then return TRUE. Else return FALSE.
*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE if there is no free slot for the newly identified array module.
****************************************************************************************/
BOOL
mpp_MaxArrayModuleOverflow(   BYTE *ArrayWWN, BYTE *ArrayAsciiName   )
{

	BYTE i, AvailableSlot;
	ArrayModuleEntry_t *ModPtr;
	LWORD DuplicateArrayFound = FALSE;

	AvailableSlot = 0xff;
	ModPtr = mpp_ModuleArray;

	for(i=0; i<mpp_MaxArrayModules; ++i)
	{
		// if we find a free slot and it has no persistent binding array name, use it.
		if((!ModPtr->RdacInfo) && (AvailableSlot == 0xff) && ModPtr->ModuleName[0] == 0)
		{
				AvailableSlot = i;
		}
		else if(ModPtr->ModuleName[0] != 0 && !strcmp((TINY *) ArrayAsciiName, (TINY *) &ModPtr->ModuleName))
		{
			if(ModPtr->RdacInfo && bcmp((BYTE *) &ModPtr->RdacInfo->WWN, ArrayWWN, 16))
			{
				DuplicateArrayFound = TRUE;
			}
			else
			{
				AvailableSlot = i;
			}
		}
		++ModPtr;
	}

	if( AvailableSlot == 0xff ) {
		return(TRUE);  // Array module overflow
	}
	else
	{
		return(FALSE);
	}

}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_AllocRdacinfo
* SUMMARY:  Allocate and initialize an RdacInfo
* SCOPE:    local
*
*
* DESCRIPTION:

*
* RESTRICTIONS:
*
* RETURNS:
*   Pointer to RdacDeviceInformation_t or NULL if we cannot allocate memory.
*************************************************************************/
RdacDeviceInformation_t *
mpp_AllocRdacinfo(MPP_HANDLE DeviceVertex, BYTE *ArrayWWN, BYTE *ArrayAsciiName)
{
	BYTE i, AvailableSlot;
	LWORD Lun;
	BYTE *ptr;
	ArrayModuleEntry_t *ModPtr;
	BYTE AVTPriority;
	BYTE MaxLuns;
	BOOL CurrentOwner, AVTEnabled;
	LWORD DuplicateArrayFound = FALSE;
	BYTE AsciiWWN[33];

	RdacDeviceInformation_t 	*RdacDevInfoBlock=NULL;
	RdacControllerInformation_t	*RdacCtlrInfoBlock=NULL;
	LunPathObjects_t		*RdacLunPathObjBlock=NULL;
	LWORD			 	RdacDevInfoBlock_Size=0;
	LWORD				RdacCtlrInfoBlock_Size=0;
	LWORD				RdacLunPathObjBlock_Size=0;
	RdacLunFailoverInfo_t           *lunFailoverInfo;



	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AllocRdacinfo: RdacDeviceInformation_t size 0x%x\n",
	sizeof(RdacDeviceInformation_t) ));
	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AllocRdacinfo: RdacLunInformation_t size 0x%x\n",
	sizeof(RdacLunInformation_t) ));
	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AllocRdacinfo: RdacControllerInformation_t size 0x%x\n",
	sizeof(RdacControllerInformation_t) ));
	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AllocRdacinfo: RdacControllerPath_t size 0x%x\n",
	sizeof(RdacControllerPath_t) ));
	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AllocRdacinfo: LunPathObjects_t size 0x%x\n",
	sizeof(LunPathObjects_t) ));
	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AllocRdacinfo: LunPathInfo_t size 0x%x\n",
	sizeof(LunPathInfo_t) ));

	RdacDevInfoBlock_Size		= MPP_RDACDEVINFO_BLOCKSIZE( mpp_MaxLunsPerArray ) ;
	RdacCtlrInfoBlock_Size		= MPP_RDACCTLRINFO_BLOCKSIZE( mpp_MaxPathsPerController ) ;
	RdacLunPathObjBlock_Size	= MPP_RDACLUNPATHOBJ_BLOCKSIZE( mpp_MaxPathsPerController ) ;

	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
 		"##### rdacinfo devinfo blksize =%d\n",RdacDevInfoBlock_Size));

	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
 		"##### rdacinfo ctlrinfo blksize =%d\n",RdacCtlrInfoBlock_Size));

	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
 		"##### rdacinfo lunpathinfo blksize =%d\n",RdacLunPathObjBlock_Size));

	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
 		"##### rdacinfo sum of all blocks  =%d\n",RdacDevInfoBlock_Size + RdacCtlrInfoBlock_Size
							+ (mpp_MaxLunsPerArray * RdacLunPathObjBlock_Size)));


	/* Allocate RdacDeviceInformation data structure and RdacLunInfo structures */
	RdacDevInfoBlock 	= (RdacDeviceInformation_t *) MPP_KMEM_ALLOC(RdacDevInfoBlock_Size);
	if ( RdacDevInfoBlock == NULL )
	{
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 240, "mpp_AllocRdacinfo() : Cannot allocate memory for RdacDevInfoBlock\n"));
		return NULL;
	}

	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AllocRdacinfo: RdacDevInfoBlock 0x%lx allocated, size 0x%x\n",
	RdacDevInfoBlock, RdacDevInfoBlock_Size));

	/* CR 140854: Move RdacDevInfoBlock spinlock up to avoid race condition in RHEL 5.2 */
	MPP_LOCK_INIT(RdacDevInfoBlock->Lock);

	// initialize default Array Load Balance Policy
	RdacDevInfoBlock->LoadBalancePolicy = mppCmn_LoadBalancePolicy;

	/* Allocate RdacControllerInformation data structure and RdacControllerPath data structures */
	RdacCtlrInfoBlock 	= (RdacControllerInformation_t *) MPP_KMEM_ALLOC(RdacCtlrInfoBlock_Size);
	if ( RdacCtlrInfoBlock == NULL )
	{
		MPP_FREE(RdacDevInfoBlock, RdacDevInfoBlock_Size);
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 241, "mpp_AllocRdacinfo() : Cannot allocate memory for RdacCtlrInfoBlock\n"));
		return NULL;
	}

	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AllocRdacinfo: RdacCtlrInfoBlock 0x%lx allocated, size 0x%x\n",
	RdacCtlrInfoBlock, RdacCtlrInfoBlock_Size));


	ptr = (BYTE *) RdacCtlrInfoBlock;

	RdacDevInfoBlock->ControllerInfo[0] = (RdacControllerInformation_t *) ptr;
	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AllocRdacinfo: ControllerInfo[0] 0x%lx\n",
	RdacDevInfoBlock->ControllerInfo[0]));

	ptr = (ptr  + sizeof(RdacControllerInformation_t) +
		(sizeof(RdacControllerPath_t)*(mpp_MaxPathsPerController-1)) );
	RdacDevInfoBlock->ControllerInfo[1] = (RdacControllerInformation_t *) ptr;
	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AllocRdacinfo: ControllerInfo[1] 0x%lx\n",
	RdacDevInfoBlock->ControllerInfo[1]));

	/* Initialize the Lun-level failover locks */
	lunFailoverInfo = &RdacDevInfoBlock->ControllerInfo[0]->LunFailoverInfo;
	MPP_LOCK_INIT(lunFailoverInfo->LunFailoverLock);
	lunFailoverInfo = &RdacDevInfoBlock->ControllerInfo[1]->LunFailoverInfo;
	MPP_LOCK_INIT(lunFailoverInfo->LunFailoverLock);

	for(Lun=0; Lun<mpp_MaxLunsPerArray; ++Lun) {

		/* Allocate LunPathObject data structure and LunPathInfo data structures */
		RdacLunPathObjBlock 	= (LunPathObjects_t *) MPP_KMEM_ALLOC( RdacLunPathObjBlock_Size);
		if ( RdacLunPathObjBlock == NULL )
		{
			if( Lun > 0 )
			{
				MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 242, "mpp_AllocRdacinfo() : Cannot allocate memory for RdacLunPathObjBlock for Lun %d\n",
				Lun));
				break;
			}
			else
			{
				mppCmn_FreeRdacInfo( RdacDevInfoBlock);
				MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 243, "mpp_AllocRdacinfo() : Cannot allocate memory for RdacLunPathObjBlock\n"));
				return NULL;
			}

		}

		// initialize default Lun Load Balance Policy
		RdacDevInfoBlock->RdacLuns[Lun].LoadBalancePolicy = mppCmn_LoadBalancePolicy;

		// The LPW Linked List Header is initialized when allocated memory for RdacLunPathObjBlock is zeroed

		/* initialize lunpathobj for controller A */
		RdacLunPathObjBlock->PreferredControllerPath = -1;
		RdacDevInfoBlock->RdacLuns[Lun].LunControllers[0] = RdacLunPathObjBlock;

		MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AllocRdacinfo: Lun %d, LunController[0] 0x%lx\n",
		Lun, RdacDevInfoBlock->RdacLuns[Lun].LunControllers[0]));

		/* initialize lunpathobj for controller B */
		RdacLunPathObjBlock = (LunPathObjects_t *)((BYTE *) RdacLunPathObjBlock  +
					( sizeof(LunPathObjects_t) + (sizeof(LunPathInfo_t)*(mpp_MaxPathsPerController-1))));
		RdacLunPathObjBlock->PreferredControllerPath = -1;
		RdacDevInfoBlock->RdacLuns[Lun].LunControllers[1] = RdacLunPathObjBlock;

		MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AllocRdacinfo: Lun %d, LunController[1] 0x%lx\n",
		Lun, RdacDevInfoBlock->RdacLuns[Lun].LunControllers[1]));

       	}

	bcopy(ArrayWWN, &RdacDevInfoBlock->WWN, 16);

	AvailableSlot = 0xff;
	ModPtr = mpp_ModuleArray;

	for(i=0; i<mpp_MaxArrayModules; ++i)
	{
		// if we find a free slot and it has no persistent binding array name, use it.
		if((!ModPtr->RdacInfo) && (AvailableSlot == 0xff) && ModPtr->ModuleName[0] == 0)
		{
				AvailableSlot = i;
		}
		else if(ModPtr->ModuleName[0] != 0 && !strcmp((TINY *) ArrayAsciiName, (TINY *) &ModPtr->ModuleName))
		{
			if(ModPtr->RdacInfo && bcmp((BYTE *) &ModPtr->RdacInfo->WWN, ArrayWWN, 16))
			{
				DuplicateArrayFound = TRUE;
			}
			else
			{
				AvailableSlot = i;
			}
		}
		++ModPtr;
	}

	if( AvailableSlot == 0xff ) {
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 51, "Maximum number of Array modules exceeded %s\n",
		       RdacDevInfoBlock->ModuleName));
		mppCmn_FreeRdacInfo( RdacDevInfoBlock);
		return(NULL);
	}
	ModPtr = mpp_ModuleArray;
	ModPtr += AvailableSlot;

	if( *ArrayAsciiName == 0 )
	{
		sprintf((TINY *) &ModPtr->ModuleName, "Array_Module_%d", AvailableSlot);
	}
	else
	{
		if(DuplicateArrayFound)
		{
			// Log an error message so the user knows the array was internally renamed.  We want this message
			// to be seen at all error levels so use ERR_FATAL.
			mpp_ConvertWWNtoAscii(&AsciiWWN[0], ArrayWWN);
			sprintf((TINY *) &ModPtr->ModuleName, "%s_%d", ArrayAsciiName, AvailableSlot);
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 113, "Duplicate array name found for WWN %s.  Internally renamed to %s.\n",  AsciiWWN, ModPtr->ModuleName));
		}
		else
		{
			strcpy((TINY *) &ModPtr->ModuleName, (TINY *) ArrayAsciiName);
		}
	}

	ModPtr->RdacInfo = RdacDevInfoBlock;
	RdacDevInfoBlock->ModuleName = &ModPtr->ModuleName;
	RdacDevInfoBlock->VirtualTargetId = AvailableSlot;

	if( !(RdacDevInfoBlock->ModuleHandle = mpp_SysInterface->mpp_makeVirtualTarget(AvailableSlot)) ) {
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 52, "mpp_makeVirtualTarget returned an error on %s\n",
		       RdacDevInfoBlock->ModuleName));
		ModPtr->RdacInfo = (RdacDeviceInformation_t *) 0;
		mppCmn_FreeRdacInfo( RdacDevInfoBlock);
		return(NULL);
	}

	if( !(mpp_GetAVTData(DeviceVertex, &AVTPriority, &CurrentOwner, &AVTEnabled)) ) {
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 53, "mpp_GetAVTData returned an error on %s\n",
		       RdacDevInfoBlock->ModuleName));
		ModPtr->RdacInfo = (RdacDeviceInformation_t *) 0;
		mppCmn_FreeRdacInfo( RdacDevInfoBlock);
		return(NULL);
	}

	// 12/02/02 - RRS. Moved determination of 32 vs 256 lun support to this function.  My original implementation
	// forgot to take into account that multiple arrays, each with different firmware versions could be present.
	// In addition, my original approach used the Software Version Page (0xC2) to determine the controller version.
	// A better method is to use the MaxLunsSupported field in this page.  Unfortunately we have to query the
	// 0xC2 page twice - once to determine whether the device belongs to us and once here to determine max Luns.
	// We could set a global variable and check it here but under multi-processor environments the flag's value
	// may change between the original call and here.  This involves the overhead of making one additional call
	// to the software page for each new array discovered.
	if( !(mpp_GetMaxLunsSupported(DeviceVertex, &MaxLuns)))
	{
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 111, "mpp_GetMaxLunsSupported returned an error on %s\n",
			RdacDevInfoBlock->ModuleName));
		ModPtr->RdacInfo = (RdacDeviceInformation_t *) 0;
		mppCmn_FreeRdacInfo( RdacDevInfoBlock);
		return(NULL);
	}

	// Anything above 31 Luns must use the SubPage for 0x2C
	if(MaxLuns > 0x1f)
		RdacDevInfoBlock->Page2CSubPage1 = 1;
	else
		RdacDevInfoBlock->Page2CSubPage1 = 0;

	RdacDevInfoBlock->AVTEnabled = AVTEnabled;

	// 07/20/06 - CR 109208.  Lun Failover enhancement
	if(RdacDevInfoBlock->AVTEnabled)
	{
		RdacDevInfoBlock->FailoverMethod = mppCmn_AVTModeFailover;
	}
	else
	{
		RdacDevInfoBlock->FailoverMethod = mppCmn_ClassicModeFailover;
	}

	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_AllocRdacinfo: %s, AVTEnabled %d, VirtualTargetId %d\n",
		RdacDevInfoBlock->ModuleName, RdacDevInfoBlock->AVTEnabled, RdacDevInfoBlock->VirtualTargetId));

	return(RdacDevInfoBlock);

}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_FreeRdacInfo
* SUMMARY:  Free the RdacInfo Data Structures
* SCOPE:    local
*
*
* DESCRIPTION:

*
* RESTRICTIONS:
*
* RETURNS:
*   none
*************************************************************************/
void
mppCmn_FreeRdacInfo( RdacDeviceInformation_t *RdacDevInfoBlock)
{
	RdacControllerInformation_t	*RdacCtlrInfoBlock=NULL;
	LunPathObjects_t		*RdacLunPathObjBlock=NULL;
	LWORD			 	RdacDevInfoBlock_Size=0;
	LWORD				RdacCtlrInfoBlock_Size=0;
	LWORD				RdacLunPathObjBlock_Size=0;
	LWORD 				Lun;

	RdacDevInfoBlock_Size		= MPP_RDACDEVINFO_BLOCKSIZE( mpp_MaxLunsPerArray ) ;
	RdacCtlrInfoBlock_Size		= MPP_RDACCTLRINFO_BLOCKSIZE( mpp_MaxPathsPerController ) ;
	RdacLunPathObjBlock_Size	= MPP_RDACLUNPATHOBJ_BLOCKSIZE( mpp_MaxPathsPerController ) ;


	for(Lun=0; Lun<mpp_MaxLunsPerArray; ++Lun) {

		RdacLunPathObjBlock = RdacDevInfoBlock->RdacLuns[Lun].LunControllers[0];

		if ( RdacLunPathObjBlock != NULL )
		{
			MPP_DEBUGPRINT((MPP_DETACH_DEBUG+MPP_DEBUG_LEVEL_3,
				"mppCmn_FreeRdacInfo: Free RdacLunPathObjBlock.Lun %d, LunController[0] 0x%lx\n",
				Lun, RdacDevInfoBlock->RdacLuns[Lun].LunControllers[0]));

			/* free LunPathObject data structure and LunPathInfo data structures */
			MPP_FREE( RdacLunPathObjBlock, RdacLunPathObjBlock_Size);
		}
		else
		{
			MPP_DEBUGPRINT((MPP_DETACH_DEBUG+MPP_DEBUG_LEVEL_3,
				"mppCmn_FreeRdacInfo: RdacLunPathObjBlock is NULL. Lun %d, LunController[0] 0x%lx\n",
				Lun, RdacDevInfoBlock->RdacLuns[Lun].LunControllers[0]));


		}

       	}

	/* Free RdacControllerInformation data structure and RdacControllerPath data structures */
	RdacCtlrInfoBlock	=	RdacDevInfoBlock->ControllerInfo[0];
	if( RdacCtlrInfoBlock !=NULL )
	{
		MPP_DEBUGPRINT((MPP_DETACH_DEBUG+MPP_DEBUG_LEVEL_3, "mppCmn_FreeRdacInfo: Free RdacCtlrInfoBlock . %s\n",
		       		RdacDevInfoBlock->ModuleName));
		MPP_FREE(RdacCtlrInfoBlock, RdacCtlrInfoBlock_Size);
	}
	else
	{
		MPP_DEBUGPRINT((MPP_DETACH_DEBUG+MPP_DEBUG_LEVEL_3, "mppCmn_FreeRdacInfo: RdacCtlrInfoBlock is NULL. \n",
		       		RdacDevInfoBlock->ModuleName));
	}

	/* Free RdacDeviceInformation data structure and RdacLunInfo structures */
	if( RdacDevInfoBlock !=NULL )
	{
		MPP_DEBUGPRINT((MPP_DETACH_DEBUG+MPP_DEBUG_LEVEL_3, "mppCmn_FreeRdacInfo: Free RdacDevInfoBlock . %s\n",
		       		RdacDevInfoBlock->ModuleName));
		MPP_FREE(RdacDevInfoBlock,  RdacDevInfoBlock_Size);
	}

	return;
}


VOID
mpp_ConvertWWNtoAscii(BYTE *AsciiWWN, BYTE *ArrayWWN)
{
	LWORD		count;

	bzero(AsciiWWN, 33);
	for(count = 0; count < 16; count++)
		sprintf(&AsciiWWN[count*2], "%02x", ArrayWWN[count]);
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_InsertController
* SUMMARY:  Fill in the controller information in an RdacInfo
* SCOPE:    local
*
*
* DESCRIPTION:

*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE completed successfully.
*************************************************************************/

LWORD
mpp_InsertController(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE ControllerIndex)
{
	LWORD			UTMLun;
	BOOL			UTMEnabled;
	LINT			LockLevel;

	if( !mpp_GetUTMData(DeviceVertex, &UTMLun, &UTMEnabled) ) {
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 54, "mpp_GetUTMData returned an error on %s:%d\n",
		       RdacInfo->ModuleName, ControllerIndex));
		return(FALSE);
	}
	MPP_LOCK(RdacInfo->Lock, LockLevel);
	RdacInfo->ControllerInfo[ControllerIndex]->ControllerPresent = TRUE;
	RdacInfo->ControllerInfo[ControllerIndex]->UTMLunExists = UTMEnabled;
	RdacInfo->ControllerInfo[ControllerIndex]->UTMLunNumber = UTMEnabled ? UTMLun : -1;

	RdacInfo->ControllerInfo[ControllerIndex]->ReservationPathIndex = 0;

	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_InsertController: %s:%d inserted, with UTM enabled %d, UTM Lun %d\n",
	RdacInfo->ModuleName, ControllerIndex,
	RdacInfo->ControllerInfo[ControllerIndex]->UTMLunExists,
	RdacInfo->ControllerInfo[ControllerIndex]->UTMLunNumber));
	MPP_UNLOCK(RdacInfo->Lock, LockLevel);
	return(TRUE);

}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_InsertControllerPath
* SUMMARY:  Fill in the controller path information in an RdacInfo
* SCOPE:    local
*
*
* DESCRIPTION:

*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE completed successfully.
*************************************************************************/

LWORD
mpp_InsertControllerPath(RdacDeviceInformation_t *RdacInfo, BYTE ControllerIndex,
				BYTE Path, ControllerAddress_t *DeviceAddress)
{
	MPP_DIR_HANDLE DirectoryVertex;
   LINT LockLevel;

	bcopy(DeviceAddress, &RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[Path].Address,
				sizeof(ControllerAddress_t));

	if( !(DirectoryVertex = mpp_SysInterface->mpp_CreateControllerVertex(RdacInfo, ControllerIndex, Path, DeviceAddress)) ) {
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 55, "mpp_CreateControllerVertex returned an error on %s:%d:%d\n",
		       RdacInfo->ModuleName, ControllerIndex, Path));
		return(FALSE);
	}

   MPP_LOCK(RdacInfo->Lock, LockLevel);

	RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[Path].DirectoryVertex = DirectoryVertex;
	MPPCMN_SET_PATH_STATE(RdacInfo, ControllerIndex, Path, MPPCMN_OPTIMAL);
	RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[Path].DirectoryCreated =
	RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[Path].Present = TRUE;
	++RdacInfo->ControllerInfo[ControllerIndex]->NumberOfPaths;
	if( RdacInfo->ControllerInfo[0]->NumberOfPaths && RdacInfo->ControllerInfo[1]->NumberOfPaths )
		RdacInfo->SingleController = FALSE;
	else
		RdacInfo->SingleController = TRUE;

  // To support the Least Queue Depth load balance policy, it is necessary to maintain a count 
  // of outstanding IO requests for each path. This is done using a RequestsInProgress counter 
  // for each path. The counter is incremented when a request is first sent to a path and 
  // decremented when the request completes. During the life of the request, the original path 
  // on which the request was sent might fail causing the IO to be re-routed to a different 
  // path. On IO completion it is necessary to determine what path's RequestsInProgress to 
  // decrement. This is accomplished by saving the initial controller and path used for the 
  // request and decrementing the associated RequestsInProgress. A problem arises when the 
  // initial path is removed. At that time, all path information including RequestsInProgress 
  // is cleared. There is the potential that the removed path be recreated before the re-routed 
  // request has completed. When this occurs, it is necessary for the completion algorithm to 
  // not decrement the RequestsInProgress counter related to the new path instance. If the 
  // counter is decremented, it will go negative. The problem is solved by using a path stamp. 
  // A path stamp identifies a particular path instance. When an IO request initiates, the path 
  // stamp is saved with the request. When the request completes, the completion algorithm uses 
  // the path stamp to determine if the RequestsInProgress counter for a path should be 
  // decremented. If the saved path stamp equals the existing path's stamp, then it is known 
  // that the path has not been removed and added, thus, RequestsInProgress is decremented.
  MPP_GETPATHSTAMP(RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[Path].PathStamp);

   MPP_UNLOCK(RdacInfo->Lock, LockLevel);
	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_InsertControllerPath: %s:%d:%d inserted,\n",
	RdacInfo->ModuleName, ControllerIndex, Path));
	return(TRUE);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_InsertLun
* SUMMARY:  Fill in the Lun information in an RdacInfo
* SCOPE:    local
*
*
* DESCRIPTION:

*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE completed successfully.
*************************************************************************/

LWORD
mpp_InsertLun(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE ControllerIndex, LWORD Lun)
{
	BYTE AVTPriority;
	BOOL CurrentOwner, AVTEnabled;
	LWORD VirtualBusStatus;
	LWORD			UTMLun;
	BOOL			UTMEnabled;

   /*
   * Check if UTM LUN is newly mapped to the host partition, the UTM LUN changes
   * its LUN number or the UTM LUN is un-mapped.
   */
   if( !mpp_GetUTMData(DeviceVertex, &UTMLun, &UTMEnabled) ) {
      MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 139, "mpp_GetUTMData returned an error on %s:%d\n",
		       RdacInfo->ModuleName, ControllerIndex));
      return(FALSE);
   }

   if( !RdacInfo->ControllerInfo[ControllerIndex]->UTMLunExists && UTMEnabled)
   {
      /*
      * This is the case where the UTM LUN is newly mapped
      */
      RdacInfo->ControllerInfo[ControllerIndex]->UTMLunExists = UTMEnabled;
      RdacInfo->ControllerInfo[ControllerIndex]->UTMLunNumber = UTMLun;

      if(RdacInfo->ControllerInfo[ControllerIndex^1]->ControllerPresent)
      {
         RdacInfo->ControllerInfo[ControllerIndex^1]->UTMLunExists = UTMEnabled;
         RdacInfo->ControllerInfo[ControllerIndex^1]->UTMLunNumber = UTMLun;
      }
      MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 154, "UTM LUN is mapped - Lun %d. %s:%d\n",
		       UTMLun,RdacInfo->ModuleName, ControllerIndex));

   }else if(UTMEnabled && (RdacInfo->ControllerInfo[ControllerIndex]->UTMLunNumber != UTMLun))
   {
      /*
      * This is the case where the UTM LUN changes its slot
      */
      MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 155, "UTM LUN is remapped - from %d to %d. %s:%d\n",
		       RdacInfo->ControllerInfo[ControllerIndex]->UTMLunNumber,
             UTMLun,RdacInfo->ModuleName, ControllerIndex));
      RdacInfo->RdacLuns[RdacInfo->ControllerInfo[ControllerIndex]->UTMLunNumber].UTMLun = FALSE;
      RdacInfo->ControllerInfo[ControllerIndex]->UTMLunNumber = UTMLun;

      if(RdacInfo->ControllerInfo[ControllerIndex^1]->ControllerPresent)
      {
         RdacInfo->ControllerInfo[ControllerIndex^1]->UTMLunExists = UTMEnabled;
         RdacInfo->ControllerInfo[ControllerIndex^1]->UTMLunNumber = UTMLun;
      }

   }else if(RdacInfo->ControllerInfo[ControllerIndex]->UTMLunExists && !UTMEnabled)
   {
      /*
      *this is the case where UTM LUN is deleted
      */
      MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 156, "UTM LUN is deleted - Lun %d. %s:%d\n",
		       RdacInfo->ControllerInfo[ControllerIndex]->UTMLunNumber,
             RdacInfo->ModuleName, ControllerIndex));
      RdacInfo->ControllerInfo[ControllerIndex]->UTMLunExists = UTMEnabled;
      RdacInfo->RdacLuns[RdacInfo->ControllerInfo[ControllerIndex]->UTMLunNumber].UTMLun = FALSE;
      RdacInfo->ControllerInfo[ControllerIndex]->UTMLunNumber = -1;

      if(RdacInfo->ControllerInfo[ControllerIndex^1]->ControllerPresent)
      {
         RdacInfo->ControllerInfo[ControllerIndex^1]->UTMLunExists = UTMEnabled;
         RdacInfo->ControllerInfo[ControllerIndex^1]->UTMLunNumber = -1;
      }

   }


	if( !mpp_GetVolumeWWN(DeviceVertex, &RdacInfo->RdacLuns[Lun].WWN[0]) ) {
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 56, "mpp_GetVolumeWWN returned an error on %s:%d:%d\n",
		       RdacInfo->ModuleName, ControllerIndex, Lun));
		return(FALSE);
	}

	if( !mpp_GetAVTData(DeviceVertex, &AVTPriority, &CurrentOwner, &AVTEnabled) ) {
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 57, " mpp_GetAVTData returned an error on %s:%d:%d\n",
		       RdacInfo->ModuleName, ControllerIndex, Lun));
		return(FALSE);
	}

	if( CurrentOwner )
		RdacInfo->RdacLuns[Lun].CurrentOwningPath = RdacInfo->RdacLuns[Lun].BootOwningPath = ControllerIndex;
	else
		RdacInfo->RdacLuns[Lun].CurrentOwningPath = RdacInfo->RdacLuns[Lun].BootOwningPath = ControllerIndex^1;

	/** Today the priority value can be 1 or 2.  Any other value should use Priority '1' as the default. **/
	if( AVTPriority == 2 )
		RdacInfo->RdacLuns[Lun].PreferredPath = ControllerIndex^1;
	else
		RdacInfo->RdacLuns[Lun].PreferredPath = ControllerIndex;


	if( RdacInfo->ControllerInfo[ControllerIndex]->UTMLunNumber == Lun )
		RdacInfo->RdacLuns[Lun].UTMLun = TRUE;
	else {
		if( !RdacInfo->RdacLuns[Lun].PseudoLunObject ) {
			// 09/12/02 - Added DeviceVertex as an input parameter.  In addition, under
			// Windows the virtual bus may be disabled but this should _not_ prevent the
			// physical disk paths from being claimed by MPP.  Presumably the user will
			// enable the pseudo-bus at a later time.
			RdacInfo->RdacLuns[Lun].PseudoLunObject = mpp_SysInterface->mpp_makeVirtualLun(DeviceVertex, RdacInfo, Lun, &VirtualBusStatus);
			if(VirtualBusStatus == MPP_PSEUDO_BUS_DISABLED ||
				(VirtualBusStatus == MPP_PSEUDO_BUS_ENABLED && RdacInfo->RdacLuns[Lun].PseudoLunObject))
			{
				return(TRUE);
			}

			return(FALSE);
		}
	}


	RdacInfo->RdacLuns[Lun].Present = TRUE;
	RdacInfo->RdacLuns[Lun].ReportedPresent = TRUE;
	RdacInfo->RdacLuns[Lun].ReportedMissing = FALSE;
	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_InsertLun: %s:%d inserted, CurrentOwningPath %d, PreferredPath %d, UTM %d\n",
	RdacInfo->ModuleName, Lun, RdacInfo->RdacLuns[Lun].CurrentOwningPath, RdacInfo->RdacLuns[Lun].PreferredPath,
	RdacInfo->RdacLuns[Lun].UTMLun));
	return(TRUE);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_InsertLunPath
* SUMMARY:  Fill in the Lun Path information in an RdacInfo
* SCOPE:    local
*
*
* DESCRIPTION:

*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE completed successfully.
*************************************************************************/

LWORD
mpp_InsertLunPath(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE ControllerIndex, BYTE PathIndex,
	LWORD Lun)
{
	BYTE ThisWWN[16];
	LINT LockLevel;
   LWORD CheckReservationStatus;

	if( !mpp_GetVolumeWWN(DeviceVertex, &ThisWWN[0]) ) {
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 58, "mpp_GetVolumeWWN returned an error on %s:%d:%d:%d\n",
		       RdacInfo->ModuleName, ControllerIndex, PathIndex, Lun));
		return(FALSE);
	}
	if( !RdacInfo->RdacLuns[Lun].UTMLun && bcmp(&ThisWWN, &RdacInfo->RdacLuns[Lun].WWN, 16) )	{
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 59, "Volume WWN for %s:%d:%d:%d does not match\n",
		RdacInfo->ModuleName, ControllerIndex, PathIndex, Lun));
		return(FALSE);
	}
    /*
   * check whether of not we need to make a persistent reservation registration
   * for the newly added path before we make it available for IOs
   */
   CheckReservationStatus = mppCmn_CheckPRRegistration(RdacInfo, DeviceVertex, Lun);
   if(CheckReservationStatus == MPPCMN_PRTN_RETURN_ERROR)
   {
      MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 119,
            "mpp_InsertLunPath: Device %s:%d:%d:%d - get error in checking PR registration\n",
            RdacInfo->ModuleName, ControllerIndex, PathIndex,Lun));
   }
   else
   {
      MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
         "mpp_InsertLunPath: Device %s:%d:%d:%d - Checked PR registration\n",
         RdacInfo->ModuleName, ControllerIndex, PathIndex,Lun));
   }

	MPP_LOCK(RdacInfo->Lock, LockLevel);
	RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].PathRemoveState = 0;
   RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].SavedLunPathDevice = NULL;
	RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].LunPathDevice = DeviceVertex;
	++RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->NumberOfLunObjects;

	// create linked list node for lun LPW load balance and insert in linked list
  RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].lLNode =
    mpp_LPWCreateLLNode(RdacInfo, ControllerIndex, PathIndex, Lun);

	if (RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].lLNode == NULL)
	{
	  MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_InsertLunPath: LPW LLNode create failed for Device %s:%d:%d:%d\n",
	    RdacInfo->ModuleName, ControllerIndex, PathIndex,Lun));
	  MPP_UNLOCK(RdacInfo->Lock, LockLevel);
	  return(FALSE);
	}

  // Insert node into linked list
  mpp_LPWInsertLLNode(RdacInfo, ControllerIndex, PathIndex, Lun);

  // Save default PathWeight in LunPathObjects_t
  RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].PathWeight =  MPP_DEFAULT_LBP_PATH_WEIGHT;
  
	MPP_UNLOCK(RdacInfo->Lock, LockLevel);
	if( RdacInfo->RdacLuns[Lun].UTMLun ) {
		if( !(RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].UtmLunDevice =
			mpp_SysInterface->mpp_CreateUtmDevice(DeviceVertex, RdacInfo, ControllerIndex, PathIndex, Lun)) ) {
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 60,"Unable to create UTM path for %s:%d:%d\n",
			RdacInfo->ModuleName, ControllerIndex, PathIndex));
		}
	}

	mpp_SysInterface->mpp_CreateLunLink(DeviceVertex, RdacInfo, ControllerIndex, PathIndex, Lun);
	RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].DeviceState[
		RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].DeviceStateIndex] = MPPCMN_OPTIMAL;

    	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_InsertLunPath: %s:%d:%d:%d inserted\n",
	RdacInfo->ModuleName, ControllerIndex, PathIndex, Lun));
	return(TRUE);
}
/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_BuildRdacinfo
* SUMMARY:  Collect all the information and fill out an RdacInfo
* SCOPE:    local
*
*
* DESCRIPTION:

*
* RESTRICTIONS:
*
* RETURNS:
*   TRUE or FALSE.  TRUE completed successfully.
*************************************************************************/

LWORD
mpp_BuildRdacinfo(MPP_HANDLE DeviceVertex, ControllerAddress_t *DeviceAddress, LWORD Lun)
{
	RdacDeviceInformation_t *RdacInfo;
	BYTE ControllerIndex, PathIndex;
	BYTE ArrayWWN[16], ArrayAsciiName[31];
	LWORD ExtLun;
	LINT LockLevel;
	BYTE FirmwareVersion[3];
	BYTE ArrayType=0;
   	LWORD IsUnconfiguredLun = MPPCMN_UNCONFIGURED_LUN_NOTCHECKED;

	bzero(ArrayWWN, sizeof(ArrayWWN));
	bzero(ArrayAsciiName, sizeof(ArrayAsciiName));

    	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_BuildRdacinfo: called with vertex 0x%x, ControllerAddress 0x%lx, Lun %d\n",
	DeviceVertex, DeviceAddress, Lun));
	if( Lun >= mpp_MaxLunsPerArray ) {
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 61, "Lun number(%d) exceeds Max Configured Value (%d)\n",
			Lun, mpp_MaxLunsPerArray));
		return(MPPCMN_CONFIG_PARAMETER_OUT_OF_LIMIT);
	}

	if(mpp_SysInterface->mppSys_DeviceAlreadyDiscovered(DeviceVertex, Lun) ) {
		MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_BuildRdacinfo: mppSys_DeviceAlreadyDiscovered: Device already present in RdacInfo \n"));
		return(TRUE);

	}

	RdacInfo = mpp_MatchExistingControllerPath(DeviceAddress, &ControllerIndex, &PathIndex);
	MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_BuildRdacinfo: mpp_MatchExistingControllerPath returned RdacInfo 0x%lx\n",
	RdacInfo));

	if( !RdacInfo ) {

		if( !mpp_IsArray(DeviceVertex,  &FirmwareVersion[0]) ) {
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 62, "Device 0x%08x is not an array\n",
			DeviceVertex));
			return(FALSE);
		}

      if( (IsUnconfiguredLun == MPPCMN_UNCONFIGURED_LUN_NOTCHECKED) &&
         (!mpp_SysInterface->mppSys_IsConfiguredDevice(DeviceVertex,DeviceAddress,Lun)) )
      {
         MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
            "Device 0x%08x, Lun %d is not configured\n",DeviceVertex,Lun));
         IsUnconfiguredLun = MPPCMN_UNCONFIGURED_LUN;
         return(MPPCMN_UNCONFIGURED_LUN);
      }
      /*We don't want to set IsUnconfiguredLun = FALSE in this case. This is because
      *the RdacInfo memory is not allocated yet. The mppSys_IsConfiguredDevice() could not
      *set each RdacLun's NotConfigured bit. In a configuration where you have only
      *one lun mapped on a single controller configuration, this allow that mppSys_IsConfiguredDevice()
      *is invoked again after RdacInfo is allocated.
      */

		if( !mpp_GetArrayName(DeviceVertex, &ArrayWWN[0], &ArrayAsciiName[0], &ExtLun) ) {
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 63, "mpp_GetArrayName returned an error on Device 0x%08x\n",
			DeviceVertex));
			return(FALSE);
		}

		if( !mpp_ControllerSlot(DeviceVertex, &ControllerIndex) ) {
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 64, "mpp_ControllerSlot returned an error on %s\n",
			&ArrayAsciiName[0]));
			return(FALSE);
		}

		RdacInfo = mpp_MatchExistingController(&ArrayWWN[0], ControllerIndex, &PathIndex);

		if( RdacInfo && (PathIndex == 0xff) ) {
			/* max path configured limit reached */
			return(MPPCMN_CONFIG_PARAMETER_OUT_OF_LIMIT);
		}
		MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_BuildRdacinfo: mpp_MatchExistingController returned RdacInfo 0x%lx\n",
			RdacInfo));

		if( !RdacInfo ) {

			if( mpp_MaxArrayModuleOverflow(&ArrayWWN[0], &ArrayAsciiName[0]) == TRUE ) {
				MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 120, "Identified Array Module exceeds Max Configured Value (%d)\n",
						mpp_MaxArrayModules));
				return(MPPCMN_CONFIG_PARAMETER_OUT_OF_LIMIT);
			}


			if( !(RdacInfo = mpp_AllocRdacinfo(DeviceVertex, &ArrayWWN[0], &ArrayAsciiName[0])) ) {
				MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 66, "mpp_AllocRdacinfo returned an error\n"));
				return(FALSE);
			}

			MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_BuildRdacinfo: mpp_AllocRdacinfo returned RdacInfo 0x%lx\n",
			RdacInfo));

			if( mpp_GetArrayType(DeviceVertex, &ArrayType) == FALSE ) {
		        MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "Cannot Get Array Type for array %s\n",ArrayAsciiName));
				return(MPPCMN_CONFIG_PARAMETER_OUT_OF_LIMIT);
			}else
            {
		        MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "Array Type for array %s is %d\n",ArrayAsciiName,ArrayType));
                RdacInfo->ArrayType = (MPPCMN_ARRAY_TYPE) ArrayType;
            }
             

			PathIndex = 0;
			MPP_LOCK(RdacInfo->Lock, LockLevel);

	       	} else {
			MPP_LOCK(RdacInfo->Lock, LockLevel);
		}

		bcopy( FirmwareVersion, &RdacInfo->FirmwareVersion, 3);
		if(((RdacInfo->FirmwareVersion[0] & 0x0f) == 0x05) && ((RdacInfo->FirmwareVersion[1] & 0x0f0 ) >= 0x40))
			RdacInfo->FWSonoran4OrLater = TRUE;
		if((RdacInfo->FirmwareVersion[0] & 0x0f) > 0x05)
			RdacInfo->FWSonoran4OrLater = TRUE;

	       	if( !PathIndex ) {
			MPP_UNLOCK(RdacInfo->Lock, LockLevel);
			mpp_InsertController(DeviceVertex, RdacInfo, ControllerIndex);
			MPP_LOCK(RdacInfo->Lock, LockLevel);
		}
		MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_BuildRdacinfo: calling mpp_InsertControllerPath, Controller %d, Path %d\n",
				ControllerIndex, PathIndex));

      MPP_UNLOCK(RdacInfo->Lock, LockLevel);

	       if( !mpp_InsertControllerPath(RdacInfo, ControllerIndex, PathIndex, DeviceAddress) ) {
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 67, "mpp_InsertControllerPath returned an error for %s:%d:%d\n",
			RdacInfo->ModuleName, ControllerIndex, PathIndex));
	       		return(FALSE);
		}

    // check for controller support of SCSI_ENGENIO_BUS_RESET
    mpp_GetPRResetSupport(DeviceVertex, RdacInfo);

      MPP_LOCK(RdacInfo->Lock, LockLevel);

	} else {
		MPP_LOCK(RdacInfo->Lock, LockLevel);
	}

	if( !RdacInfo->RdacLuns[Lun].Present ) {
		MPP_UNLOCK(RdacInfo->Lock, LockLevel);

      if((IsUnconfiguredLun == MPPCMN_UNCONFIGURED_LUN_NOTCHECKED) &&
         (!mpp_SysInterface->mppSys_IsConfiguredDevice(DeviceVertex,DeviceAddress,Lun)) )
      {
         MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
            "Device 0x%08x, Lun %d is not configured\n",DeviceVertex,Lun));
         IsUnconfiguredLun = MPPCMN_UNCONFIGURED_LUN_NOTCHECKED;
			return(MPPCMN_UNCONFIGURED_LUN);
      }
      else
      {
         IsUnconfiguredLun = FALSE;
      }

		if( !mpp_InsertLun(DeviceVertex, RdacInfo, ControllerIndex, Lun) )  {
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 68, "mpp_InsertLun returned an error for %s:%d:%d:%d\n",
			RdacInfo->ModuleName, ControllerIndex, PathIndex, Lun));
			return(FALSE);
		}
		MPP_LOCK(RdacInfo->Lock, LockLevel);
	}
	MPP_UNLOCK(RdacInfo->Lock, LockLevel);


   if((IsUnconfiguredLun == MPPCMN_UNCONFIGURED_LUN_NOTCHECKED) &&
         (!mpp_SysInterface->mppSys_IsConfiguredDevice(DeviceVertex,DeviceAddress,Lun)) )
   {
      MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_3,
         "Device 0x%08x, Lun %d is not configured\n",DeviceVertex,Lun));
      IsUnconfiguredLun = MPPCMN_UNCONFIGURED_LUN_NOTCHECKED;
		return(MPPCMN_UNCONFIGURED_LUN);
   }
   else
   {
      IsUnconfiguredLun = FALSE;
   }


	if( !RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].LunPathDevice &&
	    !mpp_InsertLunPath(DeviceVertex, RdacInfo, ControllerIndex, PathIndex, Lun) ) {
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 69, "mpp_InsertLunPath returned an error for %s:%d:%d:%d\n",
			RdacInfo->ModuleName, ControllerIndex, PathIndex, Lun));
		return(FALSE);
	}

	MPP_LOCK(RdacInfo->Lock, LockLevel);
	RdacInfo->RdacLuns[Lun].PseudoRemoveEligible = FALSE;

	MPP_UNLOCK(RdacInfo->Lock, LockLevel);
	return(TRUE);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_RemoveLun
* SUMMARY:  Remove a physical Lun from an RdacInfo
* RETURNS:
*   TRUE or FALSE.  TRUE completed successfully.
*************************************************************************/

LWORD
mpp_RemoveLun(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun)
{
	LINT LockLevel;
	LWORD i, PathExists;

	MPP_DEBUGPRINT((MPP_DETACH_DEBUG+MPP_DEBUG_LEVEL_3, "mpp_RemoveLun: %s:%d:%d:%d\n",
		RdacInfo->ModuleName, Controller, Path, Lun));

	MPP_LOCK(RdacInfo->Lock, LockLevel);

	if( RdacInfo->RdacLuns[Lun].UTMLun ) {
		mpp_SysInterface->mpp_RemoveUTM(DeviceVertex, RdacInfo, Controller, Path, Lun);
		MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 70, "UTM LUN %s:%d:%d:%d has been removed\n",
			RdacInfo->ModuleName, Controller, Path, Lun));
	}

	if( RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[Path].LunPathDevice ) {
		mpp_SysInterface->mpp_RemoveLunLink(RdacInfo, Controller, Path, Lun);
		MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 71, "Physical path %s:%d:%d:%d has been removed\n",
			RdacInfo->ModuleName, Controller, Path, Lun));
      RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[Path].SavedLunPathDevice = RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[Path].LunPathDevice;
      RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[Path].LunPathDevice = NULL;
	 	RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[Path].PathRemoveState = 1;

		bzero( &RdacInfo->RdacLuns[Lun].LunControllers[Controller]->LunPaths[Path], sizeof(LunPathInfo_t));
		if( !(--RdacInfo->RdacLuns[Lun].LunControllers[Controller]->NumberOfLunObjects) ) {
			MPP_DEBUGPRINT((MPP_DETACH_DEBUG+MPP_DEBUG_LEVEL_1, "mpp_RemoveLun: All Lun Paths removed for %s:%d:%d\n",
			RdacInfo->ModuleName, Controller, Lun));
			if( !RdacInfo->RdacLuns[Lun].LunControllers[Controller^1]->NumberOfLunObjects ) {
				MPP_DEBUGPRINT((MPP_DETACH_DEBUG+MPP_DEBUG_LEVEL_1, "mpp_RemoveLun: All Lun Paths removed for %s:%d\n",
				RdacInfo->ModuleName, Lun));
				RdacInfo->RdacLuns[Lun].PseudoRemoveEligible = TRUE;
			}
		}
	}

	PathExists = 0;
	for(i=0; i<mpp_MaxLunsPerArray; ++i) {
		/* CR 142789 - Added checks to avoid NULL pointer references */
		if( RdacInfo->RdacLuns[i].Present && RdacInfo->RdacLuns[i].LunControllers[Controller]->LunPaths[Path].LunPathDevice ) {
			PathExists = 1;
			break;
		}
	}
	if( !PathExists && RdacInfo->ControllerInfo[Controller]->ControllerPath[Path].Present ) {
		MPP_DEBUGPRINT((MPP_DETACH_DEBUG+MPP_DEBUG_LEVEL_1,
			"mpp_RemoveLun: All LUNs on Path %s:%d:%d have been removed\n",
			RdacInfo->ModuleName, Controller, Path));
		mpp_SysInterface->mpp_RemovePathDirectory(DeviceVertex, RdacInfo, Controller, Path);

		bzero(&RdacInfo->ControllerInfo[Controller]->ControllerPath[Path], sizeof(RdacControllerPath_t));

		--RdacInfo->ControllerInfo[Controller]->NumberOfPaths;
		MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 72, "Physical path %s:%d:%d has been removed\n",
		RdacInfo->ModuleName, Controller, Path));
	}

	if( RdacInfo->ControllerInfo[Controller]->ControllerPresent && !RdacInfo->ControllerInfo[Controller]->NumberOfPaths ) {
		MPP_DEBUGPRINT((MPP_DETACH_DEBUG+MPP_DEBUG_LEVEL_3,
			"mpp_RemoveLun: Controller %s:%d has been removed\n",
			RdacInfo->ModuleName, Controller));
		mpp_SysInterface->mpp_RemoveControllerDirectory(DeviceVertex, RdacInfo, Controller);

		bzero(RdacInfo->ControllerInfo[Controller], sizeof(RdacControllerInformation_t)-sizeof(RdacControllerPath_t));

		RdacInfo->SingleController = TRUE;
		MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 73, "Controller %s:%d has been removed\n",
			RdacInfo->ModuleName, Controller));
	}

  // CR 88964 07/11/2005 - removed PseudoAddLock condition
	if( RdacInfo->RdacLuns[Lun].PseudoRemoveEligible ) {
		if( !RdacInfo->RdacLuns[Lun].UTMLun ) {
			mpp_SysInterface->mpp_RemoveVirtualLun(RdacInfo, Lun);
			MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 74, "Virtual Lun %s:%d has been removed\n",
				RdacInfo->ModuleName, Lun));
		}
		else //UTM case
		{
			RdacInfo->RdacLuns[Lun].PseudoLunObject = NULL;
			RdacInfo->RdacLuns[Lun].Present = 0;
		}

		if(mpp_SysInterface->mpp_IsOkayToClearRdacLuns(RdacInfo, Lun))
		{
			/* Added 4 bytes for alignment. Removing that while doing bzero */
			bzero(&RdacInfo->RdacLuns[Lun],
				(sizeof(RdacLunInformation_t)-((2*sizeof(LunPathObjects_t *)) + 16 +sizeof(MPPCMN_LOAD_BALANCE_POLICY) +
				sizeof(void *) + 4)) );
			bzero(&RdacInfo->RdacLuns[Lun].WWN[0], 16 );
		}
	}

	MPP_UNLOCK(RdacInfo->Lock, LockLevel);

	return(0);
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_ChkIOForWandV
* SUMMARY:  Check the cdb passed in and set the 2 boolean output parameters based on what is found in the
*			cdb and sense data passed in.
*
* INPUT:	cdb - cdb of the completed op
*			SenseDataPresent - TRUE if sense data present in the completed op, FALSE otherwise
*			SenseKey - sense data of completed op, null if no data
*			ASC - the ASC code of the completed op, null if no data
*			ASCQ - the ASCQ code of the completed op, null if no data
*			b_WandV - boolean * output parameter
*			b_RetryWithWrite - boolean * output parameter
*
* OUTPUT VARS:		b_WandV - set to true if the CDB passed in is a write-with-verify and the parity-check bit is on.
*					b_RetryWithWrite - set to true if either a RAID 5 or RAID 1 write error is detected. (degraded LUN?)
*
* RETURNS:  void
*
*************************************************************************/
void
mpp_ChkIOForWandV(BYTE *cdb, BOOL SenseDataPresent, BYTE SenseKey, BYTE ASC,
				  BYTE ASCQ, BOOL *b_WandV, BOOL *b_RetryWithWrite)
{

	*b_WandV = FALSE;
	*b_RetryWithWrite = FALSE;

	if (*cdb != SCSI_WRITE_VERIFY)
	{
		return;
	}

	// see if Vendor Unique ParChk bit is turned on

	if (cdb[1] & 0x08)
	{
		*b_WandV = TRUE;
	}

	if (*b_WandV && SenseDataPresent)
	{
		// chk for degraded RAID 5 LUN error
		if (SenseKey == SENSE_KEY_HARDWARE_ERROR &&
			ASC == 0x84 &&
			ASCQ == 0x00)
		{
			MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_2,
				"mpp_ChkIOForWandV: RAID 5 WriteAndVerify IO failed\n"));
			*b_RetryWithWrite = TRUE;
		}
		// chk for RAID 1 error
		else if (SenseKey == SENSE_KEY_ILLEGAL_REQUEST &&
			ASC == 0x24 &&
			ASCQ == 0x00)
		{
			MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_2,
				"mpp_ChkIOForWandV: RAID 1 WriteAndVerify IO failed\n"));
			*b_RetryWithWrite = TRUE;
		}
	}

	return;
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_SetWandVBit
* SUMMARY:  Sets the error-recovery bit for an op. This bit is set to indicate that the next retry of this op
*			should be performed with a write-and-verify. The data must be stored as state information with the
*			original op so it can be retrieved and tested before the op is issued by the IOStart routine.
*
* INPUT:	ErrorRecovery - boolean * parameter that will be set.
*			b_WandV - input parameter, set in mpp_ChkIOForWandV
*			b_RetryWithWrite - input parameter, set in mpp_ChkIOForWandV
*
* RETURNS:  void
*
*************************************************************************/
void
mpp_SetWandVBit(BOOL *ErrorRecovery, BOOL b_WandV, BOOL b_RetryWithWrite)
{
	if (b_WandV && !b_RetryWithWrite)
	{
		*ErrorRecovery = 1;
	}
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_TestBuildWandVOp
* SUMMARY:  Logic to determine based on the op status whether the next retry of this op needs
*			to be a write w/ verify.
*
* INPUT:	cdb - cdb of the completed op
*			ErrorRecovery - boolean flag that indicates that the next retry of op should be with a W & V
*			b_WandV - boolean -- says something.
*			b_RetryWithWrite - boolean -- says to unconditionally NOT do WandV
*			oldController - the controller that the IO WAS previously issued on
*			newController - the controller that the IO WILL BE issued on
*
* RETURNS:	TRUE - a write-with-verify is warranted
*			FALSE - a write-with-verify should not be used
*************************************************************************/
int
mpp_TestBuildWandVOp(BYTE *cdb, BOOL ErrorRecovery, BOOL b_WandV, BOOL b_RetryWithWrite,
					 int oldController, int newController)
{

	/* If this is a failed WandV, revert to Write (actually, 'original command') */
	if (b_RetryWithWrite)
		return FALSE;

	/* Force WandV if ErrorRecovery is in progress */
	if (ErrorRecovery == 1)
			return TRUE;

	/* We reach this spot on the "1st" trip through this function */
	/* If we've switched controllers */
	if (oldController != newController)
	{
		/* and if this is a WRITE command */
		if (*cdb == SCSI_WRITE ||
		    *cdb == SCSI_SMALL_WRITE ||
		    *cdb == SCSI_WRITE_12 ||
		    *cdb == SCSI_WRITE_16)
		    /* then we need to turn it into a WandV */
			return TRUE;

		/* also, if this is a write verify command */
		if (*cdb == SCSI_WRITE_VERIFY ||
		    *cdb == SCSI_WRITE_VERIFY_12 ||
		    *cdb == SCSI_WRITE_VERIFY_16)
		{
			/* and we didn't build it (ParChk bit isn't on) */
			if (! b_WandV)
			    /* Then we need to make sure the vendor unique ParChk (cdb[1] & 0x08) bit is on */
				return TRUE;
		}

	}
	/* Otherwise we don't think this op needs to be forced into WandV */
	return FALSE;
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_BuildWriteWithVerify
* SUMMARY:  Retool the write op so that it is a Write And Verify operation.
*			We do this because of a hole in controller code that allows an
*			interrupted write on a controller with write through cache turned on to
*			generate parity corruption.  The Write And Verify should
*			fix the problem for retried Write operations.
*
* INPUT:	cdb - 12 byte cdb of the completed op. The op will be modified to use a write-with-verify.
*
* RETURNS:	void
*************************************************************************/
void
mpp_BuildWriteWithVerify(BYTE *cdb)
{
	unsigned char newCdb[16];
	int copySz = 0;

	bzero(newCdb, 16);

	// Calculate the size of the constructed 'Write and Verify' command
	if ( cdb[0] == SCSI_SMALL_WRITE ||
	     cdb[0] == SCSI_WRITE ||
	     cdb[0] == SCSI_WRITE_VERIFY)
		copySz=10;
	else if ( cdb[0] == SCSI_WRITE_12 ||
	          cdb[0] == SCSI_WRITE_VERIFY_12)
		copySz=12;
	else if ( cdb[0] == SCSI_WRITE_16 ||
	          cdb[0] == SCSI_WRITE_VERIFY_16)
		copySz=16;

	// 0xa, 6 byte write op maps to 10-byte WandV
	if ( cdb[0] == SCSI_SMALL_WRITE )
	{
		newCdb[0] = SCSI_WRITE_VERIFY; // 0x2e
		newCdb[1] = (cdb[1] & 0xe0) | 0x08;  // turn on the ParChk bit
		newCdb[3] = cdb[1] & 0x1f; // MSB top 5 bits
		newCdb[4] = cdb[2]; // MSB
		newCdb[5] = cdb[3]; // LSB
		newCdb[8] = cdb[4]; // transfer len
		newCdb[9] = cdb[5]; // control
	}
	else
	{
		// Everything else maps to an equal-sized WandV. Copy the whole thing,
		bcopy (cdb, newCdb, copySz);
		// reset the opcode,
		if ( copySz == 10 )
			newCdb[0] = SCSI_WRITE_VERIFY; // 0x2e
		else if (copySz == 12 )
			newCdb[0] = SCSI_WRITE_VERIFY_12; // 0xae
		else if (copySz == 16 )
			newCdb[0] = SCSI_WRITE_VERIFY_16; // 0x8e

		// and make sure the ParChk bit is on,
		if ( cdb[0] == SCSI_WRITE ||
		     cdb[0] == SCSI_WRITE_12 ||
		     cdb[0] == SCSI_WRITE_16 )
		{
			newCdb[1] = (cdb[1] & 0xf0); //Preserve just WrProtect and DPO flags
		}
		newCdb[1] |= 0x08;           // turn on the ParChk bit
	}

	MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_2,
		"mpp_BuildWriteWithVerify: rebuilt 0x%x write command to WriteAndVerify\n",
		*cdb));

	// copy the new cdb back to the original op
	bcopy(newCdb, cdb, copySz);
	return;
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_RebalanceLuns
* SUMMARY:  Move luns to their preferred owning path (ie. controller)
* SCOPE:    local
*
* DESCRIPTION:
*	This function replaces mpp_CheckPreferredAVTOwner() and logic from
*	mpp_FailBackScan() that moves luns to their preferred paths.  It
*	first checks each of the luns to determine if they should be moved
*	to a different controller path, and if so call one of the rebalance
*	functions to perform the transfer.  If the request is successful
*	the internal RdacInfo structure is updated with the path information.
*	It also re-defines the use of the mpp_DisableLunRebalance parameter.
*	The parameter now applies to both AVT and non-AVT modes (previously
*	it was non-AVT mode only), and each mode can be independently set
*	(ex. lun rebalance for AVT and no rebalance for non-AVT).  In addition
*	the function will also transfer volumes for which no I/O's are active.
*
*  @RdacInfo      RdacDeviceInformation_t object that represent a storage array
*  @forcedRebalance TRUE will override the DisableLunRebalance setting and perform
*                   the lun rebalance operation.
*
* RESTRICTIONS:
* 	This function is called within the mpp_FailBackScan() function.
* 	The mpp_CheckAVTState() function is called after mpp_FailBackScan(),
* 	meaning the if an AVT/non-AVT switch occurs, and the mode being
* 	switched to allows autolun transfers, the transer will not occur
* 	until the next call to mpp_FailBackScan().
*
* RETURNS:
* 	None.
*************************************************************************/
void
mppCmn_RebalanceLuns(RdacDeviceInformation_t *RdacInfo, BOOL forcedRebalance)
{
	MPP_HANDLE	deviceVertex;
	MPP_HANDLE	vertexAvailable[2];
	unsigned char	vertexPath[2];
	unsigned char	*controllerLunTables = NULL;
	unsigned char	controllerRebalance[2] = { 0, 0 };
   unsigned char	*controllerLunTablesForUpdate = NULL;
   unsigned char	controllerRebalanceForUpdate[2] = { 0, 0 };
	BOOL		avtEnabled;
	BOOL		currentOwner;
    	BYTE		avtPriority;
	BYTE		preferredOwner;
	BYTE		lunDone;
	BYTE		updatePreferredPath = FALSE;
	BYTE		controller;
	BYTE		path;
	LWORD		lun;
	LWORD		stateIndex;
	VOID		*page2C;
	BYTE		*cdb;
	int		pageSize;

	controllerLunTables = (unsigned char *)MPP_INT_KMEM_ALLOC((2 * mpp_MaxLunsPerArray) * sizeof(unsigned char));
   controllerLunTablesForUpdate = (unsigned char *)MPP_INT_KMEM_ALLOC((2 * mpp_MaxLunsPerArray) * sizeof(unsigned char));
   if(!controllerLunTables || !controllerLunTablesForUpdate)
	{
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 121, "Unable to malloc lunTable for Lun Rebalance\n"));
		return;
	}

	for(lun=0; lun < mpp_MaxLunsPerArray; ++lun)
	{
		lunDone = FALSE;
		if(!RdacInfo->RdacLuns[lun].Present || RdacInfo->RdacLuns[lun].UTMLun )
		{
			continue;
		}

		MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG, "RebalanceLuns: Checking(%s:%d)\n", RdacInfo->ModuleName, lun));

		// 06/24/04 - Although the 'for' loop below assumes two controllers other parts of the logic make
		// no assumptions about the number of controllers.  Long term we may have to deal with this (although
		// there are ALOT of other changes necessary) but for now assume there are always a maximum of two
		// controllers.  We can check for the presence of both controllers, and if one of them is NotPresent,
		// Failed, or in ServiceMode assume the rebalance operation cannot happen.  If both controllers are
		// available we don't know which one actually owns the lun so start with the first one.
		if( (!RdacInfo->ControllerInfo[0]->ControllerPresent ||
		      RdacInfo->ControllerInfo[0]->Failed ||
		      RdacInfo->ControllerInfo[0]->ServiceMode) ||
		    (!RdacInfo->ControllerInfo[1]->ControllerPresent ||
		      RdacInfo->ControllerInfo[1]->Failed ||
		      RdacInfo->ControllerInfo[1]->ServiceMode))
		{
			MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG + MPP_DEBUG_LEVEL_3, "RebalancePreCheck: AlternateNotAvailable(%s)\n", RdacInfo->ModuleName));
			break;
		}

		// 08/04/06.  Changed logic to check for at least one good path to each controller before the ownership
		// check is performed.  In PnP/HotPlug environments an individual lun could be removed from a path although
		// other luns on the same path may be okay.  The original logic could still move a lun to a non-existent path,
		// causing a controller-level failover to be issued which pulls the volumes back.
		vertexAvailable[0] = NULL;
		vertexAvailable[1] = NULL;
		vertexPath[0] = 0;
		vertexPath[1] = 0;
		for(controller = 0; controller < 2; ++controller)
		{
			if(!RdacInfo->ControllerInfo[controller]->ControllerPresent ||
			    RdacInfo->ControllerInfo[controller]->Failed ||
			    RdacInfo->ControllerInfo[controller]->ServiceMode)
			{
				/* This controller is not available for the array */
				MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG, "RebalanceLuns: CntrlNotAvailable(%s:%d)\n", RdacInfo->ModuleName, controller));
				break; /* No point trying to rebalance */
			}

			MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG, "RebalanceLuns: CheckPaths(%s:%d:%d)\n", RdacInfo->ModuleName, controller));
			for(path = 0; path < mpp_MaxPathsPerController; ++path)
			{
				stateIndex = RdacInfo->ControllerInfo[controller]->ControllerPath[path].PathStateIndex;
				if(!RdacInfo->ControllerInfo[controller]->ControllerPath[path].Present ||
				    RdacInfo->ControllerInfo[controller]->ControllerPath[path].PathState[stateIndex] == MPPCMN_FAILED ||
				    RdacInfo->ControllerInfo[controller]->ControllerPath[path].PathState[stateIndex] == MPPCMN_FAILED_NEED_CHECK ||
				    RdacInfo->ControllerInfo[controller]->ControllerPath[path].PathState[stateIndex] == MPPCMN_FAILED_CHECKING ||
				   !RdacInfo->RdacLuns[lun].LunControllers[controller]->LunPaths[path].LunPathDevice ||
				    RdacInfo->RdacLuns[lun].LunControllers[controller]->LunPaths[path].PathRemoveState)
				{
					/* This path is not available for the controller */
					MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG, "RebalanceLuns: NoPath(%s:%d:%d)\n", RdacInfo->ModuleName, controller, path));
					continue;
				}

				vertexAvailable[controller] = RdacInfo->RdacLuns[lun].LunControllers[controller]->LunPaths[path].LunPathDevice;
				vertexPath[controller] = path;
				MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG, "RebalanceLuns: Device(%s:%d:%d:%d-%p)\n",
					RdacInfo->ModuleName, controller, path, lun, vertexAvailable[controller]));
				break;
			}
		}

		if((vertexAvailable[0] != NULL) && (vertexAvailable[1] != NULL))
		{
			// Both paths for this device exist.  Go ahead and choose the first device.
			controller = 0;
			deviceVertex = vertexAvailable[controller];
			MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG + MPP_DEBUG_LEVEL_3,
				"mppCmn_RebalanceLuns: Checking Device %s:%d:%d:%d - 0x%lx\n",
				RdacInfo->ModuleName, controller, vertexPath[controller], lun, deviceVertex));
			if(mpp_GetAVTData(deviceVertex, &avtPriority, &currentOwner, &avtEnabled))
			{
				if(avtPriority == 1)
				{
					preferredOwner = controller;
				}
				else if(avtPriority == 2)
				{
					preferredOwner = controller ^ 1;
				}
				else
				{
					MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG + MPP_DEBUG_LEVEL_3,
						"mppCmn_RebalanceLuns: Unable to determine preferredOwner!\n"));
					break;
				}

				/*
				 * There may be cases where a controller has been brought online yet volumes
				 * with prefered ownership to that controller will not be transferred because
				 * no I/O's are sent to it.  Therefore, we must check the CurrentVolumePath (the
				 * currentOwner parameter here) to see where the volume currently resides in relation
				 * to its prefered owner.  According to the controller spec the value of currentOwner
				 * will be 1 if the controller receiving the request currently owns it, and 0 if it
				 * does not.  The 'currentOwner' variable is re-used here.
				 */
				if(currentOwner == 1)
				{
					currentOwner = controller;
				}
				else
				{
					currentOwner = controller ^ 1;
				}

				MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG + MPP_DEBUG_LEVEL_3,
					"mppCmn_RebalanceLuns: PrefOwn(%x);CurOwn(%x);PrefPath(%x);CurPath(%x);AVTEnabled(%x)\n",
					preferredOwner, currentOwner, RdacInfo->RdacLuns[lun].PreferredPath,
					RdacInfo->RdacLuns[lun].CurrentOwningPath, RdacInfo->AVTEnabled));

				if(RdacInfo->ControllerInfo[preferredOwner]->ControllerPresent &&
				   !RdacInfo->ControllerInfo[preferredOwner]->Failed &&
				  (RdacInfo->RdacLuns[lun].CurrentOwningPath != preferredOwner ||
				   RdacInfo->RdacLuns[lun].PreferredPath != preferredOwner ||
				   preferredOwner != currentOwner))
				{
					/*
					 * Lun is not on the preferred path.  If DisableLunRebalance indicates
					 * a rebalance should not occur we simply update the RdacInfo structure.
					 * If a rebalance _should_ occur we update our controllerLunTable temp
					 * variable, perform the transfer, then update the RdacInfo structure after
					 * the request succeeds.
					 */
					if((forcedRebalance == TRUE) || (mpp_DisableLUNRebalance == MPPCMN_REBALANCE_ALL) ||
					   (RdacInfo->AVTEnabled && mpp_DisableLUNRebalance == MPPCMN_REBALANCE_AVT_MODE) ||
					   (!RdacInfo->AVTEnabled && mpp_DisableLUNRebalance == MPPCMN_REBALANCE_NON_AVT_MODE))
					{
						MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG + MPP_DEBUG_LEVEL_3,
							"mppCmn_RebalanceLuns: Changing owning path for %s:%d - %d\n",
							RdacInfo->ModuleName, lun, preferredOwner));
						controllerLunTables[(preferredOwner * mpp_MaxLunsPerArray) + lun] = 1;
						controllerRebalance[preferredOwner] = 1;
					}
					else
					{
					/*
					 * This is the mpp_DisableLUNRebalance == MPPCMN_REBALANCE_NONE case
					 * In this case, we still need to update the preferred owner of a volume
					 */
					controllerLunTablesForUpdate[(preferredOwner * mpp_MaxLunsPerArray) + lun] = 1;
					controllerRebalanceForUpdate[preferredOwner] = 1;
					}
				}
			}
			else
			{
				MPP_ERRORLOGPRINT((MPP_ERR_ALL, 6,
					"Error accessing %s:%d:%d:%d to check lun rebalance\n",
					RdacInfo->ModuleName, controller, vertexPath[controller], lun));
			}
		}
	}

	/* At this point every lun for this array has been checked.  Now perform the rebalance. */
	for(controller = 0; controller < 2; ++controller)
	{
		updatePreferredPath = FALSE;
		if(!RdacInfo->ControllerInfo[controller]->ControllerPresent ||
		    RdacInfo->ControllerInfo[controller]->Failed ||
	 	    RdacInfo->ControllerInfo[controller]->FailoverInProgress ||
		    RdacInfo->ControllerInfo[controller]->ServiceMode )
		{
			/* This controller is not available for the array or no rebalance should occur */
			continue;
		}
      else
      {
         if(controllerRebalance[controller] == 0)
         {
            if(controllerRebalanceForUpdate[controller] != 0)
            {
               for(lun=0; lun < mpp_MaxLunsPerArray; ++lun)
               {
                  if(controllerLunTablesForUpdate[(controller * mpp_MaxLunsPerArray) + lun] == 1)
                  {
                     RdacInfo->RdacLuns[lun].PreferredPath = controller;
                     MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 5, "%s:%d Preferred Owner set - %d\n",
                        RdacInfo->ModuleName, lun, controller));
                     MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG + MPP_DEBUG_LEVEL_3,
                        "mppCmn_RebalanceLuns: %s:%d - Preferred owner set - %d\n",
                        RdacInfo->ModuleName, lun, controller));
                  }
               }
            }
            continue;
         }
      }

		MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG + MPP_DEBUG_LEVEL_3,
			"mppCmn_RebalanceLuns: Perform rebalance for %s Controller %d\n",
			RdacInfo->ModuleName, controller));

		if(RdacInfo->Page2CSubPage1)
		{
			page2C = (ModePage2CSubPage_t *) MPP_INT_KMEM_ALLOC(sizeof(ModePage2CSubPage_t)+10);
			pageSize = sizeof(ModePage2CSubPage_t);
		}
		else
		{
			page2C = (ModePage2C_t *) MPP_INT_KMEM_ALLOC(sizeof(ModePage2C_t)+10);
			pageSize = sizeof(ModePage2C_t);
		}

		if(!page2C)
		{
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 75,
				"%s FailBackScan could not alloc memory to rebalance LUNs\n", RdacInfo->ModuleName));
			continue;
		}

		if(RdacInfo->Page2CSubPage1)
		{
			cdb = ((BYTE *) page2C) + sizeof(ModePage2CSubPage_t);
			mpp_CreatePage2CSubPageRebalance(page2C, cdb, &controllerLunTables[controller * mpp_MaxLunsPerArray], FALSE);
		}
		else
		{
			cdb = ((BYTE *) page2C) + sizeof(ModePage2C_t);
			mpp_CreatePage2CRebalance(page2C, cdb, &controllerLunTables[controller * mpp_MaxLunsPerArray], FALSE);
		}

		deviceVertex = NULL;
		/* send the command to first available LUN */
		for(path=0; path < mpp_MaxPathsPerController && !deviceVertex; ++path)
		{
			stateIndex = RdacInfo->ControllerInfo[controller]->ControllerPath[path].PathStateIndex;
			if(!RdacInfo->ControllerInfo[controller]->ControllerPath[path].Present ||
			    RdacInfo->ControllerInfo[controller]->ControllerPath[path].PathState[stateIndex] == MPPCMN_FAILED ||
			    RdacInfo->ControllerInfo[controller]->ControllerPath[path].PathState[stateIndex] == MPPCMN_FAILED_NEED_CHECK ||
			    RdacInfo->ControllerInfo[controller]->ControllerPath[path].PathState[stateIndex] == MPPCMN_FAILED_CHECKING)
			{
				continue;
			}

			for(lun=0; lun < mpp_MaxLunsPerArray; ++lun)
			{
				if(!RdacInfo->RdacLuns[lun].Present ||
				   !RdacInfo->RdacLuns[lun].LunControllers[controller]->LunPaths[path].LunPathDevice ||
				    RdacInfo->RdacLuns[lun].LunControllers[controller]->LunPaths[path].PathRemoveState)
				{
					continue;
				}
				else
				{
					deviceVertex = RdacInfo->RdacLuns[lun].LunControllers[controller]->LunPaths[path].LunPathDevice;
					break;
				}
			}

			// 12/27/07 - CR134766.  Acquire a reference count for this device to prevent it from being removed while a
			// request is in progress. 
			if((deviceVertex != NULL) && (mpp_SysInterface->mppSys_AcquireReferenceCount(deviceVertex) == MPP_GOOD_STATUS))
			{
				break;
			}
			else
			{
				deviceVertex = NULL;
				continue;
			}
		}

		if(deviceVertex != NULL)
		{
			/* send the rebalance mode select to controller */
			if (mpp_SynchronousIo(deviceVertex, cdb, 10, page2C, pageSize, MPPCMN_XFER_HOST_DEV) != MPP_NO_ERROR)
			{
				/* command failed.  This is not really a path failover but must be set to this level
				 * in order to be logged as a warning rather than an error */
				MPP_ERRORLOGPRINT((MPP_ERR_PATH_FAILOVER, 115,
					"Mpp_FailBackScan: Device %s:%d - Unable to rebalance LUNs\n",
					RdacInfo->ModuleName, controller));
				MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG + MPP_DEBUG_LEVEL_3,
					"mppCmn_RebalanceLuns: %s Controller %d - Unable to rebalance luns\n",
					RdacInfo->ModuleName, controller));
			}
			else
			{
				/* command succeeded */
				MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 116,
					"Mpp_FailBackScan: Device %s:%d - Rebalanced LUNs\n",
					RdacInfo->ModuleName, controller));
				MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG + MPP_DEBUG_LEVEL_3,
					"mppCmn_RebalanceLuns: %s Controller %d - Rebalanced Luns\n",
					RdacInfo->ModuleName, controller));
				updatePreferredPath = TRUE;
			}

			// 12/27/07 - CR134766.  Release the reference count.
			mpp_SysInterface->mppSys_ReleaseReferenceCount(deviceVertex);
		}
		else
		{
			/* could not find a valid device to send mode select to */
			/* 08/19/03 - Changed the error level from FATAL to RECOVERED to reduce the
			 * number of error messages produced */
			MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 117,
				"Mpp_FailBackScan: Device %s:%d - Unable to find valid path or LUN to send rebalance command to\n",
				RdacInfo->ModuleName, controller));
			MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG + MPP_DEBUG_LEVEL_3,
				"mppCmn_RebalanceLuns: %s:%d - No valid path for rebalance command\n",
				RdacInfo->ModuleName, controller));
		}

		/* free memory for command */
		if(page2C)
		{
			MPP_FREE(page2C, pageSize + 10);
		}

		if(updatePreferredPath)
		{
			/* Reuse 'lun' variable here. */
			for(lun=0; lun < mpp_MaxLunsPerArray; ++lun)
			{
				if(controllerLunTables[(controller * mpp_MaxLunsPerArray) + lun] == 1)
				{
					RdacInfo->RdacLuns[lun].CurrentOwningPath = controller;
					RdacInfo->RdacLuns[lun].PreferredPath = controller;
					MPP_ERRORLOGPRINT((MPP_ERR_RECOVERED, 5, "%s:%d Preferred Owner set - %d\n",
						RdacInfo->ModuleName, lun, controller));
					MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG + MPP_DEBUG_LEVEL_3,
						"mppCmn_RebalanceLuns: %s:%d - Preferred owner set - %d\n",
						RdacInfo->ModuleName, lun, controller));
				}
			}
		}
	}

	if(controllerLunTables)
	{
		MPP_FREE(controllerLunTables, (2 * mpp_MaxLunsPerArray) * sizeof(unsigned char));
	}

   if(controllerLunTablesForUpdate)
	{
		MPP_FREE(controllerLunTablesForUpdate, (2 * mpp_MaxLunsPerArray) * sizeof(unsigned char));
	}

	return;
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_CheckControllerForServiceMode
* SUMMARY:  Determine whether a controller for an array is in Service Mode.
* SCOPE:    local
*
* DESCRIPTION:
* 	This function issues a ModeSense 0x2C request to a controller
* 	in a storage array to determine if its alternate is in
* 	Service Mode.  If so an appropriate flag is set.
* 	Its arguable whether this code should be integrated into the
* 	FailbackScan() process itself.  However, as its written today
* 	it would be rather messy.
*
* RESTRICTIONS:
* 	As noted above, in order to determine the status of a controller
* 	its alternate must be referenced.
*
* RETURNS:
* 	None.
*************************************************************************/
void
mppCmn_CheckControllerForServiceMode(RdacDeviceInformation_t *RdacInfo, BYTE Controller)
{
	MPP_HANDLE 		deviceVertex;
	ModePage2CSubPage_t	*modePage2CSubPage;
	ModePage2C_t		*modePage2C;
	BYTE			path;
	LWORD			lun;
	LWORD			pageSize;
	LWORD			stateIndex;
	BYTE			*cdb;
	BYTE			*page2C;
	BYTE			cdbLen = 10;

	for(path=0; path < mpp_MaxPathsPerController; ++path)
	{
		deviceVertex = NULL;
		stateIndex = RdacInfo->ControllerInfo[Controller^1]->ControllerPath[path].PathStateIndex;
		if( !RdacInfo->ControllerInfo[Controller^1]->ControllerPath[path].Present ||
		     RdacInfo->ControllerInfo[Controller^1]->ControllerPath[path].PathState[stateIndex] == MPPCMN_FAILED ||
		     RdacInfo->ControllerInfo[Controller^1]->ControllerPath[path].PathState[stateIndex] == MPPCMN_FAILED_NEED_CHECK ||
		     RdacInfo->ControllerInfo[Controller^1]->ControllerPath[path].PathState[stateIndex] == MPPCMN_FAILED_CHECKING)
		{
			continue;
		}

		for(lun=0; lun < mpp_MaxLunsPerArray; ++lun)
		{
			if( !RdacInfo->RdacLuns[lun].Present ||
			    !RdacInfo->RdacLuns[lun].LunControllers[Controller^1]->LunPaths[path].LunPathDevice ||
			     RdacInfo->RdacLuns[lun].LunControllers[Controller^1]->LunPaths[path].PathRemoveState )
			{
				continue;
			}

			deviceVertex = RdacInfo->RdacLuns[lun].LunControllers[Controller^1]->LunPaths[path].LunPathDevice;

			// 05/31/05 - Acquire a reference count for this device to prevent it from being removed while a
			// request is in progress.
			if(mpp_SysInterface->mppSys_AcquireReferenceCount(deviceVertex) != MPP_GOOD_STATUS)
			{
				continue;
			}

			if(RdacInfo->Page2CSubPage1)
			{
				page2C = (BYTE *) MPP_INT_KMEM_ALLOC(sizeof(ModePage2CSubPage_t)+10);
				if(!page2C)
				{
					mpp_SysInterface->mppSys_ReleaseReferenceCount(deviceVertex);
					MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 129, "Unable to allocate memory\n"));
					return;
				}
				pageSize = sizeof(ModePage2CSubPage_t);
				cdb = ((BYTE *) page2C) + pageSize;
			}
			else
			{
				page2C = (BYTE *) MPP_INT_KMEM_ALLOC(sizeof(ModePage2C_t)+10);
				if(!page2C)
				{
					mpp_SysInterface->mppSys_ReleaseReferenceCount(deviceVertex);
					MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 130, "Unable to allocate memory\n"));
					return;
				}
				pageSize = sizeof(ModePage2C_t);
				cdb = ((BYTE *) page2C) + pageSize;
			}

			*cdb = SCSI_MODE_SENSE;
			*(cdb+1) = 0x08; /*DBD bit on*/
			*(cdb+2) = (BYTE)(0x2c); /*PC = 00b (current) and Page code = 0x2c*/
			if (RdacInfo->Page2CSubPage1)
			{
				*(cdb+3) = 0x01;
			}
			else
			{
				*(cdb+3) = 0x00;
			}

			*(cdb+7) = (BYTE) (pageSize >> 8) &0x00ff;
			*(cdb+8) = (BYTE) pageSize & 0x00ff;
			if(mpp_SynchronousIo(deviceVertex, cdb, cdbLen, page2C, pageSize, MPPCMN_XFER_DEV_HOST) != MPP_NO_ERROR)
			{
				// The request may fail on this path, but try another path if one is available.
				mpp_SysInterface->mppSys_ReleaseReferenceCount(deviceVertex);
				MPP_FREE(page2C, pageSize+10);
				continue;
			}

			// Service Mode is indicated by a 0x00 in the Alt_RDACMode field.  There is already a
			// definition for this in the scsiio.h file called PASSIVE_MODE so reuse that definition
			// here.
			if (RdacInfo->Page2CSubPage1)
			{
				modePage2CSubPage = (ModePage2CSubPage_t *)page2C;
				if(modePage2CSubPage->RDAC_Mode[0] == ALTERNATE_PRESENT)
				{
					if(modePage2CSubPage->AltRDACMode[1] == PASSIVE_MODE)
					{
						RdacInfo->ControllerInfo[Controller]->ServiceMode = 1;
					}
					else
					{
						// Reset the ServiceMode flag
						RdacInfo->ControllerInfo[Controller]->ServiceMode = 0;
					}
				}

				mpp_SysInterface->mppSys_ReleaseReferenceCount(deviceVertex);
				MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG+MPP_DEBUG_LEVEL_2, "%s:%d ServiceMode status - %x\n",
					RdacInfo->ModuleName, Controller));
				MPP_FREE(page2C, pageSize+10);
				return;
			}
			else
			{
				modePage2C = (ModePage2C_t*)page2C;
				if(modePage2C->RDAC_Mode[0] == ALTERNATE_PRESENT)
				{
					if(modePage2C->AltRDACMode[1] == PASSIVE_MODE)
					{
						RdacInfo->ControllerInfo[Controller]->ServiceMode = 1;
					}
					else
					{
						// Reset the ServiceMode flag
						RdacInfo->ControllerInfo[Controller]->ServiceMode = 0;
					}
				}

				mpp_SysInterface->mppSys_ReleaseReferenceCount(deviceVertex);
				MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG+MPP_DEBUG_LEVEL_2, "%s:%d ServiceMode status - %x\n",
					RdacInfo->ModuleName, Controller));
				MPP_FREE(page2C, pageSize+10);
				return;
			}
		}
	}

	MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG+MPP_DEBUG_LEVEL_2, "%s:%d Unable to determine ServiceMode status\n",
		RdacInfo->ModuleName, Controller));
	return;
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_CheckPathStatus
* SUMMARY:  Checks path status and sets new status accordingly.
*
*
* DESCRIPTION:
*	    This function is called every sec by a timer. This checks the
*      	    path status and sets to another path state according to path state
*	    diagram. This is done by incrementing OPTIMAL and FAILED
*	    counters by 1. When they reach configured value the path is moved
*	    accordingly.
*
*	    And the main job this function does is to call mppSys_validatepath()
*	    which is a system dependent routine to check the validity of the
*	    path by sending an inquiry command.
*
* RESTRICTIONS:
*
*
* RETURNS:
*   VOID.
*************************************************************************/
VOID
mppCmn_CheckPathStatus()
{
	RdacDeviceInformation_t		*rdacInfo;
	RdacControllerPath_t		*controllerPath;
	LWORD				count, controller, path, stateIndex;
	ArrayModuleEntry_t		*ModPtr;
	LWORD				lun;


	ModPtr = mpp_ModuleArray;
	for(count = 0; count < mpp_MaxArrayModules; ++count, ++ModPtr)
	{
		rdacInfo = ModPtr->RdacInfo;
		if(!rdacInfo)
			continue;

		for(controller = 0; controller < 2; ++controller)
		{
			if(!rdacInfo->ControllerInfo[controller]->ControllerPresent)
				continue;

			for(path = 0; path < mpp_MaxPathsPerController; ++path)
			{
				if(!rdacInfo->ControllerInfo[controller]->ControllerPath[path].Present)
					continue;

				controllerPath = &rdacInfo->ControllerInfo[controller]->ControllerPath[path];
				stateIndex = controllerPath->PathStateIndex;

				switch(controllerPath->PathState[stateIndex])
				{
					case MPPCMN_OPTIMAL:
						controllerPath->PathIdleTime++;
						MPP_DEBUGPRINT((MPP_PATH_VALIDATION_DEBUG+MPP_DEBUG_LEVEL_3,
								"PathIdleTime: %d - %s:%d:%d\n", controllerPath->PathIdleTime,
								rdacInfo->ModuleName, controller, path));
						if(controllerPath->PathIdleTime > mppCmn_IdlePathCheckingInterval)
						{
							MPPCMN_SET_PATH_STATE(rdacInfo, controller, path, MPPCMN_OPTIMAL_NEED_CHECK);
							MPP_DEBUGPRINT((MPP_PATH_VALIDATION_DEBUG+MPP_DEBUG_LEVEL_3,
								"CheckPathStatus: %s:%d:%d OptimalNeedCheck\n",
								rdacInfo->ModuleName, controller, path));
						}
						break;

					case MPPCMN_OPTIMAL_NEED_CHECK:
						MPPCMN_SET_PATH_STATE(rdacInfo, controller, path, MPPCMN_OPTIMAL_CHECKING);
						if(mpp_SysInterface->mppSys_ValidatePath(rdacInfo, controller, path) != MPP_GOOD_STATUS)
						{
							// Validation request attempt failed.
							MPP_DEBUGPRINT((MPP_PATH_VALIDATION_DEBUG+MPP_DEBUG_LEVEL_3,
								"CheckPathState: %s:%d:%d IssueValidation(Optimal) failed\n",
								rdacInfo->ModuleName, controller, path));
							MPPCMN_SET_PATH_STATE(rdacInfo, controller, path, MPPCMN_OPTIMAL);
							controllerPath->PathIdleTime = 0;
						}
						break;

					case MPPCMN_FAILED:
						controllerPath->PathFailedTime++;
						MPP_DEBUGPRINT((MPP_PATH_VALIDATION_DEBUG+MPP_DEBUG_LEVEL_3,
								"PathFailedTime: %d - %s:%d:%d\n", controllerPath->PathFailedTime,
								rdacInfo->ModuleName, controller, path));
						if(controllerPath->PathFailedTime > mppCmn_RecheckFailedPathWaitTime)
						{
							// Setting FAILED_NEED_CHECK here causes either an I/O request to issue
							// a validation request or the FAILED_NEED_CHECK state to issue one after
							// the failed interval time has expired.
							MPPCMN_SET_PATH_STATE(rdacInfo, controller, path, MPPCMN_FAILED_NEED_CHECK);
							for( lun=0; lun<mpp_MaxLunsPerArray; ++lun)
							{
                        if(rdacInfo->RdacLuns[lun].LunControllers[controller]->LunPaths[path].LunPathDevice)
                        {
								   MPPCMN_SET_DEVICE_PATH_STATE(rdacInfo, controller, path, lun, MPPCMN_FAILED_NEED_CHECK);
                        }
							}
							MPP_DEBUGPRINT((MPP_PATH_VALIDATION_DEBUG+MPP_DEBUG_LEVEL_3,
								"CheckPathStatus: %s:%d:%d FailedNeedCheck\n",
								rdacInfo->ModuleName, controller, path));
						}
						break;

					case MPPCMN_FAILED_NEED_CHECK:
						controllerPath->PathFailedTime++;
						MPP_DEBUGPRINT((MPP_PATH_VALIDATION_DEBUG+MPP_DEBUG_LEVEL_3,
								"PathFailedTime(NC): %d - %s:%d:%d\n", controllerPath->PathFailedTime,
								rdacInfo->ModuleName, controller, path));
						if(controllerPath->PathFailedTime > mppCmn_FailedPathCheckingInterval)
						{
							// Issue the validation command ourselves
							MPPCMN_SET_PATH_STATE(rdacInfo, controller, path, MPPCMN_FAILED_CHECKING);
							for( lun=0; lun<mpp_MaxLunsPerArray; ++lun)
							{
                        					if(rdacInfo->RdacLuns[lun].LunControllers[controller]->LunPaths[path].LunPathDevice)
                        					{
								   MPPCMN_SET_DEVICE_PATH_STATE(rdacInfo, controller, path, lun, MPPCMN_FAILED_CHECKING);
                     					   	}
							}
							if(mpp_SysInterface->mppSys_ValidatePath(rdacInfo, controller, path) != MPP_GOOD_STATUS)
							{
								// Validation request attempt failed.
								MPP_DEBUGPRINT((MPP_PATH_VALIDATION_DEBUG+MPP_DEBUG_LEVEL_3,
									"CheckPathState: %s:%d:%d IssueValidation(Failed) failed\n",
									rdacInfo->ModuleName, controller, path));
								MPPCMN_SET_PATH_STATE(rdacInfo, controller, path, MPPCMN_FAILED);
								for( lun=0; lun<mpp_MaxLunsPerArray; ++lun)
								{
									MPPCMN_SET_DEVICE_PATH_STATE(rdacInfo, controller, path, lun, MPPCMN_FAILED);
								}
								controllerPath->PathFailedTime = 0;
							}
						}
						break;

					case MPPCMN_OPTIMAL_CHECKING:
					case MPPCMN_FAILED_CHECKING:
					case MPPCMN_SYSTEM_SPECIFIC:
						break;
				}
			}
		}
	}

	return;
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_GetArrayStatus
* SUMMARY:  Get Real Time Path and Controller Status.
* SCOPE:    local
*
* DESCRIPTION:
*	mppCmn_GetArrayStatus calls the different functions that would
*	return path and controller status info.
*
* RESTRICTIONS:
*
* RETURNS:
* 	None.
*************************************************************************/
void
mppCmn_GetArrayStatus(RdacDeviceInformation_t *RdacInfo, mpp_utilStatusInfo_t *utilStatusInfo )
{

        MPP_DEBUGPRINT((MPP_IOCTL_DEBUG + MPP_DEBUG_LEVEL_4, "mppCmn_GetArrayStatus: \n" ));
        mppCmn_InitUtilStatus(RdacInfo, utilStatusInfo);
        mppCmn_GetPathState(RdacInfo, utilStatusInfo);
        mppCmn_GetControllerState(RdacInfo, utilStatusInfo);

        bcopy(RdacInfo->ModuleName, utilStatusInfo->mpp_SAName, sizeof(DevName_t));
        mpp_SysInterface->mppSys_GetUtilSysdepData(RdacInfo, utilStatusInfo);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_InitUtilStatus
* SUMMARY:  Initializes the utilStatusInfo data structure
* SCOPE:    local
*
* DESCRIPTION:
*	This function initializes all the fields of the utilStatusInfo
*	data structure to meaningful defaults.
*
* RESTRICTIONS:
*
* RETURNS:
* 	None.
*************************************************************************/
void
mppCmn_InitUtilStatus(RdacDeviceInformation_t *RdacInfo, mpp_utilStatusInfo_t *utilStatusInfo )
{
        BYTE*   ptr;
        BYTE                    Path;
        LWORD                   Lun;
        ControllerAddress_t DummyCtlAddr = { -1, -1, -1 };
        mpp_utilLunInfo_t   *lunInfo = NULL;
        mpp_utilPathInfo_t  *pathInfo = NULL;

        MPP_DEBUGPRINT((MPP_IOCTL_DEBUG + MPP_DEBUG_LEVEL_4, "mppCmn_InitUtilStatus: Initializing UtilStatusInfo data Structure\n" ));
        memset(utilStatusInfo->mpp_SAName, 0, sizeof(DevName_t));
        utilStatusInfo->mpp_ControllerState[0] = MPPCMN_CTLR_UNKNOWN_STATE;
        utilStatusInfo->mpp_ControllerState[1] = MPPCMN_CTLR_UNKNOWN_STATE;

        ptr = (BYTE *)utilStatusInfo + sizeof(mpp_utilStatusInfo_t);
        utilStatusInfo->mpp_utilLunInfoAddress = (mpp_utilLunInfo_t *)ptr;
        lunInfo = (mpp_utilLunInfo_t *) utilStatusInfo->mpp_utilLunInfoAddress;

        ptr= ptr + sizeof(mpp_utilLunInfo_t)* mpp_MaxLunsPerArray;
        pathInfo = (mpp_utilPathInfo_t *) ptr;
        lunInfo->mpp_utilPathInfoAddress = pathInfo;

        utilStatusInfo->mpp_PlatformStatusInfo.mpp_VirtualTargetId = -1;
        utilStatusInfo->mpp_PlatformStatusInfo.mpp_VirtualHostId = -1;


        for(Lun=0; Lun<mpp_MaxLunsPerArray; ++Lun) {
                lunInfo->mpp_LunNumber = NO_LUN;
                lunInfo->mpp_utilPathInfoAddress = pathInfo;

                for(Path=0; Path < 2 * mpp_MaxPathsPerController; Path++) {

                        pathInfo->mpp_PathState = NO_PATH;
                        bcopy(&DummyCtlAddr, &pathInfo->mpp_CtlAddr, sizeof(ControllerAddress_t));
                        ptr = (BYTE *)pathInfo;
                        ptr += sizeof(mpp_utilPathInfo_t);
                        pathInfo = (mpp_utilPathInfo_t *)ptr;
                }
                ptr = (BYTE *)lunInfo;
                ptr += sizeof(mpp_utilLunInfo_t);
                lunInfo = (mpp_utilLunInfo_t *)ptr;
        }
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_QueryPathStatus
* SUMMARY:  Sends a TUR(Test Unit Ready) command
* SCOPE:    local
*
* DESCRIPTION:
*	This Function issues a TUR command along the Path supplied
* 	in utilPathInfo to detect if the path is UP or DOWN.
*
* RESTRICTIONS:
*
* RETURNS:
* 	LWORD - status of path.
*************************************************************************/
LWORD
mppCmn_QueryPathStatus( MPP_HANDLE deviceVertex, mpp_utilPathInfo_t *utilPathInfo )
{
        InqSupportedPages_t 			  	*suppPages = NULL;
        BYTE                                            *cdb = NULL;
        BYTE                                            cdbLen= CDB_LEN_6;
        LWORD                                           status;


        suppPages = (InqSupportedPages_t *) MPP_INT_KMEM_ALLOC(sizeof(InqSupportedPages_t) + CDB_LEN_6 );
        if(!suppPages)
        {
                MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 134, "mppCmn_QueryPathStatus: Unable to allocate Inquiry command memory\n"));
                return FALSE;
        }

	cdb = ((BYTE *) suppPages) + sizeof(InqSupportedPages_t);
        mppCmn_CreateInquiry((InqSupportedPages_t *)suppPages, cdb);
        status = mpp_SynchronousIo(deviceVertex, cdb, cdbLen, (void *)suppPages, sizeof(InqSupportedPages_t), MPPCMN_XFER_DEV_HOST );

        if ((status != MPP_NO_ERROR ) || ( suppPages->Periph_Qualifier != LUN_CONNECTED ))
                utilPathInfo->mpp_PathState = PATH_DOWN;
        else
                utilPathInfo->mpp_PathState = PATH_UP;

        MPP_FREE(suppPages, sizeof(InqSupportedPages_t) + CDB_LEN_6);
	return status;

}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_GetControllerState
* SUMMARY: This function issues a ModeSense 0x2C request to both controllers
* 	   in a storage array to determine their state.
* SCOPE:    local
*
* DESCRIPTION:
*	Go through RdacInfo and find the first available lun, path to a controller,
*	through which a mode sense 2c command can be issued. The controllers can be
*	in one of CTLR_ACTIVE, CTLR_MISSING, CTLR_MISSING, CTLR_OFFLINE,
*	CTLR_RESET states. If so, an appropriate field in utilStatusInfo
*	data structure is set.
*
* RESTRICTIONS:
*
* RETURNS:
* 	None.
*************************************************************************/
void
mppCmn_GetControllerState(RdacDeviceInformation_t *RdacInfo, mpp_utilStatusInfo_t *utilStatusInfo ) {
        MPP_HANDLE              deviceVertex;
        ModePage2C_t            *modePage2C=NULL;
        LWORD                   lun;
        BYTE                    *cdb;
        BYTE                    *page2C;
        BYTE                    cdbLen = CDB_LEN_10;
        BYTE                    Done = 0;
        LWORD                   pageSize;
        LINT			Controller;
        LWORD			path;
        LWORD                   mppStatus= 0xffff;
        SenseData_t             *SenseData;
#ifdef MPP_DEBUG
 	static char *ControllerStates[] = {
                "Missing",
                "Active",
                "Offline",
                "Service-Mode",
                "Reset",
                "Unknown"
        };
#endif


        page2C = (BYTE *) MPP_INT_KMEM_ALLOC(sizeof(ModePage2C_t) + CDB_LEN_10);
        if(!page2C)
        {
                MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 136, "mppCmn_GetControllerState: Unable to allocate ModePage2C memory\n"));
                return;
        }
        SenseData = (SenseData_t *) MPP_INT_KMEM_ALLOC(sizeof(SenseData_t));
        if(!SenseData)
        {
                MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 137, "mppCmn_GetControllerState: Unable to allocate SenseData memory\n"));
        	MPP_FREE(page2C, sizeof(ModePage2C_t) + CDB_LEN_10);
                return;
        }
        pageSize = sizeof(ModePage2C_t);
        cdb = ((BYTE *) page2C) + pageSize;
        mppCmn_CreateModeSense2C((ModePage2C_t *)page2C, cdb);

        for (Controller = 0; Controller < 2 ; Controller++)
        {

                if(! RdacInfo->ControllerInfo[Controller]->ControllerPresent )
                {
                        continue;
                }

                for(lun=0; lun < mpp_MaxLunsPerArray; ++lun)
                {

                        if( !RdacInfo->RdacLuns[lun].Present || RdacInfo->RdacLuns[lun].UTMLun )
                        {
                                continue;
                        }
                        for(path=0; path < mpp_MaxPathsPerController; ++path)
                        {
                                deviceVertex = NULL;

                                if( !RdacInfo->ControllerInfo[Controller]->ControllerPath[path].Present ||
                                !RdacInfo->RdacLuns[lun].LunControllers[Controller]->LunPaths[path].LunPathDevice ||
                                RdacInfo->RdacLuns[lun].LunControllers[Controller]->LunPaths[path].PathRemoveState )
                                {
                                        continue;
                                }

                                deviceVertex = RdacInfo->RdacLuns[lun].LunControllers[Controller]->LunPaths[path].LunPathDevice;

				 if(( mppStatus = mpp_SynchronousIo(deviceVertex, cdb, cdbLen, page2C, pageSize,  MPPCMN_XFER_DEV_HOST )) != MPP_NO_ERROR)
                                {
                                        // The request may fail on this path, but try another path if one is available.
                                        continue;
                                }

                                /* Set controller state */
                                modePage2C = (ModePage2C_t*)page2C;

                                if (modePage2C->RDAC_Mode[0] == NO_ALTERNATE_PRESENT )
                                        utilStatusInfo->mpp_ControllerState[Controller ^ 1] = MPPCMN_CTLR_MISSING;

                                if ( utilStatusInfo->mpp_ControllerState[Controller] == MPPCMN_CTLR_UNKNOWN_STATE )
                                        utilStatusInfo->mpp_ControllerState[Controller] = mppCmn_ConvertToControllerState(modePage2C->RDAC_Mode[1]);
                                if (modePage2C->RDAC_Mode[0] == ALTERNATE_PRESENT )
                                {
                                        if ( modePage2C->AltRDACMode[1] == PASSIVE_MODE )
                                                utilStatusInfo->mpp_ControllerState[Controller ^ 1] = MPPCMN_CTLR_IN_SERVICE;
                                        else if ( modePage2C->RDAC_Mode[1] == ACTIVE_MODE )
                                                utilStatusInfo->mpp_ControllerState[Controller ^ 1] = MPPCMN_CTLR_OFFLINE;
                                        else
                                                utilStatusInfo->mpp_ControllerState[Controller ^ 1] = mppCmn_ConvertToControllerState(modePage2C->AltRDACMode[1]);

                                }

                                Done = 1;
                                if ( Done == 1 )
                                        break;
                        }
                        if ( Done == 1 )
                                break;
                }

		if ( Done == 0 )
			MPP_DEBUGPRINT((MPP_AVTSCAN_DEBUG+MPP_DEBUG_LEVEL_2, " Unable to determine Controller status for array %s: Controller %d\n", RdacInfo->ModuleName, Controller));
		else {
			MPP_DEBUGPRINT((MPP_IOCTL_DEBUG + MPP_DEBUG_LEVEL_3, "mppCmn_GetControllerState: issued Mode Sense Page 2C to Array %s: Controller : %d, RdacMode Page[0]: 0x%x RdacMode Page[1]: 0x%x, AltRdacMode Page[0]: 0x%x AltRdacMode Page[1]:0x%x, Controller A State:%s, Controller B State:%s\n", RdacInfo->ModuleName, Controller,modePage2C->RDAC_Mode [0],modePage2C->RDAC_Mode[1], modePage2C->AltRDACMode[0],modePage2C->AltRDACMode[1], ControllerStates[utilStatusInfo->mpp_ControllerState[0] - 0x0A], ControllerStates[utilStatusInfo->mpp_ControllerState[1] - 0x0A]));
		}

                if ( Done == 1 && Controller == 1) {
			break;
                }

                Done = 0;

        }


        MPP_FREE(page2C, pageSize + CDB_LEN_10);
        MPP_FREE(SenseData, sizeof(SenseData_t));
}



/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_CreateModeSense2C
* SUMMARY:  Build a ModeSense2C command
* SCOPE:    local
*
* DESCRIPTION:
*	This Function mallocs memory for a ModeSense2C command and fills
*	up the necessary fields of the command.
*
* RESTRICTIONS:
*
* RETURNS:
* 	None.
*************************************************************************/
void
mppCmn_CreateModeSense2C(ModePage2C_t *Page2C, BYTE *cdb)
{
        LWORD                   pageSize;


        MPP_DEBUGPRINT((MPP_IOCTL_DEBUG + MPP_DEBUG_LEVEL_4, "mppCmn_CreateModeSense2C: Creating ModeSensePage2C \n"));
        pageSize = sizeof(ModePage2C_t);
        cdb = ((BYTE *) Page2C) + pageSize;

        bzero(Page2C, sizeof(ModePage2C_t));
        bzero(cdb, CDB_LEN_10);

        *cdb = SCSI_MODE_SENSE;
        *(cdb+1) = 0x08; /*DBD bit on*/
        *(cdb+2) = (BYTE)PAGE_CODE_REDUNDANT_CONTROLLER; /*PC = 00b (current) and Page code = 0x2c*/
        *(cdb+3) = 0x00;

        *(cdb+7) = (BYTE) (pageSize >> 8) &0x00ff;
        *(cdb+8) = (BYTE) pageSize & 0x00ff;


}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_CreateInquiry
* SUMMARY:  Build an Inquiry command
* SCOPE:    local
*
* DESCRIPTION:
*	This Function mallocs memory for an Inquiry command and fills
*	up the necessary fields of the command.
*
* RESTRICTIONS:
*
* RETURNS:
* 	None.
*************************************************************************/
void
mppCmn_CreateInquiry(InqSupportedPages_t *suppPages, BYTE *cdb)
{
        LWORD                   pageSize;


        MPP_DEBUGPRINT((MPP_IOCTL_DEBUG + MPP_DEBUG_LEVEL_4, "mppCmn_CreateInquiry: Creating Inquiry command\n"));
        pageSize = sizeof(InqSupportedPages_t);
        cdb = ((BYTE *) suppPages ) + pageSize;

        bzero(suppPages, sizeof(InqSupportedPages_t));
        bzero(cdb, CDB_LEN_6);

	*cdb = SCSI_INQUIRY;
	*(cdb+1) = (BYTE) 1;
	*(cdb+2) = 0;
	*(cdb+3) = *(cdb+5) = 0;
	*(cdb+4) = (BYTE) sizeof(InqSupportedPages_t);

}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_ConvertToControllerState
* SUMMARY:  Convert the input RdacMode value to an appropriate controller state
* SCOPE:    local
*
* DESCRIPTION:
*	This function takes the input RdacMode value returned by the controller
*	in response to a ModeSense2C command and maps it to an approriate
*	controller state.
*
* RESTRICTIONS:
*
* RETURNS:
* 	controller state.
*************************************************************************/
BYTE
mppCmn_ConvertToControllerState(BYTE mode)
{
        switch(mode) {
                case ACTIVE_MODE:
                        return MPPCMN_CTLR_ACTIVE;

                case DUAL_ACTIVE_MODE:
                        return MPPCMN_CTLR_ACTIVE;

/* Only for docuentation. will never get executed
                case PASSIVE_MODE:
                        return MPPCMN_CTLR_OFFLINE;
*/

                case RESET_MODE:
                        return MPPCMN_CTLR_RESET;

                default:
                        return MPPCMN_CTLR_UNKNOWN_STATE;
        }

}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_GetPathState
* SUMMARY:  Determines the state of each path by issuing a TUR
* SCOPE:    local
*
* DESCRIPTION:
*	This function goes through the RdacInfo data structure to find all
*	paths to each lun on the controller and issues a TUR command down
*	each path to determine its status.
*
* RESTRICTIONS:
*
* RETURNS:
* 	None.
*************************************************************************/
void
mppCmn_GetPathState(RdacDeviceInformation_t *RdacInfo, mpp_utilStatusInfo_t *utilStatusInfo)
{
        LWORD                                    Lun;
        LINT                                     Cont;
        LWORD 					Path;
        RdacLunInformation_t *LunInfo;
        LunPathObjects_t        *LunCont = NULL;
        LunPathInfo_t           *LunPath = NULL;
        mpp_utilLunInfo_t   *lunInfo = NULL;
        mpp_utilPathInfo_t  *pathInfo = NULL;
        BYTE *ptr = NULL;
	LWORD status;

        ptr = (BYTE *)utilStatusInfo->mpp_utilLunInfoAddress;
        lunInfo = (mpp_utilLunInfo_t *) ptr;
        ptr= ptr + sizeof(mpp_utilLunInfo_t)* mpp_MaxLunsPerArray;
        pathInfo = (mpp_utilPathInfo_t *) ptr;
        lunInfo->mpp_utilPathInfoAddress = pathInfo;

        for(Lun = 0; Lun < mpp_MaxLunsPerArray; Lun++)
        {
                LunInfo = &RdacInfo->RdacLuns[Lun];
                if (!LunInfo->Present || LunInfo->UTMLun)
                {
                        goto lun_step;
                }

                lunInfo->mpp_LunNumber = Lun;
                pathInfo = lunInfo->mpp_utilPathInfoAddress;

                for (Cont = 0; Cont < 2; Cont++)
                {
                        LunCont = LunInfo->LunControllers[Cont];
                        if (!LunCont )
                        {
        	     		ptr = (BYTE *)pathInfo;
                        	ptr += (mpp_MaxPathsPerController)*sizeof(mpp_utilPathInfo_t);
                        	pathInfo = (mpp_utilPathInfo_t *)ptr;
				continue;
                        }

                        if(! RdacInfo->ControllerInfo[Cont]->ControllerPresent )
                        {
        	     		ptr = (BYTE *)pathInfo;
                        	ptr += (mpp_MaxPathsPerController)*sizeof(mpp_utilPathInfo_t);
                        	pathInfo = (mpp_utilPathInfo_t *)ptr;
				continue;
                        }


                        for(Path=0; Path < mpp_MaxPathsPerController; Path++)
                        {

                                bcopy(&RdacInfo->ControllerInfo[Cont]->ControllerPath[Path].Address, &pathInfo->mpp_CtlAddr , sizeof(ControllerAddress_t));
                                if( !RdacInfo->ControllerInfo[Cont]->ControllerPath[Path].Present )
                                {
                                        goto path_step;
                                }

                                LunPath = &LunCont->LunPaths[Path];
                                if( !LunPath  || (!LunPath->LunPathDevice) || LunPath->PathRemoveState)
                                {
                                        goto path_step;
                                }


                                status = mppCmn_QueryPathStatus( LunPath->LunPathDevice, pathInfo);
				if ( status != MPP_NO_ERROR )
	                		MPP_DEBUGPRINT((MPP_IOCTL_DEBUG+MPP_DEBUG_LEVEL_3, "mppCmn_QueryPathStatus: sync inquiry failed for path: ArrayName %s: Controller %d: Path%d : Lun %d\n", RdacInfo->ModuleName, Cont, Path,Lun ));
				else
	                		MPP_DEBUGPRINT((MPP_IOCTL_DEBUG+MPP_DEBUG_LEVEL_3, "mppCmn_QueryPathStatus: sync inquiry succeeded for path: ArrayName %s: Controller %d: Path %d: Lun %d\n", RdacInfo->ModuleName, Cont, Path, Lun));


                path_step:      ptr = (BYTE *)pathInfo;
                                ptr += sizeof(mpp_utilPathInfo_t);
                                pathInfo = (mpp_utilPathInfo_t *)ptr;

                        }

                }

      lun_step: ptr = (BYTE *)lunInfo;
                ptr += sizeof(mpp_utilLunInfo_t);
                lunInfo = (mpp_utilLunInfo_t *)ptr;
        }
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_InitializeFeatureOptions
* SUMMARY:  Initialize Feature Options
* SCOPE:    local
*
* DESCRIPTION:
* 	This function builds a global Feature Options table based on the
* 	common code options and system-dependent options passed in as an
* 	argument.  Once a global table is built each option is initialized
* 	to a default value.
*
* RESTRICTIONS:
* 	In order to ensure the options are initialized properly this function
* 	must be called before any configuration parameters are loaded by
* 	the system-dependent driver code.
*
* 	The user MUST call mppCmn_CleanupFeatureOptions() to free the memory
* 	allocated by this function.
*
* RETURNS:
* 	TRUE if successful, else FALSE if an error occurs.
*************************************************************************/
LWORD
mppCmn_InitializeFeatureOptions(MppCmn_FeatureOptionControl_t *SysdepFeatureOptions, LWORD NumSysdepOptions)
{
	MppCmn_FeatureOptionControl_t	*tmpOptions;
	LWORD				totalOptions, numCommonOptions;
	LWORD				optionCount;

	numCommonOptions = (sizeof(mppCmn_FeatureOptions) / sizeof(MppCmn_FeatureOptionControl_t));
	totalOptions = NumSysdepOptions + numCommonOptions;
	if(NumSysdepOptions == 0 || SysdepFeatureOptions == NULL)
	{
		// There are no system-dependent options, so just return a pointer to the common parameters.
		mppCmn_FeatureOptionControl = mppCmn_FeatureOptions;
	}
	else
	{
		mppCmn_FeatureOptionControl = (MppCmn_FeatureOptionControl_t *)MPP_INT_KMEM_ALLOC(sizeof(MppCmn_FeatureOptionControl_t) * totalOptions);
		if(mppCmn_FeatureOptionControl == NULL)
		{
			return(FALSE);
		}

		bzero(mppCmn_FeatureOptionControl, sizeof(MppCmn_FeatureOptionControl_t) * totalOptions);
		tmpOptions = mppCmn_FeatureOptionControl;
		bcopy(mppCmn_FeatureOptions, tmpOptions, sizeof(MppCmn_FeatureOptionControl_t) * numCommonOptions);

		tmpOptions += numCommonOptions;
		bcopy(SysdepFeatureOptions, tmpOptions, sizeof(MppCmn_FeatureOptionControl_t) * NumSysdepOptions);
	}

	for(optionCount = 0; optionCount < totalOptions; optionCount++)
	{
		if(mppCmn_FeatureOptionControl[optionCount].ValueAddr)
		{
			mppCmn_FeatureOptionControl[optionCount].DefaultValue = *((LWORD *)mppCmn_FeatureOptionControl[optionCount].ValueAddr);
		}
	}

	mppCmn_NumFeatureOptions = totalOptions;
	return(TRUE);
}


VOID
mppCmn_CleanupFeatureOptions()
{
	if(mppCmn_FeatureOptionControl)
	{
		MPP_FREE(mppCmn_FeatureOptionControl, mppCmn_NumFeatureOptions * sizeof(MppCmn_FeatureOptionControl_t));
		mppCmn_FeatureOptionControl = NULL;
	}

	return;
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_ProcessFeatureOptions
* SUMMARY:  Process a Feature Option request.
* SCOPE:    local
*
* DESCRIPTION:
* 	This function processes a Feature Option request submitted by a
* 	user-mode application such as mppUtil.  "GET" requests return
* 	a complete list of supported options.  "SET" requests either perform
* 	an action or set a configuration parameter.
*
* RESTRICTIONS:
* 	Note the function returns zero (success) even if the request fails
* 	due to insufficient buffer space.  This is necessary because the
* 	function must update the TotalBytesNeeded parameter so the calling
* 	application knows how much memory to allocate, and returning a
* 	failed status may prevent this updated information from being
* 	returned.
*
* RETURNS:
* 	At the moment just zero, indicating success of the request.
*************************************************************************/
int
mppCmn_ProcessFeatureOptions(MppCmn_OptionControlIoctl_t *Ioctl)
{
	// TODO calculate number of options
	MppCmn_OptionControl_t	*optionControl;
	struct _MppCmn_FeatureOptionControl_t	*featureOption;
	LWORD			optionCount;
	LWORD			totalBytes = mppCmn_NumFeatureOptions * sizeof(MppCmn_OptionControl_t);
	LWORD			numIoctlParams;

	// First, check the magic value to determine if the request is valid.  Also make sure
	// the global Feature Options have been set.
	// 01/24/05 - Check for a NULL input parameter.
	if(Ioctl == NULL)
	{
		return(0);
	}

	if(Ioctl->Magic != MPPCMN_FEATURE_OPTION_MAGIC || mppCmn_FeatureOptionControl == NULL)
	{
		return(0);
	}

	if(Ioctl->RequestType == MPPCMN_OPTION_REQUEST_GET)
	{
		// Determine if enough space has been allocated to hold the requested information.
		if(totalBytes > Ioctl->BufferSize)
		{
			Ioctl->BytesTransferred = 0;
			Ioctl->TotalBytesNeeded = totalBytes;
			return(0);
		}

		optionControl = Ioctl->OptionBuffer;
		for(optionCount = 0; optionCount < mppCmn_NumFeatureOptions; optionCount++)
		{
			if(mppCmn_FeatureOptionControl[optionCount].OptionType == MPPCMN_FEATURE_TYPE_VARIABLE)
			{
				optionControl->Value = *((LWORD *)mppCmn_FeatureOptionControl[optionCount].ValueAddr);
				optionControl->DefaultValue = mppCmn_FeatureOptionControl[optionCount].DefaultValue;
				optionControl->MinValue = mppCmn_FeatureOptionControl[optionCount].MinValue;
				optionControl->MaxValue = mppCmn_FeatureOptionControl[optionCount].MaxValue;
				bcopy(mppCmn_FeatureOptionControl[optionCount].Keyword, optionControl->Keyword, MPPCMN_KEYWORD_OPTION_LENGTH);
				optionControl->Status = MPPCMN_OPTION_VARIABLE_SUCCESS;
				optionControl += 1;
			}
			else if(mppCmn_FeatureOptionControl[optionCount].OptionType == MPPCMN_FEATURE_TYPE_ACTION)
			{
				bcopy(mppCmn_FeatureOptionControl[optionCount].Keyword, optionControl->Keyword, MPPCMN_KEYWORD_OPTION_LENGTH);
				optionControl->Status = MPPCMN_OPTION_ACTION_SUCCESS;
				optionControl += 1;
			}
		}

		Ioctl->BytesTransferred = totalBytes;
		Ioctl->TotalBytesNeeded = 0;
		return(0);
	}
	else	// SET operation
	{
		if(Ioctl->BufferSize == 0 || Ioctl->OptionBuffer == NULL)
		{
			// Nothing to do
			Ioctl->BytesTransferred = 0;
			Ioctl->TotalBytesNeeded = 0;
			return(0);
		}

		optionControl = Ioctl->OptionBuffer;
		numIoctlParams = Ioctl->BufferSize / sizeof(MppCmn_OptionControl_t);
		for(optionCount = 0; optionCount < numIoctlParams; optionCount++)
		{

			featureOption = mppCmn_GetFeatureOptionControlByKeyword(optionControl->Keyword);
			if(featureOption == NULL)
			{
				optionControl->Status = MPPCMN_OPTION_KEYWORD_UNKNOWN;
				optionControl += 1;
				continue;
			}

			// Check the incoming optionControl status.  It will indicate whether the calling
			// application provided a value with the parameter and determine whether to
			// accept or reject the request.
			if((featureOption->OptionType == MPPCMN_FEATURE_TYPE_VARIABLE &&
			    optionControl->Status != MPPCMN_OPTION_VARIABLE_SUCCESS) ||
			   (featureOption->OptionType == MPPCMN_FEATURE_TYPE_ACTION &&
			    optionControl->Status != MPPCMN_OPTION_ACTION_SUCCESS))
			{
				optionControl->Status = MPPCMN_OPTION_INVALID_PARAMETER;
				optionControl += 1;
				continue;
			}

			if(featureOption->ValueAddr != NULL)
			{
				// Check the range before allowing the value to be set.
				if(optionControl->Value < featureOption->MinValue ||
				   optionControl->Value > featureOption->MaxValue)
				{
					optionControl->Status = MPPCMN_OPTION_VALUE_OUT_OF_RANGE;
					optionControl->MinValue = featureOption->MinValue;
					optionControl->MaxValue = featureOption->MaxValue;
					optionControl += 1;
					continue;
				}

				*((LWORD *)featureOption->ValueAddr) = optionControl->Value;
				optionControl->Status = MPPCMN_OPTION_VARIABLE_SUCCESS;
			}

			if(featureOption->CallbackFunc != NULL)
			{
				optionControl->Status = featureOption->CallbackFunc(featureOption, optionControl);
			}

			optionControl += 1;
		}
	}

	return(0);
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_GetFeatureOptionControlByKeyword
* SUMMARY:  Find a Feature Option by its keyword.
* SCOPE:    local
*
* DESCRIPTION:
* 	This function goes through the global Feature Option table
* 	to find an option based on its keyword.  If found a pointer
* 	to that option is returned else NULL is returned.
*
* RESTRICTIONS:
* 	None.
*
* RETURNS:
* 	None.
*************************************************************************/
struct _MppCmn_FeatureOptionControl_t *
mppCmn_GetFeatureOptionControlByKeyword(TEXT *Keyword)
{
	LWORD		optionCount;

	for(optionCount = 0; optionCount < mppCmn_NumFeatureOptions; optionCount++)
	{
		if(!bcmp((BYTE *) &mppCmn_FeatureOptionControl[optionCount].Keyword, Keyword, MPPCMN_KEYWORD_OPTION_LENGTH))
		{
			return(&mppCmn_FeatureOptionControl[optionCount]);
		}

	}

	return(NULL);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_LoadBalanceFeatureCallback
* SUMMARY:  Process a Feature Option request.
* SCOPE:    local
*
* DESCRIPTION:
* 	This function processes processes the load balance feature and sets up
* 	new(userEntered) loadBalance policy in rdack info structure.
* 	This is called when SET operation is done on Load Balance feature.
*
* RETURNS:
* 	At the moment just zero, indicating success of the request.
*************************************************************************/
int 
mppCmn_LoadBalanceFeatureCallback(struct _MppCmn_FeatureOptionControl_t *FeatureOption, MppCmn_OptionControl_t *OptionControl)
{
	RdacDeviceInformation_t *RdacInfo;
	BYTE arrayIndex = 0;
	LWORD lunIndex = 0;

	for (arrayIndex = 0; arrayIndex < mpp_MaxArrayModules; arrayIndex++)
	{
		RdacInfo = mpp_ModuleArray[arrayIndex].RdacInfo;
		if( !RdacInfo )
			continue;
		/* First set the value in Rdac struct for the array and then for each Lun */
		RdacInfo->LoadBalancePolicy = OptionControl->Value;
		for (lunIndex=0; lunIndex < mpp_MaxLunsPerArray; ++lunIndex)
		{
			if (!RdacInfo->RdacLuns[lunIndex].Present || RdacInfo->RdacLuns[lunIndex].LBPFromStore)
				continue;
			RdacInfo->RdacLuns[lunIndex].LoadBalancePolicy = OptionControl->Value;
		}
	}
	mppCmn_LoadBalancePolicy = OptionControl->Value;

	return MPPCMN_OPTION_VARIABLE_SUCCESS;
}


void
mppCmn_CheckAndSetTASBit(
	IN MPP_HANDLE DeviceVertex,
	IN RdacDeviceInformation_t *RdacInfo,
	IN LWORD Lun)
{
        ModePageA_t            	*pageA = NULL;
        SenseData_t             *senseData = NULL;
        BYTE                    cdbLen = CDB_LEN_10;
        BYTE                    *cdb;
        LWORD                   pageSize;
	LINT			lockLevel;

	// Check TAS bit setting for the virtual device.  If the bit is set exit the function.
	if(RdacInfo->RdacLuns[Lun].TASBitSet == 1)
	{
		return;
	}

        pageA = (ModePageA_t *) MPP_INT_KMEM_ALLOC(sizeof(ModePageA_t) + CDB_LEN_10);
        if(!pageA)
        {
                MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 151, "mppCmn_CheckAndSetTASBit: Unable to allocate ModePageA memory\n"));
                return;
        }

        senseData = (SenseData_t *) MPP_INT_KMEM_ALLOC(sizeof(SenseData_t));
        if(!senseData)
        {
                MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 152, "mppCmn_CheckAndSetTASBit: Unable to allocate SenseData memory\n"));
        	MPP_FREE(pageA, sizeof(ModePageA_t) + CDB_LEN_10);
                return;
        }

        pageSize = sizeof(ModePageA_t);
        cdb = ((BYTE *)pageA) + pageSize;

	// Create the PageA request and get the current values.
        mppCmn_CreateModeSensePageA((ModePageA_t *)pageA, cdb, CURRENT_PAGE_CODE_VALUES);

	// Issue the synchronous request.
	if(mpp_SynchronousIo(DeviceVertex, cdb, cdbLen, pageA, pageSize, MPPCMN_XFER_DEV_HOST) != MPP_NO_ERROR)
	{
		// There was some kind of problem.
        	MPP_FREE(pageA, sizeof(ModePageA_t) + CDB_LEN_10);
		MPP_FREE(senseData, sizeof(SenseData_t));
		return;
	}

	// Request is successful.  Now check the current value.
	if(pageA->TaskAbortedStatus == 1)
	{
		// TAS bit already set.  Go ahead and set the appropriate RdacLun bit.
		MPP_LOCK(RdacInfo->Lock, lockLevel);
		RdacInfo->RdacLuns[Lun].TASBitSet = 1;
		MPP_UNLOCK(RdacInfo->Lock, lockLevel);
        	MPP_FREE(pageA, sizeof(ModePageA_t) + CDB_LEN_10);
		MPP_FREE(senseData, sizeof(SenseData_t));
		return;
	}

	// TAS bit is not set.  Check whether the bit can be set.
	// Go ahead and reuse the senseData, pageA buffer.
	bzero(senseData, sizeof(SenseData_t));
        mppCmn_CreateModeSensePageA((ModePageA_t *)pageA, cdb, CHANGEABLE_PAGE_CODE_VALUES);

	// Issue the synchronous request.
	if(mpp_SynchronousIo(DeviceVertex, cdb, cdbLen, pageA, pageSize, MPPCMN_XFER_DEV_HOST) != MPP_NO_ERROR)
	{
		// There was some kind of problem.
        	MPP_FREE(pageA, sizeof(ModePageA_t) + CDB_LEN_10);
		MPP_FREE(senseData, sizeof(SenseData_t));
		return;
	}

	// Request is successful.
	if(pageA->TaskAbortedStatus != 1)
	{
		// TAS bit cannot be set.
        	MPP_FREE(pageA, sizeof(ModePageA_t) + CDB_LEN_10);
		MPP_FREE(senseData, sizeof(SenseData_t));
		return;
	}

	// TAS bit is not set but can be changed.
	// Go ahead and reuse the senseData, pageA buffer.
	bzero(senseData, sizeof(SenseData_t));
        mppCmn_CreateModeSelectPageA((ModePageA_t *)pageA, cdb);
	pageA->TaskAbortedStatus = 1;

	// Issue the synchronous request.
	if(mpp_SynchronousIo(DeviceVertex, cdb, cdbLen, pageA, pageSize, MPPCMN_XFER_HOST_DEV) != MPP_NO_ERROR)
	{
		// There was some kind of problem.
                MPP_ERRORLOGPRINT((MPP_ERR_RETRYABLE, 153, "mppCmn_CheckAndSetTASBit: Unable to set TAS bit\n"));
        	MPP_FREE(pageA, sizeof(ModePageA_t) + CDB_LEN_10);
		MPP_FREE(senseData, sizeof(SenseData_t));
		return;
	}

	// Everything worked!  Go ahead and set the appropriate RdacLun bit.
	MPP_LOCK(RdacInfo->Lock, lockLevel);
	RdacInfo->RdacLuns[Lun].TASBitSet = 1;
	MPP_UNLOCK(RdacInfo->Lock, lockLevel);
       	MPP_FREE(pageA, sizeof(ModePageA_t) + CDB_LEN_10);
	MPP_FREE(senseData, sizeof(SenseData_t));
	return;
}


void
mppCmn_CreateModeSensePageA(
	IN ModePageA_t *PageA,
	IN BYTE *Cdb,
	IN MODE_SENSE_PAGE_CODE_TYPE PcType)
{
	bzero(PageA, sizeof(ModePageA_t));
	bzero(Cdb, CDB_LEN_10);

	*Cdb = SCSI_MODE_SENSE;
	*(Cdb+1) = 0x08; // DBD bit on
	*(Cdb+2) = (BYTE)(0xA + (PcType << 6));
	*(Cdb+7) = (BYTE)(sizeof(ModePageA_t) >> 8) & 0x00FF;
	*(Cdb+8) = (BYTE)(sizeof(ModePageA_t)) & 0x00FF;

	return;
}


void
mppCmn_CreateModeSelectPageA(
	IN ModePageA_t *PageA,
	IN BYTE *Cdb)
{
	bzero(PageA, sizeof(ModePageA_t));
	bzero(Cdb, CDB_LEN_10);

	// Setup Page 0xA information.
	PageA->PageCode = 0xA;
	PageA->PageLength = 0xA;

	// Setup Cdb information.
	*Cdb = SCSI_MODE_SELECT;
	*(Cdb+1) = 1;
	*(Cdb+7) = (sizeof(ModePageA_t) >> 8) & 0x00FF;
	*(Cdb+8) = sizeof(ModePageA_t) & 0x00FF;

	return;
}



/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_Failover
* SUMMARY:  Perform pre-failover actions.
* SCOPE:    local
*
* DESCRIPTION:
* 	This function serves as the common "entrypoint" for doing failovers
* 	in a new manner.  It will determine which failover method is in use
* 	by a given array and set the appropriate controller, lun, and/or
* 	path statuses then queue a worker request to perform the failover
* 	itself (if necessary).
*
* RESTRICTIONS:
* 	ControllerIndex is the index number of controller you are failing FROM,
* 	NOT the controller you are failing to.
*
* RETURNS:
* 	1 if successful
* 	0 if failed
*************************************************************************/
BYTE
mppCmn_Failover(
	IN RdacDeviceInformation_t *RdacInfo,
	IN BYTE ControllerIndex,
	IN LWORD Lun,
	IN LWORD MppIoErrorCondition)
{
	BYTE		altControllerIndex = ControllerIndex^1;
	BYTE		pathIndex;
	BYTE		markFailed = 0;
	LWORD		lunIndex;
	LWORD		stateIndex;
	BYTE		queueRequestStatus;
	LINT		lockLevel;
	LunPathInfo_t	*lunPath;
	RdacLunFailoverInfo_t 		*lunFailoverInfo;
	MppCmn_FailoverContext_t	*failoverContext;

	// Check the alternate controller for existence or service mode status.
	if(RdacInfo->ControllerInfo[altControllerIndex]->ControllerPresent)
	{
		if(RdacInfo->ControllerInfo[altControllerIndex]->ServiceMode)
		{
			// Fail the failover attempt.
			MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_4, "Failover: AltControllerInServiceMode(%s:%d)\n",
				RdacInfo->ModuleName, altControllerIndex));
			return(0);
		}
	}
	else
	{
		// Fail the failover attempt.
		MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_4, "Failover: AltControllerNotPresent(%s:%d)\n",
			RdacInfo->ModuleName, altControllerIndex));
		return(0);
	}

	switch(RdacInfo->FailoverMethod)
	{
		case MPPCMN_FAILOVER_METHOD_CONTROLLER:
		{
			// Fail all of the luns and paths to this controller, then mark the controller as failed itself.
			if(!RdacInfo->ControllerInfo[ControllerIndex]->Failed)
			{
				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_4, "Failover(Cntrl): MarkPathsFailed(%s:%d)\n",
					RdacInfo->ModuleName, ControllerIndex));
				for(pathIndex = 0; pathIndex < mpp_MaxPathsPerController; ++pathIndex)
				{
					if(!RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[pathIndex].Present)
					{
						continue;
					}

					MPPCMN_SET_PATH_STATE(RdacInfo, ControllerIndex, pathIndex, MPPCMN_FAILED);
					RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[pathIndex].PathFailedTime = 0;
					markFailed = 1;
					for(lunIndex = 0; lunIndex < mpp_MaxLunsPerArray; ++lunIndex)
					{
						if(RdacInfo->RdacLuns[lunIndex].LunControllers[ControllerIndex]->LunPaths[pathIndex].LunPathDevice)
						{
							MPPCMN_SET_DEVICE_PATH_STATE(RdacInfo, ControllerIndex, pathIndex, Lun, MPPCMN_FAILED);
						}
					}

					if(markFailed)
					{
						RdacInfo->ControllerInfo[ControllerIndex]->Failed = TRUE;
					}
					else
					{
						RdacInfo->ControllerInfo[ControllerIndex]->Failed = FALSE;
					}
				}
			}

			// Determine if AVT mode has been enabled for this array.  If so it is NOT necessary to issue a failover request
			// because the path selection routine (NewSelectPath) will choose an alternate controller path.  When the
			// alternate controller receives the IO request it will transfer the lun.  The paths still need to be marked
			// as failed which has already been done above.
			if(RdacInfo->AVTEnabled)
			{
				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_4, "Failover(Cntrl): AVTEnabled(%s:%d)\n",
					RdacInfo->ModuleName, ControllerIndex));
			}
			else
			{
				if(RdacInfo->ControllerInfo[altControllerIndex]->FailoverInProgress == TRUE)
				{
					MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_4, "Failover(Cntrl): InProgress(%s:%d)\n",
						RdacInfo->ModuleName, ControllerIndex));
					return(1);
				}

				MPP_LOCK(RdacInfo->Lock, lockLevel);
				RdacInfo->ControllerInfo[altControllerIndex]->FailoverInProgress = TRUE;
				MPP_GETTIME(RdacInfo->ArrayFailoverStartTime);
				MPP_UNLOCK(RdacInfo->Lock, lockLevel);

				failoverContext = (MppCmn_FailoverContext_t *)MPP_INT_KMEM_ALLOC(sizeof(MppCmn_FailoverContext_t));
				if(!failoverContext)
				{
					MPP_LOCK(RdacInfo->Lock, lockLevel);
					RdacInfo->ControllerInfo[ControllerIndex]->Failed = FALSE;
					RdacInfo->ControllerInfo[altControllerIndex]->FailoverInProgress = FALSE;
					MPP_UNLOCK(RdacInfo->Lock, lockLevel);

					MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3,
						"Failover(Cntrl): MallocError(QueueFORequest)\n"));
					MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 157, "%s:%d could not allocate queued failover request\n",
						RdacInfo->ModuleName, ControllerIndex));
					return(0);
				}

				failoverContext->RdacInfo = RdacInfo;
				failoverContext->ControllerIndex = ControllerIndex;
				failoverContext->Lun = Lun;
				failoverContext->IoErrorCondition = MppIoErrorCondition;

				// 01/21/08 - CR135691.  Added pre- and post-failover processing.
				mpp_SysInterface->mppSys_PreFailoverProcessing(RdacInfo, ControllerIndex, RdacInfo->FailoverMethod);

				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_4, "DoFailover(Cntrl): QueueFailover(%s:%d)\n",
					RdacInfo->ModuleName, ControllerIndex));
				queueRequestStatus = (BYTE)mpp_SysInterface->mppSys_QueueRequest(mppCmn_QueueFailoverCallback, failoverContext, 0);
				if(queueRequestStatus == 0)
				{
					// Failover request could not be queued.  Complete any post-processing and return.
					mpp_SysInterface->mppSys_PostFailoverProcessing(RdacInfo, ControllerIndex, RdacInfo->FailoverMethod);
				}

				return(queueRequestStatus);
			}
		}
		break;

		case MPPCMN_FAILOVER_METHOD_LUN:
		{
			BOOL lunFailoverTimerIsNotSet = FALSE;

			// Determine whether the controller needs to be marked as failed if all of the paths are marked as failed
			// regardless of the lun itself.
			if(RdacInfo->ControllerInfo[ControllerIndex]->Failed == FALSE)
			{
				markFailed = 1;
				for(pathIndex = 0; pathIndex < mpp_MaxPathsPerController; ++pathIndex)
				{
					if(!RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[pathIndex].Present)
					{
						continue;
					}

					stateIndex = RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[pathIndex].PathStateIndex;
					if(RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[pathIndex].PathState[stateIndex] != MPPCMN_FAILED)
					{
						markFailed = 0;
						break;
					}
				}

				if(markFailed)
				{
					RdacInfo->ControllerInfo[ControllerIndex]->Failed = TRUE;
				}
			}

			// Make sure all controller paths for this lun have been marked as failed.
			for(pathIndex = 0; pathIndex < mpp_MaxPathsPerController; ++pathIndex)
			{
				if(!RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[pathIndex].Present)
				{
					continue;
				}

				lunPath = &RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[pathIndex];
				if(lunPath->DeviceState[lunPath->DeviceStateIndex] != MPPCMN_FAILED)
				{
					MPPCMN_SET_DEVICE_PATH_STATE(RdacInfo, ControllerIndex, pathIndex, Lun, MPPCMN_FAILED);
				}
			}

			// Determine if AVT mode has been enabled for this array.  If so it is NOT necessary to
			// set a lun failover timer and issue a failover request because the path selection
			// routine (NewSelectPath) will choose an alternate controller path.  When the alternate
			// controller receives the IO request it will transfer the lun.
			if(RdacInfo->AVTEnabled)
			{
				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_4, "Failover(Lun): AVTEnabled(%s:%d:%d)\n",
					RdacInfo->ModuleName, ControllerIndex, Lun));
				return(1);
			}

			// Any other status indicates a failover should take place.
			lunFailoverInfo = &RdacInfo->ControllerInfo[altControllerIndex]->LunFailoverInfo;
			MPP_LOCK(lunFailoverInfo->LunFailoverLock, lockLevel);
			MPPCMN_SET_LUN_FAILOVER_BIT(lunFailoverInfo->LunFailoverTable, Lun);
			if(lunFailoverInfo->LunFailoverTimerSet == FALSE)
			{
				lunFailoverTimerIsNotSet = TRUE;
				lunFailoverInfo->LunFailoverDuration = 0;
				lunFailoverInfo->LunFailoverTimerSet = TRUE;
			}
			MPP_UNLOCK(lunFailoverInfo->LunFailoverLock, lockLevel);

			// Check the LunFailoverTimerSet flag.  If already set then another lun failover is in
			// progress.  No need to go futher.
			if (lunFailoverTimerIsNotSet)
			{
				failoverContext = (MppCmn_FailoverContext_t *)MPP_INT_KMEM_ALLOC(sizeof(MppCmn_FailoverContext_t));
				if(!failoverContext)
				{
					MPP_LOCK(RdacInfo->Lock, lockLevel);
					RdacInfo->ControllerInfo[ControllerIndex]->Failed = FALSE;
					RdacInfo->ControllerInfo[altControllerIndex]->FailoverInProgress = FALSE;
					MPP_UNLOCK(RdacInfo->Lock, lockLevel);

					MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3,
						"Failover(Lun): MallocError(QueueFORequest)\n"));
					MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 150, "%s:%d could not allocate queued failover request\n",
						RdacInfo->ModuleName, ControllerIndex));
					return(0);
				}

				failoverContext->RdacInfo = RdacInfo;
				failoverContext->ControllerIndex = ControllerIndex;
				failoverContext->Lun = Lun;
				failoverContext->IoErrorCondition = MppIoErrorCondition;

				// 01/21/08 - CR135691.  Added pre- and post-failover processing.
				mpp_SysInterface->mppSys_PreFailoverProcessing(RdacInfo, ControllerIndex, RdacInfo->FailoverMethod);

				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_4, "DoFailover(Lun): QueueFailover(%s:%d)\n",
					RdacInfo->ModuleName, Lun));
				queueRequestStatus = (BYTE)mpp_SysInterface->mppSys_QueueRequest(mppCmn_QueueFailoverCallback, failoverContext, 0);
				if(queueRequestStatus == 0)
				{
					// Failover request could not be queued.  Complete any post-processing and return.
					mpp_SysInterface->mppSys_PostFailoverProcessing(RdacInfo, ControllerIndex, RdacInfo->FailoverMethod);
				}
				
				return(queueRequestStatus);
			}
		}
		break;
	}

	return(1);
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_DoFailover
* SUMMARY:  Perform a failover.
* SCOPE:    local
*
* DESCRIPTION:
* 	This function provides a common entrypoint for creating the actual
* 	failover request appropriate for the FailoverMethod used on an array.
* 	Once the appropriate request is built the system-dependent
* 	mpp_SysInterface->mpp_IssueFailover() function is called to send the
* 	actual request.
*
* 	Depending on the failover method this function will be called immediately
* 	by the failover worker request or delayed for a period of time,
* 	and the controller you are failing FROM	goes offline.
*
* RESTRICTIONS:
*	ForcedQuiescence indicates whether the Page 0x2C Forced Quiescence bit is set for
* 	lun-based failovers.  This boolean is ignored for controller-based failovers.
* 	noHoldInReset indicates that the alternate controller should not be reset,
*       regardless of the global "mpp_HoldAltInReset" flag.
* 	ControllerIndex is the controller you are failing FROM.
*
* RETURNS:
* 	1 if successful
* 	0 if failed
*************************************************************************/
BYTE
mppCmn_DoFailover(
	IN RdacDeviceInformation_t *RdacInfo,
	IN MPPCMN_FAILOVER_METHOD FailoverMethod,
	IN BYTE ControllerIndex,
	IN BOOL ForcedQuiescence,
	IN BOOL noHoldInReset)
{
	RdacLunFailoverInfo_t *lunFailoverInfo=NULL;
	MPP_HANDLE	failoverHandle = NULL;
	unsigned char	*controllerLunTable;
	BYTE		altControllerIndex = ControllerIndex^1;
	BYTE		*cdb, pathIndex;
	VOID		*page2C = NULL;
	LWORD		page2CSize;
	LWORD		stateIndex;
       	LWORD		lunIndex = 0;
	LINT		lockLevel;

	MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "DoFailover: (%s:%d)\n",
		RdacInfo->ModuleName, ControllerIndex));

	// See if the alternate controller is present.  If not were done.
	if(!RdacInfo->ControllerInfo[altControllerIndex]->ControllerPresent)
	{
		if(FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
		{
			lunFailoverInfo = &RdacInfo->ControllerInfo[altControllerIndex]->LunFailoverInfo;
			MPP_LOCK(lunFailoverInfo->LunFailoverLock, lockLevel);
			MPPCMN_RESET_LUNFAILOVER(lunFailoverInfo);
			MPP_UNLOCK(lunFailoverInfo->LunFailoverLock, lockLevel);
		}

		MPP_LOCK(RdacInfo->Lock, lockLevel);
		RdacInfo->ControllerInfo[ControllerIndex]->Failed = FALSE;
		RdacInfo->ControllerInfo[altControllerIndex]->FailoverInProgress = FALSE;
		MPP_UNLOCK(RdacInfo->Lock, lockLevel);

		MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_2, "DoFailover: AltNotPresent(%s:%d)\n",
			RdacInfo->ModuleName, altControllerIndex));
		MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 169, "%s:%d Failover command aborted (alternate not present)\n",
			RdacInfo->ModuleName, ControllerIndex));

		// 01/21/08 - CR135691.  Added pre- and post-failover processing.
		mpp_SysInterface->mppSys_PostFailoverProcessing(RdacInfo, ControllerIndex, FailoverMethod);
		return(0);
	}

	switch(FailoverMethod)
	{
		case MPPCMN_FAILOVER_METHOD_CONTROLLER:
		{
			if(RdacInfo->Page2CSubPage1)
			{
				page2CSize = sizeof(ModePage2CSubPage_t);
				page2C = (ModePage2CSubPage_t *)MPP_INT_KMEM_ALLOC(page2CSize + 10);
			}
			else
			{
				page2CSize = sizeof(ModePage2C_t);
				page2C = (ModePage2C_t *)MPP_INT_KMEM_ALLOC(page2CSize + 10);
			}

			if(!page2C)
			{
				MPP_LOCK(RdacInfo->Lock, lockLevel);
				RdacInfo->ControllerInfo[ControllerIndex]->Failed = FALSE;
				RdacInfo->ControllerInfo[altControllerIndex]->FailoverInProgress = FALSE;
				MPP_UNLOCK(RdacInfo->Lock, lockLevel);

				// 01/21/08 - CR135691.  Added pre- and post-failover processing.
				mpp_SysInterface->mppSys_PostFailoverProcessing(RdacInfo, ControllerIndex, FailoverMethod);

				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "DoFailover(Cntrl): MallocError(Page2C)\n",
					RdacInfo->ModuleName, altControllerIndex));
				MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 158, "%s:%d could not allocate Page2C memory.\n",
					RdacInfo->ModuleName, ControllerIndex));
				return(0);
			}

			if(RdacInfo->Page2CSubPage1)
			{
				cdb = ((BYTE *)page2C) + page2CSize;
				mpp_CreatePage2CSubPageFailoverCommand(page2C, cdb, noHoldInReset);
			}
			else
			{
				cdb = ((BYTE *)page2C) + page2CSize;
				mpp_CreatePage2CFailoverCommand(page2C, cdb, noHoldInReset);
			}

			for(pathIndex = 0; pathIndex < mpp_MaxPathsPerController; ++pathIndex)
			{
				stateIndex = RdacInfo->ControllerInfo[altControllerIndex]->ControllerPath[pathIndex].PathStateIndex;
				if(RdacInfo->ControllerInfo[altControllerIndex]->ControllerPath[pathIndex].PathState[stateIndex] != MPPCMN_FAILED)
				{
					for(lunIndex = 0; lunIndex < mpp_MaxLunsPerArray; ++lunIndex)
					{
						if(RdacInfo->RdacLuns[lunIndex].LunControllers[altControllerIndex]->LunPaths[pathIndex].LunPathDevice
						&& mpp_SysInterface->mpp_CheckPathGood(RdacInfo, (BYTE)altControllerIndex, pathIndex, lunIndex))
						{
							failoverHandle = RdacInfo->RdacLuns[lunIndex].LunControllers[altControllerIndex]->LunPaths[pathIndex].LunPathDevice;
							break;
						}
					}
				}
				if(failoverHandle != NULL)
				{
					break;
				}
			}

			if(failoverHandle)
			{
				mpp_SysInterface->mpp_IssueFailover(RdacInfo, (BYTE)altControllerIndex, pathIndex, failoverHandle,
					(BYTE *)page2C, cdb, FailoverMethod, ForcedQuiescence, noHoldInReset);
				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3,
					"DoFailover(Cntrl): FailoverIssued(%s:%d:%d)\n",
					RdacInfo->ModuleName, altControllerIndex, lunIndex));
				MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 10, "%s:%d Failover command issued\n",
					RdacInfo->ModuleName, altControllerIndex));
			}
			else
			{
				MPP_FREE(page2C, page2CSize + 10);

				MPP_LOCK(RdacInfo->Lock, lockLevel);
				RdacInfo->ControllerInfo[ControllerIndex]->Failed = FALSE;
				RdacInfo->ControllerInfo[altControllerIndex]->FailoverInProgress = FALSE;
				MPP_UNLOCK(RdacInfo->Lock, lockLevel);

				// 01/21/08 - CR135691.  Added pre- and post-failover processing.
				mpp_SysInterface->mppSys_PostFailoverProcessing(RdacInfo, ControllerIndex, FailoverMethod);

				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "DoFailover(Cntrl): NoPathFound(%s:%d)\n",
					RdacInfo->ModuleName, altControllerIndex));
				MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 9, "%s:%d Failover Failed no path available\n",
					RdacInfo->ModuleName, altControllerIndex));
				return(0);
			}
		}
		break;

		case MPPCMN_FAILOVER_METHOD_LUN:
		{
			if(RdacInfo->Page2CSubPage1)
			{
				page2CSize = sizeof(ModePage2CSubPage_t);
				page2C = (ModePage2CSubPage_t *)MPP_INT_KMEM_ALLOC(page2CSize + 10);
			}
			else
			{
				page2CSize = sizeof(ModePage2C_t);
				page2C = (ModePage2C_t *)MPP_INT_KMEM_ALLOC(page2CSize + 10);
			}

			if(!page2C)
			{
				MPP_LOCK(RdacInfo->Lock, lockLevel);
				RdacInfo->ControllerInfo[ControllerIndex]->Failed = FALSE;
				RdacInfo->ControllerInfo[altControllerIndex]->FailoverInProgress = FALSE;
				MPP_UNLOCK(RdacInfo->Lock, lockLevel);

				// 01/21/08 - CR135691.  Added pre- and post-failover processing.
				mpp_SysInterface->mppSys_PostFailoverProcessing(RdacInfo, ControllerIndex, FailoverMethod);

				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "DoFailover(Lun): MallocError(Page2C)\n",
					RdacInfo->ModuleName, altControllerIndex));
				MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 171, "%s:%d could not allocate Page2C memory.\n",
					RdacInfo->ModuleName, ControllerIndex));
				return(0);
			}

			controllerLunTable = (unsigned char *)MPP_INT_KMEM_ALLOC(mpp_MaxLunsPerArray * sizeof(unsigned char));
			if(!controllerLunTable)
			{
				MPP_FREE(page2C, page2CSize + 10);
				MPP_LOCK(RdacInfo->Lock, lockLevel);
				RdacInfo->ControllerInfo[ControllerIndex]->Failed = FALSE;
				RdacInfo->ControllerInfo[altControllerIndex]->FailoverInProgress = FALSE;
				MPP_UNLOCK(RdacInfo->Lock, lockLevel);

				// 01/21/08 - CR135691.  Added pre- and post-failover processing.
				mpp_SysInterface->mppSys_PostFailoverProcessing(RdacInfo, ControllerIndex, FailoverMethod);

				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "DoFailover(Lun): MallocFailed(LunTable)\n",
					RdacInfo->ModuleName, altControllerIndex));
				MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 159, "%s:%d Unable to malloc lunTable for LunFailover\n",
					RdacInfo->ModuleName, altControllerIndex));
				return(0);
			}

			// Get the list of luns to failover.  Also reset the LunFailoverTimerSet flag so lun failover events
			// that happen between now and completion of _this_ lun failover are noted and another failover
			// timer can start.  The next failover timer will be delayed if this failover action is still in progress.
			// Remember, the controller you're failing TO contains the lun failover information.  This is done
			// because information for the failed controller may be removed in PnP/HotPlug environments.
			bzero(controllerLunTable, mpp_MaxLunsPerArray * sizeof(unsigned char));
			lunFailoverInfo = &RdacInfo->ControllerInfo[altControllerIndex]->LunFailoverInfo;
			MPP_LOCK(lunFailoverInfo->LunFailoverLock, lockLevel);
			MPPCMN_LUNFAILOVER_TO_LUNTABLE(RdacInfo, altControllerIndex, lunFailoverInfo->LunFailoverTable, controllerLunTable);
			MPPCMN_RESET_LUNFAILOVER(lunFailoverInfo);
			MPP_UNLOCK(lunFailoverInfo->LunFailoverLock, lockLevel);

			if(RdacInfo->Page2CSubPage1)
			{
				cdb = ((BYTE *)page2C) + page2CSize;
				mpp_CreatePage2CSubPageRebalance(page2C, cdb, controllerLunTable, ForcedQuiescence);
			}
			else
			{
				cdb = ((BYTE *)page2C) + page2CSize;
				mpp_CreatePage2CRebalance(page2C, cdb, controllerLunTable, ForcedQuiescence);
			}

			for(pathIndex = 0; pathIndex < mpp_MaxPathsPerController; ++pathIndex)
			{
				stateIndex = RdacInfo->ControllerInfo[altControllerIndex]->ControllerPath[pathIndex].PathStateIndex;
				if(RdacInfo->ControllerInfo[altControllerIndex]->ControllerPath[pathIndex].PathState[stateIndex] != MPPCMN_FAILED)
				{
					for(lunIndex = 0; lunIndex < mpp_MaxLunsPerArray; ++lunIndex)
					{
						if(RdacInfo->RdacLuns[lunIndex].LunControllers[altControllerIndex]->LunPaths[pathIndex].LunPathDevice
						&& mpp_SysInterface->mpp_CheckPathGood(RdacInfo, (BYTE)altControllerIndex, pathIndex, lunIndex))
						{
							failoverHandle = RdacInfo->RdacLuns[lunIndex].LunControllers[altControllerIndex]->LunPaths[pathIndex].LunPathDevice;
							break;
						}
					}
				}

				if(failoverHandle != NULL)
				{
					break;
				}
			}

			if(failoverHandle)
			{
				// Lun-based failovers should never hold the alternate in reset, hence the argument passed is FALSE.
				mpp_SysInterface->mpp_IssueFailover(RdacInfo, (BYTE)altControllerIndex, pathIndex, failoverHandle,
					(BYTE *)page2C, cdb, FailoverMethod, ForcedQuiescence, FALSE);
				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "DoFailover(Lun): FailoverIssued(%s:%d:%d)\n",
					RdacInfo->ModuleName, altControllerIndex, lunIndex));
				MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 164, "Lun failover command issued to %s:%d\n",
					RdacInfo->ModuleName, altControllerIndex));
			}
			else
			{
				MPP_FREE(page2C, page2CSize + 10);

				MPP_LOCK(RdacInfo->Lock, lockLevel);
				RdacInfo->ControllerInfo[ControllerIndex]->Failed = FALSE;
				RdacInfo->ControllerInfo[altControllerIndex]->FailoverInProgress = FALSE;
				MPP_UNLOCK(RdacInfo->Lock, lockLevel);

				// 01/21/08 - CR135691.  Added pre- and post-failover processing.
				mpp_SysInterface->mppSys_PostFailoverProcessing(RdacInfo, ControllerIndex, FailoverMethod);

				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "DoFailover(Lun): NoPathFound(%s:%d)\n",
					RdacInfo->ModuleName, altControllerIndex));
				MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 165, "Lun failover failed no path available to %s:%d\n",
					RdacInfo->ModuleName, altControllerIndex));
				return(0);
			}
		}
		break;
	}

	return(1);
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_DoFailoverDelayedCallback
* SUMMARY:  Issue a delayed failover request
* SCOPE:    local
*
* DESCRIPTION:
* 	This function is called when a delayed failover request is made
* 	in order to verify that the controller being failed to still exists.
* 	If so a call to mppCmn_Failover is performed, else cleanup is done.
*
* RESTRICTIONS:
*
* RETURNS:
* 	None.
*************************************************************************/
void
mppCmn_DoFailoverDelayedCallback(
	IN void *Context)
{
	MppCmn_FailoverCompletionContext_t	*completionContext = (MppCmn_FailoverCompletionContext_t *)Context;
	RdacDeviceInformation_t			*rdacInfo = NULL;
	ArrayModuleEntry_t			*modPtr = NULL;
	BYTE					doFailoverStatus, idx, performFailover = FALSE;

	// Make sure the array/controller is still around before trying the failover request.
	MPP_DEBUGPRINT((0, "DoFailoverDelayedCallback(Begin)\n"));
	modPtr = mpp_ModuleArray;
	for(idx = 0; idx<mpp_MaxArrayModules; ++idx, ++modPtr)
	{
		rdacInfo = modPtr->RdacInfo;
		if(!rdacInfo)
		{
			continue;
		}

		if(rdacInfo == completionContext->FailoverContext.RdacInfo)
		{
			if(rdacInfo->ControllerInfo[completionContext->FailoverContext.ControllerIndex]->ControllerPresent)
			{
				performFailover = TRUE;
				break;
			}
		}
	}

	if(performFailover == TRUE)
	{
	  // 02/13/06 - CR 136868.  Changed the controller index passed into mppCmn_DoFailover() to the failing controller index.
		// Still around.  Do it.
		doFailoverStatus = mppCmn_DoFailover(completionContext->FailoverContext.RdacInfo, completionContext->FailoverContext.FailoverMethod,
			completionContext->FailoverContext.ControllerIndex^1, completionContext->ForcedQuiescenceAttempted,
			completionContext->noHoldInReset);
		MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "DoFailoverDelayedCallback: (DoFailoverStatus-0x%x)\n", doFailoverStatus));
	}
	else
	{
		MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "DoFailoverDelayedCallback: (ArrayOrControllerNotPresent)\n"));
		MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 170, "Failover command aborted (array or controller not present)\n"));

		mppCmn_DoFailoverCompletionCleanup(rdacInfo, completionContext);
	}

	MPP_FREE(Context, sizeof(MppCmn_FailoverCompletionContext_t));
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_QueueFailoverCallback
* SUMMARY:  Common worker routine for determining failover request.
* SCOPE:    local
*
* DESCRIPTION:
* 	This function is used to perform last-minute, common-code actions
* 	to determine the which type of failover request needs to be issued.
* 	It should be called by the system-dependent worker callback process.
*
* 	The code originally issued a ModeSense Page 0x2C request to determine
* 	whether the alternate controller was present.  Unfortunately the
* 	status information returned from the controller does not distinquish
* 	between a controller that is pulled and one that is offline.  This
* 	is important because a controller that is pulled does NOT transfer
* 	volumes automatically whereas taking a controller offline does.
*
*	There is a reason for checking a ModeSense request for lun level failover.
*	According to the controller spec all luns NOT specified in the controllerLunTable
*	will be owned by the alternate.  If the alternate is missing or offline
*	an 05/91/33 status is returned because the unspecified luns cannot
*	be transferred.  Therefore the easiest approach is to perform a
*	controller-level failover, but follow the lun-failover "rules" when
*	both controllers are present and online.  For controller-level failovers
*	no check is needed.
*
* RESTRICTIONS:
*	FailoverContext->ControllerIndex is the controller we are failing FROM.
*	If a lun-based failover is taking place the information needed to figure
*	out which luns to fail over will be located in the alternate controller's
*	data structures.  This is done because information for the "FROM" controller
*	may be removed if the driver has cleaned up the "FROM" controller's
*	information.
*
* RETURNS:
* 	void
*************************************************************************/
void
mppCmn_QueueFailoverCallback(
	IN void *Context)
{
	MPPCMN_FAILOVER_METHOD		failoverMethod;
	MppCmn_FailoverContext_t 	*FailoverContext = (MppCmn_FailoverContext_t *)Context;
	RdacDeviceInformation_t		*rdacInfo = FailoverContext->RdacInfo;
	RdacLunFailoverInfo_t		*lunFailoverInfo;
	BYTE				altControllerIndex = FailoverContext->ControllerIndex ^ 1;
	VOID				*page2C;
	BOOL				doLunFailover = TRUE;
	BOOL				noHoldInReset = FALSE;
	LWORD				page2CSize;
	LWORD				mppStatus;
	LWORD				failoverStatus;
	LINT				lockLevel;


	// Check the type of failover being performed.  If this is a lun-based failover we wait for the
	// specified LunFailoverDelay before performing the actual failover.
	if(rdacInfo->FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
	{
		lunFailoverInfo = &rdacInfo->ControllerInfo[altControllerIndex]->LunFailoverInfo;
		for(;;)
		{
			lunFailoverInfo->LunFailoverDuration++;
			if((lunFailoverInfo->LunFailoverDuration > mppCmn_LunFailoverDelay)
			&& (rdacInfo->ControllerInfo[altControllerIndex]->FailoverInProgress == FALSE))
			{
				MPP_LOCK(rdacInfo->Lock, lockLevel);
				rdacInfo->ControllerInfo[altControllerIndex]->FailoverInProgress = TRUE;
				MPP_GETTIME(rdacInfo->ArrayFailoverStartTime);
				MPP_UNLOCK(rdacInfo->Lock, lockLevel);
				break;
			}

			mpp_SysInterface->mpp_ThreadDelay(1, MPPCMN_DELAY_SECONDS);
		}

		// Check the failing controller's status.  If the alternate controller is not present or
		// offline treat this as a controller-level failover instead of the lun-level failover.
		// We don't change the rdacInfo->FailoverMethod indicator since this is viewed as a
		// temporary condition.
		MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_4, "QueueFailoverCallback: GetPage2CInfo(%s:%d)\n",
			rdacInfo->ModuleName, altControllerIndex));
		mppStatus = mppCmn_GetPage2CInfo(rdacInfo, NULL, (LINT)altControllerIndex, &page2C, &page2CSize);
		if(mppStatus == MPP_NO_ERROR)
		{
			if(rdacInfo->Page2CSubPage1)
			{
				ModePage2C_t	*modePage2CSubPage = page2C;

				if(modePage2CSubPage->RDAC_Mode[0] == NO_ALTERNATE_PRESENT)
				{
					doLunFailover = FALSE;
				}
				else
				{
					if(modePage2CSubPage->AltRDACMode[1] == RESET_MODE)
					{
						doLunFailover = FALSE;
					}
				}
			}
			else
			{
				ModePage2C_t	*modePage2C = page2C;

				if(modePage2C->RDAC_Mode[0] == NO_ALTERNATE_PRESENT)
				{
					doLunFailover = FALSE;
				}
				else
				{
					if(modePage2C->AltRDACMode[1] == RESET_MODE)
					{
						doLunFailover = FALSE;
					}
				}
			}

			// Free allocation done by ModeSense request.  page2C pointer may be re-used below.
			MPP_FREE(page2C, page2CSize);

			if(doLunFailover == FALSE)
			{
				RdacLunFailoverInfo_t *lunFailoverInfo;

				lunFailoverInfo = &rdacInfo->ControllerInfo[altControllerIndex]->LunFailoverInfo;
				MPP_LOCK(lunFailoverInfo->LunFailoverLock, lockLevel);
				MPPCMN_RESET_LUNFAILOVER(lunFailoverInfo);
				MPP_UNLOCK(lunFailoverInfo->LunFailoverLock, lockLevel);

				failoverMethod = MPPCMN_FAILOVER_METHOD_CONTROLLER;
				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_2,
					"QueueFailoverCallback: CtlNotPresentOrInReset(%s:%d)\n",
					rdacInfo->ModuleName, FailoverContext->ControllerIndex));
			}
			else
			{
				failoverMethod = rdacInfo->FailoverMethod;
			}
		}
		else
		{
			// There was an error getting Page 0x2C info.  Treat this as a controller-level failover
			// condition.
			failoverMethod = MPPCMN_FAILOVER_METHOD_CONTROLLER;
		}
	}
	else
	{
		// Evaluate the FailoverContext->IoErrorCondition to determine if the alternate should be held in
		// reset during failover.  Note this option is only honored if a Controller-based failover is happening.
		// Lun-based failovers ALWAYS assume the controller will not be held in reset (else if defeats
		// the purpose of a lun-based failover).
		if(FailoverContext->IoErrorCondition & MPPCMN_EVALUATE_IO_ERROR)
		{
			if(FailoverContext->IoErrorCondition & MPPCMN_LUN_CAN_BE_OWNED)
			{
				noHoldInReset = TRUE;
			}
		}

		failoverMethod = rdacInfo->FailoverMethod;
	}

	failoverStatus = mppCmn_DoFailover(rdacInfo, failoverMethod, FailoverContext->ControllerIndex, FALSE, noHoldInReset);
	MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_4, "QueueFailoverCallback: Status(0x%x)\n", failoverStatus));

	MPP_FREE(FailoverContext, sizeof(MppCmn_FailoverContext_t));
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_DoFailoverCompletion
* SUMMARY:  Common-code failover completion
* SCOPE:    local
*
* DESCRIPTION:
* 	This function is used to perform common-code completion actions
* 	done as the result of a failover attempt.  It should be called
* 	within the system-dependent failover completion function.
*
* RESTRICTIONS:
* 	'RequestStatus' is the status returned by the system-dependent
* 	TranslateStatus() routine.  'CompletionContext' is the common-code
* 	context pointer that should be populated by the system-dependent
* 	failover completion routine.
* 	The ControllerIndex provided in the CompletionContext->FailoverContext
* 	field is the controller you are failing TO.
*
* RETURNS:
* 	Failover status returned by mpp_AnalyseFailoverError().
*************************************************************************/
LWORD
mppCmn_DoFailoverCompletion(
	IN LWORD RequestStatus,
	IN MppCmn_FailoverCompletionContext_t *CompletionContext)
{
	MppCmn_FailoverCompletionContext_t *DelayedCompletionContext = NULL;
	RdacDeviceInformation_t *rdacInfo;
	MPPCMN_FAILOVER_METHOD  failoverMethod;
	SenseData_t             *senseData;
	SINT                    senseLength;
	LWORD                   failoverStatus;
	BYTE                    failoverInProgress, doFailoverStatus, altControllerIndex;

	if(!CompletionContext)
	{
		// We can't resolve the failover status so return an error.
		MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 166, "No failover completion context available\n"));
		return(MPP_RETURN_FAILOVER_ERROR);
	}

	rdacInfo = CompletionContext->FailoverContext.RdacInfo;
	senseData = CompletionContext->SenseData;
	senseLength =  CompletionContext->SenseLength;
	failoverMethod = CompletionContext->FailoverContext.FailoverMethod;

	failoverStatus = MPP_NO_FAILOVER_ERROR;
	if (RequestStatus)
		failoverStatus = mpp_AnalyseFailoverError(rdacInfo, CompletionContext->FailoverContext.ControllerIndex,
			CompletionContext->FailoverContext.PathIndex, CompletionContext->FailoverContext.Lun,
			RequestStatus, senseData, senseLength, CompletionContext->DataLengthTransferred,
			CompletionContext->FailoverStartTime);

	// CompletionContext->ControllerIndex is the controller you are failing TO.
	altControllerIndex = CompletionContext->FailoverContext.ControllerIndex^1;
	MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "DoFailoverCompletion: FailoverStatus(0x%x)\n", failoverStatus));

	switch(failoverStatus)
	{
		case MPP_NO_FAILOVER_ERROR:
		{
			failoverInProgress = 0;
			MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 801, "Failover succeeded to %s:%d\n",
				rdacInfo->ModuleName, CompletionContext->FailoverContext.ControllerIndex));
		}
		break;

		case MPP_RETRY_FAILOVER:
		{
			// For debug and error logging purposes a switch statement will be used here to keep the output separate.
			switch(failoverMethod)
			{
				case MPPCMN_FAILOVER_METHOD_CONTROLLER:
				{
					MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3,
						"DoFailoverCompletion(Cntrl): RetryFailover(%s:%d);(ReqStatus-0x%x);Sense(0x%x/0x%x/0x%x)\n",
					      	rdacInfo->ModuleName, CompletionContext->FailoverContext.ControllerIndex,
						RequestStatus, senseData->Sense_Key, senseData->ASC, senseData->ASCQ));
					MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 167, "%s:%d Controller failover retried (0x%x/0x%x/0x%x)\n",
						rdacInfo->ModuleName, CompletionContext->FailoverContext.ControllerIndex,
						senseData->Sense_Key, senseData->ASC, senseData->ASCQ));
				}
				break;

				case MPPCMN_FAILOVER_METHOD_LUN:
				{
					MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3,
						"DoFailoverCompletion(Lun): RetryFailover(%s:%d);(ReqStatus-0x%x);Sense(0x%x/0x%x/0x%x)\n",
					      	rdacInfo->ModuleName, CompletionContext->FailoverContext.ControllerIndex,
						RequestStatus, senseData->Sense_Key, senseData->ASC, senseData->ASCQ));
					MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 168, "%s:%d Lun failover retried (0x%x/0x%x/0x%x)\n",
						rdacInfo->ModuleName, CompletionContext->FailoverContext.Lun,
						senseData->Sense_Key, senseData->ASC, senseData->ASCQ));
				}
				break;
			}

			// 01/21/08 - CR135691.  Added support for delayed failover processing.
			DelayedCompletionContext = (MppCmn_FailoverCompletionContext_t *)MPP_INT_KMEM_ALLOC(sizeof(MppCmn_FailoverCompletionContext_t));
			if(DelayedCompletionContext != NULL)
			{
				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "DoFailoverCompletion(DelayFailoverAttempt):(Secs-0x%x)\n", mppCmn_RetryFailoverDelay));
				bcopy(CompletionContext, DelayedCompletionContext, sizeof(MppCmn_FailoverCompletionContext_t));
				DelayedCompletionContext->ForcedQuiescenceAttempted = FALSE;
				doFailoverStatus = (BYTE)mpp_SysInterface->mppSys_QueueRequest(mppCmn_DoFailoverDelayedCallback,
					DelayedCompletionContext, mppCmn_RetryFailoverDelay);
			}
			else
			{
				// Couldn't allocate memory needed for delayed action.  Do it now.
				doFailoverStatus = 0;
			}

			if(doFailoverStatus == 0)
			{
				// Attempt to queue a delayed failover action failed.  Do it now.
				doFailoverStatus = mppCmn_DoFailover(rdacInfo, failoverMethod, altControllerIndex, FALSE,
					CompletionContext->noHoldInReset);
				MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3,
					"DoFailoverCompletion: (DoFailoverStatus-0x%x)\n", doFailoverStatus));
			}

			failoverInProgress = 1;
		}
		break;

		case MPP_RETURN_FAILOVER_ERROR:
		default:
		{
			switch(failoverMethod)
			{
				case MPPCMN_FAILOVER_METHOD_CONTROLLER:
				{
					failoverInProgress = 0;

					// 01/21/08 - CR135691.  Added support for displaying OS specific status.
					MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3,
						"DoFailoverCompletion(Cntrl): FailoverFailed(%s:%d);(ReqStatus-0x%x);Sense(0x%x/0x%x/0x%x);(OSStatus-0x%x)\n",
					      	rdacInfo->ModuleName, CompletionContext->FailoverContext.ControllerIndex,
						RequestStatus, senseData->Sense_Key, senseData->ASC, senseData->ASCQ,
						CompletionContext->OSStatus));
					MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 160, "%s:%d Controller failover failed (0x%x/0x%x/0x%x;0x%x)\n",
						rdacInfo->ModuleName, CompletionContext->FailoverContext.ControllerIndex,
						senseData->Sense_Key, senseData->ASC, senseData->ASCQ,
						CompletionContext->OSStatus));
				}
				break;

				case MPPCMN_FAILOVER_METHOD_LUN:
				{
					// A lun failover request has failed.  By default lun failovers do not set
					// ForcedQuiescence in the Page2C request so the failover needs to be
					// re-attempted with the bit set.  Keep the FailoverInProgress flag in the
					// RdacInfo so another lun failover attempt does not interfere with this
					// one.  If an attempt has already been made and it fails then were done.
					if(!CompletionContext->ForcedQuiescenceAttempted)
					{
						doFailoverStatus = mppCmn_DoFailover(rdacInfo, failoverMethod, altControllerIndex, TRUE, FALSE);
						MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3,
							"DoFailoverCompletion(Lun): DoFailover(%s:%d:%d);(DoFailoverStatus-0x%x)\n",
							rdacInfo->ModuleName, altControllerIndex,
							CompletionContext->FailoverContext.Lun, doFailoverStatus));
						failoverInProgress = 1;
					}
					else
					{
						failoverInProgress = 0;

						// 01/21/08 - CR135691.  Added support for displaying OS specific status.
						MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3,
							"DoFailoverCompletion(Lun): FailoverFailed(%s:%d:%d);(ReqStatus-0x%x);(OSStatus-0x%x)\n",
							rdacInfo->ModuleName, CompletionContext->FailoverContext.ControllerIndex,
							CompletionContext->FailoverContext.Lun, RequestStatus,
							CompletionContext->OSStatus));
						MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 161, "%s:%d:%d Lun failover failed (0x%x/0x%x/0x%x;0x%x)\n",
							rdacInfo->ModuleName, CompletionContext->FailoverContext.ControllerIndex,
							CompletionContext->FailoverContext.Lun, senseData->Sense_Key,
							senseData->ASC, senseData->ASCQ, CompletionContext->OSStatus));
					}
				}
				break;

				default:
				{
					// Nothing to do.
					failoverInProgress = 0;
				}
				break;
			}
		}
		break;
	}

	if(failoverInProgress == 0)
	{
		// 01/21/08 - CR135691.  Moved completion cleanup to common routine.
		mppCmn_DoFailoverCompletionCleanup(rdacInfo, CompletionContext);
	}

	return(failoverStatus);
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_DoFailoverCompletionCleanup
* SUMMARY:  Perform last-minute cleanup actions.
* SCOPE:    local
*
* DESCRIPTION:
* 	This function performs last-minute cleanup actions previously done
* 	by mppCmn_DoFailoverCompletion.  It is being moved to this routine
* 	because cleanup actions may be necessary when failover requests
* 	are issued on a delayed basis.  If the controller is removed
* 	before the delayed failover happens no failover request will be issued
* 	although cleanup actions must still occur.
*
* RESTRICTIONS:
* 	None.
*
* RETURNS:
* 	None.
*************************************************************************/
void
mppCmn_DoFailoverCompletionCleanup(
	IN RdacDeviceInformation_t *RdacInfo,
	IN MppCmn_FailoverCompletionContext_t *CompletionContext
	)
{
	LINT		lockLevel;

	// 05/08/08 - CR 141297. When the multipath driver issues a failover request it is possible that the 
	// request may be returned with a COMMAND_LOCK_VIOLATION status (91/36).  This indicates the array is 
	// already processing another ModeSelect request.  The multipath driver might wait a few seconds before 
	// issuing the request again to give the previous ModeSelect time to finish.  If this happens, and the 
	// array has been completely removed, the delayed attempt will reference a NULL pointer and cause a bugcheck 
	// to be generated. A check for a NULL RdacInfo pointer was added to resolve the problem.
	if (RdacInfo == NULL)
	{
	  MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "FailoverCompletionCleanup: RdacInfo = NULL\n"));
	  return;
	}

	// BOB experiment.  Complete any last-minute processing the system-dependent code might want to do.
	mpp_SysInterface->mppSys_PostFailoverProcessing(RdacInfo, CompletionContext->FailoverContext.ControllerIndex,
		CompletionContext->FailoverContext.FailoverMethod);

	if(CompletionContext->FailoverContext.FailoverMethod == MPPCMN_FAILOVER_METHOD_LUN)
	{
		RdacLunFailoverInfo_t *lunFailoverInfo;

		lunFailoverInfo = &RdacInfo->ControllerInfo[CompletionContext->FailoverContext.ControllerIndex]->LunFailoverInfo;
		MPP_LOCK(lunFailoverInfo->LunFailoverLock, lockLevel);
		MPPCMN_RESET_LUNFAILOVER(lunFailoverInfo);
		MPP_UNLOCK(lunFailoverInfo->LunFailoverLock, lockLevel);
	}

	MPP_LOCK(RdacInfo->Lock, lockLevel);
	RdacInfo->ControllerInfo[CompletionContext->FailoverContext.ControllerIndex]->FailoverInProgress = FALSE;
	MPP_UNLOCK(RdacInfo->Lock, lockLevel);

	return;
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_FailLun
* SUMMARY:  Fail an individual lun
* SCOPE:    local
*
* DESCRIPTION:
* 	This function fails individual luns rather than the mpp_FailPath()
* 	routine which fails paths.  The routine will return status indicating
* 	whether another non-failed path exists for the lun on the controller
* 	specified by 'ControllerIndex'.
*
* RESTRICTIONS:
* 	None.
*
* RETURNS:
* 	1 if another path to the lun exists on this controller.
* 	0 if failed.
*************************************************************************/
BYTE
mppCmn_FailLun(
	IN RdacDeviceInformation_t *RdacInfo,
	IN BYTE ControllerIndex,
	IN BYTE PathIndex,
	IN LWORD Lun,
	IN MPPCMN_FAIL_LUN_OPTION FailOption)
{
	LWORD		stateIndex;
	LWORD		pIdx;

	MPP_DEBUGPRINT((MPP_FAILOVER_IO_DEBUG+MPP_DEBUG_LEVEL_3, "FailLun: (%s:%d:%d:%d);Option(0x%x)\n",
		RdacInfo->ModuleName, ControllerIndex, PathIndex, Lun, FailOption));

	switch(FailOption)
	{
		case MPPCMN_FAIL_LUN_ONE_PATH:
		{
			stateIndex = RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].DeviceStateIndex;
			if(RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].DeviceState[stateIndex] != MPPCMN_FAILED)
			{
				MPPCMN_SET_DEVICE_PATH_STATE(RdacInfo, ControllerIndex, PathIndex, Lun, MPPCMN_FAILED);
				RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[PathIndex].PathFailedTime = 0;
			}
		}
		break;

		case MPPCMN_FAIL_LUN_ALL_PATHS:
		{
			for(pIdx = 0; pIdx < mpp_MaxPathsPerController; pIdx++)
			{
				stateIndex = RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[pIdx].DeviceStateIndex;
				if(RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[pIdx].DeviceState[stateIndex] != MPPCMN_FAILED)
				{
					MPPCMN_SET_DEVICE_PATH_STATE(RdacInfo, ControllerIndex, pIdx, Lun, MPPCMN_FAILED);
					RdacInfo->ControllerInfo[ControllerIndex]->ControllerPath[pIdx].PathFailedTime = 0;
				}
			}
		}
		break;
	}

	// Determine if another non-failed controller path exists for this lun.
	for(pIdx = 0; pIdx < mpp_MaxPathsPerController; pIdx++)
	{
		stateIndex = RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[pIdx].DeviceStateIndex;
		if(RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[pIdx].DeviceState[stateIndex] != MPPCMN_FAILED)
		{
			if(RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[pIdx].LunPathDevice)
			{
				if(mpp_SysInterface->mpp_CheckPathGood(RdacInfo, ControllerIndex, (BYTE)pIdx, Lun))
				{
					return(1);
				}
			}
		}
	}

	return(0);
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_GetPage2CInfo
* SUMMARY:  Common-code routine to get Page 2C information.
* SCOPE:    local
*
* DESCRIPTION:
* 	This function is intended to be a common-code replacement for
*	obtaining Page 0x2C information via a ModeSense request.  Depending
*	on the arguments provided the information can be obtained from
*	a Device Vertex or from any controller/path.  The ModeSense
*	request is issued synchronously.
*
* RESTRICTIONS:
* 	- RdacInfo pointer is required.
* 	- Page2C pointer is required.
* 	- Page2CSize pointer is required.
* 	- If DeviceVertex is provided, request is sent to that device
* 	  regardless of controller.
* 	- ControllerIndex indicates where you'd like to send the request to:
* 		- Setting index to -1 indicates a wildcard value (ie - any controller).
* 		- Setting index to 0 or 1 indicates the 'A' or 'B' controller.
*
* RETURNS:
* 	Status of the mpp_SynchronousIo() function, or MPP_RETURN_ERROR
* 	if an error occurred.
*************************************************************************/
LWORD
mppCmn_GetPage2CInfo(
	IN RdacDeviceInformation_t *RdacInfo,
	IN MPP_HANDLE DeviceVertex,
	IN LINT ControllerIndex,
	OUT VOID **Page2C,
	OUT LWORD *Page2CSize)
{
	MPP_HANDLE	vertex;
	BYTE		*cdb;
	LWORD		mppStatus = MPP_NO_ERROR;
	LWORD		lun;
	LWORD		path;
	LINT		beginController;
	LINT		endController;

	// Check Page2C pointer.  Return error if pointer not provided.
	if(Page2C == NULL)
	{
		return(MPP_RETURN_ERROR);
	}

	*Page2C = (BYTE *)MPP_INT_KMEM_ALLOC(sizeof(ModePage2C_t) + CDB_LEN_10);
	if(*Page2C == NULL)
	{
		MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_3, "GetPage2CInfo: MallocFailed\n"));
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 162, "GetPage2CInfo: Could not allocate Page2C memory\n"));
		return(MPP_RETURN_ERROR);
	}

	*Page2CSize = sizeof(ModePage2C_t);
	cdb = ((BYTE *)*Page2C) + *Page2CSize;

	mppCmn_CreateModeSense2C((ModePage2C_t *)*Page2C, cdb);

	if(DeviceVertex)
	{
		mppStatus = mpp_SynchronousIo(DeviceVertex, cdb, CDB_LEN_10, *Page2C, *Page2CSize, MPPCMN_XFER_DEV_HOST);
	}
	else
	{
		if(ControllerIndex == -1)
		{
			beginController = 0;
			endController = 1;
		}
		else
		{
			beginController = endController = ControllerIndex;
		}

		for(;beginController <= endController; beginController++)
		{
			if(!RdacInfo->ControllerInfo[beginController]->ControllerPresent)
			{
				if(ControllerIndex != -1)
				{
					// Caller chose a specific controller.  Return error since it is not present.
					mppStatus = MPP_RETURN_ERROR;
					break;
				}

				continue;
			}

			for(lun = 0; lun < mpp_MaxLunsPerArray; ++lun)
			{
				if(!RdacInfo->RdacLuns[lun].Present
				|| RdacInfo->RdacLuns[lun].UTMLun)
				{
					continue;
				}

				for(path = 0; path < mpp_MaxPathsPerController; ++path)
				{
					vertex = NULL;

					if(!RdacInfo->ControllerInfo[beginController]->ControllerPath[path].Present
					|| !RdacInfo->RdacLuns[lun].LunControllers[beginController]->LunPaths[path].LunPathDevice
					||  RdacInfo->RdacLuns[lun].LunControllers[beginController]->LunPaths[path].PathRemoveState)
					{
						continue;
					}

					vertex = RdacInfo->RdacLuns[lun].LunControllers[beginController]->LunPaths[path].LunPathDevice;
					mppStatus = mpp_SynchronousIo(vertex, cdb, CDB_LEN_10, *Page2C, *Page2CSize, MPPCMN_XFER_DEV_HOST);
					if(mppStatus == MPP_NO_ERROR)
					{
						return(mppStatus);
					}
				}
			}
		}
	}

	if(mppStatus != MPP_NO_ERROR)
	{
		MPP_FREE(*Page2C, *Page2CSize);
		*Page2C = NULL;
		*Page2CSize = 0;
	}

	return(mppStatus);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_LPWCreateLLNode
* SUMMARY:  Create a Least Path Weight linked list node
* SCOPE:    local
*
*
* DESCRIPTION:
*  Each node represents a lun path. When a new path is found for a lun, a node
*  representing that path is created. During IO path selection, the lun's
*  linked (path) list is scanned for a path with the least path weight.
*
* Note: Currently, on mppWin_NewSelectPath() supports the Least Path Weight
*       Load Balance policy.
*
*       A node defined by LPWLinkedListNode_t, contains fields for debug (controllerIndex,
*       PathId, pathIndex, Lun). I am leaving these in for now.
*
* RESTRICTIONS: None
*
* RETURNS:
*   Pointer to the newly create node.
*   or
*   Null - if no memory for node creation.
*************************************************************************/
LPWLinkedListNode_t *
mpp_LPWCreateLLNode(IN RdacDeviceInformation_t *RdacInfo, LWORD controllerIndex, BYTE pathIndex, LWORD Lun)
{
  LPWLinkedListNode_t *lNode = NULL;

  // allocate memory for linked list node
  lNode = (LPWLinkedListNode_t *)MPP_INT_KMEM_ALLOC(sizeof(LPWLinkedListNode_t));
  if (lNode == NULL)
  {
    MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 404, "Memory allocation error. Ref: %d.\n", 1));
    return(NULL);
  }

  // initialize node
  lNode->PathId = RdacInfo->ControllerInfo[controllerIndex]->ControllerPath[pathIndex].PathId;
  lNode->pathWeight = MPP_DEFAULT_LBP_PATH_WEIGHT;
  lNode->controllerIndex = controllerIndex;
  lNode->pathIndex = pathIndex;
  lNode->Lun = Lun;
  lNode->prvLLNode = NULL;
  lNode->nxtLLNode = NULL;

  // return node address
  return(lNode);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_LPWInsertLLNode
* SUMMARY:  Insert a node into a Least Path Weight linked list
* SCOPE:    local
*
*
* DESCRIPTION:
*  A pointer to a node created by mpp_LPWCreateLLNode() is inserted into
*  a lun's linked list by path weight. Nodes with lesser path weight are
*  linked at the top of the list. If a node becomes the first node in the
*  list, the linked list header for the lun is updated. The linked list
*  header is defined in the LunPathObjects_t for each lun. The header
*  contains a pointer to the lun's linked list and the least path weight
*  of paths in the list.
*
* RESTRICTIONS: None
*
* RETURNS:
*   N/A
*************************************************************************/
VOID
mpp_LPWInsertLLNode(IN RdacDeviceInformation_t *RdacInfo, IN LWORD ControllerIndex, IN BYTE PathIndex, IN LWORD Lun)
{
  LPWLinkedListHeader_t *lLHeader = &RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->lLHeader;
  LPWLinkedListNode_t *insertNode = RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].lLNode;
  LPWLinkedListNode_t *currentNode = lLHeader->firstLLNode;
  LPWLinkedListNode_t *nxtNode = currentNode;

  if (currentNode == NULL
      || (currentNode && (currentNode->pathWeight > insertNode->pathWeight)))
  {
    // This is the first node in the list. Place node address in header and make it the
    // first node to check in NewSelectPath()
    lLHeader->firstLLNode = insertNode;
    lLHeader->firstLLNodeToCheck = insertNode;
    lLHeader->leastPathWeight = insertNode->pathWeight;
    if (currentNode == NULL)
      return;
    else
      goto insertAbove; // Insert above above currentNode.
  }

  // Loop while currentNode path weight is less than insertNode path weight or at end of list.
  while(TRUE)
  {
    if (currentNode->pathWeight == insertNode->pathWeight)
      break;

    if (currentNode->pathWeight > insertNode->pathWeight)
      // Transition between < and > path weights. Place insertNode above currentNode.
      goto insertAbove;

    nxtNode = (LPWLinkedListNode_t *)currentNode->nxtLLNode;
    if (nxtNode == NULL)
    { // Must be at the end of the list. Place insertNode at the end of the list, below currentNode.
      goto insertBelow;
    }

    currentNode = nxtNode;
  }

  // Path weight of currentNode = insertNode. Find the last node with the same path weight
  // and insert below.
  while((currentNode->pathWeight == insertNode->pathWeight) && nxtNode != NULL)
  {
    nxtNode = (LPWLinkedListNode_t *)currentNode->nxtLLNode;
    if (nxtNode == NULL)
    { // Must be at the end of the list. Place insertNode at the end of the list.
      goto insertBelow;
    }

    currentNode = nxtNode;
  }

  // currentNode path weight must be > than insertNode pathWeight. Place insertNode
  // above currentNode.
  goto insertAbove;

insertAbove:
  insertNode->nxtLLNode = currentNode;
  insertNode->prvLLNode = currentNode->prvLLNode;
  currentNode->prvLLNode = insertNode;
  return;

insertBelow:
  insertNode->prvLLNode = currentNode;
  insertNode->nxtLLNode = currentNode->nxtLLNode;
  currentNode->nxtLLNode = insertNode;
  return;
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_LPWRemoveLLNode
* SUMMARY:  Remove a node from a Least Path Weight linked list
* SCOPE:    local
*
*
* DESCRIPTION:
*   When a lun path is removed, mpp_LPWRemoveLLNode() is called to
*   remove the corresponding path node from the lun's Least Path Weight
*   linked list. By doing this, the path will no longer be selected for IO.
*
*   mpp_LPWRemoveLLNode() is also called when a lun path's path weight is
*   modified. The sequence of calls to update a path's path weight is:
*    mpp_LPWRemoveLLNode()
*    - update path weight in node
*    mpp_LPWInsertLLNode()
*
* RESTRICTIONS:
*
* RETURNS:
*   N/A
*************************************************************************/
VOID
mpp_LPWRemoveLLNode(IN RdacDeviceInformation_t *RdacInfo, IN LWORD ControllerIndex, IN BYTE PathIndex, IN LWORD Lun, IN BOOL freeNode)
{
  LPWLinkedListHeader_t *lLHeader = &RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->lLHeader;
  LPWLinkedListNode_t *lLNode = RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].lLNode;

  // If removing the top of the list, set the list headers firstLLNode to lLNode's nxtLLNode
  if (lLHeader->firstLLNode == lLNode)
  {
    lLHeader->firstLLNode = lLNode->nxtLLNode; // this could be NULL
    if (lLNode->nxtLLNode != NULL)
    {
      ((LPWLinkedListNode_t *)lLHeader->firstLLNode)->prvLLNode = NULL;
      lLHeader->leastPathWeight = ((LPWLinkedListNode_t *)lLHeader->firstLLNode)->pathWeight;
    }
    goto freeNode;
  }

  // Set the previous node's nxtLLNode
  ((LPWLinkedListNode_t *)(lLNode->prvLLNode))->nxtLLNode = lLNode->nxtLLNode; // this could be NULL

  if (lLNode->nxtLLNode != NULL)
  { // Make the next node point back to the removed node's previous node
    ((LPWLinkedListNode_t *)(lLNode->nxtLLNode))->prvLLNode = lLNode->prvLLNode;
  }
  goto freeNode;

freeNode:
  // if this node was the firstLLNodeToCheck, NULL firstLLNodeToCheck
  if (lLNode == lLHeader->firstLLNodeToCheck)
    lLHeader->firstLLNodeToCheck = NULL;

  if(freeNode)
    MPP_FREE(lLNode, sizeof(LPWLinkedListNode_t));
  else
  { // Not being freed. NULL nxtLLNode and prvLLNode
    lLNode->nxtLLNode = NULL;
    lLNode->prvLLNode = NULL;
  }

  return;
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_GetArrayIdentifierTag
* SUMMARY:  Get an array Device Identifier Tag.
* SCOPE:    local
*
* DESCRIPTION:
*   This routine returns a string representing an array Device Identifier Tag.
*   A Device Identifier Tag is of the form Category#DeviceIdentifier. In this
*   case, the category is "Array" and device indentifier is the array's WWN.
*   example: "Array#600a0b800029adbe000000004754604d".
*
* NOTE:
*   The ArrayIdTag and ArrayIdTagLength parameters passed in must be 
*   allocated by the callee.
*
* RESTRICTIONS:
*   None.
*
* RETURNS:
*   MPPCMN_STATUS_INVALID_PARAMETER
*   MPPCMN_STATUS_NO_MEMORY
*   MPPCMN_STATUS_SUCCESS
*************************************************************************/
LWORD
mppCmn_GetArrayIdentifierTag(
  IN BYTE *ArrayWWN,
  IN LWORD ArrayWWNLength,
  IN OUT BYTE **ArrayIdTag,
  IN OUT LWORD *ArrayIdTagLength)
{
  LWORD idx;
  BYTE *tmpString;
  char *tmpString2;
  LWORD lengthNeeded;

  // Check input arguments to make sure they are valid (ie  not NULL)
  if(ArrayWWN == NULL || ArrayIdTag == NULL || ArrayIdTagLength == NULL)
  {
    MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_1,
			"GetArrayIdentifierTag: Invalid address - ArrayWWN %p ArrayIdTag %p ArrayIdTagLength %p\n",
			 ArrayWWN, ArrayIdTag, ArrayIdTagLength));
    return(MPPCMN_STATUS_INVALID_PARAMETER);
  }

  // A formatted WWN string uses two characters for each WWN byte.  Make sure
  // the return string is long enough to hold the information.
  lengthNeeded = (ArrayWWNLength * 2) + strlen(MPPCMN_ARRAY_SETTINGS_TAG) + 1;

  tmpString = MPP_INT_KMEM_ALLOC(ArrayWWNLength*2 + 1);
  if(tmpString == NULL)
  {
    MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 404, "Memory allocation error. Ref: %d.\n", 2));
    MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_1,
                    "GetArrayIdentifierTag: MPPCMN_STATUS_NO_MEMORY for tmpString\n"));
    return(MPPCMN_STATUS_NO_MEMORY);
  }

  for(idx = 0; idx < ArrayWWNLength; idx++)
  {
    sprintf(&tmpString[idx*2], "%.2x", ArrayWWN[idx]);
  }

  tmpString2 = MPP_INT_KMEM_ALLOC(lengthNeeded);
  if(tmpString2 == NULL)
  {
    MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 404, "Memory allocation error. Ref: %d.\n", 3));
    MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_1,
                    "GetArrayIdentifierTag: MPPCMN_STATUS_NO_MEMORY for tmpString2\n"));
    MPP_FREE(tmpString, ArrayWWNLength*2 + 1);
    return(MPPCMN_STATUS_NO_MEMORY);
  }

  sprintf(tmpString2, "%s%s", MPPCMN_ARRAY_SETTINGS_TAG, tmpString);

  MPP_FREE(tmpString, ArrayWWNLength*2 + 1);

  *ArrayIdTag = tmpString2;
  *ArrayIdTagLength = lengthNeeded;
  return(MPPCMN_STATUS_SUCCESS);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_GetLunIdentifierTag
* SUMMARY:  Get a Lun Device Identifier Tag.
* SCOPE:    local
*
* DESCRIPTION:
*   This routine returns a string representing a Lun Device Identifier Tag.
*   A Device Identifier Tag is of the form Category#DeviceIdentifier. In this
*   case, the category is "Lun" and device indentifier is the Lun's WWN.
*   example: "Lun#600a0b800029adbe000058e24754198e".
*
* NOTE:
*   Memory is allocated here for the tag string. The callee must free 
*   LunIdTag after use. LunIdTag must be freed only if MPPCMN_STATUS_SUCCESS
*   is returned. LunIdTagLength will contain the allocation length.
*
* RESTRICTIONS:
*   None.
*
* RETURNS:
*   MPPCMN_STATUS_INVALID_PARAMETER
*   MPPCMN_STATUS_NO_MEMORY
*   MPPCMN_STATUS_SUCCESS
*************************************************************************/
LWORD
mppCmn_GetLunIdentifierTag(
  IN BYTE *LunWWN,
  IN LWORD LunWWNLength,
  IN OUT BYTE **LunIdTag,
  IN OUT LWORD *LunIdTagLength)
{
  LWORD idx;
  BYTE *tmpString;
  char *tmpString2;
  LWORD lengthNeeded;

  // Check input arguments to make sure they are valid (ie  not NULL)
  if(LunWWN == NULL || LunIdTag == NULL || LunIdTagLength == NULL)
  {
    MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_1,
			"GetLunIdentifierTag: Invalid address - LunWWN %p LunIdTag %p LunIdTagLength %p\n",
			 LunWWN, LunIdTag, LunIdTagLength));
    return(MPPCMN_STATUS_INVALID_PARAMETER);
  }

  // A formatted WWN string uses two characters for each WWN byte.  Make sure
  // the return string is long enough to hold the information.
  lengthNeeded = (LunWWNLength * 2) + strlen(MPPCMN_LUN_SETTINGS_TAG) + 1;

  tmpString = MPP_INT_KMEM_ALLOC(LunWWNLength*2 + 1);
  if(tmpString == NULL)
  {
    MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 404, "Memory allocation error. Ref: %d.\n", 4));
    MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_1,
                    "GetLunIdentifierTag: MPPCMN_STATUS_NO_MEMORY for tmpString\n"));
    return(MPPCMN_STATUS_NO_MEMORY);
  }

  for(idx = 0; idx < LunWWNLength; idx++)
  {
    sprintf(&tmpString[idx*2], "%.2x", LunWWN[idx]);
  }

  tmpString2 = MPP_INT_KMEM_ALLOC(lengthNeeded);
  if(tmpString2 == NULL)
  {
    MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 404, "Memory allocation error. Ref: %d.\n", 5));
    MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_1,
                    "GetLunIdentifierTag: MPPCMN_STATUS_NO_MEMORY for tmpString2\n"));
    MPP_FREE(tmpString, LunWWNLength*2 + 1);
    return(MPPCMN_STATUS_NO_MEMORY);
  }

  sprintf(tmpString2, "%s%s", MPPCMN_LUN_SETTINGS_TAG, tmpString);

  MPP_FREE(tmpString, LunWWNLength*2 + 1);

  *LunIdTag = tmpString2;
  *LunIdTagLength = lengthNeeded;
  return(MPPCMN_STATUS_SUCCESS);
}


/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_GetPathIdentifierTag
* SCOPE:    local
*
* DESCRIPTION:
*   This routine returns a string representing a path Device Identifier Tag.
*   A Device Identifier Tag is of the form Category#DeviceIdentifier. In this
*   case, the category is "Path" and device indentifier is the Path's address.
*   example (Windows): "Path#77040000".
*
* NOTE:
*   Memory is allocated here for the tag string. The callee must free PathIdTag
*   after use. PathIdTag must be freed only if MPPCMN_STATUS_SUCCESS is returned.
*   PathIdTagLength will contain the allocation length.
*
* RESTRICTIONS:
*   None.
*
* RETURNS:
*   MPPCMN_STATUS_INVALID_PARAMETER
*   MPPCMN_STATUS_SUCCESS
*************************************************************************/
LWORD
mppCmn_GetPathIdentifierTag(
  IN int Port,
  IN int Path,
  IN int Target,
  IN OUT BYTE **PathIdTag,
  IN OUT LWORD *PathIdTagLength)
{
  LWORD lengthNeeded;
  char *tmpSting;

  // Check input arguments to make sure they are valid (ie  not NULL)
  if(PathIdTag == NULL || PathIdTagLength == NULL)
  {
    MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_1,
			"GetPathIdentifierTag: Invalid address - PathIdTag %p PathIdTagLength %p\n",
			 PathIdTag, PathIdTagLength));
    return(MPPCMN_STATUS_INVALID_PARAMETER);
  }

  // A formatted path string uses two characters each for Port, Path,
  // Target, and the initial 0x77 value.  Make sure the return string is long
  // enough to hold the information.
  lengthNeeded = 8 + strlen(MPPCMN_PATH_SETTINGS_TAG) + 1;

  tmpSting = MPP_INT_KMEM_ALLOC(lengthNeeded);
  if(tmpSting == NULL)
  {
    MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 404, "Memory allocation error. Ref: %d.\n", 6));
    return(MPPCMN_STATUS_NO_MEMORY);
  }
  sprintf(tmpSting, "%s77%02x%02x%02x", MPPCMN_PATH_SETTINGS_TAG,
          Port, Path, Target);

  *PathIdTag = tmpSting;
  *PathIdTagLength = lengthNeeded;
  return(MPPCMN_STATUS_SUCCESS);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_GetLunPathIdentifierTag
* SUMMARY:  Get a path Device Identifier Tag.
* SCOPE:    local
*
* DESCRIPTION:
*   This routine returns a string representing a Lun-Path Device Identifier Tag.
*   A Device Identifier Tag is of the form Category#DeviceIdentifier. In this case,
*   Lun and Path Device Indentifier Tags are combined (reference:
*   mppCmn_GetLunIdentifierTag(), mppCmn_GetPathIdentifierTag())
*   example (Windows): "Lun#600a0b800029adbe000058e24754198ePath#77040000".
*
* NOTE:
*   Memory is allocated here for the tag string. The callee must free LunPathIdTag
*   after use. LunPathIdTag must be freed only if MPPCMN_STATUS_SUCCESS is returned.
*   LunPathIdTagLength will contain the allocation length.
*
* RESTRICTIONS:
*   None.
*
* RETURNS:
*   MPPCMN_STATUS_INVALID_PARAMETER
*   MPPCMN_STATUS_NO_MEMORY
*   MPPCMN_STATUS_SUCCESS
*************************************************************************/
LWORD
mppCmn_GetLunPathIdentifierTag(
  IN BYTE *LunWWN,
  IN LWORD LunWWNLength,
  IN int Port,
  IN int Path,
  IN int Target,
  IN OUT BYTE **LunPathIdTag,
  IN OUT LWORD *LunPathIdTagLength)
{
  LWORD idx;
  BYTE *tmpString;
  char *tmpString2;
  LWORD lengthNeeded;

  // Check input arguments to make sure they are valid (ie  not NULL)
  if(LunWWN == NULL || LunPathIdTag == NULL || LunPathIdTagLength == NULL )
  {
    MPP_DEBUGPRINT((MPP_ATTACH_DEBUG+MPP_DEBUG_LEVEL_1,
			"GetLunPathIdentifierTag: Invalid address - LunWWN %p LunPathIdTag %p LunPathIdTagLength %p\n",
			 LunWWN, LunPathIdTag, LunPathIdTagLength));			 
    return(MPPCMN_STATUS_INVALID_PARAMETER);
  }

  // A formatted lun path string uses two characters for each WWN byte plus
  // two characters each for Port, Path, Target, and the initial 0x77
  // value.  Make sure the return string is long enough to hold the information.
  lengthNeeded = ((LunWWNLength * 2) + strlen(MPPCMN_LUN_SETTINGS_TAG)) +
                 (8 + strlen(MPPCMN_PATH_SETTINGS_TAG)) + 1;

  tmpString = MPP_INT_KMEM_ALLOC(LunWWNLength*2 + 1);
  if(tmpString == NULL)
  {
    MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 404, "Memory allocation error. Ref: %d.\n", 7));
    return(MPPCMN_STATUS_NO_MEMORY);
  }

  for(idx = 0; idx < LunWWNLength; idx++)
  {
    sprintf(&tmpString[idx*2], "%.2x", LunWWN[idx]);
  }

  tmpString2 = MPP_INT_KMEM_ALLOC(lengthNeeded);
  if(tmpString2 == NULL)
  {
    MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 404, "Memory allocation error. Ref: %d.\n", 8));
    MPP_FREE(tmpString, LunWWNLength*2 + 1);
    return(MPPCMN_STATUS_NO_MEMORY);
  }

  sprintf(tmpString2, "%s%s\\%s77%02x%02x%02x", MPPCMN_LUN_SETTINGS_TAG,
          tmpString, MPPCMN_PATH_SETTINGS_TAG, Port, Path, Target);

  MPP_FREE(tmpString, LunWWNLength*2 + 1);

  *LunPathIdTag = tmpString2;
  *LunPathIdTagLength = lengthNeeded;
  return(MPPCMN_STATUS_SUCCESS);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mpp_LPWUpdateLLNodePathWeight
* SUMMARY:  Update a path's Load Balance Policy path weight
* SCOPE:    local
*
* DESCRIPTION:
*   When a user changes the path weight of a lun's path,
*   mpp_LPWUpdateLLNodePathWeight() is called to perform the node
*   update. The steps for update are:
*    remove node for linked list - mpp_LPWRemoveLLNode()
*    update the node's pathWeight
*    insert the node back into the list - mpp_LPWInsertLLNode()
*
* RESTRICTIONS:
*  none
*
* RETURNS:
*   N/A
*************************************************************************/
VOID
mpp_LPWUpdateLLNodePathWeight(
  IN RdacDeviceInformation_t *RdacInfo,
  IN LWORD ControllerIndex,
  IN BYTE PathIndex,
  IN LWORD Lun,
  IN LWORD PathWeight)
{

  // Remove the LPW linked node for update
  mpp_LPWRemoveLLNode(RdacInfo, ControllerIndex, PathIndex, Lun, FALSE);

  // Set the new pathWeight. Save in the node and LunPathInfo_t
  RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].lLNode->pathWeight = PathWeight;
  RdacInfo->RdacLuns[Lun].LunControllers[ControllerIndex]->LunPaths[PathIndex].PathWeight = PathWeight;

  // Re-insert the node into the linked list
  mpp_LPWInsertLLNode(RdacInfo, ControllerIndex, PathIndex, Lun);

  return;
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_LeastQueueDepthPolicy
* SUMMARY:  Select the correct path for an I/O to a Lun
*
*
* DESCRIPTION:
*   This function selects a path based on Least number of Ourstanding commands on that path. The path which has the least number
*   of outstanding commands will the one to get selected and returns to the caller for sending I/O
*   to Lun. A pointer to LunPathInfo_t is returned.
*
*		IN  	RdacInfo
*		IN 	Lun
*		OUT	Controller
*		OUT	Path
*
*
* RESTRICTIONS:
*
*
* RETURNS:
*   LunPathInfo_t or NULL.
*************************************************************************/
LunPathInfo_t *
mppCmn_LeastQueueDepthPolicy(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BYTE *Controller, BYTE *Path)
{
	BOOL			nonOptimalFound = FALSE;
	BYTE			nonOptimalPath = 0, nonOptimalController = 0, curController;
	LunPathInfo_t		*lunPath = NULL, *nonOptimalLunPath = NULL, *lqdLunPath = NULL;
	LWORD			index, pathsChecked, stateIndex, pathIndex;
	MPP_HANDLE		pathVertex=NULL;
	int 			leastQueueDepth = 0x7FFFFFFF;

	curController = (BYTE)RdacInfo->RdacLuns[Lun].CurrentOwningPath;

	// Find usable path with least requests in progress. Start search on current owning controller.
	for(index = 0; index < 2; index++)
	{
		if(index == 1)
		{
			curController = curController^1;
		}

		for(pathsChecked = 0; pathsChecked < mpp_MaxPathsPerController; ++pathsChecked)
		{
			pathIndex = pathsChecked;

			// skip path and device checks if optimal path and device found with lesser RequestsInProgress

			if (!RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].Present
					|| MPPSYS_ATOMIC_GET(RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].RequestsInProgress)
					>= leastQueueDepth)
			{
				continue;
			}

			stateIndex = RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].PathStateIndex;


			if(RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].Present
					&& RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].PathState[stateIndex] 
					!= MPPCMN_FAILED
					&& RdacInfo->RdacLuns[Lun].LunControllers[curController]->LunPaths[pathIndex].LunPathDevice
					&&  RdacInfo->RdacLuns[Lun].LunControllers[curController]->LunPaths[pathIndex].PathRemoveState != 1)
			{
				lunPath = &RdacInfo->RdacLuns[Lun].LunControllers[curController]->LunPaths[pathIndex];
				if(lunPath->DeviceState[lunPath->DeviceStateIndex] == MPPCMN_OPTIMAL
						|| lunPath->DeviceState[lunPath->DeviceStateIndex] == MPPCMN_OPTIMAL_NEED_CHECK
						|| lunPath->DeviceState[lunPath->DeviceStateIndex] == MPPCMN_OPTIMAL_CHECKING)
				{
					if(MPPSYS_ATOMIC_GET(RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].RequestsInProgress)
							< leastQueueDepth)
					{
						leastQueueDepth = 
							MPPSYS_ATOMIC_GET(RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].RequestsInProgress);
						lqdLunPath = lunPath;
						pathVertex = lunPath->LunPathDevice;
						*Controller = curController;
						*Path = (BYTE)pathIndex;
					}
				}

				else if(lunPath->DeviceState[lunPath->DeviceStateIndex] == MPPCMN_SYSTEM_SPECIFIC)
				{
					; // If the path is chosen MPIO will log a DSM returned bogus path" message.  Do nothing.
				}
				else if(nonOptimalFound == FALSE)
				{
					// We want the first MPPCMN_FAILED_NEED_CHECK, MPPCMN_FAILED_CHECKING path found.
					// RequestsInProgress for a non-optimal path can not be trusted. So check is not done.
					nonOptimalLunPath = lunPath;
					nonOptimalController = curController;
					nonOptimalPath = (BYTE)pathIndex;

					if(nonOptimalLunPath->DeviceState[nonOptimalLunPath->DeviceStateIndex] != MPPCMN_FAILED)
					{
						nonOptimalFound = TRUE;
					}
				}
			}
		}

		// An optimal LQD path found.
		if(lqdLunPath != NULL)
		{
			break;
		}

		// We couldn't find an optimal LQD path on the current controller.  Try the alternate controller.
		leastQueueDepth = 0x7FFFFFFF;

		// We couldn't find an MPPCMN_OPTIMAL* path.  If a nonOptimal path was found and is not FAILED, use that path.
                if(nonOptimalFound == TRUE && nonOptimalLunPath->DeviceState[nonOptimalLunPath->DeviceStateIndex] != MPPCMN_FAILED)
                {
                        break;
                }

		nonOptimalFound = FALSE;


	}

	if (lqdLunPath != NULL)
	{
		lunPath = lqdLunPath;
	}
	else if (nonOptimalFound == TRUE)
	{
		*Controller = nonOptimalController;
		*Path = nonOptimalPath;
		lunPath = nonOptimalLunPath;
		pathVertex = lunPath->LunPathDevice;
	}

	/** 11/19/04 - Reset the CurrentOwningPath for the Lun if its changed **/
	if(curController != (BYTE)RdacInfo->RdacLuns[Lun].CurrentOwningPath)
	{
		RdacInfo->RdacLuns[Lun].CurrentOwningPath = curController;
	}

	MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_4, "mppCmn_LeastQueueDepthPolicy(%s) Lun:%d"
				" Selecting (Path %d on controller %d) with pending %d requests\n",
				RdacInfo->ModuleName, Lun, *Path, *Controller, leastQueueDepth)); 

	return lunPath;

}

/**************************************************************************
 * PROCEDURE
 *
 * NAME:     mppCmn_PathWeightPolicy
 * SUMMARY:  Select the correct path for an I/O to a Lun
 *
 *
 * DESCRIPTION:
 *   This function selects the path based on the path weight. The path with the least path weight will be the one next 
 *   and returns to the caller for sending I/O  to Lun. A pointer to LunPathInfo_t is returned.
 *
 *		IN  	RdacInfo
 *		IN 	Lun
 *		OUT	Controller
 *		OUT	Path
 *
 *
 * RESTRICTIONS:
 *
 *
 * RETURNS:
 *   LunPathInfo_t or NULL.
 *************************************************************************/
LunPathInfo_t *
mppCmn_PathWeightPolicy(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BYTE *Controller, BYTE *Path)
{
	BOOL			terminateLoop = FALSE, nonOptimalFound = FALSE;
	BYTE			nonOptimalPath = 0, nonOptimalController = 0, curController, pathIndex;
	LunPathInfo_t		*lunPath = NULL, *nonOptimalLunPath = NULL;
	LWORD			index, stateIndex;
	MPP_HANDLE		pathVertex=NULL;

	LPWLinkedListHeader_t *lLHeader;
	LPWLinkedListNode_t *firstLLNodeChecked;
	LPWLinkedListNode_t *curNode;
	LPWLinkedListNode_t *firstHPWNode = NULL; // HPW - higher path weighted node
	BOOL lPWNodesChecked = FALSE; // lPW - least path weighted node

	curController = (BYTE)RdacInfo->RdacLuns[Lun].CurrentOwningPath;

	for(index = 0; index < 2; index++)
	{
		if(index == 1)
		{
			curController = curController^1;
		}
		// Get the linked list header for this lun
		lLHeader = &RdacInfo->RdacLuns[Lun].LunControllers[curController]->lLHeader;

		// Determine which path to start evaluating (Round Robin when more than one least path weighted path)
		// If the next node to check is either NULL or has a higher path weight, start at the first node.
		curNode = lLHeader->firstLLNodeToCheck;

		if (curNode == NULL)                // firstLLNodeToCheck has been removed. Start at the top of the list.
			curNode = lLHeader->firstLLNode;
		else if (curNode->pathWeight > lLHeader->leastPathWeight)
		{
			firstHPWNode = curNode;           // Save in case higher path weighted nodes are searched
			curNode = lLHeader->firstLLNode;
		}

		// save the 1st node checked for loop control
		firstLLNodeChecked = curNode;

		while (curNode != NULL)
		{
			pathIndex = curNode->pathIndex;

			stateIndex = RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].PathStateIndex;
			if(RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].Present
					&& RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].PathState[stateIndex] != MPPCMN_FAILED
					&& RdacInfo->RdacLuns[Lun].LunControllers[curController]->LunPaths[pathIndex].LunPathDevice
					&&  RdacInfo->RdacLuns[Lun].LunControllers[curController]->LunPaths[pathIndex].PathRemoveState != 1)
			{
				lunPath = &RdacInfo->RdacLuns[Lun].LunControllers[curController]->LunPaths[pathIndex];
				if(lunPath->DeviceState[lunPath->DeviceStateIndex] == MPPCMN_OPTIMAL
						|| lunPath->DeviceState[lunPath->DeviceStateIndex] == MPPCMN_OPTIMAL_NEED_CHECK
						|| lunPath->DeviceState[lunPath->DeviceStateIndex] == MPPCMN_OPTIMAL_CHECKING)
				{
					pathVertex = lunPath->LunPathDevice;
					*Controller = curController;
					*Path = (BYTE)pathIndex;
					terminateLoop = TRUE;
					break;
				}
				else if(lunPath->DeviceState[lunPath->DeviceStateIndex] == MPPCMN_SYSTEM_SPECIFIC)
				{
					; // If the path is chosen MPIO will log a DSM returned bogus path" message.  Do nothing.
				}
				else if(nonOptimalFound == FALSE)
				{
					// We want the first MPPCMN_FAILED_NEED_CHECK, MPPCMN_FAILED_CHECKING path found.
					nonOptimalLunPath = lunPath;
					nonOptimalController = curController;
					nonOptimalPath = (BYTE)pathIndex;

					if(nonOptimalLunPath->DeviceState[nonOptimalLunPath->DeviceStateIndex] != MPPCMN_FAILED)
					{
						nonOptimalFound = TRUE;
					}
				}
			}

			curNode = (LPWLinkedListNode_t *)curNode->nxtLLNode;

			if (lPWNodesChecked == FALSE)
			{ // Loop within least path weighted nodes unless all least weighted nodes checked
				if (curNode == NULL)
					curNode = lLHeader->firstLLNode;
				else if (curNode->pathWeight > lLHeader->leastPathWeight)
				{ // At the end of the least path weight list. Resume at the top of the list.
					firstHPWNode = curNode;       // Save for in case higher path weighted nodes are searched
					curNode = lLHeader->firstLLNode;
				}
			}

			if (curNode == firstLLNodeChecked)
			{ // There are no optimal least path weighted paths on the curController. Check paths with higher path weight.
				curNode = firstHPWNode; // This will be NULL if there are no HPW nodes
				lPWNodesChecked = TRUE;
			}
		}

		if(terminateLoop == TRUE)
		{ // Optimal path found
			lLHeader->firstLLNodeToCheck = (LPWLinkedListNode_t *)curNode->nxtLLNode;
			break;
		}

		// We couldn't find an MPPCMN_OPTIMAL* path.  If a nonOptimal path was found and is not FAILED, use that path.
		if(nonOptimalFound == TRUE)
		{
			break;
		}
	}

	if(terminateLoop == FALSE && nonOptimalLunPath)
	{
		*Controller = nonOptimalController;
		*Path = nonOptimalPath;
		lunPath = nonOptimalLunPath;
		pathVertex = lunPath->LunPathDevice;
	}

	/** 11/19/04 - Reset the CurrentOwningPath for the Lun if its changed **/
	if(curController != (BYTE)RdacInfo->RdacLuns[Lun].CurrentOwningPath)
	{
		RdacInfo->RdacLuns[Lun].CurrentOwningPath = curController;
	}

	return lunPath;

}



/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_RoundRobinPolicy
* SUMMARY:  Select the correct path for an I/O to a Lun
*
*
* DESCRIPTION:
*   This function selects the path based on the round robin policy and returns to the caller for sending I/O
*   to Lun. A pointer to LunPathInfo_t is returned.
*
*		IN  	RdacInfo
*		IN 	Lun
*		OUT	Controller
*		OUT	Path
*
*
* RESTRICTIONS:
*
*
* RETURNS:
*   LunPathInfo_t or NULL.
*************************************************************************/
LunPathInfo_t *
mppCmn_RoundRobinPolicy(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BYTE *Controller, BYTE *Path)
{
	BOOL			terminateLoop = FALSE, nonOptimalFound = FALSE;
	BYTE			nonOptimalPath = 0, nonOptimalController = 0, curController, pathIndex;
	LunPathInfo_t		*lunPath = NULL, *nonOptimalLunPath = NULL;
	LWORD			index, pathsChecked, stateIndex;
	MPP_HANDLE		pathVertex=NULL;

	curController = (BYTE)RdacInfo->RdacLuns[Lun].CurrentOwningPath;


	/**
	 ** Find the next available path based on the following criteria for RecoveryState:
	 **	- Optimal, OptimalNeedCheck, OptimalChecking : Use the path unconditionally.
	 **	- FailedNeedCheck, FailedChecking, System : Save information on first one found and use that path if no Optimal* paths are found.
	 **	- Failed : Save information on first one found.  If no Failed*, System, or Optimal* paths are found use this path.
	 **
	 ** If the chosen path is Failed, switch to the alternate controller and repeat the above process to locate a non-Failed path.
	 ** If all paths are Failed return the last Failed path found.
	 **/
	for(index = 0; index < 2; index++)
	{
		if(index == 1)
		{
			curController = curController^1;
		}

		for(pathsChecked = 0; pathsChecked < mpp_MaxPathsPerController; ++pathsChecked)
		{
			pathIndex = RdacInfo->RdacLuns[Lun].LunControllers[curController]->RoundRobinPathIndex;
			stateIndex = RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].PathStateIndex;
			if(RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].Present
					&& RdacInfo->ControllerInfo[curController]->ControllerPath[pathIndex].PathState[stateIndex] != MPPCMN_FAILED
					&& RdacInfo->RdacLuns[Lun].LunControllers[curController]->LunPaths[pathIndex].LunPathDevice
					&&  RdacInfo->RdacLuns[Lun].LunControllers[curController]->LunPaths[pathIndex].PathRemoveState != 1)
			{
				lunPath = &RdacInfo->RdacLuns[Lun].LunControllers[curController]->LunPaths[pathIndex];
				if(lunPath->DeviceState[lunPath->DeviceStateIndex] == MPPCMN_OPTIMAL
						|| lunPath->DeviceState[lunPath->DeviceStateIndex] == MPPCMN_OPTIMAL_NEED_CHECK
						|| lunPath->DeviceState[lunPath->DeviceStateIndex] == MPPCMN_OPTIMAL_CHECKING)
				{
					pathVertex = lunPath->LunPathDevice;
					*Controller = curController;
					*Path = pathIndex;
					terminateLoop = TRUE;
					break;
				}
				else if(nonOptimalFound == FALSE)
				{
					// We want the first MPPCMN_FAILED_NEED_CHECK, MPPCMN_FAILED_CHECKING, or
					// MPPCMN_SYSTEM_SPECIFIC path found.
					nonOptimalLunPath = lunPath;
					nonOptimalController = curController;
					nonOptimalPath = pathIndex;

					if(nonOptimalLunPath->DeviceState[nonOptimalLunPath->DeviceStateIndex] != MPPCMN_FAILED)
					{
						nonOptimalFound = TRUE;
					}
				}
			}

			++RdacInfo->RdacLuns[Lun].LunControllers[curController]->RoundRobinPathIndex;
			RdacInfo->RdacLuns[Lun].LunControllers[curController]->RoundRobinPathIndex %= mpp_MaxPathsPerController;
		}

		if(terminateLoop == TRUE)
		{
			break;
		}

		// We couldn't find an MPPCMN_OPTIMAL* path.  If a nonOptimal path was found and is not FAILED, use that path.
		if(nonOptimalFound == TRUE && nonOptimalLunPath->DeviceState[nonOptimalLunPath->DeviceStateIndex] != MPPCMN_FAILED)
		{
			break;
		}

		nonOptimalFound = FALSE;
	}

	// If the above loop was terminated then an Optimal path was discovered, else we must return the nonOptimal information
	if(terminateLoop == FALSE && nonOptimalLunPath)
	{
		*Controller = nonOptimalController;
		*Path = nonOptimalPath;
		lunPath = nonOptimalLunPath;
		pathVertex = lunPath->LunPathDevice;
	}

#ifdef MPP_DEBUG
	// The following lines are for debug purposes
	if(lunPath == NULL || (lunPath && lunPath->DeviceState[lunPath->DeviceStateIndex] == MPPCMN_FAILED))
	{
		LWORD	controller;

		MPP_DEBUGPRINT((0, "No paths available for %s:%d\n", RdacInfo->ModuleName, Lun));
		for(controller = 0; controller < 2; ++controller)
		{
			for(pathsChecked = 0; pathsChecked < mpp_MaxPathsPerController; ++pathsChecked)
			{
				stateIndex = RdacInfo->ControllerInfo[controller]->ControllerPath[pathsChecked].PathStateIndex;
				MPP_DEBUGPRINT((0, "Ctl(%d);Path(%d);Pres(%d);PathState(%d);LPD(%p);Prs(%d);DeviceState(%d)\n",
							controller, pathsChecked,
							RdacInfo->ControllerInfo[controller]->ControllerPath[pathsChecked].Present,
							RdacInfo->ControllerInfo[controller]->ControllerPath[pathsChecked].PathState[stateIndex],
							RdacInfo->RdacLuns[Lun].LunControllers[controller]->LunPaths[pathsChecked].LunPathDevice,
							RdacInfo->RdacLuns[Lun].LunControllers[controller]->LunPaths[pathsChecked].PathRemoveState,
							RdacInfo->RdacLuns[Lun].LunControllers[controller]->LunPaths[pathsChecked].DeviceState[
							RdacInfo->RdacLuns[Lun].LunControllers[controller]->LunPaths[pathsChecked].DeviceStateIndex]));
			}
		}
	}
#endif

	/** 11/19/04 - Reset the CurrentOwningPath for the Lun if its changed **/
	if(curController != (BYTE)RdacInfo->RdacLuns[Lun].CurrentOwningPath)
	{
		RdacInfo->RdacLuns[Lun].CurrentOwningPath = curController;
	}

	++RdacInfo->RdacLuns[Lun].LunControllers[curController]->RoundRobinPathIndex;
	RdacInfo->RdacLuns[Lun].LunControllers[curController]->RoundRobinPathIndex %=  mpp_MaxPathsPerController;
	MPP_DEBUGPRINT((MPP_HBA_COMMAND_DEBUG+MPP_DEBUG_LEVEL_4,
				"mppCmn_RoundRobinPolicy: %s:%d RoundRobinPathIndex %d DevObj 0x%x\n",
				RdacInfo->ModuleName, Lun,
				RdacInfo->RdacLuns[Lun].LunControllers[curController]->RoundRobinPathIndex,
				pathVertex));

	return(lunPath);

}

