/*******************************************************************************
* Copyright 2004-2007 LSI Logic Corporation.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            mppLnx26p_spinlock_size.c
SUMMARY         %description%
VERSION         %version: 2 %
UPDATE DATE     %date_modified: Mon Jan 21 05:17:20 2008 %
PROGRAMMER      %created_by:    skashyap %

        Copyright 2007, LSI Logic Corporation. All rights reserved.

DESCRIPTION: This is simple file that compiles in kernel space to give us the size of kernel struct spinlock_t from the kernel headers. This was needed as mppUtil needs the size of the spinlock_t but including kernel headers in user space is not a good idea and also gave other problems.

INCLUDE FILES:

NOTES:

RESTRICTIONS:

SEE ALSO:

REFERENCE:

IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/

#define __SRCmppLnx26p_Spinlock_Size

/***  INCLUDES  ***/  
/* Need to have this #define here to deal with a /usr/include header file problem */
/* One of the included header files includes a config definition but no config header file is present in /usr/include */
#include <linux/version.h>
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,16))
#define KBUILD_STR(s) #s
#define KBUILD_BASENAME KBUILD_STR(junk)
#endif
#include <linux/autoconf.h>
#ifndef CONFIG_NR_CPUS
#define CONFIG_NR_CPUS 1
#endif
#include <linux/spinlock.h>
#include <stdio.h>

/***  CONSTANT DEFINITIONS  ***/


/***  MACRO DEFINITIONS  ***/


/***  TYPE DEFINITIONS  ***/


/***  LOCALS  ***/


/***  PROCEDURES  ***/


/*******************************************************************************
* PROCEDURE
*
* NAME:    main 
* SUMMARY: main function 
* SCOPE:    public | private | local
    local = Internal procedure (static)
    public = Procedure is visible to all components throughout system
    private = Procedure is visible to a limited set of modules, within
        one component (default)
*
*
* DESCRIPTION: This program just prints out the size of spinlock_t by including the right headers
*
* RESTRICTIONS:
* 
* RETURNS: 0
*
* ERRNO:
*
* NOTES:
*
* EXAMPLES:
*
* SEE ALSO:
*
*/


int main()
{
        /* returns the size of spinlock from kernel headers */
        printf("%d",sizeof(spinlock_t));
        return 0;
}
