/*******************************************************************************
* Copyright 2004-2007 LSI Logic Corporation.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            mppLnx26p_sysdep.h
SUMMARY         %description%
VERSION         %version: 6 %
UPDATE DATE     %date_modified: Fri Jun 06 13:17:17 2008 %
PROGRAMMER      %created_by:    harshi %


DESCRIPTION:
This header file contains all the system dependent definitions that are used
by the common code and that are different on each platform.

INCLUDE FILES:

NOTES:

RESTRICTIONS:

SEE ALSO:

REFERENCE:

IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/


#ifndef __INCmppLnx26p_sysdep
#define __INCmppLnx26p_sysdep


/***  INCLUDES  ***/  
#ifdef __KERNEL__
#include <linux/autoconf.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/vmalloc.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/types.h>
#include <linux/slab.h>
#include <linux/errno.h>
#include <linux/spinlock.h>
#include <linux/string.h>
#include <linux/blkdev.h>
#include <linux/genhd.h>
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/smp_lock.h>
#include <linux/time.h>
#include <linux/proc_fs.h>
#include <linux/kdev_t.h>
#include <linux/blkdev.h>
#include <linux/delay.h>
#include <asm/uaccess.h>
#include <asm/system.h>
#include <asm/io.h>
#include <asm/param.h>
#include <scsi/scsi.h>
#include <scsi/scsi_host.h>
#include <scsi/scsi_driver.h>
#include <scsi/scsi_device.h>
#include <scsi/scsi_cmnd.h>
#endif
#ifndef __KERNEL__
#include <fcntl.h>
#include <linux/types.h> 
#include "mppLnx26p_spinlock.h"
#endif


/* These definitions are needed as bcopy bzero and bcmp are not available on Linux */
#ifndef bcopy
#define bcopy(s, d, n) memcpy((d), (s), (n))
#endif

#ifndef bzero
#define bzero(d, n)       memset((d), 0, (n))
#endif

#ifndef bcmp
#define bcmp(s, d, n)     memcmp((d), (s), (n))
#endif

/***  CONSTANT DEFINITIONS  ***/

#define MPP_CONTROLLER_A_PATH  "A"
#define MPP_CONTROLLER_B_PATH  "B"
#ifdef DEBUG_BUFFER_LENGTH
#undef DEBUG_BUFFER_LENGTH
#endif
#define DEBUG_BUFFER_LENGTH 1024
#define MPP_MESSAGESHEADER "RAIDarray"
#define MPP_IOCTL_GET_PHYSICALHOST_MAX_TARGET 0x4D50
#define MPP_IOCTL_GET_UTMLUN_INFO 0x4D51

#define MPPLNX_SCSI_ALLOCREQ_WAIT		10
#define MPPLNX_SCSI_ALLOCREQ_RETRY_COUNT	10

/*moved this definition from common code to system dep code */
#define MPP_DISABLELUNREBALANCE "DisableLUNRebalance"

/* Only required on Windows. On other platforms, it is a No-Op */ 
#define __cdecl 

void mpp_GetTime(unsigned long *time);
#define MPP_GETTIME(a) mpp_GetTime(&a)
#define MPP_GETPATHSTAMP(a) mpp_GetTime(&a)
#define HANDLE int

/***  Some definitons required by mppUtil, which is a user space program and hence should use the /usr/include directory include header files and not the kernel header files. Hence  if the __KERNEL__ macro is not defined, we use other definitions  ***/
#ifdef __KERNEL__
 #define MPP_HANDLE struct scsi_device *
 #define MPP_DIR_HANDLE struct proc_dir_entry *
#endif
#ifndef __KERNEL__
 #define MPP_HANDLE unsigned long
 #define MPP_DIR_HANDLE unsigned long
#endif

/* Macro definitions added for Load Balance Policy */
#ifdef __KERNEL__
typedef atomic_t		MPPSYS_ATOMIC_T;
#define MPPSYS_ATOMIC_INIT(a)   atomic_set(&a, 0)
#define MPPSYS_ATOMIC_INC(a)    atomic_inc(&a)
#define MPPSYS_ATOMIC_DEC(a)    atomic_dec(&a)
#define MPPSYS_ATOMIC_GET(a)    atomic_read(&a)
#endif

/* Macro definitons for kernel memory allocation functions */
void *mppLnx_zmalloc( size_t size, int flag);
void mppLnx_zfree(void *buf, size_t size);
#define MPP_KMEM_ALLOC(a) mppLnx_zmalloc(a, GFP_KERNEL)
#define MPP_INT_KMEM_ALLOC(a) mppLnx_zmalloc(a, GFP_ATOMIC)
#define MPP_FREE(a, b) mppLnx_zfree(a , b)


/* Macro definitions for kernel locks */
#define MPP_LOCK_INIT(a) spin_lock_init(&a);		

#define MPP_LOCK(a, b)  spin_lock_irqsave(&a,  b )
#define MPP_UNLOCK(a, b) spin_unlock_irqrestore(&a,  b ) 

#define MPP_RW_LOCK_INIT(a) do {} while (0)
#define MPP_RW_LOCK_SHARED(a) do {} while (0)
#define MPP_RW_LOCK_EXCLUSIVE(a) do {} while (0)
#define MPP_RW_UNLOCK_SHARED(a) do {} while (0)
#define MPP_RW_UNLOCK_EXCLUSIVE(a) do {} while (0)

#define MPP_LOCK_RELEASE(a) 

#define MPP_MUTEX_INIT(a)		mutex_init(&a)	
#define MPP_MUTEX_LOCK(a)		mutex_lock(&a)
#define MPP_MUTEX_UNLOCK(a)		mutex_unlock(&a)

/***  TYPE DEFINITIONS  ***/
typedef unsigned char	 BYTE;		/* unsigned numeric, bit patterns */
typedef unsigned char	 TEXT;		/* text and string data */
typedef char		 TINY;		/* signed numeric data */
typedef unsigned short	 WORD;		/* unsigned numeric, bit patterns */
typedef short		 SINT;		/* signed numeric data */
typedef short		 METACHAR;	/* character or error status */
typedef unsigned int	 LWORD;		/* unsigned numeric, bit patterns */
typedef unsigned long	 LINT;		/* unsigned long data */
typedef signed int 	 INT;		/* signed data */
typedef int		 BOOL;		/* boolean - either zero or not */
typedef unsigned char *	 POINTER;	/* pointer to BYTE type data */
typedef unsigned long  	 MPP_TIME;
typedef spinlock_t	 MPP_LOCK_T ;
typedef int              MPP_RW_LOCK_T;
typedef unsigned long 	 ULONG;
typedef void 		 VOID;
typedef void *		 PVOID;
typedef char		 CHAR;
typedef unsigned char targ_t;  

/* This is the sys-dependent definiton of the controlleraddress data structure that is part of the
RdacInfo data structure */
typedef struct ControllerAddress {
	int			HostId; 		/* Host Identifier   */
	int			ChannelId;		/* Channel Number    */
    	int 			TargetId;      		/* Target identifier */
} ControllerAddress_t;

/* Type definitions needed for function declarations in MPP_Prototypes.h. */
typedef struct credp 
{
	unsigned long credentials;
} cred_t;


typedef struct iovec iovec_t;

typedef struct uio
{
	unsigned long 	uio_offset;
	unsigned long 	uio_resid;
	iovec_t		*uio_iov;
} uio_t;

struct host_target_t 
{
	int host_id;
	int max_target_id;
};

typedef struct mutex 	MPP_MUTEX_T;
#endif        /* End of __INCmppLnx26p_sysdep */
