/*******************************************************************************
* Copyright 2004 Engenio Information Technologies, Inc.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            mppCmn_SysInterface.c
SUMMARY         %description%
VERSION         %version: 9 %
UPDATE DATE     %date_modified: Mon Jan 28 07:28:45 2008 %
PROGRAMMER      %created_by:    rstankey %

DESCRIPTION:
		Consolidation of all system dependent functions.

INCLUDE FILES:

NOTES:

RESTRICTIONS:

SEE ALSO:

REFERENCE:

IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/
/*
*	For Error Log purposes this module has been assigned numbers 1-249.  
*       Strarting Error number is 140 for this file 
*	the last number currently used is 146.
*/
#define __SRCmppCmn_SysInterface_c

/***  INCLUDES  ***/  
#include "MPP_Common.h"
#include "MPP_Sysdep.h"
#include "MPP_RdacInfo.h"
#include "mppCmn_SysInterface.h" 
#include "MPP_ProtoTypes.h"

/****************************************************************************
* PROCEDURE
* NAME:    mppCmn_RegisterSysInterface
* STATUS:  REQUIRED
* SUMMARY: routine to register system dependent functions
* SCOPE:   public 
* ARGUMENTS:
*       mppCmn_SysInterface_t       - Pointer to sysInterface structure
* DESCRIPTION:
*       	This is a System Dependent Interface Registration function.
*     All the platforms have to implement the REQUIRED system dependent functions.
*     if the system dependent code does not implement OPTIONAL routines, this 
*     function will define defaults for the same.
*  
* RESTRICTIONS:
* RETURNS: TRUE if all the fuctions that are REQUIRED are registered, else FALSE
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:  
****************************************************************************/
LWORD 
mppCmn_RegisterSysInterface( IN mppCmn_SysInterface_t *pi  )
{
	LWORD status	=	TRUE;

	/* Se the global interface pointer ot the registered interface.*/
	mpp_SysInterface = pi; 

	if (mpp_SysInterface == NULL )
	{
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 140, "mppCmn_RegisterSysInterface :: pointer to mppCmn_SysInterface_t Passed NULL.\n"));
		status = FALSE;
		return status;
	}


	/************* CHECK for  all REQUIRED functions ***********/

	if (! pi->mpp_SysdepSynchronousIo)
	{
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 141, "mppCmn_RegisterSysInterface :: Required function pointer mpp_SysdepSynchronousIo passed NULL.\n"));
		status = FALSE;
	}

	if (! pi->mpp_IssueFailover)
	{
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 142, "mppCmn_RegisterSysInterface :: Required function pointer mpp_IssueFailover passed NULL.\n"));
		status = FALSE;
	}

	if (! pi->mpp_makeVirtualLun)
	{
		MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 143, "mppCmn_RegisterSysInterface :: Required function pointer mpp_makeVirtualLun passed NULL.\n"));
		status = FALSE;
	}

        if (! pi->mppSys_GetUtilSysdepData )
        {
                MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 144, "mppCmn_RegisterSysInterface :: Required function pointer mppSys_GetUtilSysdepData passed NULL.\n"));
                status = FALSE;
        }
	

        if (! pi->mppSys_ValidatePath )
        {
                MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 145, "mppCmn_RegisterSysInterface :: Required function pointer mppSys_ValidatePath passed NULL.\n"));
                status = FALSE;
        }


        if (! pi->mppSys_CopyRdacInfoToUser )
        {
                MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 146, "mppCmn_RegisterSysInterface :: Required function pointer mppSys_CopyRdacInfoToUser passed NULL.\n"));
                status = FALSE;
        }

		// 07/20/06 - CR 109208.  Added sysdep method for queuing worker thread requests.
		if (! pi->mppSys_QueueRequest)
		{
			MPP_ERRORLOGPRINT((MPP_ERR_FATAL, 147, "mppCmn_RegisterSysInterface :: Required function pointer mppSys_QueueRequest passed NULL.\n"));
			status = FALSE;
		}


	/************* CHECK for  all OPTIONAL functions ***********/

	/************* Attach default if pointer is null ***********/
	if(! pi->mpp_IsOkayToClearRdacLuns )	
	{
		pi->mpp_IsOkayToClearRdacLuns		= mppCmn_default_IsOkayToClearRdacLuns;
	}

	if(! pi->mpp_RemoveControllerDirectory )
	{
		pi->mpp_RemoveControllerDirectory	= mppCmn_default_RemoveControllerDirectory;
	}

	if(! pi->mpp_ThreadDelay )
	{
		pi->mpp_ThreadDelay			= mppCmn_default_ThreadDelay;
	}
	
	if(! pi->mppSys_AreControllerPathsFailed )
	{
		pi->mppSys_AreControllerPathsFailed	= mppCmn_default_AreControllerPathsFailed;
	}

	if(! pi->mpp_CreateUtmDevice )
	{
		 pi->mpp_CreateUtmDevice		=  mppCmn_default_CreateUtmDevice;
	}

	if(! pi->mpp_RemoveUTM )
	{
		pi->mpp_RemoveUTM			= mppCmn_default_RemoveUTM;
	}

	if(! pi->mpp_RemoveLunLink )
	{
		pi->mpp_RemoveLunLink			= mppCmn_default_RemoveLunLink;
	}

	if(! pi->mpp_RemoveVirtualLun )
	{
		pi->mpp_RemoveVirtualLun		= mppCmn_default_RemoveVirtualLun;
	}
	
	if(! pi->mpp_CheckPathGood )
	{
		pi->mpp_CheckPathGood			= mppCmn_default_CheckPathGood; 	
	}

	if(! pi->mpp_makeVirtualTarget )
	{
		pi->mpp_makeVirtualTarget 		= mppCmn_default_makeVirtualTarget;
	}
	
	if(! pi->mpp_CreateControllerVertex )
	{
		pi->mpp_CreateControllerVertex 		= mppCmn_default_CreateControllerVertex;
	}

	if(! pi->mpp_CreateLunLink)
	{
		pi->mpp_CreateLunLink 			= mppCmn_default_CreateLunLink;
	}
	
	if(! pi->mpp_RemovePathDirectory)
	{
		pi->mpp_RemovePathDirectory 		= mppCmn_default_RemovePathDirectory;
	}
	
	if(! pi->mpp_RemoveModule) 
	{
		pi->mpp_RemoveModule 			= mppCmn_default_RemoveModule;
	}

	if(! pi->mppSys_DeviceAlreadyDiscovered) 
	{
		pi->mppSys_DeviceAlreadyDiscovered 	= mppCmn_default_DeviceAlreadyDiscovered;
	}
	
	if(! pi->mppSys_PrintSenseBuffer )
	{
		pi->mppSys_PrintSenseBuffer		= mppCmn_default_PrintSenseBuffer;
	}

	if(! pi->mppSys_AcquireReferenceCount )
	{
		pi->mppSys_AcquireReferenceCount	= mppCmn_default_AcquireReferenceCount;
	}

	if(! pi->mppSys_ReleaseReferenceCount )
	{
		pi->mppSys_ReleaseReferenceCount	= mppCmn_default_ReleaseReferenceCount;
	}

	if(! pi->mppSys_IsConfiguredDevice )
	{
		pi->mppSys_IsConfiguredDevice		= mppCmn_default_IsConfiguredDevice;
	}

	if(! pi->mppSys_PreFailoverProcessing )
	{
		pi->mppSys_PreFailoverProcessing	= mppCmn_default_PreFailoverProcessing;
	}

	if(! pi->mppSys_PostFailoverProcessing )
	{
		pi->mppSys_PostFailoverProcessing	= mppCmn_default_PostFailoverProcessing;
	}
	
	return status;
}	

/****************************************************************************
* PROCEDURE
* NAME:    mppCmn_default_IsOkayToClearRdacLuns
* STATUS:  OPTIONAL
* SUMMARY: Determine whether the RdacLun structure can be initialized to zero 
* SCOPE:   public 
* ARGUMENTS:
*       RdacInfo        - Pointer to RdacInfo structure
*       Lun             - Lun number
* DESCRIPTION: Dummy routine
* RESTRICTIONS:
* RETURNS: Returns 1 
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:  
****************************************************************************/
OPTIONAL LWORD  
mppCmn_default_IsOkayToClearRdacLuns(IN RdacDeviceInformation_t *RdacInfo, IN LWORD Lun)
{
	return(1);
}

/**************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_default_RemoveControllerDirectory
* SUMMARY:  Remove a controller directory object from the Object Manager hierarc hy
* SCOPE:    local
* ARGUMENTS:
*       DeviceVertex    - Pointer to the RDAC device object
*       RdacInfo        - Pointer to the RdacInfo structure
*       Controller      - Controller index
*
* DESCRIPTION: Dummy Routine
*
* RESTRICTIONS:
*
* RETURNS:
*       None
*************************************************************************/

OPTIONAL void
mppCmn_default_RemoveControllerDirectory(IN MPP_HANDLE DeviceVertex, IN RdacDeviceInformation_t *RdacInfo, IN BYTE Controller)
{
                return;
}

/****************************************************************************
* PROCEDURE
* NAME:    mppCmn_default_ThreadDelay
* SUMMARY: MPP function that introduces delay
* SCOPE:   public
* DESCRIPTION: This routine provides introduces delay by sleep and wakeup
*               mechanism instead of busy waiting like udelay.
*
*               DelayTime       = No. of DelayResolution Units
*               DelayReolustion = delay in secs, millisecs ..etc
*		This is a Dummy Routine.
*
* RESTRICTIONS:  
* RETURNS: void
* ERRNO:
* NOTES:  
* EXAMPLES:
* SEE ALSO:
****************************************************************************/
OPTIONAL void
mppCmn_default_ThreadDelay(IN ULONG DelayTime, IN ULONG DelayResolution)
{
        return;
}


/****************************************************************************
* PROCEDURE
* NAME:    mppCmn_default_AreControllerPathsFailed
* SUMMARY: Checks if all paths to the controller are failed.
* SCOPE:   public
* DESCRIPTION:
*   This function returns FALSE all the times. This is a Dummy Routine. 
* RESTRICTIONS:
* RETURNS: FALSE
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/

OPTIONAL LWORD
mppCmn_default_AreControllerPathsFailed(RdacDeviceInformation_t *RdacInfo, BYTE ControllerIndex, LWORD lun) 
{
        return FALSE;
}

/*******************************************************************************

* PROCEDURE
* NAME:     mppCmn_default_CreateUtmDevice
* SUMMARY:  On Linux, this function returns the DeviceHandle for UTM Device.
* SCOPE:    public
* ARGUMENTS:
* DESCRIPTION: 
*		Dummy function that returns DeviceVertex.
* RESTRICTIONS:
* RETURNS:
*		DeviceVertex
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/

OPTIONAL MPP_HANDLE
mppCmn_default_CreateUtmDevice(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t    *RdacInfo, BYTE ControllerIndex,
                                                                BYTE Path, LWORD        Lun)
{
        return((MPP_HANDLE) DeviceVertex);

}


/****************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_RemoveUTM
* SUMMARY:  mppCmn_default_RemoveUtmDevice is called to remove node(s) that are associated with the argument
* UTM LUN from the system.
* SCOPE:    private
* DESCRIPTION:  Since our mpp driver is no longer a UTM driver and leaves the UTM devices to the
* sg driver, this function is a dummy function.
* RESTRICTIONS:
* RETURNS:
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/

OPTIONAL void
mppCmn_default_RemoveUTM(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun)
{
        return;
}


/****************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_RemoveLunLink
* SUMMARY:  mppCmn_default_RemoveLunLink removes the OS device directories and object graphs, if applicable,
* to indicate the existence of the path to the logical unit.
* SCOPE:    private
* DESCRIPTION:  Since mknod facility will make the /dev entry, this routine will be just be a
* NULL function for linux.
* RESTRICTIONS:
* RETURNS:
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/

OPTIONAL void
mppCmn_default_RemoveLunLink(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun)
{

        return;
}


/****************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_RemoveVirtualLun
* SUMMARY:  mppCmn_default_RemoveVirtualLun is called to remove node(s) that are associated with the argument
* virtual LUN from the system.
* SCOPE:    private
* DESCRIPTION:   This is a dummy function .
* RESTRICTIONS:
* RETURNS:
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/

OPTIONAL void
mppCmn_default_RemoveVirtualLun(RdacDeviceInformation_t *RdacInfo, LWORD Lun)
{
                return;
}


/****************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_CheckPathGood
* SUMMARY:  mppCmn_default_CheckPathGood verifies that the OS has not "torn down" its structure for the
* controller, path and LUN.
* SCOPE:    private
* DESCRIPTION: Dummy Function
* RESTRICTIONS:
* RETURNS: 1
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/

OPTIONAL LWORD
mppCmn_default_CheckPathGood(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun)
{
                return(1);
}


/*******************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_makeVirtualTarget
* SUMMARY:
* SCOPE:    public
* ARGUMENTS:
*       targ - Instance Id
* DESCRIPTION: Dummy Function
* RESTRICTIONS:
* RETURNS:
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/

MPP_DIR_HANDLE
mppCmn_default_makeVirtualTarget(targ_t targ)
{
	return((MPP_DIR_HANDLE)     1);
}


/*******************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_CreateControllerVertex
* SUMMARY:   This is a dummy fuction
* SCOPE:    public
* DESCRIPTION: This is a dummy fuction
*  @RdacInfo A RdacDeviceInformation_t object that repesents a storage array
*  @ControllerIndex Indicates a controller's slot in a storage array
*  @path The index of the controler path
*  @DeviceAddress The Linux physical address of the path's I_T nenux. The DeviceAddress
*      object contains host id (HBA ID), channel, and target ID.
* RESTRICTIONS:
* RETURNS: 
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/

MPP_DIR_HANDLE
mppCmn_default_CreateControllerVertex ( RdacDeviceInformation_t *RdacInfo, BYTE ControllerIndex, BYTE Path, ControllerAddress_t *DeviceAddress)
{
	return (MPP_DIR_HANDLE)1;	
}


/****************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_CreateLunLink
* SUMMARY:  mppCmn_default_CreateLunLink updates the OS device directories and object graphs, if applicable,
* to indicate the existence of the path to the logical unit.
* SCOPE:    private
* DESCRIPTION: THIS IS A DUMMY FUNCTION
* RESTRICTIONS:
* RETURNS:
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/
void
mppCmn_default_CreateLunLink(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE ControllerIndex, BYTE PathIndex, LWORD Lun)
{
                return;
}


/*******************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_RemovePathDirectory
* SUMMARY:  DUMMY FUNCTION
* SCOPE:    public
* DESCRIPTION: THIS IS A DUMMY WRAPPER FUNCTION.
   @DeviceVertex A MPP_HANDLE that represents the vertex of the controller
         directory. It is not used in the Linux mpp driver.
*  @RdacInfo A RdacDeviceInformation_t object that repesents a storage array
*  @ControllerIndex Indicates a controller's slot in a storage array
*  @path The index of the controller path
* RESTRICTIONS:
* RETURNS: void
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/
void
mppCmn_default_RemovePathDirectory(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path)
{
                return;
}


/*******************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_RemoveModule
* SUMMARY:  Remove system resources for the storage array module
* SCOPE:    public
* DESCRIPTION:    THIS IS A DUMMY WRAPPER FUNCTION.
* RESTRICTIONS:
* RETURNS:
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/
void
mppCmn_default_RemoveModule(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo)
{
        return;
}

/*******************************************************************************
* PROCEDURE
*
* NAME:     mppCmn_default_DeviceAlreadyDiscovered
* SUMMARY:  MPP function that goes through RdacInfo data structure to find if a device has already
* been discovered
* SCOPE:    local
*
* DESCRIPTION: THIS IS A DUMMY WRAPPER FUNCTION
* RESTRICTIONS:
*
* RETURNS: 0
****************************************************************************/
LWORD
mppCmn_default_DeviceAlreadyDiscovered(MPP_HANDLE Devicepnt, LWORD Lun)
{
        return(0);
}

/*******************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_PrintSenseBuffer
* SUMMARY:  Dummy wraper function to print sense buffer
* SCOPE:    public
* DESCRIPTION:    THIS IS A DUMMY WRAPPER FUNCTION.
* RESTRICTIONS:
* RETURNS:
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/
OPTIONAL void 
mppCmn_default_PrintSenseBuffer ( IN RdacDeviceInformation_t *RdacInfo, IN LWORD Controller, 
				  IN  LWORD Path,IN void *SenseBuffer,IN ULONG SerialNumber)
{
        return;
}

/*******************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_AcquireReferenceCount
* SUMMARY:  Dummy wraper function to acquire a reference count
* SCOPE:    public
* DESCRIPTION:    THIS IS A DUMMY WRAPPER FUNCTION.
* RESTRICTIONS:
* RETURNS:
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/
OPTIONAL LWORD 
mppCmn_default_AcquireReferenceCount(IN MPP_HANDLE DeviceVertex)
{
        return(MPP_GOOD_STATUS);
}

/*******************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_ReleaseReferenceCount
* SUMMARY:  Dummy wraper function to release a reference count
* SCOPE:    public
* DESCRIPTION:    THIS IS A DUMMY WRAPPER FUNCTION.
* RESTRICTIONS:
* RETURNS:
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/
OPTIONAL void 
mppCmn_default_ReleaseReferenceCount(IN MPP_HANDLE DeviceVertex)
{
        return;
}

/*******************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_IsConfiguredDevice
* SUMMARY:  Returns a TRUE statement indicating a given Lun is configured for this array.
* SCOPE:    public
* DESCRIPTION:    THIS IS A DUMMY WRAPPER FUNCTION.
* RESTRICTIONS:
* RETURNS:
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/
OPTIONAL BOOL 
mppCmn_default_IsConfiguredDevice(IN MPP_HANDLE DeviceVertex, IN ControllerAddress_t *DeviceAddress, IN LWORD Lun)
{
        return(TRUE);
}

/*******************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_PreFailoverProcessing
* SUMMARY:  Does nothing as the default action.
* SCOPE:    public
* DESCRIPTION:    THIS IS A DUMMY WRAPPER FUNCTION.
* RESTRICTIONS:
* RETURNS:
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/
OPTIONAL VOID
mppCmn_default_PreFailoverProcessing(IN RdacDeviceInformation_t *RdacInfo, IN BYTE ControllerIndex, IN MPPCMN_FAILOVER_METHOD FailoverMethod)
{
	return;
}

/*******************************************************************************
* PROCEDURE
* NAME:     mppCmn_default_PostFailoverProcessing
* SUMMARY:  Does nothing as the default action.
* SCOPE:    public
* DESCRIPTION:    THIS IS A DUMMY WRAPPER FUNCTION.
* RESTRICTIONS:
* RETURNS:
* ERRNO:
* NOTES:
* EXAMPLES:
* SEE ALSO:
****************************************************************************/
OPTIONAL VOID
mppCmn_default_PostFailoverProcessing(IN RdacDeviceInformation_t *RdacInfo, IN BYTE ControllerIndex, IN MPPCMN_FAILOVER_METHOD FailoverMethod)
{
	return;
}
