/*******************************************************************************
*  Copyright 2004-2007 LSI Logic Corporation.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            mppLnx26p_vhbamisc.c
SUMMARY         %description%
VERSION         %version: 4 %
UPDATE DATE     %date_modified: Thu Apr 03 13:50:26 2008 %
PROGRAMMER      %created_by:    bmoger %


DESCRIPTION:This file contains miscellaneous functions that are used in the 
Linux MPP virtual HBA driver.

INCLUDE FILES:

NOTES:

RESTRICTIONS:

SEE ALSO:

REFERENCE:
  349-1033500 Linux MPP Driver Feature Architecture Specification
  349-1034610 Linux MPP Virtual HBA Driver Feature Design Document
  349-1034750 Linux MPP Upper Level Driver Feature Design Document
  349-1034730 Linux MPP Utility Feature Design Document
  349-1034620 Linux MPP Installation Feature Design Document
  349-1043860 Linux MPP Driver for Linux 2.6 Kernel


IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/

#define __SRCmppLnx26p_vhbamisc_c

/***  INCLUDES  ***/  
/***  Linux kernel INCLUDES  ***/  
#include <linux/module.h>

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/errno.h>
#include <linux/timer.h>
#include <linux/types.h>
#include <linux/string.h>
#include <linux/genhd.h>
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/smp_lock.h>
#include <linux/vmalloc.h>
#include <linux/spinlock.h>
#include <linux/list.h>
#include <linux/interrupt.h>
#include <scsi/scsi_host.h>

#include <asm/io.h>

#include <linux/blkdev.h>

#include <linux/stat.h>

/***  MPP commomn API INCLUDES  ***/  
#include "MPP_Common.h"
#include "MPP_RdacInfo.h"
#include "MPP_ProtoTypes.h"
#include "MPP_Sysdep.h"
#include "mppLnx_version.h"
/***  Linux MPP Virtual HBA INCLUDES  ***/  
#include "mppLnx26p_vhba.h"
#include "mppLnx26p_shared.h"


/***  CONSTANT DEFINITIONS  ***/


/***  MACRO DEFINITIONS  ***/


/***  TYPE DEFINITIONS  ***/


/***  LOCALS  ***/


/***  PROCEDURES  ***/

/*******************************************************************************
* PROCEDURE
*
* NAME:     mppLnx_dumpCmnd
* SUMMARY:  Dumps the content of a struct scsi_cmnd object.
* SCOPE:   local
*
*
* DESCRIPTION:
   Dumps the content of a struct scsi_cmnd object. This function is used only for
   debugging

* @SCnp The struct scsi_cmnd object to be dumped.
* RESTRICTIONS:
*   This function is only complied to the driver module when MPP_DEBUG is on.
* 
* RETURNS:
*
* ERRNO:
*
* NOTES:
*
* EXAMPLES:
*
* SEE ALSO:
*
*/
#ifdef MPP_DEBUG

void mppLnx_dumpCmnd(struct scsi_cmnd * SCnp)
{
   char tmpBuffer[4096];
   int len;
   int cmdSize = 0;
   int i,s;
   printk("struct scsi_cmnd dump:\n");
   printk("\tcommand id. device h%dc%dt%dl%d\n",
      SCnp->device->host->host_no, SCnp->device->channel, SCnp->device->id, SCnp->device->lun); 
   printk("\t eh_eflags %d\n",SCnp->eh_eflags);
   printk("\t done function address 0x%lx\n",(unsigned long)SCnp->done);
   printk("\tserial number %ld\n", SCnp->serial_number);

   printk("\t retires %d\n",SCnp->retries);
   printk("\t allowed %d\n",SCnp->allowed);
   printk("\t timeout_per_command %d seconds \n",SCnp->timeout_per_command/HZ);
   printk("\t cmd_len %d\n",SCnp->cmd_len);
   printk("\t sc_data_direction 0x%x\n",SCnp->sc_data_direction);
   printk("\t cmnd:\n");
   cmdSize=COMMAND_SIZE(SCnp->cmnd[0]);
   if(unlikely(cmdSize > MAX_COMMAND_SIZE))
   {
      printk("\tInvalid scsi command op code %x\n",SCnp->cmnd[0]);
   }
 
   if(likely(cmdSize <= MAX_COMMAND_SIZE))
   {
      printk("\t opcode:%02x ", SCnp->cmnd[0]);

      for ( i = 1, s = COMMAND_SIZE(SCnp->cmnd[0]); i < s; ++i) 
         printk("%02x ", SCnp->cmnd[i]);
      
      printk("\n");
   }
   printk("\t request_bufflen %d\n", SCnp->request_bufflen);
   if(SCnp->request_bufflen >2048)
   {
      len = 2048;
   }
   else
   {
      len = SCnp->request_bufflen;
   }
   memset(tmpBuffer, 0, 4096);
   mppLnx_BytestoAscii(tmpBuffer, SCnp->request_buffer, len);
   printk("\t request_buffer %s\n", tmpBuffer);

   printk("\t use_sg %d\n", SCnp->use_sg);
   printk("\t sglist_len %d\n", SCnp->sglist_len);

   printk("\t underflow %d\n", SCnp->underflow);
   printk("\t transfersize %d\n",SCnp->transfersize);
   printk("\tn resid %d\n",SCnp->resid);
   printk("\t request struct address 0x%lx\n",(unsigned long)&SCnp->request);
   memset(tmpBuffer, 0 , 4096);
   len = sizeof(SCnp->sense_buffer);
   mppLnx_BytestoAscii(tmpBuffer, SCnp->sense_buffer, len);
   printk("\t sense_buffer %s\n",tmpBuffer);
   printk("\t scsi_done function address 0x%lx\n",(unsigned long)SCnp->scsi_done);
   printk("\t SCp struct address 0x%lx\n",(unsigned long)&SCnp->SCp);
   printk("\t host_scribble address 0x%lx\n",(unsigned long)&SCnp->host_scribble);
   printk("\t result 0x%d\n",SCnp->result);
   printk("\t tag %d\n",SCnp->tag);
   printk("\t pid %ld\n", SCnp->pid);
}
#endif
/*******************************************************************************
* PROCEDURE
*
* NAME:     mppLnx_BytestoAscii
* SUMMARY:  Converts a sequence of bytes to its ASCII representation
* SCOPE:   local
    local
*
*
* DESCRIPTION:
   This function takes a char buffer as input and converts the buffer to 
   ASCII string.

* @ascii The ascii string of the input buff. The length of ascii must be equale
         or greater than 2*bufflen. Output
  @buff  a char buffer whose content will be converted to ascii string. Input
  @bufflen the length of the buff. Input
* RESTRICTIONS:
* 
* RETURNS:
*
* ERRNO:
*
* NOTES:
*
* EXAMPLES:
*
* SEE ALSO:
*
*/
void mppLnx_BytestoAscii(char *ascii, char *buff, int bufflen)
{
	int	count;

	for(count = 0; count < bufflen; count++)
		sprintf(&ascii[count*2], "%02x", buff[count]);
}

#ifdef MPP_DEBUG
/*******************************************************************************
* PROCEDURE
*
* NAME:     mppLnx_dump_mppLnx_PDeviceEntry
* SUMMARY:  Dump the content of a mppLnx_PDeviceEntry_t object
* SCOPE:   local
*
*
* DESCRIPTION:
   This function dumps the content of a mppLnx_PDeviceEntry_t object.
   It is used for debugging only

* @pde a pointer to an mppLnx_PDeviceEntry_t object whose the content
   will be dumped. 
     
* RESTRICTIONS:
This function is only complied to the driver module when MPP_DEBUG is on.
* 
* RETURNS:
*
* ERRNO:
*
* NOTES:
*
* EXAMPLES:
*
* SEE ALSO:
*
*/

void mppLnx_dump_PDeviceEntry(mppLnx_PDeviceEntry_t * pde)
{
   printk("mppLnx_PDeviceEntry dump:\n");

   printk("\tcontrollerSlot %d\n",pde->controllerSlot);


   printk("\tioCount %d\n",pde->ioCount);
   printk("\tioFails %d\n",pde->ioFails);
   printk("\tlongestTrip %d\n",pde->longestTrip);
   printk("\tpathId %d\n",pde->pathId);
   printk("\tporcNode Name %s\n",(char *)pde->procNode.nodeName);
   printk("\t Array name %s\n",(char *)pde->rdacInfo->ModuleName);
   printk("\tshortestTrip %d\n",pde->shortestTrip);
   printk("\tphysical Device h%dc%dt%dl%d\n",
      pde->pdevice->host->host_no, pde->pdevice->channel,
      pde->pdevice->id, pde->pdevice->lun);
}
#endif


#ifdef MPP_DEBUG
/*******************************************************************************
* PROCEDURE
*
* NAME:     mppLnx_dump_struct scsi_host_template
* SUMMARY:  Dump the content of a list of a struct scsi_host_template object
* SCOPE:   local
*
*
* DESCRIPTION:
   This function dumps the context of a struct scsi_host_template object.
   This function is only for debugging

* sht a pointer to the first entry of the struct scsi_host_template object
* RESTRICTIONS:
This function is only complied to the driver module when MPP_DEBUG is on.
* 
* RETURNS:
*
* ERRNO:
*
* NOTES:
*
* EXAMPLES:
*
* SEE ALSO:
*
*/

void mppLnx_dump_Scsi_Host_Template(struct scsi_host_template *sht)
{
   printk("======== struct scsi_host_template %s ========\n",sht->name);
   printk("       sht->proc_name = %s\n",    sht->module->name);
   printk("       sht->can_queue = %d\n",    sht->can_queue);
   printk("       sht->this_id = %d\n",    sht->this_id);
   printk("       sht->sg_tablesize = %d\n",    sht->sg_tablesize);
   printk("       sht->max_sectors = %d\n",    sht->max_sectors);
   printk("       sht->dma_boundary = 0x%lx\n", sht->dma_boundary);
   printk("       sht->cmd_per_lun = %d\n",    sht->cmd_per_lun);
   printk("       sht->present = %d\n",    sht->present);
   printk("       sht->unchecked_isa_dma = %d\n",    sht->unchecked_isa_dma);
   printk("       sht->use_clustering = %d\n",    sht->use_clustering);
   printk("       sht->emulated = %d\n",    sht->emulated);
}

#endif



#ifdef MPP_DEBUG
/*******************************************************************************
* PROCEDURE
*
* NAME:     mppLnx_dump_Scsi_Host
* SUMMARY:  Dump the content of a Scsi_Host object
* SCOPE:   local
*
*
* DESCRIPTION:
   This function dumps the context of a Scsi_Host object.
   This function is only for debugging

* @shp a pointer to the Scsi_Host object
* RESTRICTIONS:
This function is only complied to the driver module when MPP_DEBUG is on.
* 
* RETURNS:
*
* ERRNO:
*
* NOTES:
*
* EXAMPLES:
*
* SEE ALSO:
*
*/

void mppLnx_dump_Scsi_Host(struct Scsi_Host *shp)
{
   struct device *pgendevice;
   u64 * dma_mask;
   pgendevice = scsi_get_device(shp);
   dma_mask = pgendevice->dma_mask;
   if(NULL == shp)
   {
      printk(KERN_ERR "%s: sh = NULL\n", __FUNCTION__);
      return;
   }
   printk("=== Scsi_Host %d ======\n",shp->host_no);
   if(shp->hostt->proc_name != NULL)
   {
      printk("       proc_name = %s\n",shp->hostt->proc_name);
   }else
   {
      printk("       proc_name = %s\n",shp->hostt->module->name);
   }
   printk("       shp->host_busy = %d\n",shp->host_busy);
   printk("       shp->host_failed = %d\n",    shp->host_failed);
   printk("       shp->resetting = %d\n", shp->resetting);
   printk("       shp->last_reset = %ld\n",    shp->last_reset);
   printk("       shp->max_channel = %d\n",    shp->max_channel);
   printk("       shp->max_lun = %d\n",    shp->max_lun);
   printk("       shp->max_id = %d\n",    shp->max_id);
   printk("       shp->unique_id = %d\n",    shp->unique_id);
   printk("       shp->max_cmd_len = %d\n",    shp->max_cmd_len);
   printk("       shp->this_id = %d\n",    shp->this_id);
   printk("       shp->can_queue = %d\n",    shp->can_queue);
   printk("       shp->cmd_per_lun = %d\n",    shp->cmd_per_lun);
   printk("       shp->sg_tablesize = %d\n",    shp->sg_tablesize);
   printk("       shp->max_sectors = %d\n",    shp->max_sectors);
   printk("       shp->dma_boundary = 0x%lx\n", shp->dma_boundary);
   printk("       shp->unchecked_isa_dma = %d\n",    shp->unchecked_isa_dma);
   printk("       shp->use_clustering = %d\n",    shp->use_clustering);
   printk("       shp->use_blk_tcq = %d\n",  shp->use_blk_tcq);
   printk("       shp->host_self_blocked = %d\n",    shp->host_self_blocked);
   printk("       shp->reverse_ordering = %d\n",   shp->reverse_ordering);
   printk("       shp->host_blocked = %d\n",    shp->host_blocked);
   printk("       shp->max_host_blocked = %d\n", shp->max_host_blocked);

   if ( dma_mask != NULL )
      printk("       parent dma_mask = 0x%llx\n", *dma_mask);
   else
      printk("       parent dma_mask = NULL\n");

   printk("       shp->base = %ld\n",    shp->base);
   printk("       shp->dma_channel = %d\n",    shp->dma_channel);
   printk("       shp->host_no = %d\n",    shp->host_no);
   printk("       shp->host_blocked = %d\n",    shp->host_blocked);
   printk("       shp->host_self_blocked = %d\n",    shp->host_self_blocked);
   printk("       shp->io_port = %ld\n",    shp->io_port);
}
#endif

#ifdef MPP_DEBUG
/*******************************************************************************
* PROCEDURE
*
* NAME:     mppLnx_dump_Scsi_Host
* SUMMARY:  Dump the content of a Scsi_Host object
* SCOPE:   local
*
*
* DESCRIPTION:
   This function dumps the context of a Scsi_Host object.
   This function is only for debugging

* @shp a pointer to the Scsi_Host object
* RESTRICTIONS:
This function is only complied to the driver module when MPP_DEBUG is on.
* 
* RETURNS:
*
* ERRNO:
*
* NOTES:
*
* EXAMPLES:
*
* SEE ALSO:
*
*/
void mppLnx_dumpReadWriteCdb(struct scsi_cmnd *command)
{
   unsigned char  *cmd = command->cmnd;
   unsigned int   lba;
   unsigned int   tranlen;
   char           *diskname;
   /*
   * if the cdb is a read/write cdb, dump its LBA address and transfer length.
   * the current task's name (process name) will be dumped as well.
   * the debug traces will help us to understand what user space processes performing
   * disk access during host boot time and how an application read/write IOS are split to
   * smaller block IOs
   */
   diskname = command->request->rq_disk ? command->request->rq_disk->disk_name : "--";
   if(*cmd == READ_6)
   {
      lba =  MPPLNX_GET_LWORD_FROM_2BYTES(cmd+2);
      tranlen = *(cmd+4);
      MPP_DEBUGPRINT((MPP_RETRY_DEBUG+MPP_DEBUG_LEVEL_2,
         "disk:%s SN=%ld VD=H:%dC:%dT:%dL:%d process:%s opcode READ_6 LBA:0x%x:TranLen:0x%x\n",
         diskname,
         command->serial_number, command->device->host->host_no, command->device->channel,
         command->device->id, command->device->lun, 
         current->comm,lba,tranlen));

   }
   if(*cmd == WRITE_6)
   {
      lba =  MPPLNX_GET_LWORD_FROM_2BYTES(cmd+2);
      tranlen = *(cmd+4);
      MPP_DEBUGPRINT((MPP_RETRY_DEBUG+MPP_DEBUG_LEVEL_2,
         "disk:%s SN=%ld VD=H:%dC:%dT:%dL:%d  process: %s opcode WRITE_6 LBA:0x%x:TranLen:0x%x\n",
         diskname,
         command->serial_number, command->device->host->host_no, command->device->channel,
         command->device->id, command->device->lun, 
         current->comm,lba,tranlen));
   }
   if( *cmd == READ_10 )
   {
      lba =  MPPLNX_GET_LWORD_FROM_4BYTES(cmd+2);
      tranlen = MPPLNX_GET_LWORD_FROM_2BYTES(cmd+7);
      MPP_DEBUGPRINT((MPP_RETRY_DEBUG+MPP_DEBUG_LEVEL_2,
         "disk:%s SN=%ld VD=H:%dC:%dT:%dL:%d  process: %s opcode READ_10 LBA:0x%x:TranLen:0x%x\n",
         diskname,
         command->serial_number, command->device->host->host_no, command->device->channel,
         command->device->id, command->device->lun, 
         current->comm,lba,tranlen));
   }
   if(*cmd == WRITE_10)
   {
      lba =  MPPLNX_GET_LWORD_FROM_4BYTES(cmd+2);
      tranlen = MPPLNX_GET_LWORD_FROM_2BYTES(cmd+7);
      MPP_DEBUGPRINT((MPP_RETRY_DEBUG+MPP_DEBUG_LEVEL_2,
         "disk:%s SN=%ld VD=H:%dC:%dT:%dL:%d  process: %s opcode WRITE_10 LBA:0x%x:TranLen:0x%x\n",
         diskname,
         command->serial_number, command->device->host->host_no, command->device->channel,
         command->device->id, command->device->lun, 
         current->comm,lba,tranlen));
   }

   if( *cmd == READ_12 )
   {
      lba =  MPPLNX_GET_LWORD_FROM_4BYTES(cmd+2);
      tranlen = MPPLNX_GET_LWORD_FROM_4BYTES(cmd+6);
      MPP_DEBUGPRINT((MPP_RETRY_DEBUG+MPP_DEBUG_LEVEL_2,
         "disk:%s SN=%ld VD=H:%dC:%dT:%dL:%d  process: %s opcode READ_12 LBA:0x%x:TranLen:0x%x\n",
         diskname,
         command->serial_number, command->device->host->host_no, command->device->channel,
         command->device->id, command->device->lun, 
         current->comm,lba,tranlen));
   }

   if(*cmd == WRITE_12)
   {
      lba =  MPPLNX_GET_LWORD_FROM_4BYTES(cmd+2);
      tranlen = MPPLNX_GET_LWORD_FROM_4BYTES(cmd+6);
      MPP_DEBUGPRINT((MPP_RETRY_DEBUG+MPP_DEBUG_LEVEL_2,
         "disk:%s SN=%ld VD=H:%dC:%dT:%dL:%d  process: %s opcode WRITE_12 LBA:0xx%x:TranLen:0x%x\n",
         diskname,
         command->serial_number, command->device->host->host_no, command->device->channel,
         command->device->id, command->device->lun, 
         current->comm,lba,tranlen));
   }
   
}
   
#endif


/**
 * scsi_add_timer - Start timeout timer for a single scsi command.
 * @scmd:	scsi command that is about to start running.
 * @timeout:	amount of time to allow this command to run.
 * @complete:	timeout function to call if timer isn't canceled.
 *
 * Notes:
 *    This should be turned into an inline function.  Each scsi command
 *    has its own timer, and as it is added to the queue, we set up the
 *    timer.  When the command completes, we cancel the timer.
 **/
void mppLnx_scsi_add_timer(struct scsi_cmnd *scmd, int timeout,
		    void (*complete)(struct scsi_cmnd *))
{
    
	/*
	 * If the clock was already running for this command, then
	 * first delete the timer.  The timer handling code gets rather
	 * confused if we don't do this.
	 */
	if (scmd->eh_timeout.function)
		del_timer(&scmd->eh_timeout);

	scmd->eh_timeout.data = (unsigned long)scmd;
	scmd->eh_timeout.expires = jiffies + timeout;
	scmd->eh_timeout.function = (void (*)(unsigned long)) complete;


	add_timer(&scmd->eh_timeout);
}

/**
 * scsi_delete_timer - Delete/cancel timer for a given function.
 * @scmd:	Cmd that we are canceling timer for
 *
 * Notes:
 *     This should be turned into an inline function.
 *
 * Return value:
 *     1 if we were able to detach the timer.  0 if we blew it, and the
 *     timer function has already started to run.
 **/
int mppLnx_scsi_delete_timer(struct scsi_cmnd *scmd)
{
	int rtn;

	rtn = del_timer(&scmd->eh_timeout);


	scmd->eh_timeout.data = (unsigned long)NULL;
	scmd->eh_timeout.function = NULL;

	return rtn;
}

/*
* This is the implementation of using kernel public APIs "symbol_get" and "symbol_put" to replace
* inter module communication APIs that are deprecated. 
*
* The following symbols are used by the mppUpper driver module. Since the mppVhba driver 
* module must use the common functions that are built into the mppUpper driver module, 
* the mppVhba driver depends on the mppUpper driver module. Since the mppUpper driver must 
* use the following symbols, this creates a circular dependency problem of the modules.
*
* We exports the following symbols to the public but the mppUpper driver module can not use 
* those symbols directly to avoid circular dependency. It must use "symbol_get" and "symbol_put"
* to retrieve those symbols.
*
* A driver module object defined in linux/module.h contains two arrays of symbols. All the
* symbols are exported symbols. The first list is regular exported symbols and the second 
* list is GPLed exported symbols. The following symbols will go to the regular exported symbol 
* list.
*
*  The exported symbols are part of the contract between the upper level driver module and the
*  virtual HBA driver module. The symbol names can not be changed in one side,
*/
EXPORT_SYMBOL(mppLnx_IssueFailover);
EXPORT_SYMBOL(mppLnx_newDeviceAdded);
EXPORT_SYMBOL(mppLnx_failbackRescan);
EXPORT_SYMBOL(mppLnx_validatepath);
EXPORT_SYMBOL(mppLnx_printsensebuffer);
EXPORT_SYMBOL(mppLnx_vhbaScanHost);
EXPORT_SYMBOL(mppLnx_delete_PdeviceEntry);
EXPORT_SYMBOL(mppLnx_delete_VdeviceEntry);
EXPORT_SYMBOL(mppLnx_wakeup_pathvalidate_thread);
EXPORT_SYMBOL(mppLnx_TestAndGetDevice);
EXPORT_SYMBOL(mppLnx_cleanup_requests_per_scsi_device);
EXPORT_SYMBOL(mppLnx_QueueRequest);

