/*******************************************************************************
* Copyright 2004 Engenio Information Technologies, Inc.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            MPP_Common.h
SUMMARY         %description%
VERSION         %version: 56 %
UPDATE DATE     %date_modified: Wed Feb 13 11:42:32 2008 %
PROGRAMMER      %created_by:    rspencer %

DESCRIPTION:

INCLUDE FILES:

NOTES:

RESTRICTIONS:

SEE ALSO:

REFERENCE:

IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/


#ifndef __INCMPP_Common
#define __INCMPP_Common


/***  INCLUDES  ***/  
#include "MPP_Sysdep.h"




/***  CONSTANT DEFINITIONS  ***/
#define TRUE 1
#define FALSE 0

#ifndef IN
#define IN
#endif

#ifndef OUT
#define OUT
#endif

#ifndef REQUIRED
#define REQUIRED
#endif

#ifndef OPTIONAL
#define OPTIONAL
#endif

/* MPP debug levels */
#define MPP_DEBUG_LOG_ONLY     0x80000000
#define MPP_DEBUG_MEMORY_ONLY  0x40000000
#define MPP_INIT_DEBUG         0x20000000
#define MPP_ATTACH_DEBUG       0x10000000
#define MPP_IOCTL_DEBUG        0x08000000
#define MPP_OPEN_DEBUG         0x04000000
#define MPP_READ_DEBUG         0x02000000
#define MPP_HBA_COMMAND_DEBUG  0x01000000
#define MPP_ABORT_DEBUG	       0x00800000
#define MPP_DUMP_DEBUG	       0x00400000
#define MPP_SYNC_IO_DEBUG      0x00200000
#define MPP_FAILOVER_IO_DEBUG  0x00100000
#define MPP_FAILOVERSCAN_DEBUG 0x00080000
#define MPP_AVTSCAN_DEBUG      0x00040000
#define MPP_UTM_DEBUG          0x00020000
#define MPP_DETACH_DEBUG       0x00010000
#define MPP_ALLOC_DEBUG        0x00008000
#define MPP_PNP_DEBUG          0x00004000
#define MPP_POWER_DEBUG        0x00002000
#define MPP_RESERVE_DEBUG        0x00001000
#define MPP_RETRY_DEBUG        0x00000800
#define	MPP_PATH_VALIDATION_DEBUG 0x00000400
#define MPP_WORKER_THREAD_DEBUG   0x00000200
#define MPP_DEBUG_LEVEL_1 1
#define MPP_DEBUG_LEVEL_2 2
#define MPP_DEBUG_LEVEL_3 4
#define MPP_DEBUG_LEVEL_4 8

/* MPP IO Error Conditions */
#define MPPCMN_EVALUATE_IO_ERROR   0x00000001   // Evaluate condition. If not set, condition is ignored
#define MPPCMN_LUN_CAN_BE_OWNED   0x00000002   // IO Error due to LUN_NOT_OWNED, ASCQ_LUN_CAN_BE_OWNED

#define MPP_DEFAULT_VENDOR_ID "LSI     "
#define MPP_DEFAULT_PRODUCT_ID "VirtualDisk     "
#define MPP_EPOINT "!"
#define MPP_CARET "^"

#define	MPPCMN_VENDOR_ID_LENGTH		8
#define	MPPCMN_PRODUCT_ID_LENGTH	16

#define MPP_PREFIX "mpp_"
#define MINIMUM_MAJOR_REL 4
#define MINIMUM_MINOR_REL 1

/* MPP configuration parameters */
#define MPP_DEBUG_LEVEL "DebugLevel"
#define MPP_NOTREADYWAITTIME "NotReadyWaitTime"
#define MPP_BUSYWAITTIME "BusyWaitTime"
#define MPP_QUIESCENCEWAITTIME "QuiescenceWaitTime"
#define MPP_MAXLUNSPERARRAY "MaxLunsPerArray"
#define MPP_MAXPATHSPERCONTROLLER "MaxPathsPerController"
#define	MPP_INQUIRYWAITTIME "InquiryWaitTime"
#define	MPP_INQUIRYINTERVAL "InquiryInterval"
#define MPP_SCANINTERVAL "ScanInterval"
#define MPP_MAXARRAYMODULES "MaxArrayModules"
#define MPP_VIRTUALADAPTERNAME "VirtualAdapterName"
#define MPP_ERRORLEVEL "ErrorLevel"
#define MPP_VENDORID "VirtualDiskVendorId"
#define MPP_PRODUCTID "VirtualDiskProductId"
#define MPP_SELECTIONTIMEOUTRETRYCOUNT "SelectionTimeoutRetryCount"
#define MPP_COMMANDTIMEOUTRETRYCOUNT "CommandTimeoutRetryCount"
#define MPP_UARETRYCOUNT "UaRetryCount"
#define MPP_RETRYCOUNT "RetryCount"
#define MPP_IDFORMAT "ID%d"
#define MPP_SYNCHTIMEOUT "SynchTimeout"
#define MPP_FAILOVERQUIESCETIME "FailOverQuiescenceTime"
#define MPP_BUSNUMBER "BusNumber"
#define MPP_HOLDALTINRESET "HoldAltInReset"
#define	MPP_CONTROLLERIOWAITTIME "ControllerIoWaitTime"
#define	MPP_ARRAYIOWAITTIME "ArrayIoWaitTime"
#define MPP_FAILOVERTIMEOUT "FailoverTimeout"
#define MPP_FAILBACKTOCURRENTALLOWED "FailBackToCurrentAllowed"
#define MPP_DOUARETRY "DoUaRetry"
#define MPP_S2TOS3KEY "S2ToS3Key"
#define DEVNM_LEN               34
#define MPP_MAXARRAYFAILOVERLENGTH "ArrayFailoverWaitTime"
#define	MPPCMN_RECHECKFAILEDPATHWAITTIME "RecheckFailedPathWaitTime"
#define	MPPCMN_FAILEDPATHCHECKINGINTERVAL "FailedPathCheckingInterval"
#define	MPPCMN_IDLEPATHCHECKINGINTERVAL "IdlePathCheckingInterval"
#define	MPPCMN_PRINTSENSEBUFFER "PrintSenseBuffer"
#define MPPCMN_ANCIENTWAITTIMETHRESHOLD "AncientWaitTimeThreshold"
#define MPPCMN_LUNFAILOVERDELAY "LunFailoverDelay"
#define MPPCMN_CLASSICMODEFAILOVER "ClassicModeFailover"
#define MPPCMN_AVTMODEFAILOVER "AVTModeFailover"
#define	MPPCMN_RETRYFAILOVERDELAY "RetryFailoverDelay"
#define MPPCMN_PRWAITTIME "PRWaitTime"

/* 10/01/04 - Default define values for the configuration parameters.
 * The naming format should be MPPCMN_DEFAULT_<config_name>.
 */
#define	MPPCMN_DEFAULT_DEBUG_LEVEL                      0
#define	MPPCMN_DEFAULT_NOTREADYWAITTIME                 300
#define	MPPCMN_DEFAULT_BUSYWAITTIME                     300
#define	MPPCMN_DEFAULT_QUIESCENCEWAITTIME               300
#define	MPPCMN_DEFAULT_MAXLUNSPERARRAY                  256
#define MPPCMN_DEFAULT_MAXPATHSPERCONTROLLER            4
#define	MPPCMN_DEFAULT_INQUIRYWAITTIME                  60
#define	MPPCMN_DEFAULT_INQUIRYINTERVAL                  1
#define MPPCMN_DEFAULT_SCANINTERVAL                     60
#define MPPCMN_DEFAULT_MAXARRAYMODULES                  30
#define MPPCMN_DEFAULT_ERRORLEVEL                       3
#define MPPCMN_DEFAULT_SELECTIONTIMEOUTRETRYCOUNT       0
#define MPPCMN_DEFAULT_COMMANDTIMEOUTRETRYCOUNT         1
#define MPPCMN_DEFAULT_UARETRYCOUNT                     10
#define MPPCMN_DEFAULT_RETRYCOUNT                       10
#define MPPCMN_DEFAULT_SYNCHTIMEOUT                     120
#define MPPCMN_DEFAULT_FAILOVERQUIESCETIME              20
#define MPPCMN_DEFAULT_HOLDALTINRESET                   0
#define	MPPCMN_DEFAULT_CONTROLLERIOWAITTIME             120
#define	MPPCMN_DEFAULT_ARRAYIOWAITTIME                  240
#define	MPPCMN_DEFAULT_DISABLELUNREBALANCE              0
#define MPPCMN_DEFAULT_FAILOVERTIMEOUT                  120
#define MPPCMN_DEFAULT_FAILBACKTOCURRENTALLOWED         1
#define MPPCMN_DEFAULT_DOUARETRY                        0
#define MPPCMN_DEFAULT_MAXARRAYFAILOVERLENGTH           0
#define	MPPCMN_DEFAULT_RECHECKFAILEDPATHWAITTIME        60
#define	MPPCMN_DEFAULT_FAILEDPATHCHECKINGINTERVAL       60
#define	MPPCMN_DEFAULT_IDLEPATHCHECKINGINTERVAL         60
#define	MPPCMN_DEFAULT_PRINTSENSEBUFFER			        0
#define	MPPCMN_DEFAULT_ANCIENTWAITTIMETHRESHOLD         120
#define MPPCMN_DEFAULT_LUNFAILOVERDELAY			3
#define MPPCMN_DEFAULT_RETRYFAILOVERDELAY				3
#define MPPCMN_DEFAULT_PRWAITTIME						300


/* mpp driver statuses */
#define MPP_GOOD_STATUS	0
#define MPP_CHECK_CONDITION 1
#define MPP_SCSI_BUSY 2
#define MPP_SCSI_RESERVATION 3
#define MPP_UNSUPPORTED_SCSI_STATUS 4
#define MPP_INVALID_REQUEST 5
#define MPP_SELECTION_TIMEOUT 6
#define MPP_HARDWARE_ERROR 7
#define MPP_COMMAND_TIMEOUT 8
#define MPP_COMMAND_ABORTED 9
#define MPP_UNRECOGNIZED_OS_STATUS 10
#define MPP_REQUEST_SENSE_FAILED 11
#define	MPP_REQUEST_PENDING 12
#define MPP_IO_TIMEOUT 13
#define MPP_BUS_RESET 14

/* mpp actions on I/O statuses */
#define MPP_NO_ERROR 0
#define MPP_RETURN_ERROR 1
#define MPP_RETRY_DEC_COUNT 2
#define MPP_RETRY_NO_DEC 3
#define MPP_RETRY_ALTERNATE_CONTROLLER 4
#define MPP_FAILOVER 5
#define MPP_FAILOVER_CONTROLLER 6
#define MPP_FAILOVER_TO_CURRENT 7
#define MPP_FAILOVER_LUN 8

#define MPP_NO_FAILOVER_ERROR 0
#define MPP_RETRY_FAILOVER 1
#define MPP_RETURN_FAILOVER_ERROR 2

/* mpp driver error levels - display error messages when the mpp_ErrorLevel is equal to or less than the level */
#define MPP_ERR_ALL            0  /* display all errors */
#define MPP_ERR_RECOVERED      1  /* display controller failover + path failover + retryable + fatal + recovered errors */
#define MPP_ERR_RETRYABLE      2  /* display controller failover + path failover + retryable + fatal errors */
#define MPP_ERR_PATH_FAILOVER  3  /* display controller failover + path failover + fatal errors */
#define MPP_ERR_CTLR_FAILOVER  4  /* display controller failover + fatal errors */
#define MPP_ERR_FATAL          5  /* display fatal errors only */


#define MPP_VIRTUAL_BUS_TYPE 1
#define MPP_VIRTUAL_DISK_TYPE 2
#define MPP_UTM_DISK_TYPE 3
#define MPP_PHYSICAL_DISK_TYPE 4

/* MPP Virtual Bus ioctls */
#define MPP_IOCTL_GETPATHS  	0x4D01
#define MPP_IOCTL_GETLUNS  	0x4D02
#define MPP_IOCTL_GETRDACINFO  	0x4D03
#define MPP_IOCTL_FAILBACKSCAN 	0x4D04
#define MPP_IOCTL_AVTCHECKSCAN 	0x4D05
#define MPP_IOCTL_AVTPATHSCAN  	0x4D06
#define MPP_IOCTL_SETDEBUG  	0x4D07
#define MPP_IOCTL_SETERROR  	0x4D08
#define MPP_IOCTL_BUSSCAN  	0x4D09
#define MPP_IOCTL_GETMODULES	0x4D0A
#define MPP_IOCTL_UTIL_STATUS   0x4D0B
#define	MPP_IOCTL_OPTIONCONTROL	0x4D0C		// Feature Option Control enhancement
#define	MPP_IOCTL_FORCEREBALANCE	0x4D0D

/* Additional MPP status codes */
#define	MPP_PSEUDO_BUS_ENABLED	1
#define	MPP_PSEUDO_BUS_DISABLED 0

/* Thread Delay Resolutions */
#define	MPPCMN_DELAY_SECONDS	  1
#define	MPPCMN_DELAY_MILLISECONDS 1000

/* mpp_BuildRdacinfo() return status
*  TRUE                       - is a configured LUN
*  FALSE                      - not a storage array device
*  MPPCMN_UNCONFIGURED_LUN    - is a storage array device but is not configured
*  MPPCMN_CONFIG_PARAMETER_OUT_OF_LIMIT - configured parameter (in mpp.conf) overflow
*/
#define  MPPCMN_UNCONFIGURED_LUN                 2
#define  MPPCMN_UNCONFIGURED_LUN_NOTCHECKED      3
#define  MPPCMN_CONFIG_PARAMETER_OUT_OF_LIMIT    4	

/* DisableLunRebalance parameter definitions */
#define	MPPCMN_REBALANCE_ALL			0
#define	MPPCMN_REBALANCE_NON_AVT_MODE	1
#define	MPPCMN_REBALANCE_AVT_MODE		2
#define	MPPCMN_REBALANCE_NONE			3

/*
* Data transfer directions
*/

#define MPPCMN_XFER_HOST_DEV              0   /*data transfer from initiator to target */
#define MPPCMN_XFER_DEV_HOST              1   /*data transfer from target to initiator */
#define MPPCMN_XFER_NONE                  2   /*no data transfer */
#define MPPCMN_XFER_UNKNOWN               3   /*data transfer direction is unknown */

/*
 * ScanTask recovery stages
 * Multi-threading the ScanTask process means each array is checked independently,
 * Given this the driver must know the progress of an array ScanTask operation.
 * At the moment the following states have been defined:
 *
 * NOT_RUNNING : No ScanTask is running for this array.
 * SERVICE_MODE_CHECK : The driver is currently checking the Service Mode status of the controller.
 * GOOD_PATH_CHECK : The driver is currently checking the status of fails that are
 *    unfailed.  At the moment only a check for the firmware version is done.
 * LUN_REBALANCING : The driver is currently performing a lun rebalance on this array.
 *
 * As of 08/05/04 the logic dealing with path recovery has been rewritten therefore it
 * is no longer necessary for ScanTask process to do this.
 */
#define	MPPCMN_SCANTASK_NOT_RUNNING		0x0000
#define	MPPCMN_SCANTASK_SERVICE_MODE_CHECK	0x0001
#define	MPPCMN_SCANTASK_GOOD_PATH_CHECK		0x0002
#define	MPPCMN_SCANTASK_LUN_REBALANCING		0x0004
#define	MPPCMN_SCANTASK_CHECK_AVT_STATE		0x0008

#ifdef MPP_DEBUG
#define MPP_DEBUGPRINT(x)   mpp_DebugPrint x 
#else
#define MPP_DEBUGPRINT(x) 
#endif
#define MPP_ERRORLOGPRINT(x)   mpp_ErrorLog x 

#define MPP_RDACINFOSIZE(LUNS, PATHS)	(LWORD) (sizeof(RdacDeviceInformation_t) + \
					(sizeof(RdacLunInformation_t) * (LUNS-1)) + \
					(2*(sizeof(RdacControllerInformation_t))) + \
       					(2*(sizeof(RdacControllerPath_t)*(PATHS-1)) ) + \
       					LUNS * ((2*(sizeof(LunPathObjects_t))) + \
       					(2*(sizeof(LunPathInfo_t)* (PATHS-1)))) )

#define MPP_RDACDEVINFO_BLOCKSIZE( LUNS )	(LWORD) (sizeof(RdacDeviceInformation_t) + \
						(sizeof(RdacLunInformation_t) * (LUNS-1))) 

#define MPP_RDACCTLRINFO_BLOCKSIZE( PATHS )	(LWORD) ( (2*(sizeof(RdacControllerInformation_t))) + \
       						(2*(sizeof(RdacControllerPath_t)*(PATHS-1))))

#define MPP_RDACLUNPATHOBJ_BLOCKSIZE( PATHS )	(LWORD) (((2*(sizeof(LunPathObjects_t))) + \
       						(2*(sizeof(LunPathInfo_t)* (PATHS-1)))))

#define MPP_UTILSTATUSSIZE(LUNS, PATHS) (LWORD) (sizeof(mpp_utilStatusInfo_t) + \
                                        (sizeof(mpp_utilLunInfo_t) * (LUNS)) + \
                                        (LUNS * 2 * sizeof(mpp_utilPathInfo_t)*(PATHS)) )
/*
 * Macro definitions for use in changing the PathState of the ControllerPath and LunPathInfo structures.
 * These should be used whenever possible, as they record both the current and previous states.
 * MPPCMN_SET_PATH_STATE and MPPCMN_RESTORE_PATH_STATE are used for ControllerPath structures.
 * MPPCMN_SET_DEVICE_PATH_STATE and MPPCMN_RESTORE_DEVICE_PATH_STATE are used for LunPathInfo structures.
 */
#define	MPPCMN_SET_PATH_STATE(_RdacInfo_, _Controller_, _Path_, _PathState_) \
	{ \
		LWORD	curIndex = (_RdacInfo_)->ControllerInfo[_Controller_]->ControllerPath[_Path_].PathStateIndex; \
		if((_RdacInfo_)->ControllerInfo[_Controller_]->ControllerPath[_Path_].PathState[curIndex] != _PathState_) \
		{ \
			curIndex++; \
			curIndex %= MPPCMN_MAX_STATE_HISTORY; \
			(_RdacInfo_)->ControllerInfo[_Controller_]->ControllerPath[_Path_].PathStateIndex = curIndex; \
			(_RdacInfo_)->ControllerInfo[_Controller_]->ControllerPath[_Path_].PathState[curIndex] = _PathState_; \
			MPP_DEBUGPRINT((MPP_PNP_DEBUG+MPP_DEBUG_LEVEL_3, "NewPathState(Cntrl-0x%x;Path-0x%x;State-0x%x)\n", \
				_Controller_, _Path_, _PathState_)); \
		} \
	}

#define	MPPCMN_SET_DEVICE_PATH_STATE(_RdacInfo_, _Controller_, _Path_, _Lun_, _PathState_) \
	{ \
		LWORD	curIndex = (_RdacInfo_)->RdacLuns[_Lun_].LunControllers[_Controller_]->LunPaths[_Path_].DeviceStateIndex; \
		if((_RdacInfo_)->RdacLuns[_Lun_].LunControllers[_Controller_]->LunPaths[_Path_].DeviceState[curIndex] != _PathState_) \
		{ \
			curIndex++; \
			curIndex %= MPPCMN_MAX_STATE_HISTORY; \
			(_RdacInfo_)->RdacLuns[_Lun_].LunControllers[_Controller_]->LunPaths[_Path_].DeviceStateIndex = curIndex; \
			(_RdacInfo_)->RdacLuns[_Lun_].LunControllers[_Controller_]->LunPaths[_Path_].DeviceState[curIndex] = _PathState_; \
			MPP_DEBUGPRINT((MPP_PNP_DEBUG+MPP_DEBUG_LEVEL_3, "NewDevicePathState(Cntrl-0x%x;Path-0x%x;Lun-0x%x;State-0x%x)\n", _Controller_, _Path_, _Lun_,_PathState_)); \
		} \
	}

#define	MPPCMN_RESTORE_PATH_STATE(_RdacInfo_, _Controller_, _Path_) \
	if((_RdacInfo_)->ControllerInfo[_Controller_]->ControllerPath[_Path_].PathStateIndex == 0) \
	{ \
		(_RdacInfo_)->ControllerInfo[_Controller_]->ControllerPath[_Path_].PathStateIndex = MPPCMN_MAX_STATE_HISTORY; \
	} \
	else \
	{ \
		(_RdacInfo_)->ControllerInfo[_Controller_]->ControllerPath[_Path_].PathStateIndex--; \
	}

#define	MPPCMN_RESTORE_DEVICE_PATH_STATE(_RdacInfo_, _Controller_, _Path_, _Lun_) \
	if((_RdacInfo_)->RdacLuns[_Lun_].LunControllers[_Controller_]->LunPaths[_Path_].DeviceStateIndex == 0) \
	{ \
		(_RdacInfo_)->RdacLuns[_Lun_].LunControllers[_Controller_]->LunPaths[_Path_].DeviceStateIndex = MPPCMN_MAX_STATE_HISTORY; \
	} \
	else \
	{ \
		(_RdacInfo_)->RdacLuns[_Lun_].LunControllers[_Controller_]->LunPaths[_Path_].DeviceStateIndex--; \
	}

/*
 * Definition used to indicate how many MPPCMN_PATH_STATE's we will keep state history for.
 */
#define	MPPCMN_MAX_STATE_HISTORY	10


/*
 * Macro definitions used for specifying whether to place a request at the beginning or end of an I/O queue.
 */
#define	MPPCMN_QUEUE_TO_HEAD	1
#define	MPPCMN_QUEUE_TO_TAIL	2


/***  TYPE DEFINITIONS  ***/
typedef TEXT          DevName_t[ DEVNM_LEN ];
typedef struct getRdacInfoIoctl {
	LWORD 	target;
	LWORD   BufferSize;
	void	*RdacInfoAdrs;
	void	*RdacName;
} getRdacInfoIoctl_t;


typedef enum _MPP_FEATURE_ID {
	FeatUnknown = 0,
	FeatMinimumFirmwareRelease,
	FeatPage2CSubPage
} MPP_FEATURE_ID;

/*
 * PathState defintions for use with the Path Validation enhancements.
 */
typedef enum _MPPCMN_PATH_STATE {
	MPPCMN_OPTIMAL = 0,			// Path or device is available for I/O routing.
	MPPCMN_FAILED,				// Path or device is not available for I/O routing.
	MPPCMN_OPTIMAL_NEED_CHECK,		// Path or device is available but needs a validation check.
	MPPCMN_OPTIMAL_CHECKING,		// Path or device is available and a validation check is in progress.
	MPPCMN_FAILED_NEED_CHECK,		// Path or device is failed and needs a validation check.
	MPPCMN_FAILED_CHECKING,			// Path or device is failed and a validation check is in progress.
	MPPCMN_SYSTEM_SPECIFIC			// Path or device is in a system-specific state (ex. PnP).
} MPPCMN_PATH_STATE;

typedef struct	_MPP_FEATURE_SUPPORT {
	MPP_FEATURE_ID		FeatureId;
	BYTE			MajorRelease;
	BYTE			MinorRelease;
	BYTE			RevisionRelease;
} MPP_FEATURE_SUPPORT, *PMPP_FEATURE_SUPPORT;

typedef struct _MPPCMN_DLIST {
	struct _MPPCMN_DLIST	*Flink;
	struct _MPPCMN_DLIST	*Blink;
} MPPCMN_DLIST;

// 09/20/04 - Feature Option Control Enhancement
#define	MPPCMN_KEYWORD_OPTION_LENGTH		40

typedef enum _MPPCMN_FEATURE_OPTION_TYPE {
	MPPCMN_FEATURE_TYPE_VARIABLE = 0,
	MPPCMN_FEATURE_TYPE_ACTION
} MPPCMN_FEATURE_OPTION_TYPE;

typedef enum _MPPCMN_OPTION_CONTROL_REQUEST {
	MPPCMN_OPTION_REQUEST_GET = 0,
	MPPCMN_OPTION_REQUEST_SET
} MPPCMN_OPTION_CONTROL_REQUEST;

typedef enum _MPPCMN_OPTION_CONTROL_STATUS {
	MPPCMN_OPTION_VARIABLE_SUCCESS = 0,
	MPPCMN_OPTION_ACTION_SUCCESS,
	MPPCMN_OPTION_VALUE_OUT_OF_RANGE,
	MPPCMN_OPTION_INVALID_PARAMETER,
	MPPCMN_OPTION_KEYWORD_UNKNOWN,
	MPPCMN_OPTION_STATUS_UNKNOWN
} MPPCMN_OPTION_CONTROL_STATUS;

typedef struct _MppCmn_OptionControlIoctl {
	IN LINT					Magic;
	IN MPPCMN_OPTION_CONTROL_REQUEST	RequestType;
	IN LWORD				BufferSize;
	OUT LWORD				BytesTransferred;
	OUT LWORD				TotalBytesNeeded;
	IN OUT VOID				*OptionBuffer;
} MppCmn_OptionControlIoctl_t;

struct _MppCmn_OptionControl;

typedef LWORD	(*MPPCMN_FEATURE_UTIL_CALLBACK_FUNC)(struct _MppCmn_OptionControl *OptionControl);

typedef struct _MppCmn_OptionControl {
	OUT MPPCMN_OPTION_CONTROL_STATUS	Status;
	IN OUT TEXT				Keyword[MPPCMN_KEYWORD_OPTION_LENGTH + 1];
	IN OUT LWORD				Value;
	OUT LWORD				DefaultValue;
	OUT LWORD				MinValue;
	OUT LWORD				MaxValue;
	MPPCMN_FEATURE_UTIL_CALLBACK_FUNC		CallBackFunc;
} MppCmn_OptionControl_t;

struct _MppCmn_FeatureOptionControl_t;

typedef MPPCMN_OPTION_CONTROL_STATUS	(*MPPCMN_FEATURE_CALLBACK_FUNC)(struct _MppCmn_FeatureOptionControl_t *FeatureOption, MppCmn_OptionControl_t *OptionControl);

typedef struct _MppCmn_FeatureOptionControl_t {
	MPPCMN_FEATURE_OPTION_TYPE		OptionType;
	TEXT					Keyword[MPPCMN_KEYWORD_OPTION_LENGTH + 1];
	VOID					*ValueAddr;	// Optional
	LWORD					DefaultValue;
	LWORD					MinValue;
	LWORD					MaxValue;
	MPPCMN_FEATURE_CALLBACK_FUNC		CallbackFunc; 	// Optional
} MppCmn_FeatureOptionControl_t;

#define	MPPCMN_FEATURE_OPTION_MAGIC		sizeof(MppCmn_OptionControlIoctl_t)

// 07/20/06 - CR 109208.  Lun-based Failover Enhancement

#define MPPCMN_LUN_FAILOVER_TABLE_LENGTH	32


#define MPPCMN_SET_LUN_FAILOVER_BIT(_Array_, _Lun_) \
	{ \
		if(_Array_ != NULL) \
		{ \
			_Array_[(_Lun_ / 8)] |= (1 << (_Lun_ % 8)); \
		} \
	}

#define MPPCMN_LUNFAILOVER_TO_LUNTABLE(_RdacInfo_, _ControllerIndex_, _LunFailover_, _LunTable_) \
	{ \
		LWORD _offset_, _offset2_, _lun_; \
		\
		for(_offset_ = 0; _offset_ < MPPCMN_LUN_FAILOVER_TABLE_LENGTH; (_offset_)++) \
		{ \
			if(_LunFailover_[_offset_] != 0) \
			{ \
				for(_offset2_ = 0; _offset2_ < 8; (_offset2_)++) \
				{ \
					if((_LunFailover_[_offset_] >> _offset2_) & 1) \
					{ \
						_lun_ = (_offset_ * 8) + _offset2_; \
						(_LunTable_)[_lun_] = 1; \
						MPP_ERRORLOGPRINT((MPP_ERR_CTLR_FAILOVER, 163, \
							"%s:%d Lun failover to controller %d\n", \
							(_RdacInfo_)->ModuleName, _lun_, _ControllerIndex_)); \
					} \
				} \
			} \
		} \
	}

#define MPPCMN_RESET_LUNFAILOVER(_LunFailoverInfo_) \
	{ \
		(_LunFailoverInfo_)->LunFailoverTimerSet = FALSE; \
		(_LunFailoverInfo_)->LunFailoverDuration = 0; \
		bzero((_LunFailoverInfo_)->LunFailoverTable, MPPCMN_LUN_FAILOVER_TABLE_LENGTH); \
	}

typedef enum {
	MPPCMN_FAILOVER_METHOD_CONTROLLER = 0,
	MPPCMN_FAILOVER_METHOD_LUN = 1
} MPPCMN_FAILOVER_METHOD;

typedef enum {
	MPPCMN_FAIL_LUN_ONE_PATH = 0,		// Fail the lun on a given path to a given controller.
	MPPCMN_FAIL_LUN_ALL_PATHS = 1		// Fail the lun on all paths to a given controller.
} MPPCMN_FAIL_LUN_OPTION;

// Initialize a new MPPCMN_DLIST header
#define	MPPCMN_INITIALIZE_DLIST_HEAD(_DListHead_) \
	((_DListHead_)->Flink = (_DListHead_)->Blink = (_DListHead_))

// Add a new MppCmnDList entry to the end of an existing header
#define	MPPCMN_INSERT_DLIST_TAIL(_DListHead_, _DListEntry_) \
	{ \
		MPPCMN_DLIST	*_tmpBlink; \
		MPPCMN_DLIST	*_tmpHead; \
		_tmpHead = (_DListHead_); \
		_tmpBlink = _tmpHead->Blink; \
		(_DListEntry_)->Flink = _tmpHead; \
		(_DListEntry_)->Blink = _tmpBlink; \
		_tmpBlink->Flink = (_DListEntry_); \
		_tmpHead->Blink = (_DListEntry_); \
	}

// Remove a MPPCMN_DLIST entry
#define	MPPCMN_REMOVE_DLIST_ENTRY(_DListEntry_) \
	{ \
		MPPCMN_DLIST	*_tmpBlink; \
		MPPCMN_DLIST	*_tmpFlink; \
		_tmpFlink = (_DListEntry_)->Flink; \
		_tmpBlink = (_DListEntry_)->Blink; \
		_tmpBlink->Flink = _tmpFlink; \
		_tmpBlink->Blink = _tmpBlink; \
	}

// Check whether a given MPPCMN_DLIST is empty
#define	MPPCMN_IS_DLIST_EMPTY(_DListHead_) \
	((_DListHead_)->Flink == (_DListHead_))

#define MPPCMN_GET_STRUCT(_Address_, _Type_, _Field_) \
	((_Type_ *)((TINY *)(_Address_) - (LPOINTER)(&((_Type_ *)0)->_Field_)))

//Target Protocol Identifier 
typedef enum {
    MPPCMN_TARGET_FC    = 0,    // Fibre Channel Array Type
	MPPCMN_TARGET_ISCSI = 5 ,	// iSCSI Array Type
	MPPCMN_TARGET_SAS   = 6,	// SAS Array Type
	MPPCMN_TARGET_IB    =4		// Infiniband Array Type
} MPPCMN_ARRAY_TYPE;

/***  GLOBALS  ***/ 
extern TEXT mpp_VendorId[9];
extern TEXT mpp_ProductId[17];
extern TEXT mpp_Version[16];

extern LWORD mpp_Debug;
extern LWORD mpp_NotReadyWaitTime;
extern LWORD mpp_BusyWaitTime;
extern LWORD mpp_QuiescenceWaitTime;
extern LWORD mpp_InquiryWaitTime;
extern LWORD mpp_MaxLunsPerArray;
extern LWORD mpp_MaxPathsPerController;
extern LWORD mpp_ScanInterval;
extern LWORD mpp_InquiryInterval;
extern LWORD mpp_MaxArrayModules;
extern LWORD mpp_ErrorLevel;
extern LWORD mpp_SelectionTimeoutRetryCount;
extern LWORD mpp_CommandTimeoutRetryCount;
extern LWORD mpp_UaRetryCount;
extern LWORD mpp_SyncRetryCount;
extern LWORD mpp_SynchTimeout;
extern LWORD mpp_FailoverTimeout;
extern LWORD mpp_FailOverQuiescenceTime;
extern LWORD mpp_FailBackToCurrentAllowed;
extern LWORD mpp_DoUARetry;
extern LWORD mpp_HoldAltInReset;
extern LWORD mpp_Page2CSubPage;
extern LWORD mpp_ControllerIoWaitTime;
extern LWORD mpp_ArrayIoWaitTime;
extern LWORD mpp_DisableLUNRebalance;
extern LWORD mpp_MaxArrayFailoverLength;
extern LWORD mppCmn_RecheckFailedPathWaitTime;
extern LWORD mppCmn_FailedPathCheckingInterval;
extern LWORD mppCmn_IdlePathCheckingInterval;
extern LWORD mppCmn_PrintSenseBuffer;
extern LWORD mppCmn_AncientWaitTimeThreshold;
/* variable used for Scsi2 to Scsi3 persistent reservation */
extern BYTE  mpp_S2ToS3Key[8];
extern MppCmn_FeatureOptionControl_t *mppCmn_FeatureOptionControl;
extern LWORD mppCmn_NumFeatureOptions;
extern LWORD mppCmn_ClassicModeFailover;
extern LWORD mppCmn_AVTModeFailover;
extern LWORD mppCmn_LunFailoverDelay;
extern LWORD mppCmn_RetryFailoverDelay;
extern LWORD mppCmn_PRWaitTime;

/* Load Balance Policy related definitions */
typedef enum _MPPCMN_LOAD_BALANCE_POLICY {
	MPPCMN_LB_ROUND_ROBIN_SUBSET = 0,  // The default policy.
	MPPCMN_LB_LEAST_QUEUE_DEPTH = 1,
	MPPCMN_LB_PATH_WEIGHT = 2
} MPPCMN_LOAD_BALANCE_POLICY;

/* Load Balance Policy String definitions */
#define MPP_LOAD_BALANCE_POLICY "LoadBalancePolicy"
#define MPP_LBP_ROUND_ROBIN_WITH_SUBSET "RoundRobinSubset" 
#define MPP_LBP_LEAST_QUEUE_DEPTH       "LeastQueueDepth"
#define MPP_LBP_LEAST_PATH_WEIGHT       "LeastPathWeight"
#define MPP_LBP_REQUESTS_IN_PROGRESS    "ReqInProgress"
#define MPP_LBP_PATH_WEIGHT             "PathWeight"
#define MPP_LBP_PATH_ID                 "PathId"

extern  MPPCMN_LOAD_BALANCE_POLICY	mppCmn_LoadBalancePolicy;
#define	MPPCMN_DEFAULT_LB_POLICY	MPPSYS_LB_ROUND_ROBIN_SUBSET
#define MPP_DEFAULT_LBP_PATH_WEIGHT 0


/* Device Settings Tags */ 
#define	MPPCMN_ARRAY_SETTINGS_TAG  "Array#"
#define	MPPCMN_LUN_SETTINGS_TAG  "Lun#"
#define	MPPCMN_PATH_SETTINGS_TAG  "Path#"
typedef enum _MPPCMN_DEV_SETTINGS_TYPE {
	MPPCMN_ARRAY_SETTINGS = 1,
	MPPCMN_LUN_SETTINGS = 2,
	MPPCMN_PATH_SETTINGS = 3
} MPPCMN_DEV_SETTINGS_TYPE, *PMPPCMN_DEV_SETTINGS_TYPE;


/* MPPCMN_RETURN_STATUS definitions */
#define MPPCMN_STATUS_SUCCESS 0
#define MPPCMN_STATUS_INVALID_PARAMETER 1
#define MPPCMN_STATUS_NO_MEMORY 2

#define		WWN_LENGTH		16

/* mppUtil -S related struct definitions */
typedef struct mpp_utilGetStatusIoctl {
        LWORD   mpp_Target;
        LWORD   mpp_BufferSize;
        void*   mpp_StatusAddress;
} mpp_utilGetStatusIoctl_t;

typedef struct mpp_utilSysStatusInfo {
        int mpp_VirtualHostId;
        int mpp_VirtualTargetId;
} mpp_utilSysStatusInfo_t;

typedef struct mpp_utilStatusInfo {
        DevName_t mpp_SAName;
        BYTE    mpp_ControllerState[2];
        mpp_utilSysStatusInfo_t mpp_PlatformStatusInfo;
        void*   mpp_utilLunInfoAddress;
} mpp_utilStatusInfo_t;

typedef struct mpp_utilLunInfo {
        int mpp_LunNumber;
        void*   mpp_utilPathInfoAddress;
} mpp_utilLunInfo_t;

typedef struct mpp_utilPathInfo {
        ControllerAddress_t mpp_CtlAddr;
        int 	mpp_PathState;
} mpp_utilPathInfo_t;


typedef void (*MPPCMN_QUEUE_REQUEST_CALLBACK)(IN void *Context);

/* mppUtil -S Miscellaneous Definitions */
#define NO_LUN  -1
#define NO_PATH -1
#define CDB_LEN_6 6
#define CDB_LEN_10 10
#define PATH_UP 1
#define PATH_DOWN 0
#define PATH_MISSING 0

/* mppUtil -S Controller States */
#define MPPCMN_CTLR_MISSING 0x0A
#define MPPCMN_CTLR_ACTIVE  0x0B
#define MPPCMN_CTLR_OFFLINE 0x0C
#define MPPCMN_CTLR_IN_SERVICE 0x0D
#define MPPCMN_CTLR_RESET 0x0E
#define MPPCMN_CTLR_UNKNOWN_STATE 0x0F
/*** prototypes ***/



#endif        /* End of __INCMPP_Common.h */
