/*******************************************************************************
*  Copyright 2004-2008 LSI Corporation.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            MPP_ProtoTypes.h
SUMMARY         %description%
VERSION         %version: 45 %
UPDATE DATE     %date_modified: Wed Jul 02 11:12:23 2008 %
PROGRAMMER      %created_by:    harshi %

DESCRIPTION:

INCLUDE FILES:

NOTES:

RESTRICTIONS:

SEE ALSO:

REFERENCE:

IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/


#ifndef __INCMPP_ProtoTypes
#define __INCMPP_ProtoTypes


/***  ProtoTypes  ***/ 
extern void mpp_DebugPrint(LWORD DebugPrintLevel, TINY *DebugMessage, ...);
extern void mpp_ErrorLog(LWORD Level, LWORD Number, TINY *LogMessage, ...);

extern void mpp_VirtualdiskInquiryData(TEXT *inqData);

extern LWORD mpp_IsArray(MPP_HANDLE DeviceVertex, BYTE *FirmwareVersion);

extern VOID mpp_GetPRResetSupport(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo);

extern LWORD mpp_BuildRdacinfo(MPP_HANDLE DeviceVertex, ControllerAddress_t *DeviceAddress, LWORD Lun);

extern void mpp_probeVirtualBus(void);

extern LWORD mpp_GetArrayName(MPP_HANDLE DeviceVertex, BYTE *ArrayWWN, BYTE *ArrayAsciiName, LWORD *Lun);
extern LWORD mpp_DetermineNodeType(dev_t Node, RdacDeviceInformation_t **RdacInfo, BYTE *ControllerIndex, BYTE *PathIndex,
	 LWORD *Lun); 
extern LWORD mpp_PhysicalDiskOpen(MPP_HANDLE Node, RdacDeviceInformation_t *RdacInfo, BYTE ControllerIndex, BYTE PathIndex, LWORD Lun);
extern LWORD mpp_UtmDiskOpen(dev_t Node, RdacDeviceInformation_t *RdacInfo, BYTE ControllerIndex, BYTE PathIndex, LWORD Lun);
extern void mpp_UtmDiskClose(dev_t Node, RdacDeviceInformation_t *RdacInfo, BYTE ControllerIndex, BYTE PathIndex, LWORD Lun);
extern LWORD mpp_NativeBusIoctlCmd(dev_t Node, int cmd, void *arg, int mode);
extern MPP_HANDLE mpp_SelectPath(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BYTE *Controller, BYTE *Path);
extern LunPathInfo_t *mppCmn_NewSelectPath(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BYTE *Controller, BYTE *Path);
extern LunPathInfo_t *mppCmn_RoundRobinPolicy(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BYTE *Controller, BYTE *Path);
extern LunPathInfo_t *mppCmn_PathWeightPolicy(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BYTE *Controller, BYTE *Path);
extern LunPathInfo_t *mppCmn_LeastQueueDepthPolicy(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BYTE *Controller, BYTE *Path);
extern LWORD mpp_AnalyseIoError(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun, LWORD mpp_status, 
			SenseData_t *SenseData, SINT SenseLength, LWORD DataLengthXfered, MPP_TIME StartTime,
			BYTE *SelectionTimeoutRetryCount, BYTE *CommandTimeoutRetryCount, BYTE *UaRetryCount, BYTE *RetryCount,
			MPP_TIME ControllerIoWaitTime, MPP_TIME ArrayIoWaitTime, LWORD *mppIoErrorCondition);
extern LWORD mpp_AnalyseSyncError(LWORD mppStatus, SenseData_t *SenseData, LWORD SenseLengthReturned, 
			LWORD DataLengthXfered, MPP_TIME StartTime, BYTE *SelectionTimeoutRetryCount, 
			BYTE *CommandTimeoutRetryCount, BYTE *UaRetryCount);
extern BYTE mpp_FailPath(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path);
extern MPP_HANDLE mpp_SelectFailoverPath(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BYTE *Controller, BYTE *Path);
extern LWORD mpp_AnalyseFailoverError(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun, LWORD mpp_status, 
			SenseData_t *SenseData, SINT SenseLength, LWORD DataLengthXfered, MPP_TIME StartTime);
extern RdacDeviceInformation_t * mpp_MatchExistingControllerPath(ControllerAddress_t *DeviceAddress, BYTE *ControllerIndex, BYTE *PathIndex);
extern void mpp_FailBackScan(void);
extern void mpp_CheckAVTState(void);
extern void mpp_ScanForAddedDevices(void);
extern LWORD mpp_SynchInquiry(MPP_HANDLE DeviceVertex, BOOL Evpd, BYTE PgCode, void *BufferAddress, LWORD BufferLength);
extern LWORD mpp_SynchronousIo(MPP_HANDLE DeviceVertex, BYTE *cdb, BYTE cdblen, void *BufferAddress, LWORD BufferLength, TINY Direction);
extern LWORD mpp_RemoveLun(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun);
extern LWORD mpp_IsSupported(MPP_FEATURE_ID Feature, BYTE *SwVersion);
extern LWORD mpp_NativePseudoDiskIoctlCmd(dev_t Node, int cmd, void *arg, int mode, cred_t *crp, int *rvalp);
extern int mpp_OpenVirtualDisk(RdacDeviceInformation_t *RdacInfo, LWORD Lun);
extern int mpp_CloseVirtualDisk(RdacDeviceInformation_t *RdacInfo, LWORD Lun);
extern LINT mpp_open(dev_t *devp, int oflag, int otyp, cred_t *credp);
extern int mpp_ioctl(dev_t dev, int cmd, void *arg, int mode, cred_t *crp, int *rvalp);
extern int mpp_close(dev_t dev, int oflag, int otyp, cred_t *credp);
extern int mpp_read(dev_t dev, uio_t *uiop, cred_t *credp);
extern int mpp_write(dev_t dev, uio_t *uiop, cred_t *credp);
extern void mpp_ChkIOForWandV(BYTE *cdb, BOOL SenseDataPresent, BYTE SenseKey, BYTE ASC, 
				  BYTE ASCQ, BOOL *b_WandV, BOOL *b_RetryWithWrite);
extern void mpp_SetWandVBit(BOOL *ErrorRecovery, BOOL b_WandV, BOOL b_RetryWithWrite);
extern int mpp_TestBuildWandVOp(BYTE *cdb, BOOL ErrorRecovery, BOOL b_WandV, 
								BOOL b_RetryWithWrite, int oldController, int newController);
extern void mpp_BuildWriteWithVerify(BYTE *cdb);
extern LWORD mpp_GetUTMData(MPP_HANDLE DeviceVertex, LWORD *UTMLun, BOOL *UTMEnabled);
extern void mpp_CheckForMultiplePaths(void);
extern void mppCmn_CheckControllerForServiceMode(RdacDeviceInformation_t *RdacInfo, BYTE Controller);
extern VOID	mppCmn_RebalanceLuns(RdacDeviceInformation_t *RdacInfo, BOOL forcedRebalance);
extern LWORD mpp_CheckSwVersion(MPP_HANDLE DeviceVertex, BYTE *);
extern LWORD mpp_CheckHwVersion(MPP_HANDLE DeviceVertex);
extern VOID mppCmn_CheckPathStatus(VOID);
extern void mppCmn_GetArrayStatus(RdacDeviceInformation_t *RdacInfo, mpp_utilStatusInfo_t *utilStatusInfo );

extern RdacDeviceInformation_t * mpp_AllocRdacinfo(MPP_HANDLE DeviceVertex, BYTE *ArrayWWN, BYTE *ArrayAsciiName);
extern void 	mppCmn_FreeRdacInfo( RdacDeviceInformation_t *RdacDevInfoBlock);
extern LWORD mppCmn_InitializeFeatureOptions(MppCmn_FeatureOptionControl_t *SysdepFeatureOptions, LWORD NumSysdepOptions);
extern VOID mppCmn_CleanupFeatureOptions(VOID);
extern struct _MppCmn_FeatureOptionControl_t *mppCmn_GetFeatureOptionControlByKeyword(TEXT *Keyword);
extern int mppCmn_ProcessFeatureOptions(MppCmn_OptionControlIoctl_t *Ioctl);
extern int mppCmn_LoadBalanceFeatureCallback(struct _MppCmn_FeatureOptionControl_t *FeatureOption, MppCmn_OptionControl_t *OptionControl);
extern LWORD mpp_IsNull(BYTE *BufferAddress, LWORD BufferLength);
extern LWORD mpp_IsBlank(BYTE *BufferAddress, LWORD BufferLength);
extern void mppCmn_CheckAndSetTASBit(IN MPP_HANDLE DeviceVertex, IN RdacDeviceInformation_t *RdacInfo, IN LWORD Lun);
extern void mppCmn_CreateModeSensePageA(IN ModePageA_t *PageA, IN BYTE *Cdb, IN MODE_SENSE_PAGE_CODE_TYPE PcType);
extern void mppCmn_CreateModeSelectPageA(IN ModePageA_t *PageA, IN BYTE *Cdb);
extern LWORD mpp_GetMaxLunsSupported(MPP_HANDLE DeviceVertex, BYTE *MaxLuns);
extern BYTE mppCmn_Failover(IN RdacDeviceInformation_t *RdacInfo, IN BYTE ControllerIndex, IN LWORD Lun, IN LWORD MppIoErrorCondition);
extern BYTE mppCmn_DoFailover(IN RdacDeviceInformation_t *RdacInfo, IN MPPCMN_FAILOVER_METHOD FailoverMethod,
	IN BYTE ControllerIndex, IN BOOL ForcedQuiescence, IN BOOL noHoldInReset);
extern LWORD mppCmn_DoFailoverCompletion(IN LWORD RequestStatus, IN MppCmn_FailoverCompletionContext_t *CompletionContext);
extern void mppCmn_DoFailoverCompletionCleanup(IN RdacDeviceInformation_t *RdacInfo, IN MppCmn_FailoverCompletionContext_t *CompletionContext);
extern BYTE mppCmn_FailLun(IN RdacDeviceInformation_t *RdacInfo, IN BYTE ControllerIndex, IN BYTE PathIndex,
	IN LWORD Lun, IN MPPCMN_FAIL_LUN_OPTION FailOption);
extern LWORD mppCmn_GetPage2CInfo(IN RdacDeviceInformation_t *RdacInfo, IN MPP_HANDLE DeviceVertex, IN LINT ControllerIndex,
	OUT VOID **Page2C, OUT LWORD *Page2CSize);
extern void mppCmn_QueueFailoverCallback(IN void *Context);
extern void mppCmn_DoFailoverDelayedCallback(IN void *Context);

extern LPWLinkedListNode_t *mpp_LPWCreateLLNode(IN RdacDeviceInformation_t *RdacInfo, IN LWORD controllerIndex, IN BYTE pathIndex, IN LWORD Lun);
extern VOID mpp_LPWInsertLLNode(IN RdacDeviceInformation_t *RdacInfo, IN LWORD ControllerIndex, IN BYTE PathIndex, IN LWORD Lun);
extern VOID mpp_LPWRemoveLLNode(IN RdacDeviceInformation_t *RdacInfo, IN LWORD ControllerIndex, IN BYTE PathIndex, IN LWORD Lun, IN BOOL freeNode);
extern VOID mpp_LPWUpdateLLNodePathWeight(IN RdacDeviceInformation_t *RdacInfo, IN LWORD ControllerIndex, IN BYTE PathIndex,
         IN LWORD Lun, IN LWORD PathWeight);
extern LWORD mppCmn_GetArrayIdentifierTag(IN BYTE *ArrayWWN, IN LWORD ArrayWWNLength, IN OUT BYTE **ArrayIdTag,
         IN OUT LWORD *ArrayIdTagLength);
extern LWORD mppCmn_GetLunIdentifierTag(IN BYTE *LunWWN, IN LWORD LunWWNLength, IN OUT BYTE **LunIdTag,
         IN OUT LWORD *LunIdTagLength);
extern LWORD mppCmn_GetPathIdentifierTag(IN int Port, IN int Path, IN int Target, IN OUT BYTE **PathIdTag,
	IN OUT LWORD *PathIdTagLength); 
extern LWORD mppCmn_GetLunPathIdentifierTag(IN BYTE *LunWWN, IN LWORD LunWWNLength, IN int Port, IN int Path, IN int Target,
	IN OUT BYTE **LunPathIdTag, IN OUT LWORD *LunPathIdTagLength); 


#endif        /* End of __INCMPP_ProtoTypes */
