/*******************************************************************************
* Copyright 2004 Engenio Information Technologies, Inc.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            mppCmn_s2tos3.h
SUMMARY         %description%
VERSION         %version: 21 %
UPDATE DATE     %date_modified: Mon Jan 28 08:08:47 2008 %
PROGRAMMER      %created_by:    rstankey %

DESCRIPTION:
   This file contains common definitions for performing Scsi2  reserve/release 
   to Scsi3 persistent reservation translation. The translation operations are
   performed asynchronously. A platform mpp driver implementation should call 
   APIs in this file via a separate task so that the translation operation 
   will not block system dispatching I/Os.


INCLUDE FILES:

NOTES:

RESTRICTIONS:

SEE ALSO:

REFERENCE:

  349-1031000 Yuma Software Functional Specification
  349-1033500 Linux MPP Driver Feature Architecture Specification
  349-1034610 Linux MPP Virtual HBA Driver Feature Design Document
  349-1034750 Linux MPP Upper Level Driver Feature Design Document
  349-1034730 Linux MPP Utility Feature Design Document
  349-1034620 Linux MPP Installation Feature Design Document


IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/


#ifndef __INCmppCmn_s2tos3
#define __INCmppCmn_s2tos3


/***  INCLUDES  ***/  


/***  CONSTANT DEFINITIONS  ***/
#define  MPPCMN_PR_REGISTER                           0
#define  MPPCMD_PR_REGISTER_AND_IGNORE_EXISTING_KEY   1

/*
* The three status returned by all scsi2 to scsi3 translation functions
*/
#define MPPCMN_PRTN_GOOD_STATUS             0
#define MPPCMN_PRTN_RESERVATION_CONFLICT    1
#define MPPCMN_PRTN_RETURN_ERROR            2
#define MPPCMN_PRTN_CHECK_CONDITION         3
#define MPPCMN_PRTN_COMMAND_NOT_SUPPORTED   4

/***  MACRO DEFINITIONS  ***/
#define MPP_GET_LWORD_FROM_4BYTES(a) \
   (a[0] << 24) | \
   (a[1] << 16) | \
   (a[2] << 8 ) | \
   (a[3]      )


#define MPP_GET_LWORD_FROM_2BYTES(a) \
   ((a[0] <<8) & 0x0000ff00)| \
   ((a[1]    ) & 0x000000ff)

/***  TYPE DEFINITIONS  ***/


/***  GLOBALS  ***/ 

LWORD mppCmn_MapScsi2Reserve(RdacDeviceInformation_t *rdacInfo, LWORD Lun, BYTE * uniqueId, 
                             BYTE *reservationKey,BOOL enableCC,SenseData_t *sensedata);
LWORD mppCmn_MapScsi2Release(RdacDeviceInformation_t *rdacInfo, LWORD Lun, BYTE * uniqueId,
                             BYTE *reservationKey,
                             BOOL enableCC,
                             SenseData_t * sensedata);

LWORD mppCmn_MapDeviceReset(
      RdacDeviceInformation_t *rdacInfo,
      LWORD Lun);

LWORD mppCmn_MapBusDeviceResetVs(
      RdacDeviceInformation_t *rdacInfo);

LWORD mppCmn_MapBusDeviceReset(
      RdacDeviceInformation_t *rdacInfo,
      LWORD Lun);
      
LWORD
mppCmn_S2toS3SynchCmnd(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BYTE *cdb, 
                       BYTE cdblen, void *BufferAddress,LWORD BufferLength,
                       TINY Direction,
                       BOOL enableCC,
                       SenseData_t * sensedata);
LWORD mppCmn_MkPRClear(RdacDeviceInformation_t *RdacInfo, LWORD Lun, 
                       BYTE * reservationKey,
                       BOOL enableCC,
                       SenseData_t * sensedata);

LWORD mppCmn_GetPRKeys(RdacDeviceInformation_t *rdacInfo, LWORD LUN, 
                       PRINReadKeysParamData_t *keyParamData,
                       BOOL enableCC,SenseData_t *sensedata);

LWORD mppCmn_GetPRReservations(RdacDeviceInformation_t *rdacInfo, LWORD Lun, 
                               PRINReadResevParamData_t *ResParamData,
                               BOOL enableCC,SenseData_t * sensedata);
LWORD mppCmn_MkPRRegistrationForAll(RdacDeviceInformation_t *rdacInfo, LWORD Lun, 
                                    BYTE *reservationKey,
                                    BOOL enableCC,
                                    SenseData_t * sensedata);
LWORD mppCmn_MkPRRegistration(MPP_HANDLE node, BYTE reservationType, BYTE * reservationKey,
                              BOOL enableCC,
                              SenseData_t * sensedata);
LWORD mppCmn_MkPRPreempt(RdacDeviceInformation_t *rdacInfo, LWORD Lun,BYTE * reservationKey, 
                         BYTE * serviceActionKey,
                         BOOL enableCC,
                         SenseData_t * sensedata);
LWORD mppCmn_MkPRReservation(RdacDeviceInformation_t *rdacInfo,LWORD Lun, BYTE * reservationKey,
                             BOOL enableCC,
                             SenseData_t * sensedata);
LWORD mppCmn_CheckPRRegistration(RdacDeviceInformation_t *rdacInfo, MPP_HANDLE device, LWORD virtualLun);
VOID  mppCmn_GenReservationKey(BYTE *uniqueID, BYTE *key);
TINY  mppCmn_IsKeyForThisHost(BYTE *uniqueID, BYTE * reservationKey);
TINY  mppCmn_IsMppKey(BYTE * reservationKey);
VOID  mppCmn_GenHashKey(BYTE *uniqueID, BYTE *hashKey);
VOID  mppCmn_KeyEncode(BYTE *clearKey, BYTE *cipherKey);
VOID  mppCmn_KeyDecode(BYTE *cipherKey, BYTE *clearKey);
LWORD 
mppCmn_SynchronousPRIo(MPP_HANDLE DeviceVertex, BYTE *cdb, BYTE cdblen, void *BufferAddress,
                       LWORD BufferLength, TINY Direction,
                       BOOL enableCC,
                       SenseData_t * sensedata);
LWORD mppCmn_CheckForReservationHolder(RdacDeviceInformation_t *RdacInfo, LWORD Lun, BOOL enableCC,
		SenseData_t *senseData);
LWORD mppCmn_SelectPRPath(RdacDeviceInformation_t *RdacInfo, LWORD ControllerIndex,
	LWORD Lun, MPP_HANDLE *DeviceVertex);

#endif        /* End of __INCmppCmn_s2tos3 */
