/*******************************************************************************
* Copyright 2004-2007  LSI Logic Corporation
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            mppUtil_Common.h
SUMMARY         %description%
VERSION         %version: 31 %
UPDATE DATE     %date_modified: Fri Jan 25 23:05:07 2008 %
PROGRAMMER      %created_by:    bmoger %

DESCRIPTION:

INCLUDE FILES:

NOTES:

RESTRICTIONS:

SEE ALSO:

REFERENCE:

IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/
#ifndef __SRCmppUtil_Common
#define __SRCmppUtil_Common

#include "mppUtil_Sysdep.h"

/***  CONSTANT DEFINITIONS  ***/
#define		TRUE			1
#define		FALSE			0
#define		DONE			2
#define		INVALID			-1
#define		SCAN_FAILBACK		"failback"
#define		SCAN_AVT		"avt"
#define		SCAN_BUSSCAN		"busscan"
#define		SCAN_FORCE_REBALANCE      "forcerebalance"
#define		NOT_APPLICABLE		"N/A"
#define		INVALID_OPT		-1
#define		MAX_BUSES		255
#define		BUS_PATH_LEN		255
#undef          DEBUG_BUFFER_LENGTH
#define		DEBUG_BUFFER_LENGTH	255
#define		TIME_BUFFER_LENGTH	19
#define		WWN_LENGTH		16
#define		STR_LENGTH		19 /* 18 is the length of each line of the mppUtil GetRequest (-g option) output + 1 byte for \0 */ 
#define		MPPCMN_UTIL_USAGE	"[-a [target_name]] [-d debug_level] [-e error_level] [-g target_id] [-o [feature_action_name | feature_variable_name=value]] [-s \"failback\" | \"avt\" | \"busscan\" | \"forcerebalance\"] [-w target_wwn,controller_index] [ -S ] [-c [wwnFileName]]"
#define		MPPCMN_UTIL_CMDLINE_ARGS	"achtmlowd:e:g:s:S" 
#define		MAX_CMDLINE_LENGTH	80
#define		UP			"Up"
#define		DOWN			"Down"
#define		MPPCMN_DEL_EQUAL	'='
#define		MPPCMN_DEL_COMMA	','
#define		FIRST_DRIVER		1
#define		NEXT_DRIVER		2

#define MAX_ARRAY_STR_LEN		36  /* max string length of array module name - 30 unicode char's */	
#define HOST_NAME_LEN			256
#define DOMAIN_NAME_LEN			256
#define TIME_STR_LEN			256

/** Defines for printing out the '-S' option **/
#define VIRTUAL_TARGET_STATUS_COLUMN	0
#define	VIRTUAL_TARGET_WIDTH		10
#define	A_CONTROLLER_STATUS_COLUMN	13
#define	B_CONTROLLER_STATUS_COLUMN	40
#define CONTROLLER_STATUS_WIDTH		22
#define	SANAME_COLUMN			57
#define	UTIL_STATUS_BUF_LENGTH		128

/***  MACRO DEFINITIONS  ***/
#define		YES_NO(a)		a == 1 ? 'Y' : 'N'
#define		A_OR_B(a)		a == 0 ? 'A' : 'B'

typedef struct _WWN_FILE_DATA {
        BOOL active;
        CHAR fileName[MAX_ARRAY_STR_LEN+1];
} WWN_FILE_DATA, *PWWN_FILE_DATA;


typedef struct _WWN_FILES {
        int numWwnFiles;
        WWN_FILE_DATA arrayDataList[1];
}WWN_FILES, *PWWN_FILES;

#define RECORD_LENGTH 10

/***  PROCEDURE DEFINITIONS ***/
	VOID	utilDebug(TINY *debugMessage, ...);
	VOID	utilUsage(MPP_STRING prog);
	BOOL	utilDetermineBusFd();
	LINT	utilGetBusFd(LINT whichDriver);
	VOID	utilFormatVertex(MPP_HANDLE vertex, MPP_STRING buffer);
	VOID	utilFormatHandle(MPP_DIR_HANDLE handle, MPP_STRING buffer);
	int	utilFormatLunPathDevice(MPP_HANDLE handle);
	MPP_STRING utilFormatDevState(MPPCMN_PATH_STATE state);
	void 	utilFormatControllerAddress(ControllerAddress_t address, MPP_STRING buffer, LWORD PathId);
	BOOL	mppSys_ProcessCmdLineArgs(LINT option, MPP_STRING argument);
	BOOL	isNum(MPP_STRING arg);

	VOID	utilFormatTime(MPP_TIME rawTime, MPP_STRING buffer);
	VOID	utilFormatHostName (MPP_STRING buffer);
	VOID	utilFormatDomainName (MPP_STRING buffer);
	VOID	utilFormatCurrentGMTTime (MPP_STRING buffer);
	void	mppUtilSys_FormatVirtualTarget(mpp_utilSysStatusInfo_t *utilSysStatusInfo, MPP_STRING buffer);
	void	mppUtilSys_FormatPhysicalTarget(ControllerAddress_t *ctlAddress, MPP_STRING buffer);

        void    mppUtilSys_ReadPhysicalTarget(ControllerAddress_t *ctlAddress, MPP_STRING buffer);
        void     mppUtilSys_ReadVirtualTarget(mpp_utilSysStatusInfo_t *utilSysStatusInfo,  MPP_STRING buffer);
        BOOL    mppUtilSys_CompareCtlAddr( ControllerAddress_t *utilCtlAddress, ControllerAddress_t *ctlAddress);
        MPP_STRING mppUtilSys_setWwnDirPath();
        MPP_FILE_HANDLE mppUtilSys_OpenFile(MPP_STRING fileName, INT flags, INT mode);
        INT mppUtilSys_CloseFile(MPP_FILE_HANDLE fd);
        INT mppUtilSys_ReadFile(MPP_FILE_HANDLE fd, MPP_STRING rdBuffer,INT bytesToRead);
        INT mppUtilSys_WriteFile(MPP_FILE_HANDLE fd, MPP_STRING wrtBuffer, INT bytesToWrite);
        INT mppUtilSys_SetFilePointer(MPP_FILE_HANDLE fd, INT bytesToMove, INT seekStart );
        INT mppUtilSys_DeleteFile(MPP_STRING filePathName);
        BOOL mppUtilSys_DoesWwnDirPathFileExist(MPP_STRING file_name);
        BOOL mppUtilSys_DeleteWWNList();
        BOOL mppUtilSys_PrintWWNList(PWWN_FILES *wwnFileData);


#endif
