/*******************************************************************************
* Copyright 2004-2006 LSI Logic Corporation.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME:		scsiio.h
SUMMARY:	SCSI I/O defines and typedefs
COMPONENT:	corelib
VERSION:	%version: 70 %
UPDATE DATE:	%date_modified: Mon Feb 04 18:42:13 2008 %
PROGRAMMER:	%created_by:    sdachepa %

DESCRIPTION:	Environment Dependent SCSI Definitions

     	Contains constant and type definitions for generic SCSI oper-
     	ations, as well as structure definitions and constants for disk
     	array mode pages.  Some structures have bit fields that depend
     	on byte order (two versions are provided - for little-endian and
     	big-endian machines).  Alpha, MIPS, and Intel 80x86 processors
     	are LITTLE-ENDIAN types (the default here).

NOTES:

REFERENCE:
1.  PIP0003A.DOC, Source Code Integrity Measures

CODING STANDARD WAIVERS:

*******************************************************************************/

#ifndef __INCscsiio
#define __INCscsiio

/***  CONSTANT DEFINITIONS  ***/

#define CDB_LENGTH			12
#define MAX_BLK_LIST_SIZE		128
#define MAX_SES_PAGES			32
#define CTL_NUM_SW_PARTITIONS		14  /* ctl s/w partitions listed in S/W Inq Page */

/*
 * Page Control Values
 */

#define PAGE_CONTROL_CURRENT		0x00
#define PAGE_CONTROL_CHANGEABLE		0x01
#define PAGE_CONTROL_DEFAULT		0x02
#define PAGE_CONTROL_SAVED		0x03

/*
 * Page Codes
 */

#define PAGE_CODE_CACHING		0x08
#define PAGE_CODE_LOGICAL_ARRAY		0x2b
#define PAGE_CODE_PHYSICAL_ARRAY	0x2a
#define PAGE_CODE_REDUNDANT_CONTROLLER	0x2c
#define PAGE_CODE_SUBSYSTEM		0x2d
#define PAGE_CODE_CACHE_CONTROL		0x2e
#define PAGE_CODE_DATE_TIME		0x2f
#define PAGE_CODE_HOTSPARE		0x3a
#define PAGE_CODE_ALL_PAGES             0x3f

#define	PAGE_CODE_LUN_STATS		0x3a
#define	PAGE_CODE_CONT_STATS		0x3b
#define	PAGE_CODE_CONT_MON_MGMT		0X30

/*
 * SCSI Commands
 */

#define	 SCSI_TEST_UNIT_READY		0x00
#define	 SCSI_REZERO			0x01
#define	 SCSI_REQUEST_SENSE		0x03
#define	 SCSI_FORMAT			0x04
#define	 SCSI_REPAIR_PARITY		0x06
#define	 SCSI_REASSIGN_BLOCK		0x07
#define  SCSI_READ			0x28
#define  SCSI_SMALL_WRITE		0x0a
#define  SCSI_WRITE			0x2a
#define  SCSI_WRITE_12			0xaa
#define  SCSI_WRITE_16			0x8a
#define  SCSI_INQUIRY			0x12
#define	 SCSI_LOG_SELECT		0x4c
#define	 SCSI_LOG_SENSE			0x4d
#define	 SCSI_MODE_SELECT		0x55
#define	 SCSI_MODE_SENSE		0x5a
#define	 SCSI_RESERVE			0x16
#define	 SCSI_RELEASE			0x17
#define  SCSI_RECEIVE_DIAGNOSTIC	0x1c
#define  SCSI_SEND_DIAGNOSTIC		0x1d
#define	 SCSI_READ_CAPACITY		0x25
#define	 SCSI_WRITE_VERIFY 		0x2e
#define	 SCSI_WRITE_VERIFY_12	0xae
#define	 SCSI_WRITE_VERIFY_16	0x8e
#define  SCSI_VERIFY			0x2f
#define	 SCSI_READ_DEFECT_DATA 		0x37
#define	 SCSI_WRITE_BUFFER 		0x3b
#define	 SCSI_READ_BUFFER 		0x3c
#define	 SCSI_SAFE_PASS_THROUGH		0xBE
#define   SCSI_READ_CAPACITY_16     0x9E
#define   SCSI_REPORT_LUNS          0xA0
#define   SCSI_START_STOP_UNIT      0x1B
#define   SCSI_LSI_QUIESCE          0x0E
#define  SCSI_ENGENIO_BUS_RESET         0xF0
#define	 SCSI_PR_IN    		0x5E
#define   SCSI_PR_OUT         0x5F



/*
 * SCSI Status Definitions
 */
#define SCSI_STAT_GOOD			0x00
#define SCSI_STAT_CHECK_CONDITION	0x02
#define SCSI_STAT_BUSY			0x08
#define SCSI_STAT_RESERVATION_CONFLICT	0x18
#define SCSI_STAT_QUEUE_FULL		0x28

/*
 * SCSI Sense Key Definitons
 */

#define SENSE_KEY_NO_SENSE            	0x00
#define SENSE_KEY_RECOVERED_ERROR    	0x01
#define SENSE_KEY_NOT_READY          	0x02
#define SENSE_KEY_MEDIUM_ERROR       	0x03
#define SENSE_KEY_HARDWARE_ERROR     	0x04
#define SENSE_KEY_ILLEGAL_REQUEST    	0x05
#define SENSE_KEY_UNIT_ATTENTION     	0x06
#define SENSE_KEY_DATA_PROTECT       	0x07
#define SENSE_KEY_BLANK_CHECK       	0x08
#define SENSE_KEY_VENDOR_SPECIFIC    	0x09
#define SENSE_KEY_COPY_ABORTED       	0x0a
#define SENSE_KEY_ABORTED_COMMAND    	0x0b
#define SENSE_KEY_EQUAL             	0x0c
#define SENSE_KEY_VOLUME_OVERFLOW    	0x0d
#define SENSE_KEY_MISCOMPARE         	0x0e
#define SENSE_KEY_RESERVED           	0x0f

/*
 * Inquiry EVPD page codes
 */

#define INQ_SUPPAG_PAGE		0x00
#define INQ_SERNUM_PAGE		0x80
#define INQ_DEVCID_PAGE		0x83
#define INQ_HDWVER_PAGE		0xC0
#define INQ_FRMVER_PAGE		0xC1
#define INQ_SFWVER_PAGE		0xC2
#define INQ_FEAPAR_PAGE		0xC3
#define INQ_SUBSYS_PAGE		0xC4
#define INQ_HSTINT_PAGE		0xC5
#define INQ_DGM_PAGE		0xC6
#define INQ_HSTINT2_PAGE	0xC7
#define INQ_EXTDEVID_PAGE	0xC8
#define INQ_VOLACESSCTRL_PAGE	0xC9

/*
 * Buffer IDs for ReadBuffer
*/

#define TRANSFER_BUFFER       0x00
#define PROCESSOR_MEMORY      0x01
#define SUBSYSTEM_IDENTIFIER  0xE8
#define SUBSYSTEM_FAULT       0xE9
#define DRIVE_FAULT           0xEA
#define HOST_MANAGED          0xEC
#define HOST_INTERFACE        0xED
#define USER_CONFIG_OPTIONS   0xEE
#define RM_DATA_STORE         0xEF
#define BOOTP_INFORMATION     0xF0

/*
 * Send/Receive Diagnostic page codes
 */

#define SES_SUPPORTED_DIAG_PAGE	0x00
#define SES_CONFIGURATION_PAGE	0x01
#define SES_ENCLOSURE_PAGE	0x02
#define SES_ARRAY_PAGE		0x06
#define SES_DRIVE_GROUP_PAGE	0x91
#define SES_TRANSLATION_PAGE	0xA0

/* ASC Definitions - limited to those for which a controller switch will NOT be able to alleviate the problem*/

#define  FORMAT_FAILED  0x31
#define  OUT_OF_ALTERNATES 0x32
#define  CONTROLLER_MSG_ERROR 0x43
#define  DRIVE_SELECTION_TIMEOUT 0x45
#define  OPERATION_NOT_ALLOWED 0x84
#define  DRIVE_IO_ABORTED 0x85
#define  MICROCODE_DL_FAILED 0x87
#define  DRIVE_ERROR  0xE0
/* The following cases are for ADP-93 */
#define  NO_INDEX 0x01
#define  NO_SEEK  0x02
#define  WRITE_FAULT 0x03
#define  NO_REFERENCE_POSITION 0x06
#define  TRACK_ERROR  0x09
#define  AUTO_REALLOCATION_FAILURE 0x0c
#define  ECC_ERROR 0x10
#define  UNRECOVERED_READ_ERROR 0x11
#define  NO_ID_FIELD 0x12
#define  NO_DATA_FIELD 0x13
#define  NO_RECORDED_ENTITY 0x14
#define  POSITIONING_ERROR 0x15
#define  DATA_SYNCH_ERROR 0x16
#define  COMMAND_SEQUENCE_ERROR 0x2c
#define  INCOMPATIBLE_MEDIA 0x30
#define  OVERLAPPED_COMMAND 0x4E
#define  DRIVE_RECOVERED_ERROR_NOT_ALL_DATA 0x80
#define  QUIESCIENCE_IN_PROGRESS 0x8B
#define  DACSTORE_ERROR 0x90
#define  DRIVE_VENDOR_UNIQUE_SENSE_DATA 0x93
#define  LUN_NOT_OWNED 0x94
#define  DRIVE_CHANNEL_RESET 0x95
#define  ICON_FAILURE 0xC0

/*
 * ASC/ASCQ Definitions
 *
 * Note:  following method for accessing ASC/ASCQ as WORD value should
 *        work and should be portable:
 *
 *        if ( GET_WORD( sense_data->ASC ) == AS_DEGRADED_LUN ) ...
 */

#define	AS_DEGRADED_LUN			0x8600
#define	ASC_DEGRADED			0x86
#define	ASCQ_DEGRADED			0x00
#define ASCQ_QUIESCENCE_IN_PRGS		0x02
#define ASC_QUIESCENCE			0x8b
#define ASC_NOT_READY			0x04
#define ASCQ_BECOMING_READY		0x01
#define ASCQ_FORMAT_IN_PROGRESS 0x04
#define ASCQ_OPERATION_IN_PROGRESS      0x07
#define ASC_MODE_ERROR			0x91
#define	ASCQ_GENERAL_ERROR		0x00
#define	ASCQ_CMD_LOCK_VIOLATION		0x36
#define ASC_MICROCODE_DOWNLOAD_FAILED	0x87
#define ASCQ_INVALID_BOARD_TYPE		0x08
#define ASCQ_GENERAL_DOWNLOAD_FAILURE	0x00
#define ASCQ_UTM_LUN_CONFLICT		0x0C
// the following 3 ASCQs added for PR 81936
#define ASCQ_REPOSITORY_FULL_20		0x20
#define ASCQ_SNAPSHOT_OPERATION_STOPPED		0x21
#define ASCQ_REPOSITORY_FULL_22		0x22

// the following ASCQs are used for Persistent Reservation status changes
#define ASCQ_RESERVATIONS_PREEMPTED	0x03
#define ASCQ_RESERVATIONS_RELEASED	0x04
#define ASCQ_REGISTRATIONS_PREEMPTED	0x05

/*
* When ASC==0x94, we have two ASCQs - 0x01 and 0x02.
* A volume cannot be transferred to alternative controller with 0x94/02 condition
*/
#define ASCQ_LUN_CAN_BE_OWNED    0x01
#define ASCQ_LUN_CANNOT_BE_OWNED 0x02

// They are used to identify the SCSI sense 05/20/00 returned
// by the controller in response to an unsupported command
#define ASC_INVALID_COMMAND      0x20
#define ASCQ_INVALID_COMMAND     0x00

/*
 * LUN Type
 */

#define REGULAR_LUN			0
#define SUB_LUN				1

/*
 * Drive Status
 */

#define OPTIMAL_DRV			0x00
#define NON_EXIST			0x01
#define SPARE				0x02
#define DRV_FAILED			0x03
#define REPLACED			0x04
#define WARNING				0x05
#define MISMATCH			0x06
#define CONTROLLER			0x07
#define FORMATING			0x08
#define WRONGDRV			0x09
#define OFFLINEDRV			0x0b
#define UNCERTIFIED_DRV		0x1b

/*
 * Drive Actions
 */

#define ADD_DRIVE			0x80
#define DELETE_DRIVE			0x81
#define FAIL_DRIVE			0x83
#define REPLACE_DRIVE			0x84
#define REPLACE_DRIVE_FORMAT		0x94

/*
 * Page 2B constant definitions:
 *
 * LUN Status
 */

#define OPTIMAL				0x00
#define OPTIMAL_PARITY_SCANNING		0x20
#define	DEGRADED			0x01
/* PR 5736 - We show Unknown when LUN is degraded and pending reconstruction / initialization.  IAF
 * jasherma 11/30/98
 */
#define DEGRADED_IAF			0x53
#define REPLACED_DRV_FORMATING		0x41
#define REPLACED_RD0_FORMATING		0x40
#define	RECONSTLUN			0x02
#define	DEAD				0x04
#define FORMAT_IN_PROGRESS		0x44
#define IAF_IN_PROGRESS			0x50
#define LUN_AWAITING_FORMAT		0x54
#define LUN_OPTIMAL_RECONFIGURING	0x60
#define LUN_DEGRADED_RECONFIGURING	0x61
#define LUN_DEAD_RECONFIGURING		0x64
#define LUN_DEAD_WDR			0x74

/*
 * Logical Array Page Action Codes
 */

#define ADD_LUN				0x80
#define DELETE_LUN			0x81
#define MODIFY_LUN			0x82
#define REPLACE_LUN			0x83
#define TEST_ADD_LUN			0x84
#define TEST_REPLACE_LUN		0x85
#define STOP_LUN_PARITY_SCAN		0x86
#define ADD_LUN_NO_INIT			0x87
#define REVIVE_LUN_CHANNEL_FAILURE	0x88

/*
 * Logical Array Page LUN Status Codes
 */

#define OPTIMAL_LUN			0x00
#define NON_FATAL_PARM_MISMATCH		0x10
#define UNDEFINED_LUN			0x01 /* (NOT non-existent) */
#define RECONSTRUCTING			0x11
#define FATAL_PARM_MISMATCH		0x02
#define MULTIPLE_DRIVES_DOWN		0x12
#define AWAITING_FULL_FORMAT		0x22
#define AWAITING_MODIFIED_FORMAT	0x32
#define FORMATTING			0x42

/*
 *  Logical Array Page LUN sub status codes
 */
#define PARITY_SCAN_ABORTED		0x50

/* These are masks to be used on the OperationProgress field of page 2B */
#define LUN_OPERATION_PROGRESS_MASK	0x0F
#define LUN_OPERATION_TYPE_MASK		0x70
#define LUN_OP_PENDING_MASK			0x80

/* These are the different operation types */
#define LUN_QUIET			0x00
#define LUN_RECONSTRUCTING	0x01
#define LUN_DSS_IN_PROGRESS	0x02
#define LUN_DCE_IN_PROGRESS	0x03
#define LUN_DRM_IN_PROGRESS	0x04

/* These are convenience macros for extracting information from the OperationProgress field */
#define LUN_OPERATION_PROGRESS(x)	((x) & LUN_OPERATION_PROGRESS_MASK)
#define LUN_OPERATION_TYPE(x)		(((x) & LUN_OPERATION_TYPE_MASK) >> 4)
#define IS_LUN_OP_PENDING(x)		((x) & LUN_OP_PENDING_MASK)

/*
 *  Log Select Action Codes
 */
#define	DISABLE_PERF_MONITORING		0x00
#define	ENABLE_PERF_MONITORING		0x01
#define	RESET_ALL_PARAMETERS		0x02

#define	LOG_SELECT_PAGE_LENGTH		0x0c

/*
 * Controller modes definitions
 */

#define PASSIVE_MODE			0x00 /*This is a legacy definition */
#define NO_ALTERNATE_PRESENT            0x00
#define ACTIVE_MODE			0x01 /*This is a legacy definition */
#define ALTERNATE_PRESENT		0x01
#define DUAL_ACTIVE_MODE		0x02
#define RESET_MODE			0x04
#define UNKNOWN_STATE                   0xff

/*
 *  Alternate RDAC Mode - MODE SELECT options
 */

#define	RDAC_RELEASE_ALTERNATE 		0x08
#define	RDAC_RESET_ALTERNATE 		0x0c

/* RDAC Options field */

#define PARITY_SCAN			0x01
#define RDAC_FORCED_QUIESENCE		0x02

/* RDAC dual active LUN table mode sense values */

#define LUN_NOT_CONFIGURED		0x00
#define LUN_OWNED			0x01
#define LUN_OWNED_BY_ALTERNATE		0x02

/*
 * INQUIRY Peripheral Qualifier Field Value(s)
 */

#define LUN_CONNECTED			0x00 /* LUN currently connected */
#define LUN_NOT_CONNECTED		0x01 /* LUN currently not connected */

/*
 * Host Interface Definition Values
 */

#define HINTF_RS232				1
#define HINTF_PARALLELl_SCSI	2
#define HINTF_FCP				3
#define HINTF_ETHERNET			4
#define HINTF_PCI_I2O           5

/*
 * Feature Parameters Definition Values
 */

/* PCI Connect Parameter Definition Values */
#define PCI_FW_DL_DISABLED    0x01

/*
* SCSI-3 Persistent reservation parameter definition
*/
#define MAX_TRANSPORTIDS               8   /*max 8 HBA on a host */
#define MAX_RESERVATION_KEYS           32  /*max number of reservation keys
                                            *in PRIN parameter data for READ KEYS
                                            */
#define MAX_RESERVATION_DESCRIPTORS    8   /*max number of reservation descriptors
                                            *in PRIN parameter data for READ RESERVATION
                                            */


/*
* PROUT service action codes
*/
#define  SCSI_PROUT_REGISTER                 0x00
#define  SCSI_PROUT_RESERVE                  0x01
#define  SCSI_PROUT_RELEASE                  0x02
#define  SCSI_PROUT_CLEAR                    0x03
#define  SCSI_PROUT_PREEMPT                  0x04
#define  SCSI_PROUT_PREEMPT_AND_ABORT        0x05
#define  SCSI_PROUT_REGISTER_AND_IGNORE_EXISTING_KEY  0x06
/*
* PRIN service action codes
*/
#define  SCSI_PRIN_READ_KEYS                    0x00
#define  SCSI_PRIN_READ_RESERVATION             0x01
#define  SCSI_PRIN_REPORT_CAPABILITIES          0x02


/******************************************************************************
 ***	       BYTE AND BIT OFFSETS USED WITH CDB'S AND SENSE DATA 	    ***
 ***			      (MACHINE-INDEPENDENT)			    ***
 *****************************************************************************/

/*
 * Byte offsets - example of usage:
 *
 *		BlkNumber = GETLWORD( Cdb.Byte[ C_READCAP_BLKNO ] );
 */

#define	C_OPCODE		0
#define C_BITS			1
#define C_INQUIRY_PAGECODE	2
#define C_INQUIRY_LENGTH	4
#define C_READCAP_BLKNO		2
#define C_REQSENS_LENGTH	4
#define C_MODSENS_PAGECODE	2
#define C_MODSENS_LENGTH	7
#define C_VERIFY_BLKNO		2
#define C_VERIFY_LENGTH		7
#define C_MODSEL_LENGTH		7
#define C_READBUF_BUFFID	2
#define C_READBUF_BUFFOFFSET	3
#define C_READBUF_LENGTH	6
#define C_WRITEBUF_BUFFID	2
#define C_WRITEBUF_BUFFOFFSET	3
#define C_WRITEBUF_LENGTH	6
#define C_DOWNLOAD_LENGTH	6
#define C_FORMAT_VENDORSPEC	2
#define C_FORMAT_INTERLEAVE	3

/*
 * Bit offsets and bitcounts for use in manipulating "C_BITS" field
 * using GETBITS, SETBITS macros, e.g.,
 *
 *	LunNumber = GETBITS( Cdb.Byte[ C_BITS ], LUN, LUN_BITCOUNT );
 *
 *		or
 *
 *	Cdb.Byte[ C_BITS ] |= SETBITS( LUN, LUN_BITCOUNT, LunNumber );
 */

#define LUN_OFFS	 5	/* "Logical Unit No."	- All Commands */
#define LUN_BITCOUNT	 3
#define EVPD_OFFS	 0	/* "Vital Product Data"	- INQUIRY */
#define EVPD_BITCOUNT	 1
#define RELADR		 0	/* "Relative Address"	- READ CAPACITY, VERIFY */
#define RELADR_BITCOUNT	 1
#define AENP_OFFS	 3	/* "AEN Sense"		- REQUEST SENSE */
#define AENP_BITCOUNT	 1
#define DBD_OFFS	 3	/* "Disable Blk Descr."	- MODE SENSE */
#define DBD_BITCOUNT	 1
#define PC_OFFS		 6	/* "Page Control"	- MODE SENSE */
				/*    note - "PC" is actually in the */
				/*    MODESENSE_PAGECODE byte        */
#define PC_BITCOUNT	 2
#define PGCODE_OFFS	 0
#define PGCODE_BITCOUNT	 6
#define BYTCHK_OFFS	 1 	/* "Byte Check"		- VERIFY */
#define BYTCHK_BITCOUNT	 1
#define PARCHK_OFFS	 3	/* "Parity Check"	- VERIFY */
#define PARCHK_BITCOUNT	 1
#define	DPO_OFFS	 4	/* "Disable Page Out"	- VERIFY */
#define DPO_BITCOUNT	 1
#define SP_OFFS		 0	/* "Save Pages"		- MODE SELECT */
#define SP_BITCOUNT	 1
#define PF_OFFS		 4	/* "Page Format"	- MODE SELECT & */
#define PF_BITCOUNT	 1	/*                        SEND DIAGNOSTIC */
#define DLFMT_OFFS	 0	/* "Defect List Format"	- FORMAT */
#define DLFMT_BITCOUNT	 3
#define CMPLST_OFFS	 3	/* "Complete List"	- FORMAT */
#define CMPLST_BITCOUNT	 1
#define FMTDATA_OFFS	 4	/* "Format Data"	- FORMAT */
#define FMTDATA_BITCOUNT 1
#define MODE_OFFS	 0	/* "Mode"		- READ/WRITE BUFFER */
#define MODE_BITCOUNT	 3
#define DRVADR_OFFS	 3	/* "Drive Addressing	- WRITE BUFFER */
#define DRVADR_BITCOUNT  1

#define ILI_OFFS	 5	/* "Illegal Length Ind" - SENSE DATA */
#define ILI_BITCOUNT	 1
#define SENSKEY_OFFS	 0	/* "Sense Key" (1)      - SENSE DATA */
#define SENSKEY_BITCOUNT 4

#define	PCR_OFFS	 1	/* "Page Control Reset" - LOG SELECT */
#define	PCR_BITCOUNT	 1
#define	PPC_OFFS	 1	/*                      - LOG SENSE  */
#define	PPC_BITCOUNT	 1
#define PCV_OFFS	 0	/* "Page Code Valid"    - RECEIVE DIAGNOSTIC */
#define PCV_BITCOUNT	 1
#define ST_OFFS		 2	/* "Self Test"		- SEND DIAGNOSTIC */
#define ST_BITCOUNT	 1
#define VND_OFFS	 6	/* "Vendor Unique"	- SEND DIAGNOSTIC */
#define VND_BITCOUNT	 2

/***  TYPE DEFINITIONS  ***/
typedef enum _MODE_SENSE_PAGE_CODE_TYPE {
	CURRENT_PAGE_CODE_VALUES = 0,
	CHANGEABLE_PAGE_CODE_VALUES = 1,
	DEFAULT_PAGE_CODE_VALUES = 2,
	SAVED_PAGE_CODE_VALUES = 3
} MODE_SENSE_PAGE_CODE_TYPE;

/******************************************************************************
 ***	 SCSI STRUCTURES THAT SHOULD NOT CHANGE FROM MACHINE TO MACHINE	    ***
 *****************************************************************************/

typedef struct ReadCapacity {
	LWORD		Blkno;
	LWORD		Capacity;
} ReadCapacityData_t;

typedef struct BlockList {
	WORD		Reserved;
	WORD		ListLength;
	LWORD		BlockAddress[ MAX_BLK_LIST_SIZE ];
} BlockList_t;

typedef struct InquiryReturnHeader {
	unsigned int	Periph_Device_Type	:5,
			Periph_Qualifier	:3,
			PageCode		:8,
			Reserved		:8,
			PageLength		:8;
} InquiryReturnHeader_t;

typedef struct ModeParameterHeader {
	WORD		ModeDataLength;
	BYTE		MediumType;
	BYTE		DeviceSpecificParameter;
	WORD		Reserved;
	WORD		BlockDescriptorLength;
} ModeParameterHeader_t;


typedef struct ModePage2A {
	ModeParameterHeader_t	Header;
	BYTE		PageCode;
	BYTE		PageLength;
	BYTE		DriveStatus[240];
} ModePage2A_t;

typedef struct ModePage2C {
	ModeParameterHeader_t	Header;
	BYTE		PageCode;
	BYTE		PageLength;
	BYTE		Controller_Serial_No[ 16 ];
	BYTE		AltControllerSerialNo[ 16 ];
	BYTE		RDAC_Mode[ 2 ];
	BYTE		AltRDACMode[ 2 ];
	BYTE		QuiescenceTimeout;
	BYTE		RDACOptions;
	BYTE		ControllerLunTable[ 64 ];
	BYTE		Reserved3;
	BYTE		Reserved4;
} ModePage2C_t;

typedef struct ModePage2CSubPage {
	ModeParameterHeader_t	Header;
	BYTE		PageCode;
	BYTE		SubPageCode;
	BYTE		PageLength[ 2 ];
	BYTE		Controller_Serial_No[ 16 ];
	BYTE		AltControllerSerialNo[ 16 ];
	BYTE		RDAC_Mode[ 2 ];
	BYTE		AltRDACMode[ 2 ];
	BYTE		QuiescenceTimeout;
	BYTE		RDACOptions;
	BYTE		ControllerLunTable[ 256 ];
	BYTE		Reserved3;
	BYTE		Reserved4;
} ModePage2CSubPage_t;

typedef struct ModePage2D {
	ModeParameterHeader_t	Header;
	BYTE		PageCode;
	BYTE		PageLength;
	BYTE		ErrIndicators;
	BYTE		ComponentStatus[ 1 ];
} ModePage2D_t;

typedef struct ModePage3A {
	ModeParameterHeader_t	Header;
	BYTE		PageCode;
	BYTE		PageLength;
	BYTE		Action;
	BYTE		Reserved[11];
	BYTE		MaxGHSDrivesSupported;
	BYTE		NumHSIdentifierLists;
	BYTE		IdentifierLists[239];
} ModePage3A_t;

typedef struct LogPage3A {
     BYTE               PageCode;
     BYTE               Reserved1;
     WORD               PageLength;
     BYTE               LogParameters[1];
} LogPage3A_t;

typedef struct LogPage3B {
     BYTE               PageCode;
     BYTE               Reserved1;
     WORD               PageLength;
     BYTE               LogParameters[1];
} LogPage3B_t;

typedef struct SupportedDiagPage {
	BYTE		PageCode;
	BYTE		Reserved;
	WORD		PageLength;
	BYTE		Pages[MAX_SES_PAGES];
} SupportedDiagPage_t;

typedef struct ConfigurationPage {
	BYTE		PageCode;
	BYTE		NumberofSubEnclosures;
	WORD		PageLength;
	LWORD		GenerationCode;
	BYTE		Descriptors[1];
} ConfigurationPage_t;

/* this structure is intended to be used for both Enclosure and Array Pages */
typedef struct EnclosureArrayPage {
	BYTE		PageCode;
	BYTE		BitFields;
	WORD		PageLength;
	LWORD		GenerationCode;
	BYTE		Data[1];
} EnclosureArrayPage_t;

typedef struct TranslationPage {
	BYTE		PageCode;
	BYTE		BitFields;
	WORD		PageLength;
	LWORD		GenerationCode;
	LWORD		Reserved;
	BYTE		Descriptors[1];
} TranslationPage_t;

typedef struct SenseData {
	BYTE		Error_Code;
	BYTE		Segment_Number; /* not applicable to DAC */
	BYTE		Sense_Key;
	BYTE		Information[ 4 ];
	BYTE	 	Additional_Len;
	LWORD		Command_Specific_Info;
	BYTE		ASC;
	BYTE		ASCQ;
	BYTE		Field_Replaceable_Unit;
	BYTE		Sense_Key_Specific_Info[ 3 ];
	BYTE		Recovery_Action[ 2 ];
	BYTE		Total_Errors;
	BYTE		Total_Retries;
	BYTE		ASC_Stack_1;
	BYTE		ASCQ_Stack_1;
	BYTE		ASC_Stack_2;
	BYTE		ASCQ_Stack_2;
	BYTE		Additional_FRU_Info[ 8 ];
	BYTE		Error_Specific_Info[ 3 ];
	BYTE		Error_Detection_Point[ 4 ];
	BYTE		Original_CDB[10];
	BYTE		Host_ID;
	BYTE		Host_Descriptor[ 2 ];
	BYTE		Serial_Number[ 16 ];
	BYTE		Array_SW_Revision[ 4 ];
	BYTE		Data_Xfer_Operation;
	BYTE		LUN_Number;
	BYTE		LUN_Status;
	BYTE		Drive_ID;
	BYTE		Xfer_Start_Drive_ID;
	BYTE		Drive_SW_Revision[ 4 ];
	BYTE		Drive_Product_ID[ 16 ];
	BYTE		PowerUp_Status[ 2 ];
	BYTE		RAID_Level;
	BYTE		Drive_Sense_ID[ 2 ];
	BYTE		Drive_Sense_Data[ 32 ];
	BYTE		Reserved2[24];
} SenseData_t;

/*
 * (1)  Even though there's a BYTE field called Sense_Key in the sense data,
 *      technically, the actual sense key is the low-order four bits
 */

typedef struct CmdBlock {
	BYTE		Byte[12];
	BYTE 		*Buffer;
	LWORD		BufferLength;
} CmdBlock_t;

typedef struct FCTransportId {
   BYTE     Reserved1[2];
   BYTE     WWN[8];
   BYTE     Reserved2[2];
}  FCTransportId_t;

typedef  BYTE ReservationKey[8];
/*
* Persisten Reserve IN parameter data for READ KEYS
*/
typedef struct PRINReadKeysParamData
{
   BYTE                    PRgeneration[4];
   BYTE                    Additional_Len[4];
   ReservationKey          Reservation_Key[MAX_RESERVATION_KEYS];
}  PRINReadKeysParamData_t;



/******************************************************************************
 ***  SCSI STRUCTURES THAT WILL NEED TO CHANGE FOR DIFFERENT ARCHITECTURES  ***
 *****************************************************************************/

#ifndef BIG_ENDIAN

/* Little Endian version */

typedef struct InquiryData {
	unsigned int	Periph_Device_Type		: 5,
					Periph_Qualifier		: 3,
					Device_Type_Qualifier	: 7,
					Removable_Media			: 1,
					ANSI_Version			: 3,
					ECMA_Version			: 3,
					ISO_Version				: 2,
					Response_Data_Format	: 4,
					Reserved1				: 3,
					AENC					: 1;
	unsigned int	Additional_Length	: 8,
					Reserved2			: 8,
					Reserved3			: 6,
					EncServ				: 1,
					Reserved4			: 1,
					SftReset			: 1,
					CmdQue				: 1,
					Reserved5			: 1,
					Linked				: 1,
					Sync				: 1,
					WBus16				: 1,
					WBus32				: 1,
					RelAdr				: 1;
	BYTE			Vendor_ID[ 8 ];
	BYTE			Product_ID[ 16 ];
	BYTE			Revision_Level[ 4 ];
} InquiryData_t;

typedef struct DriveInquiryData {
	unsigned int	Periph_Device_Type	: 5,
					Periph_Qualifier	: 3,
					Device_Type_Qualifier: 7,
					Removable_Media		: 1,
					ANSI_Version		: 3,
					ECMA_Version		: 3,
					ISO_Version			: 2,
					Response_Data_Format: 4,
					Reserved1			: 3,
					AENC				: 1;
	unsigned int	Additional_Length	: 8,
					Reserved2			:16,
					SftReset			: 1,
					CmdQue				: 1,
					Reserved3			: 1,
					Linked				: 1,
					Sync				: 1,
					WBus16				: 1,
					WBus32				: 1,
					RelAdr				: 1;
	BYTE		Vendor_ID[ 8 ];
	BYTE		Product_ID[ 16 ];
	BYTE		Revision_Level[ 4 ];
	BYTE		VendSpec1[20];
	BYTE		Reserved4[40];
	BYTE		VendSpec2[16];
} DriveInquiryData_t;

typedef struct InqSupportedPages
{
	unsigned int	Periph_Device_Type	:5,
					Periph_Qualifier	:3,
					PageCode			:8,
					Reserved			:8,
					PageLength			:8;
	BYTE 		Pages[32];
} InqSupportedPages_t;

typedef struct InqUnitSerialNumberData
{
	unsigned int	Periph_Device_Type	: 5,
					Periph_Qualifier	: 3,
					Page_Code			: 8,
					Reserved1			: 8,
					Page_Length			: 8;
	BYTE		SerialNumber[32];
} InqUnitSerialNumberData_t;

typedef struct InqShortSubSysPageData
{
	unsigned int	Periph_DeviceType	: 5,
			Periph_Qualifier	: 3,
			Page_Code		: 8,
			Reserved1		: 8,
			Page_Length		: 8;
	BYTE		Identifier[16];
	BYTE		Rev_Level[4];
	BYTE		SlotID[2];
	BYTE		Reserved2[6];
} InqShortSubSysPageData_t;

typedef struct InqLongSubSysPageData
{
	unsigned int	Periph_DeviceType	: 5,
			Periph_Qualifier	: 3,
			Page_Code		: 8,
			Reserved1		: 8,
			Page_Length		: 8;
	BYTE		Page_ID[4];
	BYTE		Identifier[16];
	BYTE		Rev_Level[4];
	BYTE		SlotID[2];
	BYTE		Reserved2[2];
} InqLongSubSysPageData_t;

typedef struct InqDeviceIdData
{
	unsigned int	Periph_Device_Type	: 5,
			Periph_Qualifier	: 3,
			Page_Code			: 8,
			Reserved1			: 8,
			Page_Length			: 8;
	unsigned int	CodeSet		: 4,
			Reserved2	: 4,
			IdentiferType	: 4,
			Reserved3	: 4,
			Reserved4	: 8,
			IdentifierLength : 8;
	BYTE		ExtendedIdentifier [16];
	unsigned int	Target_CodeSet		: 4,
			Target_Protocol_Identifier	: 4;
} InqDeviceIdData_t;

typedef struct InqHwPageData {
	unsigned int	Periph_Device_Type	: 5,
					Periph_Qualifier	: 3,
					Page_Code			: 8,
					Reserved1			: 8,
					Page_Length			: 8;
	BYTE		Page_Identifier[ 4 ];
	BYTE		Num_Channels;
	BYTE		Flags;
	BYTE		Processor_Memory_Size;
	BYTE		Reserved2[ 5 ];
	BYTE		Board_Name[ 64 ];
	BYTE		Board_Part_Number[ 16 ];
	BYTE		Schematic_Number[ 12 ];
	BYTE		Schematic_Revision[ 4 ];
	BYTE		Serial_Number[ 16 ];
	BYTE		Reserved3[ 16 ];
	BYTE		Date_Manufactured[ 8 ];
	BYTE		Board_Revision[ 2 ];
	BYTE		Board_Identifier[ 4 ];
} InqHwPageData_t;

typedef struct InqSwPageData {
	unsigned int	Periph_Device_Type	: 5,
					Periph_Qualifier	: 3,
					Page_Code			: 8,
					Reserved1			: 8,
					Page_Length			: 8;
	BYTE		Page_Identifier[ 4 ];
	BYTE		SW_Version[ 3 ];
	BYTE		SW_Date[ 3 ];
	BYTE		FeaturesEnabled;
	BYTE		Max_LUN_Supported[ 1 ];
	BYTE		SW_Partition[CTL_NUM_SW_PARTITIONS] [16];
} InqSwPageData_t;

typedef struct InqFwPageData {
	unsigned int	Periph_Device_Type	: 5,
					Periph_Qualifier	: 3,
					Page_Code			: 8,
					Reserved1			: 8,
					Page_Length			: 8;
	BYTE		Page_Identifier[ 4 ];
	BYTE		FW_Version[ 3 ];
	BYTE		FW_Date[ 3 ];
	BYTE		Reserved2[ 2 ];
} InqFwPageData_t;

typedef struct ModePage08 {
	ModeParameterHeader_t	Header;
	unsigned int	PageCode					: 6,
					Reserved1					: 1,
					PS							: 1,
					PageLength					: 8,
					ReadCacheDisable	     	: 1,
					MultiplicationFactor	    : 1,
					WriteCacheEnable			: 1,
					Reserved2					: 5,
					WriteRetentionPriority		: 4,
					DemandReadRetentionPriority	: 4;
	WORD			DisablePrefetchTransferLength;
	WORD			MinimumPreFetch;
	WORD			MaximumPreFetch;
	WORD			MaximumPreFetchCeiling;
} ModePage08_t;

typedef struct ModePage2B {
	ModeParameterHeader_t	Header;
	unsigned  int	PageCode			: 7,
					ParametersSavable	: 1,
					PageLength			: 8,
					ActionStatus		: 8,
					RaidLevel			: 8;
	BYTE		LunType;
	BYTE		LunBlockSize[ 4 ];
	BYTE		DriveSectorSize[ 2 ];
	BYTE		LunNumberOfBlocks[ 4 ];
	BYTE		Reserved1[4];
	BYTE		LunSegmentSize[4];
	BYTE		SegmentZeroSize;
	/* LUN flags -  Previously set up using bit fields */
	WORD		LunFlags;
	BYTE		ReconBlockComplete[4];
	BYTE		ReconFrequency;
	BYTE		ReconAmount[ 2 ];
	BYTE		LunNumber;
	BYTE		OperationProgress;
	BYTE		Reserved5;
	BYTE		Disk_Bit_Map[ 32 ];
	BYTE		Configuration_Table[ 64 ];
} ModePage2B_t;

typedef struct ModePage2E {
	ModeParameterHeader_t	Header;
	unsigned int	PageCode		: 6,
					Reserved1		: 1,
					PS				: 1,
					PageLength		: 8,
					CME				: 1,
					FWT				: 1,
					CWOB			: 1,
					Reserved2		: 5,
					WCA				: 1,
					RCA				: 1,
					BOK				: 1,
					ABOK			: 1,
					CMA				: 1,
					ACMA			: 1,
					BPR				: 1,
					ABPR			: 1;
	BYTE			Reserved3;
	BYTE			Reserved4;
	BYTE			ReadCachingAlgorithm;
	BYTE			Reserved5;
	unsigned int	WriteCachingAlgorithm	: 8,
	 				Reserved6				: 8,
	 				CacheFlushAlgorithm		: 8,
	 				CacheFlushModifier		: 4,
					Reserved7				: 4;
	unsigned int	TwoMinWarnFlushAlgorithm	: 8,
	 				TwoMinWarnFlushModifier		: 4,
					Reserved8					: 4,
	 				CacheBatteryAge				: 7,
					AgeSet						: 1,
	 				Reserved10					: 8;
	BYTE		DemandFlushThreshold;
	BYTE		DemandFlushAmount;
	WORD		Reserved11;
	WORD		Reserved12;
	WORD		CacheSize;
	WORD		CacheBlockSize;
	WORD		LargeIOSize;
	BYTE		CacheMirrorAllocSize;
	BYTE		Reserved13;
	WORD		Reserved14;
	WORD		Reserved15;
	WORD		Reserved16;
	WORD		Reserved17;
	WORD		Reserved18;
	WORD        Reserved19;
	WORD        Reserved20;
	WORD        Reserved21;
	WORD        Reserved22;
	WORD        Reserved23;
	WORD        Reserved24;
	WORD        Reserved25;
	WORD        Reserved26;
	WORD        Reserved27;
	WORD        Reserved28;
	WORD        Reserved29;
	WORD        Reserved30;
} ModePage2E_t;

typedef struct ModePage2F {
	ModeParameterHeader_t	Header;
	unsigned int	PageCode	: 6,
					Reserved1	: 1,
					PS			: 1,
					PageLength	: 8,
					Reserved2	: 8,
					Reserved3	: 8;
	LWORD			SecondsSinceJan70;
} ModePage2F_t;

typedef struct CtlrMonMgmtLogPage {
	BYTE		PageCode;
	BYTE		Reserved1;
	WORD		PageLength;
	WORD		ParameterCode;
	BYTE		Flags;
	BYTE		ParameterLength;
	BYTE		ActionToTake;
	BYTE		Reserved3;
	BYTE		Reserved4[2];
} CtlrMonMgmtLogPage_t;

/* Feature Parameters VPD page format */
typedef struct InqFeaParData
{
        unsigned int    Periph_Device_Type      : 5,
        Periph_Qualifier                        : 3,
        Page_Code                               : 8,    /* Inquiry VPD Page 0xC3 */
        Reserved1                               : 8,
        PageLength                              : 8;
        BYTE                                    Page_Identifier[4];    /* "PRMS" */
        BYTE                                    MaxLunPieces;
        BYTE                                    MaxGHSDrives;
        BYTE                                    PCIConnParms;
	BYTE					UTMData;
	      BYTE PRReset                            : 1,   /* PR reset supported y/n */
		      rsvdbit1                              : 1,
		      rsvdbit2                              : 1,
		      rsvdbit3                              : 1,
		      rsvdbit4                              : 1,
		      rsvdbit5                              : 1,
		      rsvdbit6                              : 1,
		      rsvdbit7                              : 1;
        BYTE                                    Reserved2[35];
} InqFeaParData_t;


typedef struct ModePageA {
	ModeParameterHeader_t	Header;
	BYTE		PageCode;
	BYTE		PageLength;
	BYTE 		ReportLogExceptCondition: 1;
	BYTE		GlobalLogTgtSaveDisable: 1;
	BYTE		DescSenseData: 1;
	BYTE		Reserved1: 1;
	BYTE		TaskMgmtFuncOnly: 1;
	BYTE		TaskSetType: 3;
	BYTE		Obsolete1: 1;
	BYTE		QueueErrorMgmt: 2;
	BYTE		Reserved2: 1;
	BYTE		QueueAlgorithmModifier: 4;
	BYTE		Obsolete2: 3;
	BYTE		SoftwareWriteProtect: 1;
	BYTE		UAInterLockControl: 2;
	BYTE		ReportACheck: 1;
	BYTE		VS: 1;
	BYTE		AutoLoadMode: 3;
	BYTE		Reserved3: 3;
	BYTE		TaskAbortedStatus: 1;
	BYTE		ApplicationTagOwner: 1;
	BYTE		Obsolete3[2];
	BYTE		BusyTimeoutPeriod[2];
	BYTE		ExtendedSelfTestCompletion[2];
} ModePageA_t;

typedef struct InqSubSystem
{
        unsigned int    Periph_Device_Type      : 5,
        Periph_Qualifier                        : 3,
        Page_Code                               : 8,    /* Inquiry VPD Page 0xC4 */
        Reserved1                               : 8,
        PageLength                              : 8;
        BYTE                                    Page_Identifier[4];    /* "subs" */
        BYTE                                    SubSystemId[16];
        BYTE                                    SubSystemRevision[4];
        BYTE                                    ControllerSlotId[2];
        BYTE                                    Reserved2[2];
} InqSubSystem_t;

typedef struct InqVolumeAccessControl
{
        unsigned int    Periph_Device_Type      : 5,
        Periph_Qualifier                        : 3,
        Page_Code                               : 8,    /* Inquiry VPD Page 0xC9 */
        Reserved1                               : 8,
        PageLength                              : 8;
        BYTE                                    Page_Identifier[4];    /* "vace" */
        BYTE					AVTCVP;
	BYTE					PathPriotity;
        BYTE                                    Reserved2[38];
} InqVolumeAccessControl_t;

typedef struct InqExtDeviceId
{
        unsigned int    Periph_Device_Type      : 5,
        Periph_Qualifier                        : 3,
        Page_Code                               : 8,    /* Inquiry VPD Page 0xC8 */
        Reserved1                               : 8,
        PageLength                              : 8;
        BYTE                                    Page_Identifier[4];    /* "edid" */
	BYTE					Reserved2[3];
	BYTE					VolumeUniqueIdLength;
	BYTE					VolumeUniqueId[16];
	BYTE					VolumeUserLabelLength;
	BYTE					VolumeUserLabel[60];
        BYTE					ArrayUniqueIdLength;
	BYTE					ArrayUniqueId[16];
	BYTE					ArrayUserLabelLength;
	BYTE					ArrayUserLabel[60];
	BYTE					LogicalUnitNumber[8];
} InqExtDeviceId_t;

/* Generic host interface block */
typedef struct HostIntfDefn
{
	unsigned int	IntfNum		: 7,
					TI			: 1,
					IntfType	: 8,
					Reserved1	: 8,
					IntfDefnLen	: 8;
	BYTE			IntfInfo[68];		/* sized for largest interface block: Ethernet */
}
HostIntfDefn_t;

/* Fibre Channel Host Interface Definition Block */
typedef struct FCHostIntfDefn
{
	unsigned int	IntfNum		: 7,
					TI			: 1,
					IntfType	: 8,		/* Type = 0x03 */
					Reserved1	: 8,
					IntfDefnLen	: 8;		/* Length = 0x1C */
	BYTE			FC0_Technology[12];
	BYTE			FCPartType[12];
	BYTE			FCPartRev[2];
	BYTE			Topology;
	BYTE			CtlrHostIDSwitch;
}
FCHostIntfDefn_t;

typedef struct FCHostIntfDefn2
{
	unsigned int	IntfNum		: 7,
					TI			: 1,
					IntfType	: 8,		/* Type = 0x03 */
					Reserved1	: 8,
					IntfDefnLen	: 8;		/* Length = 0x1C */
	BYTE			FCPortName[8];
	BYTE			FCNodeName[8];
	BYTE			HardAddress;
	BYTE			AssignedCtlrID[3];
	BYTE			Reserved2[8];
}
FCHostIntfDefn2_t;

/* Host Interface and Host Interface 2 VPD page format */
typedef struct InqHostIntfData
{
	unsigned int	Periph_Device_Type	: 5,
					Periph_Qualifier	: 3,
					Page_Code			: 8,	/* Inquiry VPD Page 0xC5 and 0xC7 */
					Reserved1			: 8,
					PageLength			: 8;
	BYTE			Page_Identifier[4];			/* "HINF" */
	HostIntfDefn_t	HostIntf[8];
}
InqHostIntfData_t;

typedef struct  SstDescriptor
{
	unsigned int	Algorithm_Type	: 4,
					Reserved		: 3,
					isValid			: 1,
					minSegSize		: 8,
					maxSegSizeMsb		: 8,
					maxSegSizeLsb		: 8;
}
SstDescriptor_t;

typedef struct InqDgmPageData {
	unsigned int	Periph_Device_Type	: 5,
					Periph_Qualifier	: 3,
					Page_Code			: 8,		/*Inquiry VPD page 0xC6 */
					Reserved1			: 8,
					Page_Length			: 8;
	BYTE			Page_Identifier[4];
	unsigned int	Max_Drives_Added_to_DG	: 4,
					Reserved2				: 4,
					Reserved3				: 16,
					R0To5E					: 1,
					R0To1E					: 1,
					R5To1E					: 1,
					R5To0E					: 1,
					R1To5E					: 1,
					R1To0E					: 1,
					Reserved4				: 2;
	SstDescriptor_t SegSizeTrnDesc[10];
} InqDgmPageData_t;


/*
* Persisten Reservation Out command. Parameter List
*/
typedef struct PROUTParamData {
   BYTE           Reservation_Key[8];
   BYTE           Srv_Act_Reservation_Key[8];
   BYTE           Scop_Spec_Add[4];
   unsigned int   Aptpl              :1,
                  Reserved1          :1,
                  All_Tg_Pt          :1,
                  Spec_I_Pt          :1,
                  Reserved2          :4,
                  Reserved3          :8,
                  Obsolete           :16;
   BYTE           TransportId_Param_Len[4];
   FCTransportId_t TransportIdList[MAX_TRANSPORTIDS];
} PROUTParamData_t;

/*
* Persisten Reserve IN reservation descriptor
*/
typedef struct ReservationDescriptor
{
   ReservationKey       Reservation_Key;
   BYTE                 Scope_Specific_Address[4];
   unsigned int         Reserved:      8,
                        Type: 4,
                        Scope:4,
                        Obsolete:16;
} ReservationDescriptor_t;


#else

/* Big Endian version */

typedef struct InquiryData {
	unsigned int	Periph_Qualifier	: 3,
					Periph_Device_Type	: 5,
					Removable_Media		: 1,
					Device_Type_Qualifier: 7,
					ISO_Version			: 2,
					ECMA_Version		: 3,
					ANSI_Version		: 3,
					AENC				: 1,
					Reserved1			: 3,
					Response_Data_Format: 4;
	unsigned int	Additional_Length	: 8,
					Reserved2			: 8,
					Reserved4			: 1,
					EncServ				: 1,
					Reserved3			: 6,
					RelAdr				: 1,
					WBus32				: 1,
					WBus16				: 1,
					Sync				: 1,
					Linked				: 1,
					Reserved5			: 1,
					CmdQue				: 1,
					SftReset			: 1;
	BYTE		Vendor_ID[ 8 ];
	BYTE		Product_ID[ 16 ];
	BYTE		Revision_Level[ 4 ];
} InquiryData_t;

typedef struct DriveInquiryData {
	unsigned int	Periph_Qualifier		: 3,
					Periph_Device_Type		: 5,
					Removable_Media			: 1,
					Device_Type_Qualifier	: 7,
					ISO_Version				: 2,
					ECMA_Version			: 3,
					ANSI_Version			: 3,
					AENC					: 1,
					Reserved1				: 3,
					Response_Data_Format	: 4;
	unsigned int	Additional_Length	: 8,
					Reserved2			:16,
					RelAdr				: 1,
					WBus32				: 1,
					WBus16				: 1,
					Sync				: 1,
					Linked				: 1,
					Reserved3			: 1,
					CmdQue				: 1,
					SftReset			: 1;
	BYTE		Vendor_ID[ 8 ];
	BYTE		Product_ID[ 16 ];
	BYTE		Revision_Level[ 4 ];
	BYTE		VendSpec1[20];
	BYTE		Reserved4[40];
	BYTE		VendSpec2[16];
} DriveInquiryData_t;

typedef struct InqSupportedPages
{
	unsigned int	Periph_Qualifier		:3,
			Periph_Device_Type		:5,
			PageCode			:8,
			Reserved			:8,
			PageLength			:8;
	BYTE		Pages[32];
} InqSupportedPages_t;

typedef struct InqUnitSerialNumberData
{
	unsigned int	Periph_Qualifier		: 3,
			Periph_Device_Type		: 5,
			Page_Code			: 8,
			Reserved1			: 8,
			Page_Length			: 8;
	BYTE		SerialNumber[32];
} InqUnitSerialNumberData_t;

typedef struct InqShortSubSysPageData
{
	unsigned int	Periph_Qualifier	: 3,
			Periph_Device_Type	: 5,
			Page_Code		: 8,
			Reserved1		: 8,
			Page_Length		: 8;
	BYTE		Identifier[16];
	BYTE		Rev_Level[4];
	BYTE		SlotID[2];
	BYTE		Reserved2[6];
} InqShortSubSysPageData_t;

typedef struct InqLongSubSysPageData
{
	unsigned int	Periph_Qualifier	: 3,
			Periph_Device_Type	: 5,
			Page_Code		: 8,
			Reserved1		: 8,
			Page_Length		: 8;
	BYTE		Page_ID[4];
	BYTE		Identifier[16];
	BYTE		Rev_Level[4];
	BYTE		SlotID[2];
	BYTE		Reserved[2];
} InqLongSubSysPageData_t;


typedef struct InqDeviceIdData
{
	unsigned int	Periph_Qualifier	: 3,
			Periph_Device_Type	: 5,
			Page_Code			: 8,
			Reserved1			: 8,
			Page_Length			: 8;
	unsigned int	Reserved2	: 4,
			CodeSet		: 4,
			Reserved3	: 4,
			IdentiferType	: 4,
			Reserved4	: 8,
			IdentifierLength : 8;
	BYTE		ExtendedIdentifier [16];
	unsigned int	Target_Protocol_Identifier	: 4,
            Target_CodeSet		: 4;
} InqDeviceIdData_t;

typedef struct InqHwPageData {
	unsigned int	Periph_Qualifier		: 3,
			Periph_Device_Type		: 5,
			Page_Code			: 8,
			Reserved1			: 8,
			Page_Length			: 8;
	BYTE		Page_Identifier[ 4 ];
	BYTE		Num_Channels;
	BYTE		Flags;
	BYTE		Processor_Memory_Size;
	BYTE		Reserved2[ 5 ];
	BYTE		Board_Name[ 64 ];
	BYTE		Board_Part_Number[ 16 ];
	BYTE		Schematic_Number[ 12 ];
	BYTE		Schematic_Revision[ 4 ];
	BYTE		Serial_Number[ 16 ];
	BYTE		Reserved3[ 16 ];
	BYTE		Date_Manufactured[ 8 ];
	BYTE		Board_Revision[ 2 ];
	BYTE		Board_Identifier[ 4 ];
} InqHwPageData_t;

typedef struct InqSwPageData {
	unsigned int	Periph_Qualifier		: 3,
					Periph_Device_Type		: 5,
					Page_Code			: 8,
					Reserved1			: 8,
					Page_Length			: 8;
	BYTE		Page_Identifier[ 4 ];
	BYTE		SW_Version[ 3 ];
	BYTE		SW_Date[ 3 ];
	BYTE		FeaturesEnabled;
	BYTE            Max_LUN_Supported[ 1 ];
	BYTE		SW_Partition[CTL_NUM_SW_PARTITIONS] [16];
} InqSwPageData_t;

typedef struct InqFwPageData {
	unsigned int	Periph_Qualifier		: 3,
					Periph_Device_Type		: 5,
					Page_Code			: 8,
					Reserved1			: 8,
					Page_Length			: 8;
	BYTE		Page_Identifier[ 4 ];
	BYTE		FW_Version[ 3 ];
	BYTE		FW_Date[ 3 ];
	BYTE		Reserved2[ 2 ];
} InqFwPageData_t;

typedef struct ModePage08 {
	ModeParameterHeader_t	Header;
	unsigned int	PS				: 1,
					Reserved1			: 1,
					PageCode			: 6,
					PageLength			: 8,
					Reserved2			: 5,
					WriteCacheEnable		: 1,
					MultiplicationFactor		: 1,
					ReadCacheDisable	  	: 1,
					DemandReadRetentionPriority	: 4,
					WriteRetentionPriority		: 4;
	WORD		DisablePrefetchTransferLength;
	WORD		MinimumPreFetch;
	WORD		MaximumPreFetch;
	WORD		MaximumPreFetchCeiling;
} ModePage08_t;

typedef struct ModePage2B {
	ModeParameterHeader_t	Header;
	unsigned  int	ParametersSavable		: 1,
					PageCode			: 7,
					PageLength			: 8,
					ActionStatus			: 8,
					RaidLevel			: 8;
	BYTE		LunType;
	BYTE		LunBlockSize[ 4 ];
	BYTE		DriveSectorSize[ 2 ];
	BYTE		LunNumberOfBlocks[ 4 ];
	BYTE		Reserved1[4];
	BYTE		LunSegmentSize[4];
	BYTE		SegmentZeroSize;
	/* LUN flags -  Previously set up using bit fields */
    WORD        LunFlags;
	BYTE		ReconBlockComplete[4];
	BYTE		ReconFrequency;
	BYTE		ReconAmount[ 2 ];
	BYTE		LunNumber;
	BYTE		OperationProgress;
	BYTE		Reserved5;
	BYTE		Disk_Bit_Map[ 32 ];
	BYTE		Configuration_Table[ 64 ];
} ModePage2B_t;

typedef struct ModePage2E {
	ModeParameterHeader_t	Header;
	unsigned int	PS				: 1,
					Reserved1		: 1,
					PageCode		: 6,
					PageLength		: 8,
					Reserved2		: 5,
					CWOB			: 1,
					FWT				: 1,
					CME				: 1,
					ABPR			: 1,
					BPR				: 1,
					ACMA			: 1,
					CMA				: 1,
					ABOK			: 1,
					BOK				: 1,
					RCA				: 1,
					WCA				: 1;
	BYTE		Reserved3;
	BYTE		Reserved4;
	BYTE		ReadCachingAlgorithm;
	BYTE		Reserved5;
	unsigned int	WriteCachingAlgorithm	: 8,
					Reserved6				: 8,
	 				CacheFlushAlgorithm		: 8,
	 				Reserved7				: 4,
					CacheFlushModifier		: 4;
	unsigned int	TwoMinWarnFlushAlgorithm	: 8,
	 				Reserved8					: 4,
					TwoMinWarnFlushModifier		: 4,
	 				AgeSet						: 1,
					CacheBatteryAge				: 7,
	 				Reserved10					: 8;
	BYTE		DemandFlushThreshold;
	BYTE		DemandFlushAmount;
	WORD		Reserved11;
	WORD		Reserved12;
	WORD		CacheSize;
	WORD		CacheBlockSize;
	WORD		LargeIOSize;
	BYTE		CacheMirrorAllocSize;
	BYTE		Reserved13;
	WORD		Reserved14;
	WORD		Reserved15;
	WORD		Reserved16;
	WORD		Reserved17;
	WORD		Reserved18;
	WORD        Reserved19;
	WORD        Reserved20;
	WORD        Reserved21;
	WORD        Reserved22;
	WORD        Reserved23;
	WORD        Reserved24;
	WORD        Reserved25;
	WORD        Reserved26;
	WORD        Reserved27;
	WORD        Reserved28;
	WORD        Reserved29;
	WORD        Reserved30;
} ModePage2E_t;

typedef struct ModePage2F {
	ModeParameterHeader_t	Header;
	unsigned int	PS				: 1,
					Reserved1		: 1,
					PageCode		: 6,
					PageLength		: 8,
					Reserved2		: 8,
					Reserved3		: 8;
	LWORD		SecondsSinceJan70;
} ModePage2F_t;

typedef struct CtlrMonMgmtLogPage {
	BYTE		PageCode;
	BYTE		Reserved1;
	WORD		PageLength;
	WORD		ParameterCode;
	BYTE		Flags;
	BYTE		ParameterLength;
	BYTE		ActionToTake;
	BYTE		Reserved3;
	BYTE		Reserved4[2];
} CtlrMonMgmtLogPage_t;

/* Feature Parameters VPD page format */
typedef struct InqFeaParData
{
        unsigned int    Periph_Qualifier        : 3,
        Periph_Device_Type                      : 5,
        Page_Code                               : 8,    /* Inquiry VPD Page 0xC3 */
        Reserved1                               : 8,
        PageLength                              : 8;
        BYTE                                    Page_Identifier[4];    /* "PRMS" */
        BYTE                                    MaxLunPieces;
        BYTE                                    MaxGHSDrives;
        BYTE                                    PCIConnParms;
	BYTE					UTMData;
	      BYTE rsvdbit7                           : 1,
		      rsvdbit6                              : 1,
		      rsvdbit5                              : 1,
		      rsvdbit4                              : 1,
		      rsvdbit3                              : 1,
		      rsvdbit2                              : 1,
		      rsvdbit1                              : 1,
		      PRReset                               : 1;   /* PR reset supported y/n */
        BYTE                                    Reserved2[35];
} InqFeaParData_t;


typedef struct ModePageA {
	ModeParameterHeader_t	Header;
	BYTE		PageCode;
	BYTE		PageLength;
	BYTE		TaskSetType: 3;
	BYTE		TaskMgmtFuncOnly: 1;
	BYTE		Reserved1: 1;
	BYTE		DescSenseData: 1;
	BYTE		GlobalLogTgtSaveDisable: 1;
	BYTE 		ReportLogExceptCondition: 1;
	BYTE		QueueAlgorithmModifier: 4;
	BYTE		Reserved2: 1;
	BYTE		QueueErrorMgmt: 2;
	BYTE		Obsolete1: 1;
	BYTE		VS: 1;
	BYTE		ReportACheck: 1;
	BYTE		UAInterLockControl: 2;
	BYTE		SoftwareWriteProtect: 1;
	BYTE		Obsolete2: 3;
	BYTE		ApplicationTagOwner: 1;
	BYTE		TaskAbortedStatus: 1;
	BYTE		Reserved3: 3;
	BYTE		AutoLoadMode: 3;
	BYTE		Obsolete3[2];
	BYTE		BusyTimeoutPeriod[2];
	BYTE		ExtendedSelfTestCompletion[2];
} ModePageA_t;

typedef struct InqSubSystem
{
        unsigned int    Periph_Qualifier        : 3,
        Periph_Device_Type                      : 5,
        Page_Code                               : 8,    /* Inquiry VPD Page 0xC4 */
        Reserved1                               : 8,
        PageLength                              : 8;
        BYTE                                    Page_Identifier[4];    /* "subs" */
        BYTE                                    SubSystemId[16];
        BYTE                                    SubSystemRevision[4];
        BYTE                                    ControllerSlotId[2];
        BYTE                                    Reserved2[2];
} InqSubSystem_t;

typedef struct InqExtDeviceId
{
        unsigned int    Periph_Qualifier        : 3,
        Periph_Device_Type                      : 5,
        Page_Code                               : 8,    /* Inquiry VPD Page 0xC8 */
        Reserved1                               : 8,
        PageLength                              : 8;
        BYTE                                    Page_Identifier[4];    /* "edid" */
	BYTE					Reserved2[3];
	BYTE					VolumeUniqueIdLength;
	BYTE					VolumeUniqueId[16];
	BYTE					VolumeUserLabelLength;
	BYTE					VolumeUserLabel[60];
        BYTE					ArrayUniqueIdLength;
	BYTE					ArrayUniqueId[16];
	BYTE					ArrayUserLabelLength;
	BYTE					ArrayUserLabel[60];
	BYTE					LogicalUnitNumber[8];
} InqExtDeviceId_t;

typedef struct InqVolumeAccessControl
{
	unsigned int    Periph_Qualifier        : 3,
        Periph_Device_Type                      : 5,
        Page_Code                               : 8,    /* Inquiry VPD Page 0xC9 */
        Reserved1                               : 8,
        PageLength                              : 8;
        BYTE                                    Page_Identifier[4];    /* "vace" */
        BYTE					AVTCVP;
	BYTE					PathPriotity;
        BYTE                                    Reserved2[38];
} InqVolumeAccessControl_t;

/* Generic host interface block */
typedef struct HostIntfDefn
{
	unsigned int	TI			: 1,
					IntfNum		: 7,
					IntfType	: 8,
					Reserved1	: 8,
					IntfDefnLen	: 8;
	BYTE			IntfInfo[68];		/* sized for largest interface block: Ethernet */
}
HostIntfDefn_t;

/* Fibre Channel Host Interface Definition Block */
typedef struct FCHostIntfDefn
{
	unsigned int	TI			: 1,
					IntfNum		: 7,
					IntfType	: 8,		/* Type = 0x03 */
					Reserved1	: 8,
					IntfDefnLen	: 8;		/* Length = 0x1C */
	BYTE			FC0_Technology[12];
	BYTE			FCPartType[12];
	BYTE			FCPartRev[2];
	BYTE			Topology;
	BYTE			CtlrHostIDSwitch;
}
FCHostIntfDefn_t;

typedef struct FCHostIntfDefn2
{
	unsigned int	TI			: 1,
					IntfNum		: 7,
					IntfType	: 8,		/* Type = 0x03 */
					Reserved1	: 8,
					IntfDefnLen	: 8;		/* Length = 0x1C */
	BYTE			FCPortName[8];
	BYTE			FCNodeName[8];
	BYTE			HardAddress;
	BYTE			AssignedCtlrID[3];
	BYTE			Reserved2[8];
}
FCHostIntfDefn2_t;

/* Host Interface and Host Interface 2 VPD page format */
typedef struct InqHostIntfData
{
	unsigned int	Periph_Qualifier	: 3,
					Periph_Device_Type	: 5,
					Page_Code			: 8,	/* Inquiry VPD Page 0xC5 and 0xC7 */
					Reserved1			: 8,
					PageLength			: 8;
	BYTE			Page_Identifier[4];			/* "HINF" */
	HostIntfDefn_t	HostIntf[8];
}
InqHostIntfData_t;

typedef struct  SstDescriptor
{
	unsigned int	isValid			: 1,
					Reserved		: 3,
					Algorithm_Type	: 4,
					minSegSize		: 8,
					maxSegSizeMsb		: 8,
					maxSegSizeLsb		: 8;
}
SstDescriptor_t;

typedef struct InqDgmPageData
{
	unsigned int	Periph_Qualifier	: 3,
					Periph_Device_Type	: 5,
					Page_Code			: 8,	/*Inquiry VPD page 0xC6 */
					Reserved1			: 8,
					Page_Length			: 8;
	BYTE			Page_Identifier[4];
	unsigned int	Reserved2				: 4,
					Max_Drives_Added_to_DG	: 4,
					Reserved3				: 16,
					Reserved4				: 2,
					R1To0E					: 1,
					R1To5E					: 1,
					R5To0E					: 1,
					R5To1E					: 1,
					R0To1E					: 1,
					R0To5E					: 1;
	SstDescriptor_t SegSizeTrnDesc[10];
} InqDgmPageData_t;

/*
* Persisten Reserve IN reservation descriptor
*/
typedef struct ReservationDescriptor
{
   ReservationKey       Reservation_Key;
   BYTE                 Scope_Specific_Address[4];
   unsigned int         Reserved:      8,
                        Scope:4,
                        Type: 4,
                        Obsolete:16;
} ReservationDescriptor_t;

/*
* Persisten Reservation Out command. Parameter List
*/
typedef struct PROUTParamData {
   BYTE           Reservation_Key[8];
   BYTE           Srv_Act_Reservation_Key[8];
   BYTE           Scop_Spec_Add[4];
   unsigned int   Reserved2          :4,
                  Spec_I_Pt          :1,
                  All_Tg_Pt          :1,
                  Reserved1          :1,
                  Aptpl              :1,
                  Reserved3          :8,
                  Obsolete           :16;
   BYTE           TransportId_Param_Len[4];
   FCTransportId_t TransportIdList[MAX_TRANSPORTIDS];
} PROUTParamData_t;

#endif

typedef struct ModePage3F {
	ModeParameterHeader_t	Header;
	BYTE				PageCode;
	ModePage08_t		Page08;
	ModePage2A_t		Page2A;
	ModePage2B_t		Page2B;
	ModePage2C_t		Page2C;
	ModePage2E_t		Page2E;
	ModePage3A_t		Page3A;
	ModePage2D_t		Page2D;
	BYTE				Page2DPad[255];
} ModePage3F_t;


/**
* Persistent Reserve IN parameter data for READ RESERVATION
*/

typedef struct PRINReadResevParamData
{
   BYTE                          PRgeneration[4];
   BYTE                          Additional_Len[4];
   ReservationDescriptor_t       Reservation_Descriptor[MAX_RESERVATION_DESCRIPTORS];
}  PRINReadResevParamData_t;

#endif /* __INCscsiio */

