/*******************************************************************************
*  Copyright 2004-2008 LSI Corporation.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            mppLnx26p_prototypes.h
SUMMARY         %description%
VERSION         %version: 6 %
UPDATE DATE     %date_modified: Sun Jun 15 20:52:32 2008 %
PROGRAMMER      %created_by:    bmoger %

DESCRIPTION:
This header file contains all definitions that are used only
in the Linux Upper Level driver. Also, the definitions, which are
defined in this header file, are not used by the MPP common APIs.

INCLUDE FILES:

NOTES:

RESTRICTIONS:

SEE ALSO:

REFERENCE:

IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/


#ifndef __INCmppLnx26p_prototypes
#define __INCmppLnx26p_prototypes


/***  INCLUDES  ***/
#ifndef __KERNEL__
#define __KERNEL__
#endif

#include "MPP_ProtoTypes.h"
#include "mppCmn_s2tos3.h"
#include <linux/list.h>


/***  CONSTANT DEFINITIONS  ***/

#define MPP_UTM_LUN_DEVICE   1001

/*** macro definition used for function pointer replacement ***/
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CONFIG_FILE_NAME "/etc/mpp.conf"
#define BINDING_FILE_NAME "/var/mpp/devicemapping"

/*
* A data structure that handles unconfigured device list
*/
typedef struct mppLnx_UnconfiguredDeviceEntry
{
   struct list_head           list;
   struct scsi_device                *physical_device;
   unsigned int               isUnconfigured:1,
                              isAttached:1,
                              isDetected:1,
                              reserved:29;
} mppLnx_UnconfiguredDeviceEntry_t;

typedef struct mppLnx_UnconfiguredDeviceList
{
   spinlock_t                          *unconfiguredDeviceLock;
   mppLnx_UnconfiguredDeviceEntry_t    *deviceEntryList;
}  mppLnx_UnconfiguredDeviceList_t;



/***  FUNCTIONS DECLARATIONS ***/
extern BYTE mpp_IsFailoverPossible(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun, BYTE level);

extern BYTE mpp_FailController(RdacDeviceInformation_t *RdacInfo, BYTE Controller, LWORD Lun);

extern BYTE mpp_IsAnotherPathAvailableForFailover(RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, BYTE LWORD);


/* MPP upper level driver initialization and cleanup routines */
static int mppLnx_init(void);
static void mppLnx_exit(void);

/* MPP upper level driver initialization helper functions */
static int mppLnx_readConfigData(void);
static int mppLnx_readBindingData(void);
static void mppLnx_modifyConfigParameter(char *, char *);
static void mppLnx_FillInPersistentArray(char*, char* );
static char* mppLnx_strstrip(char *, char *);
static void mppLnx_parseLine(char **, char *, char **, char **);
static BOOL mppLnx_simple_strtoul(const char*, char**, unsigned int, unsigned long *);

/* The following functions are interceptor functions */

static int mppLnx_sd_probe (struct device * dev);

/* Function declarations for MPP device driver interface and class interface*/
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,16))
static int mppLnx_class_add (struct class_device *, struct class_interface *);
static void mppLnx_class_remove (struct class_device *, struct class_interface *);
static int mppLnx_sg_add (struct class_device *cl_dev, struct class_interface *);
static void mppLnx_sg_remove (struct class_device *cl_dev, struct class_interface *);
#else
static int mppLnx_class_add (struct class_device *);
static void mppLnx_class_remove (struct class_device *);
static int mppLnx_sg_add (struct class_device *cl_dev);
static void mppLnx_sg_remove (struct class_device *cl_dev);
#endif
static int mppLnx_driver_probe (struct device * dev);
static int mppLnx_driver_remove (struct device * dev);

/* Function declarations for scsi_driver interface*/
static int  mppLnx_init_command(struct scsi_cmnd *);

/* Function declarations for file operations */
static int mppLnx_open (struct inode *inode, struct file *file);
static int mppLnx_release (struct inode *inode, struct file *file);
static int mppLnx_ioctl( struct inode *inode, struct file *file, unsigned int cmd_in, unsigned long arg );

/* Function to identify the disk type for a struct scsi_device */
static LWORD mppLnx_DeviceType(struct scsi_device*, LunPathInfo_t **lunPathInfo, RdacDeviceInformation_t **rdacinfo);

/*Function to remove a LUN from rdacInfo data structure */
static void mppLnx_removeLun(struct scsi_device *sdp);

/*Functions for Synchronous I/O */
static LWORD mppLnx_Translate_Linux_Status (int result);

/* functions for managing un-configured devices */
static mppLnx_UnconfiguredDeviceEntry_t * mppLnx_getUnconfiguredDevice(struct scsi_device * device);
static void mppLnx_deleteUnconfiguredDevice(struct scsi_device * device);
static void mppLnx_addUnconfiguredDevice(struct scsi_device * device);
static LWORD
mppLnx_BuildRdacinfo(MPP_HANDLE DeviceVertex, ControllerAddress_t *DeviceAddress,
                     LWORD Lun);
static void mppLnx_RescanUnconfiguredDevices(void);


/* system dependent routines */
LWORD
mpp_SysdepSynchronousIo(MPP_HANDLE ScsiDevice, BYTE *cdb, BYTE cdblen, void *BufferAddress,
			LWORD BufferLength,     void *SenseBuffer, LWORD SenseLength, TINY DataDirection,
			LWORD *SenseLengthReturned, LWORD *DataLengthXfered);

void
mpp_IssueFailover (RdacDeviceInformation_t *RdacInfo, BYTE	Controller,
			BYTE Path, MPP_HANDLE FailoverHandle, BYTE *Page2C,
			BYTE	*modeSelectCdb,
			MPPCMN_FAILOVER_METHOD FailoverMethod,
			BOOL ForceQuiescence, BOOL noHoldInReset);

void mppSys_GetUtilSysdepData(RdacDeviceInformation_t *RdacInfo, mpp_utilStatusInfo_t *utilStatusInfo );

LWORD
mppSys_ValidatePath (RdacDeviceInformation_t *RdacInfo, LWORD Controller, LWORD Path);

VOID
mppSys_PrintSenseBuffer (RdacDeviceInformation_t *RdacInfo, LWORD Controller,
			 LWORD Path, void *SenseBuffer, ULONG SerialNumber);

SINT
mppSys_CopyRdacInfoToUser( void *RdacInfoAdrs, RdacDeviceInformation_t *RdacInfo);

MPP_HANDLE
mpp_makeVirtualLun (MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, LWORD Lun, LWORD *PBusStatus);

LWORD
mppSys_QueueRequest(MPPCMN_QUEUE_REQUEST_CALLBACK RequestCallback, void *Context, LWORD DelaySecs);

void
mpp_RemoveControllerDirectory (MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo, BYTE Controller);

void
mpp_ThreadDelay(ULONG DelayTime,ULONG DelayResolution);

LWORD
mppSys_AreControllerPathsFailed(RdacDeviceInformation_t *RdacInfo,
                                BYTE ControllerIndex, LWORD Lun);

MPP_DIR_HANDLE
mpp_makeVirtualTarget(targ_t targ) ;

MPP_DIR_HANDLE
mpp_CreateControllerVertex (RdacDeviceInformation_t *RdacInfo,
				BYTE ControllerIndex, BYTE Path,
				ControllerAddress_t *DeviceAddress);

void
mpp_CreateLunLink(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo,
			BYTE ControllerIndex, BYTE        PathIndex, LWORD        Lun);

void
mpp_RemovePathDirectory ( MPP_HANDLE DeviceVertex,
			RdacDeviceInformation_t      *RdacInfo, BYTE Controller, BYTE Path);

void mpp_RemoveLunLink( RdacDeviceInformation_t *RdacInfo, BYTE Controller, BYTE Path, LWORD Lun);


void mpp_RemoveVirtualLun (RdacDeviceInformation_t *RdacInfo, LWORD Lun);

LWORD
mppSys_IsOkayToClearRdacLuns(IN RdacDeviceInformation_t *RdacInfo, IN LWORD Lun);

void
mpp_RemoveModule(MPP_HANDLE DeviceVertex, RdacDeviceInformation_t *RdacInfo);

LWORD
mppSys_DeviceAlreadyDiscovered (MPP_HANDLE Devicepnt, LWORD Lun );

BOOL
mppSys_IsConfiguredDevice(MPP_HANDLE DeviceVertex, ControllerAddress_t *DeviceAddress, LWORD Lun);

/* All the functions provided in the Upper Level driver module that need to be used by the Virtual HBA driver have to be exported */
EXPORT_SYMBOL(mpp_hot_plug_list);
EXPORT_SYMBOL(mpp_hot_plug_spin_lock);
EXPORT_SYMBOL(mpp_ModuleArray) ;
EXPORT_SYMBOL(mppLnx_Config_Parameters);
EXPORT_SYMBOL(mpp_FailBackScan) ;
EXPORT_SYMBOL(mpp_CheckAVTState );
EXPORT_SYMBOL(mpp_VirtualdiskInquiryData );
EXPORT_SYMBOL(mpp_FailPath );
EXPORT_SYMBOL(mpp_IsFailoverPossible);
EXPORT_SYMBOL(mpp_FailController);
EXPORT_SYMBOL(mpp_IsAnotherPathAvailableForFailover) ;
EXPORT_SYMBOL(mpp_AnalyseFailoverError );
EXPORT_SYMBOL(mpp_AnalyseIoError);
EXPORT_SYMBOL(mpp_AnalyseSyncError);
EXPORT_SYMBOL(mpp_ConvertWWNtoAscii);
EXPORT_SYMBOL(mpp_ErrorLog);
EXPORT_SYMBOL(mpp_GetTime);
EXPORT_SYMBOL(mpp_SelectFailoverPath);
EXPORT_SYMBOL(mpp_SelectPath);
EXPORT_SYMBOL(mppCmn_NewSelectPath);
EXPORT_SYMBOL(mppLnx_Translate_Linux_Status);
EXPORT_SYMBOL(mpp_DebugPrint);
EXPORT_SYMBOL(mppLnx_zmalloc);
EXPORT_SYMBOL(mppLnx_zfree);
EXPORT_SYMBOL(mpp_ChkIOForWandV);
EXPORT_SYMBOL(mpp_SetWandVBit);
EXPORT_SYMBOL(mpp_TestBuildWandVOp);
EXPORT_SYMBOL(mpp_BuildWriteWithVerify);
EXPORT_SYMBOL(mppCmn_CheckPathStatus);
EXPORT_SYMBOL(mppCmn_CheckPRRegistration);
EXPORT_SYMBOL(mppCmn_CheckAndSetTASBit);
EXPORT_SYMBOL(mppCmn_DoFailoverCompletion);
EXPORT_SYMBOL(mppCmn_Failover);
EXPORT_SYMBOL(mppCmn_LunFailoverDelay);
EXPORT_SYMBOL(mpp_IsNull);

/*
* SCSI2 to SCSI3 Reservation translation symbols
*/
EXPORT_SYMBOL(mppCmn_MapBusDeviceReset);
EXPORT_SYMBOL(mppCmn_MapBusDeviceResetVs);
EXPORT_SYMBOL(mppCmn_GenReservationKey);
EXPORT_SYMBOL(mppCmn_MapScsi2Reserve);
EXPORT_SYMBOL(mppCmn_MapScsi2Release);
EXPORT_SYMBOL(mppCmn_S2toS3SynchCmnd);
EXPORT_SYMBOL(mppCmn_CheckForReservationHolder);
EXPORT_SYMBOL(mppCmn_SynchronousPRIo);


#endif        /* End of __INCmppLnx26p_prototypes */
