/*******************************************************************************
*  Copyright 2004-2008 LSI Corporation.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation,  version 2 of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
********************************************************************************/
/*******************************************************************************

NAME            mppLnx26p_shared.h
SUMMARY         %description%
VERSION         %version: 4 %
UPDATE DATE     %date_modified: Sun Jun 15 20:53:30 2008 %
PROGRAMMER      %created_by:    bmoger %


DESCRIPTION:
   This header file contains definitions that are shared by the Linux MPP
   virtual HBA driver and the Linux MPP upper level driver. The definitions,
   which are defined in this header file, are not used by the MPP common APIs.
INCLUDE FILES:

NOTES:

RESTRICTIONS:

SEE ALSO:

REFERENCE:

IMPLEMENTATION:

MODIFICATION HISTORY:

*******************************************************************************/


#ifndef __INCmppLnx26p_shared
#define __INCmppLnx26p_shared


/***  INCLUDES  ***/


/***  CONSTANT DEFINITIONS  ***/
#define MPPLNX_PROC_NAME               "mpp"

/***  MACRO DEFINITIONS  ***/


/***  TYPE DEFINITIONS  ***/
/***  the global data structure for the configurable parameters for MPP driver ***/
struct mpp_Config_Parameters{
    TEXT mpp_VendorId[9];  /* the vendor ID that the MPP driver will report for
    the virtualized RAID controllers */
    TEXT mpp_ProductId[17];  /* the product ID that the MPP driver will report for
    the virtualized RAID controllers */
    TEXT mpp_Version[16];  /* the Raid Manager version of the MPP driver */
    LWORD mpp_Debug;  /* controls the debug output display */
    LWORD mpp_NotReadyWaitTime;  /* the time, in seconds, that the MPP driver
    will wait for a controller NOT READY condition to clear */
    LWORD mpp_BusyWaitTime;    /* the time, in seconds, that the MPP driver
    will wait for a controller BUSY condition to clear */
    LWORD mpp_QuiescenceWaitTime;    /* the time, in seconds, that the MPP driver
    will wait for a controller quiescence condition to clear */
    LWORD mpp_InquiryWaitTime;  /*  the time, in seconds, that the MPP driver
    will wait for inquiry command for storage array name to return */
    LWORD mpp_MaxLunsPerArray;  /* the maximum number of Luns that are mapped to the host*/
    LWORD mpp_MaxPathsPerController;  /* the maximum number of paths from the host
    where the MPP driver is running to one array controller*/
    LWORD mpp_MaxArrayModules;  /* the maximum number of storage arrays that MPP driver supports*/
    LWORD mpp_ScanInterval;  /* the time interval, in seconds, at which the MPP driver
    will check for failed paths/controllers having been restored, a change in the preferred owner
    of AVT-enabled LUNS and a change in the AVT-enabled settings */
    LWORD mpp_InquiryInterval;  /* the time interval, in seconds, that the MPP driver
    resends the inquiry command to get storage array name */
    LWORD mpp_ErrorLevel;  /* determines what errors to log */
    LWORD mpp_SelectionTimeoutRetryCount;  /* the number of times a selection timeout
    from a device will be retried */
    LWORD mpp_CommandTimeoutRetryCount;  /* the number of times a command timeout
    from a device
    will be retried */
    LWORD mpp_UaRetryCount;  /* the number of times a Unit Attention status
    from a device
    will be retried */
    LWORD mpp_SyncRetryCount;  /* the number of times a synchronous I/O error
    from a device
    will be retried */
    LWORD mpp_SynchTimeout;  /* the time in seconds, for synchronous I/O's
    that are internally generated by the MPP driver */
    LWORD mpp_FailOverQuiescenceTime;  /* the time in seconds that the MPP driver
    will wait for a quiescence condition to clear for an explicit failover operation */
    LWORD mpp_FailoverTimeout;  /* the maximum time, in seconds, that the MPP driver
    will wait for a controller failover operation to finish */
    LWORD mpp_FailBackToCurrentAllowed;  /* determines if it is allowed to fail back
    to the preferred controller if it is previously failed and is restored by the failback task */
    LWORD mpp_HoldAltInReset;  /*  determines whether it is allowed for one controller
    to hold the alternate controller in reset */
    LWORD mpp_DoUARetry;  /* determines whether to retry an I/O if it returns UNIT ATTENTION status */
    LWORD mpp_ControllerIoWaitTime;  /* the maximum time, in seconds, that an I/O can be retried
    on a controller regardless of what status it is returning */
    LWORD mpp_ArrayIoWaitTime;  /* the maximum time, in seconds, that an I/O can be retried
    regardless of which controller(s) it has been sent to */
    LWORD mpp_DisableLUNRebalance; /* whenther to disbale LUN rebalance after controller failback */
    LWORD mpp_MaxArrayFailoverLength;  /* max seconds to allow a controller to failover */
    LWORD mpp_IdlePathCheckingInterval;     /* Time Interval for checking an IO idle path */
    LWORD mpp_RecheckFailedPathWaitTime; /* Time to wait for moving the path from FAILED to FAILED_CHECKING*/
    LWORD mpp_FailedPathCheckingInterval;  /* Time to wait before issuing Path Validation command*/
    BYTE mpp_S2ToS3Key[8]; /* Unique ID used for Scsi-2 to Scsi-3 persistent reservation */
    LWORD mpp_PrintSenseBuffer;  /* set this to 1 to dump sense data information */
    BYTE  mpp_ClassicModeFailover;  /* Failover policy (LUN/controller) for mode-selected arrays */
    BYTE  mpp_AVTModeFailover;  /* Failover policy (LUN/controller) for AVT arrays */
    LWORD mpp_LunFailoverDelay;  /* Time to delay issuing LUN-level Mode Select */
    LWORD mpp_LoadBalancePolicy;  /* Load balance Policy for path selection */
};

/***  GLOBALS  ***/
extern struct mpp_Config_Parameters mppLnx_Config_Parameters;

/***  FUNCTION DECLARATION ***/
extern VOID mpp_ConvertWWNtoAscii(BYTE *AsciiWWN, BYTE *ArrayWWN);

typedef enum {
        ADD_DEVICE,
        DEL_DEVICE
} HOT_PLUG_TYPE;

typedef struct _mpp_hot_plug_event {
        struct  list_head       list;
        struct scsi_device      *device;
	spinlock_t		*hot_plug_lock;
        HOT_PLUG_TYPE           event_type;
} mpp_hot_plug_event;

extern struct list_head mpp_hot_plug_list;
extern spinlock_t mpp_hot_plug_spin_lock;

#endif        /* End of __INCmppLnx26p_shared  */
