#!/bin/bash
# Author:Hyphen Wang <hyphenwang@redflag-linux.com>
# Version: v0.2
# Date:2008-12-26

function checkKey()
{
local ID=$1
if clplcnsc -L -P $ID 2>&1|grep "unregistered" >/dev/null;then
  echo "HA License $ID is unregistered."
  return 0
fi
if clplcnsc -L -P $ID 2>&1|grep TRIAL >/dev/null;then
  echo "Deleting HA $ID License"
  clplcnsc -D -P $ID
  return 0
elif clplcnsc -L -P $ID|grep PRODUCT >/dev/null;then
  echo "HA $ID is already registered,License valid."
  return 1
fi
}

function getKey()
{
SERIALNUM=`echo "$CONTENT"|grep -B8 "$ETH0_HWADDR"|grep -E -o "[[:alpha:]]{2}[[:digit:]]{6}"|sed 's/ //g'`
LICENSEKEY=`echo "$CONTENT"|grep -A1 $ETH0_HWADDR|grep -E '([[:alnum:]-]){8,9}'|sed 's/ //g'`
#echo $SERIALNUM
#echo $ETH0_HWADDR
#echo $LICENSEKEY
}

function runScript()
{
FILENAME=`mktemp`
cat << EOF > $FILENAME
#!/usr/bin/expect
set user [lindex \$argv0]
spawn clplcnsc -I -P ${PRODUCTID}
expect "Select product division."
sleep 1
send "1\n"
expect "Enter serial number"
sleep 1
send "${SERIALNUM}\n"
expect "Enter HW address"
sleep 1
send "${ETH0_HWADDR}\n"
expect "Enter license key"
send "${LICENSEKEY}\n"
sleep 1
interact
EOF
chmod +x $FILENAME
$FILENAME
rm $FILENAME
}

if [ $# -ge 1 ]&&[ -e $1 ];then
  LICENSEFILE=$1
elif [ -e "License.txt" ];then
  LICENSEFILE="License.txt"
else
  echo "Can't find License File."
  echo "Usage: $0 License.txt"
  echo 'License file name default is "License.txt"'
  exit 1
fi
dos2unix $LICENSEFILE >/dev/null 2>&1

ETH0_HWADDR=`ifconfig eth0|grep HWaddr|awk '{print $5}'`
ETH1_HWADDR=`ifconfig eth1|grep HWaddr|awk '{print $5}'`

if ! cat $LICENSEFILE|grep -A1 "$ETH0_HWADDR"|grep -q "$ETH1_HWADDR";then
  echo "The HA License didn't match this machine."
  exit 1
fi

echo "***************************************************"
WITHAGENT=0
if CONTENT=`cat $LICENSEFILE|grep -A10 -B10 "$ETH0_HWADDR"|grep -A20 -E 'Agent.*Agent'|grep -B20 'End of Agent'`;then
  WITHAGENT=1
  PRODUCTID=`echo "$CONTENT"|grep -E -o '[[:alnum:]]+MON[[:digit:]]+'`
  if checkKey $PRODUCTID;then
    echo "Registering HA $PRODUCTID License."
    getKey
    runScript
  fi
  echo "***************************************************"
fi

if [ $WITHAGENT -eq 1 ];then
  CONTENT=`cat $LICENSEFILE|grep -A5 -B20 "$ETH0_HWADDR"|grep -A30 'Ŀ'|grep -B30 -E 'Agent.*Agent'`
else
  CONTENT=`cat $LICENSEFILE|grep -A5 -B20 "$ETH0_HWADDR"|grep -A30 'Ŀ'`
fi
PRODUCTID=`echo "$CONTENT"|grep 'Ʒ'|grep -E -o '(SX|LE|SE)[[:digit:]]+'`
if checkKey $PRODUCTID;then
  echo "Registering HA $PRODUCTID License."
  getKey
  runScript
fi
echo "***************************************************"

