#!/bin/bash
# test network width
function usage
{
       echo "Usage: $0 <ethernet device> <sleep time>"
       echo "    e.g. $0 eth0 2"
       exit 65
}

if [ $# -lt 2 ];then
usage
fi
typeset in in_old dif_in
typeset out out_old dif_out
typeset timer
typeset eth

eth=$1
timer=$2

in_old=$(cat /proc/net/dev | grep $eth | sed -e "s/\(.*\)\:\(.*\)/\2/g" | awk ' { print $1 }' )
out_old=$(cat /proc/net/dev | grep $eth |  sed -e "s/\(.*\)\:\(.*\)/\2/g" |  awk ' { print $9 }' )

while true
do
       sleep  ${timer}
       in=$(cat /proc/net/dev | grep $eth |  sed -e "s/\(.*\)\:\(.*\)/\2/g" | awk ' { print $1 }' )
       out=$(cat /proc/net/dev | grep $eth |  sed -e "s/\(.*\)\:\(.*\)/\2/g" | awk ' { print $9 }' )
       dif_in=$(((in-in_old)/timer/1024))
       dif_out=$(((out-out_old)/timer/1024))
       echo "IN: ${dif_in} KByte/s   OUT: ${dif_out} KByte/s"
       in_old=${in}
       out_old=${out}
done
exit 0
