#!/bin/perl -w
use XML::Twig;
use encoding "utf-8";

# 定义对item节点的处理函数为&item函数
my $twig_handlers = {'item' => \&item};
my $file = "./feed.xml";
# 创建实例时，增加TwigHandlers属性的定义
my $twig = new XML::Twig(TwigRoots => {'item' => 1},
  TwigHandlers => $twig_handlers,
  pretty_print => 'indented');
# 打开指定的XML文件
$twig->parsefile($file);
#不要输出整个树节点
#$twig->print;
print "\n";

# 对item节点的处理函数
sub item {
  my ($twig,$item) = @_;
  # 获得item节点下的第一个子节点，并且tag是title的，如果不指定tag，则获得全部第一个子节点
  my $title = $item -> first_child('title');
  # 同样的，这次获得的是title节点的文本节点值
  my $title_text = $item -> first_child_text('title');
  $title_text =~ s/<![CDATA[(.*)]>/$1/;
  $title -> set_text($title_text);
  $title -> set_att('type','blog');
  # 输出
  $title -> print;
}
