#!/bin/perl -w
use XML::Twig;
use encoding "utf-8";

# 定义对item/title节点的处理函数为&item_title函数
my $twig_handlers = {'item' => \&item};
my $file = "./feed.xml";
# 创建实例时，增加TwigHandlers属性的定义OB
my $twig = new XML::Twig(TwigRoots => {'item' => 1},
  TwigHandlers => $twig_handlers,
  pretty_print => 'indented');
$twig->parsefile($file);
# 打开指定的XML文件
$twig->print;
print "\n";

# 对item/title节点的处理函数OA
sub item {
  my ($twig,$item) = @_;
  for my $child ($item -> children) {
    my $child_name = $child -> name;
    if ( $child_name eq 'title' ) {
  my $child_text = $child -> text;
  $child_text =~ s/<![CDATA[(.*)]>/$1/;
  $child -> set_text($child_text);
  $child -> set_att('type','blog');
    }
  else {
    $child -> delete;
  }
  }
}
