#!/bin/perl -w
use XML::Twig;
use encoding 'utf-8';

# 定义对item/title节点的处理函数为&item_title函数
my $twig_handlers = {'item/title' => \&item_title};
my $file = "./feed.xml";
# 创建实例时，增加TwigHandlers属性的定义OB
my $twig = new XML::Twig(TwigRoots => {'title' => 1},
  TwigHandlers => $twig_handlers,
  pretty_print => 'indented');
$twig->parsefile($file);
# 打开指定的XML文件
$twig->print;
print "\n";

# 对item/title节点的处理函数OA
sub item_title {
  my ($twig,$title) = @_;
  my $title_text = $title -> text;
  $title_text =~ s/<![CDATA[(.*)]>/$1/;
  # 设置其的文本节点内容
  $title -> set_text($title_text);
  # 设置其的属性节点内容
  $title -> set_att('type','blog');
  #$title -> set_remove_cdata ('#CDATA');
 }
