#!/bin/perl -w
use XML::Twig;
use encoding "utf-8";

my $file = "./feed.xml";
my $twig = XML::Twig->new();
$twig->parsefile($file);
# 定义一个树目录的根变量
my $root = $twig->root;

# 使用XPath架构来描述某个节点的位置，item节点在channel节点下面
# 通过循环来遍历item下面的所有子节点
foreach my $item ($root->first_child('channel')->children('item')) {
  print $item->first_child_text('title');
  print "(".$item->first_child_text('link').")\n";
  print $item->first_child_text('author')."\n";
  print $item->first_child_text('pubDate')."\n";
#  print $item->first_child_text('description')."\n";
}
print "=========================================\n";

print qq|<?xml version="1.0" encoding="UTF-8" ?>|;
print "\n";
my $myitem = XML::Twig::Elt->new('html');
my $mybody = XML::Twig::Elt->new('body');
# 把两个节点连接起来
$mybody->paste($myitem);

foreach my $item ($root->first_child('channel')->children('item')) {
  # 创建一个新节点后，把从另一个树节点的内容通过新的节点插入目录树中
  my $mytitle = XML::Twig::Elt->new('title');
  # 创建文本节点
  $mytitle->set_text($item->first_child_text('title'));
  $mytitle->paste($myitem);
  my $mylink = XML::Twig::Elt->new('a');
  # 创建属性节点
  $mylink->set_att('href',$item->first_child_text('link'));
  $mylink->paste('first_child',$mytitle);
}
# 使用更容易查看的方式输出XML内容
$myitem->print('indented');
