#!/bin/perl -w
use XML::Twig;
use encoding "utf-8";

my $file = "./feed.xml";
my $twig = XML::Twig->new();
$twig->parsefile($file);
# 定义一个树目录的根变量
my $root = $twig->root;

# 使用XPath架构来描述某个节点的位置，item节点在channel节点下面
# 通过循环来遍历item下面的所有子节点
foreach my $item ($root->first_child('channel')->children('item')) {
  print $item->first_child_text('title');
  print "(".$item->first_child_text('link').")\n";
  print $item->first_child_text('author')."\n";
  print $item->first_child_text('pubDate')."\n";
#  print $item->first_child_text('description')."\n";
}
print "=========================================\n";

print qq|<?xml version="1.0" encoding="UTF-8" ?>|;
print "\n";
my $myitem = XML::Twig::Elt->new('html');
my $mybody = XML::Twig::Elt->new('body');
# 把两个节点连接起来
$mybody->paste($myitem);

# 从另一棵树上拷贝分支，然后粘贴到新树上
foreach my $item ($root->first_child('channel')->children('item')) {
  my $copyitem = $item->copy;
  $copyitem->paste($mybody);
}

# 在新树上对分支进行修改
foreach my $item ($mybody->children('item')) {
  my $mytitle = $item->first_child('title');
  my $mylink = XML::Twig::Elt->new('a');
  $mylink->set_att('href',$item->first_child_text('link'));
  $mylink->paste('first_child',$mytitle);
}

# 使用XML:Twig来输出
my $mytwig = XML::Twig->new(pretty_print => 'indented',remove_cdata => 'true');
$html=$myitem->sprint;
$mytwig->parse($html);
$mytwig->print;
