ifdef VERSION_SRC

ifndef VERSION_FILES
$(error Need VERSION_FILES defined for version objects)
endif

ifndef VERSION_PREFIX
$(error Need VERSION_PREFIX defined for version objects)
endif

VERSION_OBJ = $(subst .c,.o,$(VERSION_SRC))

VERSION_NUM = $(VERSION_PREFIX)_BUILD_VERSION
VERSION_DATE = $(VERSION_PREFIX)_BUILD_DATE
VERSION_MD5 = $(VERSION_PREFIX)_BUILD_MD5

ifdef STAMP_DIR
STAMP_MD5 = $(STAMP_DIR)/stamp-md5
else
STAMP_MD5 = stamp-md5
endif

ifndef MAKEBO_VERSION
MAKEBO_VERSION = $(VERSION)
endif

VERDEFS = -D$(VERSION_NUM)=\""$(MAKEBO_VERSION)"\" \
	  -D$(VERSION_DATE)=\""$(shell LANG=C date)"\" \
	  -D$(VERSION_MD5)=\""$(shell cat $(STAMP_MD5))"\"

VERMAGIC = $(if $(filter $(VERSION_OBJ),$@),$(VERDEFS))

ifneq ($(MAKECMDGOALS),install)
VERSTAMP = stamp
endif

stamp: ;

$(STAMP_MD5): $(VERSION_FILES)
	@cat $(VERSION_FILES) Makefile | md5sum | sed -e 's/ .*//' > stamp-md5

endif
