/*
 * compat_should_remove_suid.c
 *
 * This code has been copied from mainline linux kernel git commit
 * e7b34019606ab1dd06196635e931b0c302799228 to allow ocfs2 to build
 * against older kernels. For license, refer to mm/filemap.c in mainline
 * linux kernel.
 *
 */

#include <linux/fs.h>
#include <linux/capability.h>

/*
 * The logic we want is
 *
 *	if suid or (sgid and xgrp)
 *		remove privs
 */
int should_remove_suid(struct dentry *dentry)
{
	mode_t mode = dentry->d_inode->i_mode;
	int kill = 0;

	/* suid always must be killed */
	if (unlikely(mode & S_ISUID))
		kill = ATTR_KILL_SUID;

	/*
	 * sgid without any exec bits is just a mandatory locking mark; leave
	 * it alone.  If some exec bits are set, it's a real sgid; kill it.
	 */
	if (unlikely((mode & S_ISGID) && (mode & S_IXGRP)))
		kill |= ATTR_KILL_SGID;

	if (unlikely(kill && !capable(CAP_FSETID)))
		return kill;

	return 0;
}
