#ifndef KAPI_AIOVEC_H
#define KAPI_AIOVEC_H

#ifdef NO_VECTORIZED_AIO

#include <linux/fs.h>
#include <linux/uio.h>

static ssize_t kapi_generic_file_aio_read(struct kiocb *iocb,
					  const struct iovec *iov,
					  unsigned long nr_segs,
					  loff_t pos)
{
	BUG_ON(nr_segs != 1);
	return generic_file_aio_read(iocb, iov->iov_base, iov->iov_len, pos);
}

static ssize_t __ocfs2_file_aio_read(struct kiocb *iocb,
				     const struct iovec *iov,
				     unsigned long nr_segs,
				     loff_t pos);

static ssize_t ocfs2_file_aio_read(struct kiocb *iocb,
				   char __user *buf,
				   size_t buflen,
				   loff_t pos)
{
	struct iovec iov_local = { .iov_base = (void __user *)buf,
				   .iov_len  = buflen };
	const struct iovec *iov = &iov_local;
	unsigned long nr_segs = 1;

	return __ocfs2_file_aio_read(iocb, iov, nr_segs, pos);
}

static ssize_t __ocfs2_file_aio_write(struct kiocb *iocb,
				      const struct iovec *iov,
				      unsigned long nr_segs,
				      loff_t pos);

static ssize_t ocfs2_file_aio_write(struct kiocb *iocb,
				    const char __user *buf,
				    size_t buflen,
				    loff_t pos)
{
	struct iovec iov_local = { .iov_base = (void __user *)buf,
				   .iov_len  = buflen };
	const struct iovec *iov = &iov_local;
	unsigned long nr_segs = 1;

	iocb->ki_left = buflen;
	return __ocfs2_file_aio_write(iocb, iov, nr_segs, pos);
}

#else	/* ! NO_VECTORIZED_AIO */

#define kapi_generic_file_aio_read(a, b, c, d) \
			generic_file_aio_read(a, b, c, d)

#define ocfs2_file_aio_read	__ocfs2_file_aio_read

#define ocfs2_file_aio_write	__ocfs2_file_aio_write

#endif

#endif
