#ifndef KAPI_HIGHMEM_H
#define KAPI_HIGHMEM_H

/*
 * Same but also flushes aliased cache contents to RAM.
 *
 * This must be a macro because KM_USER0 and friends aren't defined if
 * !CONFIG_HIGHMEM
 */
#define zero_user_page(page, offset, size, km_type)		\
	do {							\
		void *kaddr;					\
								\
		BUG_ON((offset) + (size) > PAGE_SIZE);		\
								\
		kaddr = kmap_atomic(page, km_type);		\
		memset((char *)kaddr + (offset), 0, (size));	\
		flush_dcache_page(page);			\
		kunmap_atomic(kaddr, (km_type));		\
	} while (0)

#endif
