#ifndef KAPI_MANDATORY_LOCK_H
#define KAPI_MANDATORY_LOCK_H

#ifdef NO_MANDATORY_LOCK
#include <linux/fs.h>
/*
 * Candidates for mandatory locking have the setgid bit set
 * but no group execute bit -  an otherwise meaningless combination.
 */

static inline int __mandatory_lock(struct inode *ino)
{
        return (ino->i_mode & (S_ISGID | S_IXGRP)) == S_ISGID;
}

/*
 * ... and these candidates should be on MS_MANDLOCK mounted fs,
 * otherwise these will be advisory locks
 */

static inline int mandatory_lock(struct inode *ino)
{
        return IS_MANDLOCK(ino) && __mandatory_lock(ino);
}
#endif

#endif /* KAPI_MANDATORY_LOCK_H */
