#ifndef KAPI_WORKQUEUE_H
#define KAPI_WORKQUEUE_H

#ifdef NO_DELAYED_WORK_STRUCT
# define delayed_work				work_struct
typedef void kapi_work_struct_t;
# define work_to_object(a, b, c)		(a)
# define KAPI_INIT_WORK(a, b, c)		INIT_WORK(a, b, c)
# define KAPI_INIT_DELAYED_WORK(a, b, c)	INIT_WORK(a, b, c)
#else
typedef struct work_struct kapi_work_struct_t;
# define work_to_object(a, b, c)		container_of(a, b, c)
# define KAPI_INIT_WORK(a, b, c)		INIT_WORK(a, b)
# define KAPI_INIT_DELAYED_WORK(a, b, c)	INIT_DELAYED_WORK(a, b)
#endif

#endif
