#
# RHEL5
#

TOOLSARCH = $(shell $(TOPDIR)/vendor/rhel5/rpmarch.guess tools $(TOPDIR))
MODULEARCH = $(shell $(TOPDIR)/vendor/rhel5/rpmarch.guess module $(TOPDIR))

$(TOPDIR)/vendor/rhel5/ocfs2-%.spec: $(TOPDIR)/vendor/rhel5/ocfs2.spec-generic
	SPECVER="$@"; \
		SPECVER="$${SPECVER#*ocfs2-}"; \
		SPECVER="$${SPECVER%.spec}"; \
		SUBVER="$${SPECVER#2.6.18-}"; \
		SUBVER="$${SUBVER%%.*}"; \
		if [ "$${SUBVER}" -lt 53 ]; \
		then \
			DEBUG=0; \
		else \
			DEBUG=1; \
		fi; \
		sed -e 's/@@KVER@@/'$${SPECVER}'/' -e 's/@@PKG_VERSION@@/'$(PKG_VERSION)'/' -e 's/@@DEBUG@@/'$${DEBUG}'/' -e 's/@@DONT_STRIP@@/'$(DONT_STRIP)'/' < $< > $@

rhel5_%_srpm: dist $(TOPDIR)/vendor/rhel5/ocfs2-%.spec
	rpmbuild -bs --define "_sourcedir $(TOPDIR)" --define "_srcrpmdir $(TOPDIR)" $(TOPDIR)/vendor/rhel5/ocfs2-$(patsubst rhel5_%_srpm,%,$@).spec

rhel5_%_rpm: rhel5_%_srpm
	rpmbuild --rebuild $(MODULEARCH) "ocfs2-$(patsubst rhel5_%_rpm,%,$@)-$(DIST_VERSION)-$(PKG_VERSION).el5.src.rpm"


packages: $(shell $(TOPDIR)/vendor/rhel5/kernel.guess targets)
