#
# SUSE KMPs (SLE10+, 10.2+)
#

TOOLSARCH = $(shell $(TOPDIR)/vendor/suse-kmp/rpmarch.guess tools $(TOPDIR))
MODULEARCH = $(shell $(TOPDIR)/vendor/suse-kmp/rpmarch.guess module $(TOPDIR))


$(TOPDIR)/vendor/suse-kmp/ocfs2.spec: $(TOPDIR)/vendor/suse-kmp/ocfs2.spec-generic
	SPECVER="$@"; \
		SPECVER="$${SPECVER#*ocfs2-}"; \
		SPECVER="$${SPECVER%.spec}"; \
		sed -e 's/@DIST_VERSION@/'$(DIST_VERSION)'/' -e 's/@@PKG_VERSION@@/'$(PKG_VERSION)'/' < $< > $@

srpm: dist $(TOPDIR)/vendor/suse-kmp/ocfs2.spec
	rpmbuild -bs --define "_sourcedir $(TOPDIR)" --define "_srcrpmdir $(TOPDIR)" $(TOPDIR)/vendor/suse-kmp/ocfs2.spec

rpms: srpm
	rpmbuild --rebuild $(MODULEARCH) ocfs2-$(DIST_VERSION)-$(PKG_VERSION).src.rpm

packages: rpms
