%define kmod_name drbd83
%define kver %(rpm -q kernel-devel --qf "%{V}-%{R}\\n" | tail -n 1)
%{!?kdir: %{expand: %%define kdir /lib/modules/%{kver}/build}}
%define short_name drbd
%{!?centos_ver: %define centos_ver %(Z=`rpm -q --whatprovides /etc/redhat-release`;A=`rpm -q --qf '%{V}' $Z`; echo ${A:0:1})}

Name: %{kmod_name}
Summary: Distributed Redundant Block Device driver for Linux
Version: 8.3.8
Release: 1%{?dist}
Source: %{short_name}-%{version}.tar.gz
License: GPL
ExclusiveOS: linux
Group: System Environment/Kernel
Provides: %{name}
URL: http://www.drbd.org/
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Conflicts: drbd
Conflicts: drbd82
BuildRequires: flex kernel-devel docbook-utils

%description
Drbd is a distributed replicated block device. It mirrors a
block device over the network to another machine. Think of it
as networked raid 1. It is a building block for setting up
high availability (HA) clusters.

Authors:
--------
    Philipp Reisner <philipp.reisner@linbit.com>
    Lars Ellenberg  <lars.ellenberg@linbit.com>

%prep
%setup -n drbd-%{version} -q -c -T -a 0

%build

[ -n $RPM_BUILD_ROOT -a "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT

#build common package
pushd %{short_name}-%{version}
%if %{centos_ver} == 4
%configure --with-utils --with-xen --without-udev --without-km \
           --with-pacemaker --with-heartbeat --with-rgmanager
%endif

%if %{centos_ver} == 5
%configure --with-utils --with-xen --with-udev --without-km \
           --with-pacemaker --with-heartbeat --with-rgmanager
%endif

make 
popd

%install
#install common package
pushd %{short_name}-%{version}
make install DESTDIR=$RPM_BUILD_ROOT
popd

FILELIST="%{_builddir}/%{short_name}-%{version}/file.list"
cd $RPM_BUILD_ROOT
#
# this is because /etc/init.d != /etc/rc.d != /etc/rc.d/init.d ...
# you may want to edit this, or the file list below ;)
#
find etc/ -name drbd -printf "/%p\n" > "$FILELIST"
# on suse/united we have additionally:
test -e sbin/rcdrbd && echo "/sbin/rcdrbd" >> "$FILELIST"

#
# and I only want to install a hint to the example conf
#
cat <<___ > etc/drbd.conf
#
# please have a a look at the example configuration file in
# %{_docdir}/%{name}/drbd.conf
#


___

# remove udev rules for CentOS 4
%if %{centos_ver} == 4
rm -rf etc/udev
%endif

%clean
[ -n $RPM_BUILD_ROOT -a "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%files -f %{_builddir}/%{short_name}-%{version}/file.list
%defattr(755,root,root)
/sbin/drbdsetup
/sbin/drbdadm
/sbin/drbdmeta
/usr/sbin/drbd-overview
/usr/lib/drbd/crm-fence-peer.sh
/usr/lib/drbd/crm-unfence-peer.sh
/usr/lib/drbd/notify.sh
/usr/lib/drbd/notify-out-of-sync.sh
/usr/lib/drbd/notify-split-brain.sh
/usr/lib/drbd/notify-emergency-reboot.sh
/usr/lib/drbd/notify-emergency-shutdown.sh
/usr/lib/drbd/notify-io-error.sh
/usr/lib/drbd/notify-pri-lost-after-sb.sh
/usr/lib/drbd/notify-pri-lost.sh
/usr/lib/drbd/notify-pri-on-incon-degr.sh
/usr/lib/drbd/outdate-peer.sh
/usr/lib/drbd/snapshot-resync-target-lvm.sh
/usr/lib/drbd/unsnapshot-resync-target-lvm.sh
/usr/lib/ocf/resource.d/linbit/drbd
/usr/share/cluster/drbd.metadata
/usr/share/cluster/drbd.sh
/etc/bash_completion.d/drbdadm
/etc/drbd.d/global_common.conf
/etc/ha.d/resource.d/drbddisk
/etc/ha.d/resource.d/drbdupper
%if %{centos_ver} == 5
/etc/udev/rules.d/65-drbd.rules
%endif
/etc/xen/scripts/block-drbd
%{_localstatedir}/lib/drbd

%defattr(644,root,root)
%config(noreplace) /etc/drbd.conf

%defattr(-,root,root)
%{_mandir}/man8/drbd.8.gz
%{_mandir}/man8/drbdsetup.8.gz
%{_mandir}/man8/drbdadm.8.gz
%{_mandir}/man8/drbddisk.8.gz
%{_mandir}/man5/drbd.conf.5.gz
%{_mandir}/man8/drbdmeta.8.gz
%doc %{short_name}-%{version}/scripts/drbd.conf
%doc %{short_name}-%{version}/COPYING
%doc %{short_name}-%{version}/README
%doc file.list
%doc %{short_name}-%{version}/ChangeLog

%post
chkconfig --add drbd

for i in `seq 0 15` ; do
    test -b /dev/drbd$i || mknod -m 0660 /dev/drbd$i b 147 $i;
done

if [ -n "`/usr/bin/getent group | grep ^haclient`" ]; then
   chgrp haclient /sbin/drbdsetup
   chmod o-x /sbin/drbdsetup
   chmod u+s /sbin/drbdsetup
   chgrp haclient /sbin/drbdmeta
   chmod o-x /sbin/drbdmeta
   chmod u+s /sbin/drbdmeta
fi

%preun
if type -p service ; then
	service drbd stop
fi
if type -p rcdrbd ; then
	rcdrbd stop
fi

lsmod | grep drbd > /dev/null 2>&1
if [ $? -eq 0 ]; then
	rmmod drbd
fi

if [ $1 -eq 0 ]; then
	chkconfig --del drbd
fi

%changelog
* Fri Jun 04 2010 Ralph Angenendt <ralph@centos.org> drbd83-8.3.8-1
- upgraded to upstream version 8.3.8
* Thu Mar 18 2010 Ralph Angenendt <ralph@centos.org> drbd83-8.3.7-1
- upgraded to upstream version 8.3.7
* Mon May  4 2009 Ralph Angenendt <ralph@centos.org> drbd83-8.3.1-1
- upgraded to upstream version 8.3.1
- created drbd83 branch to allow people to stay at 8.0/8.2
- first packaging of this release

* Mon Jun  2 2008 Johnny Hughes <johnny@centos.org> drbd82-8.2.6-1
- upgraded to upstream version 8.2.6

* Tue Feb 26 2008 Johnny Hughes <johnny@centos.org> drbd82-8.2.5-1
- upgraded to upstream version 8.2.5

* Thu Feb  7 2008 Johnny Hughes <johnny@centos.org>
- created a new branch named drbd82 to allow running drbd-8.2.x
- added permissions changes if haclient exists in post section
- allow upgrade from centos-5, conflicts and manual upgrade for centos-4

* Thu Dec 27 2007 Johnny Hughes <johnny@centos.org>
- upgraded to upstream version 8.0.8
- added drbd-8.0.8-inint64_t-include.patch to fix this issue detailed here:
  http://lists.linbit.com/pipermail/drbd-user/2007-December/008028.html

* Sun Oct 21 2007 Johnny Hughes <johnny@centos.org>
- upgraded to upstream version 8.0.6

* Thu Jul 26 2007 Johnny Hughes <johnny@centos.org>
- upgraded to upstream version 8.0.4

* Thu May 10 2007 04:30:00 +0600 Johnny Hughes <johnny@centos.org>
- modified to roll in kmod building by splitting out the modules to a
  seperate SRPM 

* Mon May 7 2007 17:10:14 +0200 Philipp Reisner <phil@linbit.com>
- drbd (8.0.3-1)
 * Fixed a race condition that could cause us to continue to traverse a bio
   after it was freed. (led to an OOPS)
 * Fixed a race condition that could cause us to use members of an ee, after
   it was freed. (led to various weirdness)
 * Language fixes for the man pages.
 * The drbdsetup commands (events, wait-connect,...) release the lock now.
 * Minor fixes and updates to the user land tools and to the peer outdater.

* Fri Apr 6 2007 21:32:39 +0200 Philipp Reisner <phil@linbit.com>
- drbd (8.0.2-1)
 * Removed a bug that could cause an OOPS in drbd_al_to_on_disk_bm()
 * Improved the robustness of the UUID based algorithm that decides
   about the resync direction.
 * Fixed the error handling in case a the open() of a backing
   blockdevice fails.
 * Fixed a race condition that could cause a "drbdadm disconnect" to hang.
 * More verbosity in we can not claim a backing block device.
 * More verbosity and paranoia in the bitmap area.
 * On some vendor kernels 8.0.1 did not load because of kzalloc. fixed.
 * Fault injection can now not only be turned on or off, but can be 
   enabled on a per device basis.
 * Fixed the scripts and files needed to build drbd into a kernel.

* Mon Mar 3 2007 10:10:26 +0200 Philipp Reisner <phil@linbit.com>
- drbd (8.0.1-1)
 * Fixed some race conditions that could trigger an OOPS when the loca disk
   failes and DRBD detaches itself from the failing disk.
 * Added a missing call to drbd_try_outdate_peer().
 * LVM's LVs expose ambiguous queue settings. When a RAID-0 (md) PV is
   used the present a segment size of 64k but at the same time allow only
   8 sectors. Fixed DRBD to deal with that fact corretly.
 * New option "always-asbp" to also use the after-after-split-brain-policy
   handlers, even it is not possible to determine from the UUIDs that
   the data of the two nodes was related in the past.
 * More verbosity in case a bio_add_page() fails.
 * Replaced kmalloc()/memset() with kzmalloc(), and a wrapper for older kernls
 * A fast version of drbd_al_to_on_disk_bm(). This is necessary for short
   (even sub-second) switchover times while having large "al-extents" settings.
 * Fixed drbdadm's array overflows (of on stack objects)
 * drbdsetup can now dump its usage in a XML format
 * New init script for gentoo
 * Fixed Typos in the usage of /proc/sysrq-trigger in the example config.

* Wed Jan 24 2007 16:10:09 +0200 Philipp Reisner <phil@linbit.com>
- drbd (8.0.0-1)
 * No effecitve changes to rc2.

* Wed Jan 17 2007 17:30:23 +0200 Philipp Reisner <phil@linbit.com>
- drbd (8.0rc2-1)
 * Added the well known automagiacally adjust drbd_config.h to
   make drbd compile on every by vendor's backports defaced 
   kernel. ( Linux-2.6.x only of course )
 * Fixed races with starting and finishing resync processes 
   while heavy application IO is going on.
 * Ported DRBD to the new crypto API (and added a emulation of the
   now API on top of the old one for older 2.6.x kernels)
 * Code to perform better on ethernet networks with jumbo
   frames.
 * Bugfixes to our request code (race conditions).
 * Every error code that is returned by drbdsetup has a 
   textual description by now.

* Fri Dec 22 2006 15:19:10 +0200 Philipp Reisner <phil@linbit.com>
- drbd (8.0rc1-1)
 * The drbd-peer-outdater got updated to work in multi node heartbeat
   clusters. (But we still not suceeded to get this into Heartbeat's
   repository accepted.)
 * Fixed resync decission after a crash in a pri-pri cluster.
 * Implemented the ping-timeout option for "sub-second" failover clusters.
 * Implemented all the "violently" options in the reconnect handling.
 * Updated man pages of drbd.conf and drbdsetup.
 * Removed the "self-claiming" on secondary nodes.
 * Fixed an uncountable number of bugs.

* Fri Nov  3 2006 15:20:54 +0200 Philipp Reisner <phil@linbit.com>
- drbd (8.0pre6-1)
 * All panic() calls where removed from DRBD.
 * IO errors while accessing the backing storage device are now handled
   correct.
 * Conflict detection for two primaries is in place and tested.
 * More tracing stuff
 * Lots of bugs found and fixed

* Sun Oct 31 2006 22:03:54 +0200 Philipp Reisner <phil@linbit.com>
- drbd (8.0pre5-1)
 * The request code was completely rewritten.
 * The write conflict detection code for primary-primary is currently
   broken, but will be fixed soon.
 * drbdsetup is no longer based on IOCTL but works now via
   netlink/connector.
 * drbd_panic() is on its way out.
 * A runtime configurable tracing framework got added.
 * A lot of effort was put into finding and fixing bugs.

* Mon Jul 31 2006 12:04:41 +0200 Philipp Reisner <phil@linbit.com>
- drbd (8.0pre4-1)
 * Added the "drbd-peer-outdater" heartbeat plugin.
 * New ("cluster wide") state changes. (Cluster wide serialisation of
   major state changes, like becomming primary, invalidateing a disk etc...)
 * Write requests are now sent by the worker instead out of the process's
   context that calls make_request().
 * The worker thread no longer gets restarted upon loss of connection.
 * A testsuite developed by students of 'FH Hagenberg' was added.

* Tue Apr 20 2006 13:46:18 +0200 Philipp Reisner <phil@linbit.com>
- drbd (8.0pre3-1)
 * Now it works on device mapper (LVM) as well as on "real" block devices.
 * Finally (after years) a sane "drbdadm adjust" imprementation, which is
   really really robust.
 * Fixes for 64bit kernel / 32 bit userland environments
 * Fixes in the sys-v init script
 * Renamed "--do-what-I-say" to "--overwrite-data-of-peer". Hopefully
   people now understand what this option does.

* Tue Apr  6 2006 17:53:56 +0200 Philipp Reisner <phil@linbit.com>
- drbd (8.0-pre2-1)
 * removed the "on-disconnect" and "split-brain-fix" config options and
   added the "fencing" config option instead.
 * Updated all manpages to cover drbd-8.0
 * /proc/drbd shows the whole drbd_state_t, as well the logging of state
   changes shows every field of drbd_state_t now.
 * Deactivated most of the TCQ code for now, since it changed again
   in the mainline kernel.
 * Minor other fixes.

* Tue Mar 14 2006 11:37:56 +0200 Philipp Reisner <phil@linbit.com>
- drbd (8.0_pre1-1)
 * Removed support for Linux-2.4.x
 * Cleanup of the wire protocol.
 * Added optional peer authentication with a shared secret.
 * Consolidated state changes into a central function.
 * Improved, tunable after-split-brain recovery strategies.
 * Always verify all IDs used in the protocol that are used as pointers.
 * Introduced the "outdate" disk state, and commands for managing it.
 * Introduced the "drbdmeta" command, and require the user to create
   meta-data explicitly.
 * Support for primary/primary (for OCFS2, GFS...)
 * Replaced the sync-groups with the sync-after mechanism.
 * The "common" section in the configuration file.
 * Replaced the generation counters (GCs) with data-generation-UUIDs
 * Improved performance by using Linux-2.6's BIOs with up to 32k per
   IO request. Before we transferred only up to 4k per IO request.
 * A Warning if the disk sizes are more than 10% different.
 * A connection teardown packet to differentiate between a crash
   of the peer and a peer that is shut down gracefully.
 * External imposable SyncPause states, to serialize DRBD's resynchronisation
   with the resynchronisation of backing storage's RAID configurations.
 * Backing storage can be hot added to disk less nodes.
 * Prepared for advanced integration to Heartbeat-2.0
 * Changed internal APIs so that missed writes of the meta-data super
   block are reported as they happen.
 * The http://usage.drbd.org sub project.
 * Rewrote the scanner/parser of drbd.conf. 10 times smaller/faster and
   easier to maintain.
 * Asynchronous meta-data IO [ Code drop from the DRBD+ branch ]
