#!/bin/bash
echo 'Please input client IP:'
echo '( Which admit connect to this machine)'
read CLIENT_IP
echo 'Please input community password:'
read PASSWORD
echo 'Please input system location:'
read SYS_LOC
echo 'Please input system contact:'
read SYS_CONTACT
echo '*******************************************'
echo "Client IP: $CLIENT_IP"
echo "Community password: $PASSWORD"
echo "System location: $SYS_LOC"
echo "System contact: $SYS_CONTACT"
echo '*******************************************'
echo "Do you confirm upper information(Yes/No):" 
echo 'Yes to continue,No or other words will exit !'
read YesNo
if [ $YesNo == 'Yes' ] || [ $YesNo == 'yes' ];then
    mv /etc/snmp/snmpd.conf /etc/snmp/snmpd.conf.bak
    cat << EOF > /etc/snmp/snmpd.conf
com2sec RoUser  $CLIENT_IP       $PASSWORD
group   Group1 v1           RoUser
group   Group1 v2c           RoUser
access  Group1 ""      any       noauth    exact all none none
view all    included  .1                               80
syslocation $SYS_LOC
syscontact $SYS_CONTACT
EOF
    echo 'The snmpd.conf file has done,start snmpd service now.'
    service snmpd restart
    if [ $? -eq 0 ];then
        echo 'The snmpd service start successfully.'
        echo "Please use below snmpwalk command to get snmp messages in $CLIENT_IP:"
        HOST_IP=`ifconfig eth0|grep -w 'inet'|awk '{print $2}'|sed 's/addr://'`
        echo "snmpwalk -v 2c -c $PASSWORD $HOST_IP .1"
    else
        echo 'The snmpd service start failed,please run this script again,or check configure file:/etc/snmp/snmpd.conf'
    fi
else
    exit 1
    echo 'Input error,please check again'
fi
